/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.model.FactoryMonitor;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Node2Dom;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLExistsTest;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.util.ArrayIterator;
import oracle.javatools.util.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeFactory {
    public static final int NODE_CACHED = UpdateMessage.newMessageID("NodeFactory.NODE_CACHED");
    public static final int NODE_UNCACHED = UpdateMessage.newMessageID("NodeFactory.NODE_UNCACHED");
    private static boolean _suppressNodeCachedNotify = false;
    String prefix;
    private static final Map<URL, Node> allNodes = new Maps.ManagedCacheMap(Maps.AbstractCacheMap.ReferenceType.WEAK, "NodeFactory,items=allNodes");
    private static final Map<URL, Node> loadedNodes = new Maps.ManagedCacheMap(Maps.AbstractCacheMap.ReferenceType.WEAK, "NodeFactory,items=loadedNodes");
    private static final Map<URL, Node> openedNodes = new Maps.ManagedCacheMap("NodeFactory,items=openedNodes");
    private static final NodeTracker _nodeTracker = new NodeTracker(null);

    private void $init$() {
        this.prefix = "NodeFactory,items=";
    }

    static {
        Node.addNodeListenerForTypeHierarchy(Node.class, _nodeTracker);
        Object2Dom.registerConverter((ToDomConverter)new Node2Dom());
        URLFileSystem.addExistsTest((URLExistsTest)new 1());
    }

    public static Node findOrCreateOrFail(URL url) {
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        try {
            Node node = NodeFactory.findOrCreate(url);
            return node;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Node findOrCreate(URL url) throws IllegalAccessException, InstantiationException {
        return NodeFactory.findOrCreateUsingDefault(url, Recognizer.getDefaultNodeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node findOrCreate(Class<? extends Node> type, URL url) throws IllegalAccessException, InstantiationException {
        Node node = null;
        if (url != null) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                node = NodeFactory.find(url);
                if (node != null) {
                    Node node2 = node;
                    return node2;
                }
                try {
                    _suppressNodeCachedNotify = true;
                    node = NodeFactory.createImpl(type, url);
                    Assert.execute((Runnable)new NodeTypeValidator(node));
                }
                finally {
                    _suppressNodeCachedNotify = false;
                }
            }
            if (node != null) {
                FactoryMonitor.notify(node, NODE_CACHED);
            }
        }
        return node;
    }

    public static <T extends Node> T findOrCreateOrFail(Class<T> type, URL url) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        try {
            Node node = NodeFactory.findOrCreate(type, url);
            return (T)node;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node findOrCreateUsingDefault(URL url, Class<? extends Node> defaultNodeType) throws IllegalAccessException, InstantiationException {
        Node node = null;
        if (url != null) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                node = NodeFactory.find(url);
                if (node != null) {
                    Node node2 = node;
                    return node2;
                }
                try {
                    _suppressNodeCachedNotify = true;
                    Iterator iter = Recognizer.getRecognizerIterator(url);
                    while (iter.hasNext()) {
                        Recognizer recognizer = (Recognizer)iter.next();
                        Class<? extends Node> cls = recognizer.recognize(url);
                        if (cls == null || (node = recognizer.create(url, cls)) == null) continue;
                        NodeFactory.cache(url, node, false);
                        break;
                    }
                    if (node == null && defaultNodeType != null) {
                        node = NodeFactory.createImpl(defaultNodeType, url);
                    }
                }
                finally {
                    _suppressNodeCachedNotify = false;
                }
            }
            if (node != null) {
                FactoryMonitor.notify(node, NODE_CACHED);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node find(URL url) {
        Map<URL, Node> map = allNodes;
        synchronized (map) {
            Node node = allNodes.get(url);
            return node;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Node findInFolder(Folder folder, URL url) {
        if (folder == null || url == null) {
            return null;
        }
        iter = folder.getChildren();
        if (iter != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            child = iter.next();
            if (!(child instanceof Node) || !url.equals((node = (Node)child).getURL())) continue;
            return node;
lbl9:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl10:
        // 1 sources

        return null;
    }

    public static Node clone(Node srcNode, URL dstNodeURL) {
        URL srcNodeURL = srcNode.getURL();
        Class<?> nodeClass = srcNode.getClass();
        try {
            Node dstNode = (Node)nodeClass.newInstance();
            dstNode.setURL(dstNodeURL);
            URLFileSystem.copy((URL)srcNodeURL, (URL)dstNodeURL);
            Node node = dstNode;
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.println((String)("Unable to create node:\n" + URLFileSystem.getPlatformPathName((URL)dstNodeURL) + ".\nThe file system permissions may not allow it."));
            Node node = null;
            return node;
        }
    }

    public static Node uncache(URL url) {
        return NodeFactory.uncache(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node uncache(URL url, boolean notify) {
        Node node;
        Map<URL, Node> map = allNodes;
        synchronized (map) {
            node = allNodes.remove(url);
        }
        if (notify) {
            FactoryMonitor.notify(node, NODE_UNCACHED);
        }
        return node;
    }

    public static void recache(URL oldURL, URL newURL, Node node) {
        NodeFactory.recache(oldURL, newURL, node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recache(URL oldURL, URL newURL, Node node, boolean notify) {
        if (!URLFileSystem.equals((URL)oldURL, (URL)newURL)) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                if (oldURL != null) {
                    Node oldNode = NodeFactory.find(oldURL);
                    notify = notify && oldNode != node;
                    NodeFactory.uncache(oldURL, notify);
                }
                if (newURL != null && node != null) {
                    NodeFactory.cache(newURL, node, notify);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<Node> getCachedNodes() {
        Map<URL, Node> map = allNodes;
        synchronized (map) {
            Object[] array = new Node[allNodes.size()];
            int i = 0;
            for (Node node : allNodes.values()) {
                array[i++] = node;
            }
            ArrayIterator arrayIterator = new ArrayIterator(array);
            return arrayIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<Node> getOpenNodes() {
        Map<URL, Node> map = openedNodes;
        synchronized (map) {
            Iterator<Node> iterator = Collections.unmodifiableCollection(new HashSet<Node>(openedNodes.values())).iterator();
            return iterator;
        }
    }

    public static final void attach(Observer observer, Class<? extends Node> type) {
        FactoryMonitor.attach(observer, type);
    }

    public static final void detach(Observer observer, Class<? extends Node> type) {
        FactoryMonitor.detach(observer, type);
    }

    private NodeFactory() {
        this.$init$();
    }

    private static Node createImpl(Class type, URL url) throws IllegalAccessException, InstantiationException {
        Node node = (Node)type.newInstance();
        node.setURL(url);
        NodeFactory.cache(url, node, true);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cache(URL url, Node node, boolean notify) {
        Node other = NodeFactory.find(url);
        if (other == null || other != node) {
            Map<URL, Node> map = allNodes;
            synchronized (map) {
                allNodes.put(url, node);
            }
            if (notify && !_suppressNodeCachedNotify) {
                FactoryMonitor.notify(node, NODE_CACHED);
            }
        }
    }

    private static Class recognize(URL url) {
        Iterator iter = Recognizer.getRecognizerIterator(url);
        while (iter.hasNext()) {
            Recognizer recognizer = (Recognizer)iter.next();
            Class<? extends Node> cls = recognizer.recognize(url);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    static Class maS$recognize(URL uRL) {
        return NodeFactory.recognize(uRL);
    }

    static Map ra$loadedNodes() {
        return loadedNodes;
    }

    static Map ra$openedNodes() {
        return openedNodes;
    }

    static final class 1
    implements URLExistsTest {
        public boolean urlExists(URL url) {
            return NodeFactory.find(url) != null;
        }
    }

    private static class NodeTypeValidator
    implements Runnable {
        private final Node _node;

        NodeTypeValidator(Node node) {
            this._node = node;
        }

        public void run() {
            if (!URLFileSystem.exists((URL)this._node.getURL())) {
                return;
            }
            Class cls = NodeFactory.maS$recognize(this._node.getURL());
            Assert.printStackTrace((cls != null && cls != this._node.getClass() ? 1 : 0) != 0, (String)String.format("NodeFactory.findOrCreate() Contract Violation!\nThe specified node type %s does not match the recognized %s for URL %s", this._node.getClass().getName(), cls, URLFileSystem.getPlatformPathName((URL)this._node.getURL())));
        }
    }

    private static class NodeTracker
    extends NodeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeLoaded(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            if (url != null) {
                Map map = NodeFactory.ra$loadedNodes();
                synchronized (map) {
                    NodeFactory.ra$loadedNodes().put(url, node);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeUnloaded(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            Map map = NodeFactory.ra$loadedNodes();
            synchronized (map) {
                Node curNode = (Node)NodeFactory.ra$loadedNodes().get(url);
                if (curNode == node) {
                    NodeFactory.ra$loadedNodes().remove(url);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeOpened(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            if (url != null) {
                Map map = NodeFactory.ra$openedNodes();
                synchronized (map) {
                    NodeFactory.ra$openedNodes().put(url, node);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeClosed(NodeEvent e) {
            Node node = e.getNode();
            URL url = node.getURL();
            Map map = NodeFactory.ra$openedNodes();
            synchronized (map) {
                Node curNode = (Node)NodeFactory.ra$openedNodes().get(url);
                if (curNode == node) {
                    NodeFactory.ra$openedNodes().remove(url);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            Node newNode = NodeFactory.find(newURL);
            if (newNode == null) {
                return;
            }
            if (newNode.isLoaded()) {
                Map map = NodeFactory.ra$loadedNodes();
                synchronized (map) {
                    NodeFactory.ra$loadedNodes().remove(oldURL);
                    NodeFactory.ra$loadedNodes().put(newURL, newNode);
                }
            }
            if (newNode.isOpen()) {
                Map map = NodeFactory.ra$openedNodes();
                synchronized (map) {
                    NodeFactory.ra$openedNodes().remove(oldURL);
                    NodeFactory.ra$openedNodes().put(newURL, newNode);
                }
            }
        }

        private NodeTracker() {
        }

        NodeTracker(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

