/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeUtil {
    public static final int RELOAD_PROMPTED = 1;
    public static final int RELOAD_PROMPTED_IF_DIRTY = 2;
    public static final int RELOAD_SILENTLY = 3;
    private static final boolean VERBOSE_RELOAD = Boolean.getBoolean("verbose_on_activate");
    private static final Comparator<Node> LOCK_ORDER_COMPARATOR = new 1();

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void runUnderReadLock(Collection<? extends Node> nodes, Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("null Runnable");
        }
        clazz = null;
        lockedNone = true;
        lockedAll = true;
        for (Node node : nodes) {
            if (node == null) {
                throw new IllegalArgumentException("null node");
            }
            if (clazz == null) {
                clazz = node.getClass();
            } else if (!node.getClass().equals(clazz)) {
                throw new IllegalArgumentException("Node subclass mismatch. Expected class: " + clazz.getName() + " Actual class: " + node.getClass().getName());
            }
            if (node.isReadOrWriteLocked()) {
                lockedNone = false;
                continue;
            }
            lockedAll = false;
        }
        if (!lockedNone && !lockedAll) {
            throw new IllegalMonitorStateException();
        }
        list = NodeUtil.getLockOrder(nodes);
        for (Node node : list) {
            node.readLock();
        }
        try {
            r.run();
        }
        finally {
            Collections.reverse(list);
            ** for (node : list)
        }
lbl-1000:
        // 1 sources

        {
            node.readUnlock();
            continue;
        }
lbl33:
        // 1 sources

    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void runUnderWriteLock(Collection<? extends Node> nodes, Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("null Runnable");
        }
        clazz = null;
        lockedNone = true;
        lockedAll = true;
        for (Node node : nodes) {
            if (node == null) {
                throw new IllegalArgumentException("null node");
            }
            if (clazz == null) {
                clazz = node.getClass();
            } else if (!node.getClass().equals(clazz)) {
                throw new IllegalArgumentException("Node subclass mismatch. Expected class: " + clazz.getName() + " Actual class: " + node.getClass().getName());
            }
            if (node.isReadLocked()) {
                throw new IllegalMonitorStateException("Calling thread already holds a read lock on " + URLFileSystem.getPlatformPathName((URL)node.getURL()));
            }
            if (node.isWriteLocked()) {
                lockedNone = false;
                continue;
            }
            lockedAll = false;
        }
        if (!lockedNone && !lockedAll) {
            throw new IllegalMonitorStateException();
        }
        list = NodeUtil.getLockOrder(nodes);
        for (Node node : list) {
            node.writeLock();
        }
        try {
            r.run();
        }
        finally {
            Collections.reverse(list);
            ** for (node : list)
        }
lbl-1000:
        // 1 sources

        {
            node.writeUnlock();
            continue;
        }
lbl35:
        // 1 sources

    }

    private static List<Node> getLockOrder(Collection<? extends Node> nodes) {
        ArrayList<Node> list = new ArrayList<Node>(nodes);
        Collections.sort(list, LOCK_ORDER_COMPARATOR);
        return list;
    }

    public static void storeAllTimestamps(Map<Node, Long> timestampMap) {
        NodeUtil.storeTimestampsImpl(timestampMap, NodeFactory.getCachedNodes(), new OpenNodeFilter(null));
    }

    public static void storeAllTimestamps(Map<Node, Long> timestampMap, NodeFilter nodeFilter) {
        NodeUtil.storeTimestampsImpl(timestampMap, NodeFactory.getCachedNodes(), nodeFilter);
    }

    public static void storeTimestamps(Map<Node, Long> timestampMap, Collection<Node> nodes) {
        NodeUtil.storeTimestampsImpl(timestampMap, nodes.iterator(), new OpenNodeFilter(null));
    }

    public static void storeTimestamps(Map<Node, Long> timestampMap, Collection<Node> nodes, NodeFilter nodeFilter) {
        NodeUtil.storeTimestampsImpl(timestampMap, nodes.iterator(), nodeFilter);
    }

    private static void storeTimestampsImpl(Map<Node, Long> timestampMap, Iterator<? extends Node> nodesIter, NodeFilter nodeFilter) {
        while (nodesIter.hasNext()) {
            Node node = nodesIter.next();
            if (NodeUtil.isReloadable(node) && nodeFilter.accept(node)) {
                long timestamp = node.getUnmodifiedTimestamp();
                timestampMap.put(node, timestamp);
                continue;
            }
            timestampMap.remove(node);
        }
    }

    private static boolean isReloadable(Node node) {
        if (node == null) {
            return false;
        }
        return node.getAttributes().isSet(ElementAttributes.NON_RELOADABLE) ^ true;
    }

    public static void reloadBuffers(Map<Node, Long> timestampMap) {
        NodeUtil.reloadBuffers(timestampMap, true);
    }

    public static void reloadBuffers(Map<Node, Long> timestampMap, boolean silentReload) {
        NodeUtil.reloadBuffers(timestampMap, silentReload, false);
    }

    public static void reloadBuffers(Map<Node, Long> timestampMap, boolean silentReload, boolean manualReload) {
        if (timestampMap != null) {
            Iterator<Node> iter = timestampMap.keySet().iterator();
            NodeUtil.reloadBuffers(iter, timestampMap, silentReload, manualReload);
        }
    }

    public static void reloadBuffers(Collection<Node> nodes, boolean silentReload) {
        if (nodes != null) {
            NodeUtil.reloadBuffers(nodes.iterator(), null, silentReload, false);
        }
    }

    public static void reloadBuffers(Collection<Node> nodes, Map<Node, Long> timestampMap, int reloadMode, boolean manualReload) {
        NodeUtil.reloadBuffers(nodes.iterator(), timestampMap, reloadMode, manualReload);
    }

    private static void reloadBuffers(Iterator nodeIterator, Map<Node, Long> timestampMap, boolean silentReload, boolean manualReload) {
        int reloadMode = silentReload ? 2 : 1;
        NodeUtil.reloadBuffers(nodeIterator, timestampMap, reloadMode, manualReload);
    }

    private static void reloadBuffers(Iterator nodeIterator, Map<Node, Long> timestampMap, int reloadMode, boolean manualReload) {
        ArrayList<Node> autoReloadNodes = new ArrayList<Node>();
        ArrayList<Node> promptedReloadNodes = new ArrayList<Node>();
        int nodeChecked = 0;
        PerformanceLogger.get().startTiming("NodeUtil.reloadBuffers");
        try {
            while (nodeIterator.hasNext()) {
                Node node = (Node)nodeIterator.next();
                if (node == null || !node.isOpen()) continue;
                ++nodeChecked;
                if (VERBOSE_RELOAD) {
                    Assert.println((String)("Checking open node: " + node.getLongLabel()));
                }
                node.isReadOnly();
                if (node.getAttributes().isSet(ElementAttributes.NON_RELOADABLE)) continue;
                boolean mustReload = false;
                if (timestampMap != null) {
                    long storedTimestamp;
                    long urlTimestamp = URLFileSystem.lastModified((URL)node.getURL());
                    if (urlTimestamp != (storedTimestamp = timestampMap.get(node).longValue())) {
                        long nodeTimestamp = node.getTimestamp();
                        mustReload = urlTimestamp >= 0L && (urlTimestamp > nodeTimestamp || urlTimestamp < nodeTimestamp && urlTimestamp < storedTimestamp);
                    }
                } else {
                    mustReload = true;
                }
                if (!mustReload) continue;
                if (reloadMode == 3) {
                    autoReloadNodes.add(node);
                    continue;
                }
                if (reloadMode == 2 && !node.isDirty()) {
                    autoReloadNodes.add(node);
                    continue;
                }
                promptedReloadNodes.add(node);
            }
        }
        finally {
            PerformanceLogger.get().stopTiming("NodeUtil.reloadBuffers", "Checked " + nodeChecked + " open nodes", 500);
        }
        NodeUtil.performReload(autoReloadNodes, promptedReloadNodes, manualReload);
    }

    private static void performReload(ArrayList<Node> autoReloadNodes, ArrayList<Node> promptedReloadNodes, boolean manualReload) {
        try {
            2 closure = new 2(true, manualReload, promptedReloadNodes, autoReloadNodes);
            closure.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void autoReload(ArrayList<Node> nodes) {
        for (Node node : nodes) {
            NodeUtil.tryRevert(node);
        }
    }

    private static void promptedReload(ArrayList<Node> nodes) {
        int response;
        CheckBoxListModel listModel = new CheckBoxListModel();
        for (Node node : nodes) {
            Icon icon = node.getIcon();
            String label = URLFileSystem.getPlatformPathName((URL)node.getURL());
            listModel.addElement((Object)node, icon, true, true, label);
        }
        int size = listModel.getSize();
        if (size > 0 && (response = SelectFilesPanel.showDialog(IdeArb.getString(56), IdeArb.format(480, listModel.findTextForElement(0)), IdeArb.getString(193), listModel, true, 0, "f1_idedexternallymodifiedfiles_html")) == 0) {
            int i = size - 1;
            while (i >= 0) {
                if (listModel.isElementSelected(i)) {
                    Node node = (Node)listModel.getUserObjectAt(i);
                    NodeUtil.tryRevert(node);
                }
                --i;
            }
        }
    }

    private static void tryRevert(Node node) {
        try {
            RevertNodeCommand.reload(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void problemReload(ArrayList<Node> problemNodes) {
        if (!problemNodes.isEmpty()) {
            IdeMainWindow parentComponent = Ide.getMainWindow();
            JComponent header = NodeUtil.createLabel(IdeArb.getString(276));
            JList list = NodeUtil.createList(problemNodes, 8);
            JComponent footer = NodeUtil.createLabel(IdeArb.getString(152));
            JPanel message = new JPanel(new BorderLayout(10, 10));
            message.add((Component)header, "North");
            message.add((Component)new JScrollPane(list), "Center");
            message.add((Component)footer, "South");
            String title = IdeArb.getString(70);
            String helpTopic = "f1_idedexternallymodifiedfilesproblem_html";
            MessageDialog.error((Component)((Object)parentComponent), (Object)message, (String)title, (String)helpTopic);
        }
    }

    private static JComponent createLabel(String text) {
        JTextArea label = new JTextArea(text, 0, 60);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setBorder(null);
        label.setEditable(false);
        label.setOpaque(false);
        label.setForeground(UIManager.getColor("Label.foreground"));
        label.setBackground(UIManager.getColor("Label.background"));
        return label;
    }

    private static JList createList(ArrayList<Node> nodes, int visibleRowCount) {
        JList<Object> list = new JList<Object>(nodes.toArray());
        list.setVisibleRowCount(visibleRowCount);
        list.setCellRenderer(new 3());
        return list;
    }

    private NodeUtil() {
    }

    static void maS$autoReload(ArrayList arrayList) {
        NodeUtil.autoReload(arrayList);
    }

    static void maS$promptedReload(ArrayList arrayList) {
        NodeUtil.promptedReload(arrayList);
    }

    static void maS$problemReload(ArrayList arrayList) {
        NodeUtil.problemReload(arrayList);
    }

    static final class 1
    implements Comparator {
        public int compare(Node n1, Node n2) {
            return System.identityHashCode(n1) - System.identityHashCode(n2);
        }
    }

    static final class 2
    extends SwingClosure {
        private final /* synthetic */ boolean v$manualReload;
        private final /* synthetic */ ArrayList v$promptedReloadNodes;
        private final /* synthetic */ ArrayList v$autoReloadNodes;

        protected void runImpl() throws Exception {
            if (this.v$manualReload && this.v$promptedReloadNodes.size() == 0) {
                String title = IdeArb.getString(56);
                String message = IdeArb.getString(209);
                IdeMainWindow parentComponent = Ide.getMainWindow();
                JOptionPane.showMessageDialog((Component)((Object)parentComponent), message, title, 1);
                return;
            }
            ArrayList<Node> problemNodes = new ArrayList<Node>();
            if (CommandProcessor.getInstance().isTransactionActive()) {
                problemNodes.addAll(this.v$promptedReloadNodes);
                this.v$promptedReloadNodes.clear();
                problemNodes.addAll(this.v$autoReloadNodes);
                this.v$autoReloadNodes.clear();
            } else {
                Iterator i = this.v$autoReloadNodes.iterator();
                while (i.hasNext()) {
                    Node node = (Node)i.next();
                    if (!node.isReadOrWriteLocked()) continue;
                    problemNodes.add(node);
                    i.remove();
                }
                Iterator i2 = this.v$promptedReloadNodes.iterator();
                while (i2.hasNext()) {
                    Node node = (Node)i2.next();
                    if (!node.isReadOrWriteLocked()) continue;
                    problemNodes.add(node);
                    i2.remove();
                }
            }
            NodeUtil.maS$autoReload(this.v$autoReloadNodes);
            NodeUtil.maS$promptedReload(this.v$promptedReloadNodes);
            NodeUtil.maS$problemReload(problemNodes);
        }

        public 2(boolean bl, boolean bl2, ArrayList arrayList, ArrayList arrayList2) {
            this.v$autoReloadNodes = arrayList2;
            this.v$promptedReloadNodes = arrayList;
            this.v$manualReload = bl2;
            super(bl);
        }
    }

    static final class 3
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Node node = (Node)value;
            String text = node.getShortLabel() + " (" + URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)node.getURL())) + ")";
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }

    public static interface NodeFilter {
        public boolean accept(Node var1);
    }

    private static class OpenNodeFilter
    implements NodeFilter {
        public boolean accept(Node node) {
            return node != null && node.isLoadedUnsafe();
        }

        private OpenNodeFilter() {
        }

        OpenNodeFilter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

