/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.DefaultSubDirtyable;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ModelArb;
import oracle.javatools.util.Copyable;

public class Preferences
extends DefaultFolder
implements Copyable,
SubDirtyable {
    public static final String DEFAULT_PROJECT_KEY = "DefaultProject";
    public static final String DEFAULT_WORKSPACE_KEY = "DefaultWorkspace";
    private SubDirtyable _subDirtyable;
    private final HashMap _preferencesMap;
    private Project _defaultProject;
    private Workspace _defaultWorkspace;

    private void $init$() {
        this._subDirtyable = new DefaultSubDirtyable();
        this._preferencesMap = new HashMap();
    }

    public Preferences() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        Preferences copy = object != null ? (Preferences)object : new Preferences();
        this.copyToImpl(copy);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPreferencesMap() {
        HashMap hashMap = this._preferencesMap;
        synchronized (hashMap) {
            HashMap hashMap2 = new HashMap(this._preferencesMap);
            return hashMap2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferencesMap(Map preferencesMap) {
        HashMap hashMap = this._preferencesMap;
        synchronized (hashMap) {
            this._preferencesMap.clear();
            if (preferencesMap != null) {
                for (Object key : preferencesMap.keySet()) {
                    Object value;
                    if (key == null || (value = preferencesMap.get(key)) == null || value.getClass() != URL.class) continue;
                    this._preferencesMap.put(key, value);
                }
            }
        }
    }

    public boolean isDirty() {
        return this._subDirtyable.isDirty();
    }

    public void markDirty(boolean dirty) {
        this._subDirtyable.markDirty(dirty);
    }

    public void setOwner(Dirtyable owner) {
        this._subDirtyable.setOwner(owner);
    }

    public String getShortLabel() {
        return ModelArb.getString(25);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return ModelArb.getIcon(66);
    }

    public String getToolTipText() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        ArrayList children = new ArrayList();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            children.addAll(this._children);
        }
        return children.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getDefaultProject() {
        if (this._defaultProject == null) {
            try {
                URL url;
                HashMap hashMap = this._preferencesMap;
                synchronized (hashMap) {
                    url = (URL)this._preferencesMap.get(DEFAULT_PROJECT_KEY);
                }
                if (url != null) {
                    this._defaultProject = (Project)NodeFactory.findOrCreate(url);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._defaultProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace getDefaultWorkspace() {
        if (this._defaultWorkspace == null) {
            URL url;
            HashMap hashMap = this._preferencesMap;
            synchronized (hashMap) {
                url = (URL)this._preferencesMap.get(DEFAULT_WORKSPACE_KEY);
            }
            if (url == null) {
                return null;
            }
            try {
                this._defaultWorkspace = (Workspace)NodeFactory.findOrCreate(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._defaultWorkspace;
    }
}

