/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.IdeVetoableSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.OwnerMap;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Reference;
import oracle.ide.model.Subject;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.ModelArb;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;

public final class Project
extends HashStructureNode
implements VetoableSubject {
    public static final String EXT = ".jpr";
    public static final String DATA_KEY = "Project";
    public static final String NAMESPACE_URI = "http://xmlns.oracle.com/ide/project";
    public static final String ROOT_QNAME = "jpr:project";
    private final transient StorageListener _storageListener;
    private static final IdentityHashMap _projectChangeListenersMap = new IdentityHashMap();
    private static final CopyOnWriteArrayList _projectChangeListenersOrder = new CopyOnWriteArrayList();
    private static HashStructure _customizedDefaults = null;

    private void $init$() {
        this._storageListener = new StorageListener(null);
    }

    static {
        Node.addNodeListenerForType(Project.class, new NL(null));
        TechnologyScopeConfiguration.init();
        WorkingSets.init();
        try {
            int debugLevel = Integer.getInteger("ProjectChangeListener.debug.level", 0);
            if (debugLevel > 0) {
                2 pcl = new 2(debugLevel);
                Project.addProjectChangeListener("", pcl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Project() {
        this.$init$();
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.CLOSEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.NAVIGABLE | ElementAttributes.BUILDABLE | ElementAttributes.SELECTION_CONTAINER | ElementAttributes.NON_HISTORIED);
    }

    public final Icon getIcon() {
        return OracleIcons.getIcon((String)"project.png");
    }

    public final Iterator getChildren() {
        return ProjectContent.getInstance(this).getNodeIterator();
    }

    public final boolean canRemove(Element element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            Node owner = OwnerMap.getInstance(this).getContainerOwner(node);
            if (owner instanceof Folder) {
                return ((Folder)((Object)owner)).canRemove(node);
            }
        }
        return true;
    }

    public final boolean canAdd(Element element) {
        return (element instanceof Project || element instanceof Workspace) ^ true;
    }

    public final boolean containsChild(Element element) {
        if (element instanceof Locatable) {
            URL url = ((Locatable)((Object)element)).getURL();
            ContentSet allContents = ProjectContent.getInstance(this).getAllContents();
            if (allContents.canHaveMember(url)) {
                return URLFileSystem.exists((URL)url);
            }
        }
        return false;
    }

    public final int size() {
        return super.size() + OwnerMap.getInstance(this).getOwnedChildrenList().size();
    }

    protected void closeImpl() throws IOException {
        OwnerMap ownerMap = OwnerMap.getInstance(this);
        if (ownerMap != null) {
            ownerMap.close();
        }
        super.closeImpl();
    }

    protected void saveImpl() throws IOException {
        OwnerMap ownerMap;
        if (this._hashDirtyTracker.isDirty() && (ownerMap = OwnerMap.getInstance(this)) != null) {
            ownerMap.sortOwnerMap();
        }
        super.saveImpl();
    }

    public final boolean remove(Element element, boolean notify) {
        OwnerMap.getInstance(this).removeElement(element);
        return true;
    }

    public final boolean add(Element element) {
        return true;
    }

    public final boolean add(Node node, String contentSetKey) {
        return ProjectContent.getInstance(this).add(node, contentSetKey);
    }

    public final boolean add(Node[] nodes, String contentSetKey) {
        return ProjectContent.getInstance(this).add(nodes, contentSetKey);
    }

    public final boolean add(Element element, boolean notify) {
        return true;
    }

    public final boolean isDefault() {
        return Ide.isRunning() && this == Ide.getDefaultProject();
    }

    public final boolean isDefaultProject() {
        return this.isDefault();
    }

    public final Iterator findChildren(Class childType) {
        return ProjectContent.getInstance(this).findChildren(childType);
    }

    public final Iterator findChildren(Class[] types) {
        return ProjectContent.getInstance(this).findChildren(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addProjectChangeListener(String propertyName, ProjectChangeListener listener) {
        if (propertyName != null && listener != null) {
            propertyName = propertyName.intern();
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                CopyOnWriteArrayList<String> propertyNames = (CopyOnWriteArrayList<String>)_projectChangeListenersMap.get(listener);
                if (propertyNames == null) {
                    propertyNames = new CopyOnWriteArrayList<String>();
                    propertyNames.addIfAbsent(propertyName);
                    _projectChangeListenersMap.put(listener, propertyNames);
                    _projectChangeListenersOrder.addIfAbsent(listener);
                } else {
                    propertyNames.addIfAbsent(propertyName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeProjectChangeListener(String propertyName, ProjectChangeListener listener) {
        if (propertyName != null && listener != null) {
            propertyName = propertyName.intern();
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                CopyOnWriteArrayList propertyNames = (CopyOnWriteArrayList)_projectChangeListenersMap.get(listener);
                if (propertyNames != null) {
                    propertyNames.remove(propertyName);
                    if (propertyNames.size() == 0) {
                        Project.removeProjectChangeListener(listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeProjectChangeListener(ProjectChangeListener listener) {
        if (listener != null) {
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                _projectChangeListenersMap.remove(listener);
                _projectChangeListenersOrder.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCustomizedDefaults(HashStructure hash) {
        Class<Project> clazz = Project.class;
        synchronized (Project.class) {
            if (_customizedDefaults != null) {
                throw new IllegalStateException("Project customized defaults are already initialized.");
            }
            _customizedDefaults = hash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final boolean containsOwnedChild(Element child) {
        if (this.ensureLoad()) {
            return OwnerMap.getInstance(this).containsOwnedChild(child);
        }
        return false;
    }

    public final Folder findOwner(Element element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            Node owner = OwnerMap.getInstance(this).getContainerOwner(node);
            if (owner instanceof Folder) {
                return (Folder)((Object)owner);
            }
        }
        if (this.containsChild(element)) {
            return this;
        }
        return null;
    }

    public final void add(Node node, Node ownerNode) {
        if (ownerNode instanceof Folder) {
            OwnerMap.addToOwnerMap(this, node, ownerNode);
        }
    }

    public final Iterator findMyChildren(Class childType) {
        return new ProjectContent.ChildTypeIterator(this.getMyChildren(), childType);
    }

    public final Iterator findMyChildren(Class[] types) {
        switch (types.length) {
            case 0: {
                return Collections.EMPTY_LIST.iterator();
            }
            case 1: {
                return this.findMyChildren(types[0]);
            }
        }
        return new ProjectContent.MultiChildTypeIterator(this.getMyChildren(), types);
    }

    final void copyChildrenTo(List list, boolean includeOwnedChildren) {
        super.copyChildrenTo(list, includeOwnedChildren);
        if (includeOwnedChildren) {
            OwnerMap.getInstance(this).copyOwnedChildrenListTo(list);
        }
    }

    public final void update(Object observed, UpdateMessage change) {
        if (change.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
            List modObjs = change.getModifyObjects();
            URL oldURL = (URL)modObjs.get(0);
            Node node = (Node)observed;
            OwnerMap ownerMap = OwnerMap.getInstance(this);
            Node owner = ownerMap.getContainerOwner(oldURL);
            ownerMap.handleNodeRenamed(oldURL, node, owner);
        } else if (change.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List remObjs = change.getRemoveObjects();
            ArrayList<Element> removedList = new ArrayList<Element>();
            OwnerMap ownerMap = OwnerMap.getInstance(this);
            int i = 0;
            while (i < remObjs.size()) {
                Element element = (Element)remObjs.get(i);
                Node owner = ownerMap.getContainerOwner(element);
                if (owner != null && this.remove(element, false)) {
                    removedList.add(element);
                }
                ++i;
            }
            if (removedList.size() > 0) {
                UpdateMessage.fireChildrenRemoved(this, removedList);
            }
        }
    }

    public final void notifyVetoObservers(Object subject, UpdateMessage change) throws ChangeVetoException {
        ((VetoableSubject)this.getSubject()).notifyVetoObservers(subject, change);
    }

    public static final String getDefaultName() {
        return ModelArb.getString(31);
    }

    final void loadImpl() throws IOException {
        if (_customizedDefaults != null) {
            _customizedDefaults.copyTo(this._hash);
        }
        super.loadImpl();
    }

    final void initListOfChildren() {
    }

    protected final HashStructureIO newHashStructureIO() {
        HashStructureIO io = super.newHashStructureIO();
        io.addXpathToFlatten("/*[local-name()='project']/list[@n='ownerMap']/hash");
        return io;
    }

    protected final String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    protected final String getRootQName() {
        return ROOT_QNAME;
    }

    protected final Subject createSubject() {
        return new IdeVetoableSubject();
    }

    public final boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((Project)o);
    }

    public final Object copyTo(Object object) {
        Project copy = object != null ? (Project)object : new Project();
        this.copyToImpl(copy);
        return copy;
    }

    void handleCustomPropsClosed() {
        StorageListener.mav$handleCustomPropsClosed(this._storageListener);
    }

    void handleCustomPropsOpened(HashStructure customProperties) {
        StorageListener.mav$handleCustomPropsOpened(this._storageListener, customProperties);
    }

    void handleAttachStructureChangeListener(HashStructure hash) {
        StorageListener.mav$attachStructureChangeListener(this._storageListener, this._hash);
    }

    void handleDetachStructureChangeListener() {
        StorageListener.mav$detachStructureChangeListener(this._storageListener);
    }

    void handlePropertiesCopied(HashStructureNode copy) {
        StorageListener.mav$fireNodeCopied(this._storageListener, copy);
    }

    private Iterator getMyChildren() {
        Iterator nodeIter = this.getChildren();
        Map ownerMap = OwnerMap.getInstance(this).getMap();
        if (ownerMap != null) {
            ArrayList<Node> ownedNodes = new ArrayList<Node>();
            for (Reference ref : ownerMap.keySet()) {
                ownedNodes.add(ref.getData());
            }
            int numOwnedNodes = ownedNodes.size();
            if (numOwnedNodes > 0) {
                return new 1(this, nodeIter, numOwnedNodes, ownedNodes);
            }
        }
        return nodeIter;
    }

    private static boolean namesMatch(String listenerKey, String propertyName) {
        if (propertyName.startsWith(listenerKey)) {
            int listenerKeyLen;
            int propertyNameLen = propertyName.length();
            return propertyNameLen == (listenerKeyLen = listenerKey.length()) || propertyName.charAt(listenerKeyLen) == '/' || listenerKeyLen == 0;
        }
        return false;
    }

    static StorageListener ra$_storageListener(Project project) {
        return project._storageListener;
    }

    static CopyOnWriteArrayList ra$_projectChangeListenersOrder() {
        return _projectChangeListenersOrder;
    }

    static IdentityHashMap ra$_projectChangeListenersMap() {
        return _projectChangeListenersMap;
    }

    static boolean maS$namesMatch(String string, String string2) {
        return Project.namesMatch(string, string2);
    }

    final class 1
    implements Iterator {
        private Object _next;
        private final /* synthetic */ Iterator v$nodeIter;
        private final /* synthetic */ int v$numOwnedNodes;
        private final /* synthetic */ ArrayList v$ownedNodes;
        final /* synthetic */ Project this$0;

        public boolean hasNext() {
            this.ensurePrepared();
            return this._next != null;
        }

        public Object next() {
            this.ensurePrepared();
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            Object next = this._next;
            this._next = null;
            return next;
        }

        public void remove() {
            new UnsupportedOperationException().printStackTrace();
        }

        private void ensurePrepared() {
            if (this._next == null) {
                while (this.v$nodeIter.hasNext()) {
                    Object nodeObj = this.v$nodeIter.next();
                    if (this.isOwnedNode(nodeObj)) continue;
                    this._next = nodeObj;
                    return;
                }
            }
        }

        private boolean isOwnedNode(Object nodeObj) {
            int i = 0;
            while (i < this.v$numOwnedNodes) {
                if (nodeObj == this.v$ownedNodes.get(i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public 1(Project project, Iterator iterator, int n, ArrayList arrayList) {
            this.v$ownedNodes = arrayList;
            this.v$numOwnedNodes = n;
            this.v$nodeIter = iterator;
            this.this$0 = project;
        }
    }

    private static final class NL
    extends NodeListener {
        void nodeLoaded(NodeEvent e) {
            StorageListener.mav$fireProjectLoaded(Project.ra$_storageListener((Project)e.getNode()));
        }

        void nodeUnloaded(NodeEvent e) {
            StorageListener.mav$fireProjectUnloaded(Project.ra$_storageListener((Project)e.getNode()));
        }

        public void nodeOpened(NodeEvent e) {
            StorageListener.mav$fireProjectOpened(Project.ra$_storageListener((Project)e.getNode()));
        }

        public void nodeClosed(NodeEvent e) {
            StorageListener.mav$fireProjectClosed(Project.ra$_storageListener((Project)e.getNode()));
        }

        private NL() {
        }

        NL(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class StorageListener
    extends StructureChangeListener {
        private HashStructure _projectProps;
        private HashStructure _customProps;

        private void attachStructureChangeListener(HashStructure projectProps) {
            this._projectProps = projectProps;
            projectProps.addStructureChangeListener((StructureChangeListener)this);
        }

        private void fireNodeCopied(HashStructureNode copy) {
            Project projectCopy = (Project)copy;
            for (ProjectChangeListener listener : Project.ra$_projectChangeListenersOrder()) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectCopied(Project.this, projectCopy);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectCopied", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void fireProjectLoaded() {
            for (ProjectChangeListener listener : Project.ra$_projectChangeListenersOrder()) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectLoaded(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectLoaded()", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void fireProjectUnloaded() {
            for (ProjectChangeListener listener : Project.ra$_projectChangeListenersOrder()) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectUnloaded(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectUnloaded", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void fireProjectOpened() {
            for (ProjectChangeListener listener : Project.ra$_projectChangeListenersOrder()) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectOpened(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectOpened", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void detachStructureChangeListener() {
            if (this._projectProps != null) {
                this._projectProps.removeStructureChangeListener((StructureChangeListener)this);
            }
        }

        private void fireProjectClosed() {
            for (ProjectChangeListener listener : Project.ra$_projectChangeListenersOrder()) {
                try {
                    long startTime = System.nanoTime();
                    listener.projectClosed(Project.this);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectClosed", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleCustomPropsOpened(HashStructure customProps) {
            this._customProps = customProps;
            customProps.addStructureChangeListener((StructureChangeListener)this);
        }

        private void handleCustomPropsClosed() {
            if (this._customProps != null) {
                this._customProps.removeStructureChangeListener((StructureChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void structureValuesChanged(StructureChangeEvent e) {
            ChangeInfo[] details = e.getChangeDetails();
            int n = details.length;
            ArrayList<ChangeInfo> chunkedDetails = new ArrayList<ChangeInfo>();
            for (Object listenerObj : Project.ra$_projectChangeListenersOrder()) {
                CopyOnWriteArrayList listenerKeys;
                IdentityHashMap identityHashMap = Project.ra$_projectChangeListenersMap();
                synchronized (identityHashMap) {
                    listenerKeys = (CopyOnWriteArrayList)Project.ra$_projectChangeListenersMap().get(listenerObj);
                }
                if (listenerKeys == null) continue;
                Iterator keyIter = listenerKeys.iterator();
                chunkedDetails.clear();
                while (keyIter.hasNext()) {
                    String listenerKey = keyIter.next().toString();
                    int j = 0;
                    while (j < n) {
                        ChangeInfo detail = details[j];
                        String propertyName = detail.getPropertyName();
                        if (Project.maS$namesMatch(listenerKey, propertyName)) {
                            chunkedDetails.add(detail);
                        }
                        ++j;
                    }
                }
                if (chunkedDetails.size() <= 0) continue;
                ChangeInfo[] chunkedDetailsArray = chunkedDetails.toArray(new ChangeInfo[chunkedDetails.size()]);
                ProjectChangeEvent event = new ProjectChangeEvent(e.getSource(), Project.this, chunkedDetailsArray);
                ProjectChangeListener listener = (ProjectChangeListener)listenerObj;
                try {
                    long startTime = System.nanoTime();
                    listener.projectPropertiesChanged(event);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("ProjectChangeListener.projectPropertiesChanged", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private StorageListener() {
        }

        static void mav$fireNodeCopied(StorageListener storageListener, HashStructureNode hashStructureNode) {
            storageListener.fireNodeCopied(hashStructureNode);
        }

        static void mav$detachStructureChangeListener(StorageListener storageListener) {
            storageListener.detachStructureChangeListener();
        }

        static void mav$attachStructureChangeListener(StorageListener storageListener, HashStructure hashStructure) {
            storageListener.attachStructureChangeListener(hashStructure);
        }

        static void mav$handleCustomPropsOpened(StorageListener storageListener, HashStructure hashStructure) {
            storageListener.handleCustomPropsOpened(hashStructure);
        }

        static void mav$handleCustomPropsClosed(StorageListener storageListener) {
            storageListener.handleCustomPropsClosed();
        }

        StorageListener(1 var2_2) {
            this();
        }

        static void mav$fireProjectClosed(StorageListener storageListener) {
            storageListener.fireProjectClosed();
        }

        static void mav$fireProjectOpened(StorageListener storageListener) {
            storageListener.fireProjectOpened();
        }

        static void mav$fireProjectUnloaded(StorageListener storageListener) {
            storageListener.fireProjectUnloaded();
        }

        static void mav$fireProjectLoaded(StorageListener storageListener) {
            storageListener.fireProjectLoaded();
        }

        public final class 1 {
        }
    }

    static final class 2
    extends ProjectChangeListener {
        private int _eventCounter;
        private final /* synthetic */ int v$debugLevel;

        private void $init$() {
            this._eventCounter = 0;
        }

        void projectLoaded(Project project) {
            System.out.println("[Project loaded] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
        }

        public void projectOpened(Project project) {
            System.out.println("[Project opened] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
        }

        public void projectClosed(Project project) {
            System.out.println("[Project closed] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
        }

        void projectUnloaded(Project project) {
            System.out.println("[Project unloaded] " + URLFileSystem.getPlatformPathName((URL)project.getURL()));
        }

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            ChangeInfo[] details = e.getChangeDetails();
            int n = details.length;
            boolean hasNonPlaceholderEvent = false;
            if (this.v$debugLevel == 2) {
                int i = 0;
                while (i < n) {
                    ChangeInfo detail = details[i];
                    if (detail.getChangeType() == 2) {
                        details[i] = null;
                    } else {
                        hasNonPlaceholderEvent = true;
                    }
                    ++i;
                }
            }
            if (this.v$debugLevel > 2 || hasNonPlaceholderEvent) {
                ++this._eventCounter;
                int i = 0;
                while (i < details.length) {
                    ChangeInfo detail = details[i];
                    if (detail != null) {
                        Project p = e.getProject();
                        if (e.getSource() == p._hash) {
                            System.out.print("[" + this._eventCounter + "] shared ");
                        } else {
                            System.out.print("[" + this._eventCounter + "] user   ");
                        }
                        System.out.println(details[i].toString());
                    }
                    ++i;
                }
            }
        }

        public 2(int n) {
            this.v$debugLevel = n;
            this.$init$();
        }
    }
}

