/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import oracle.ide.ExtensionRegistry;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

final class UserProperties
implements PropertyStorage,
Copyable {
    private final URL _sharedStorageURL;
    private HashStructure _hash;
    private URL _userStorageURL;
    private final String _namespaceURI;
    private final String _rootQName;

    UserProperties(URL sharedStorageURL, String namespaceURI, String rootQName) {
        if (sharedStorageURL == null) {
            throw new IllegalArgumentException();
        }
        this._sharedStorageURL = sharedStorageURL;
        this._namespaceURI = namespaceURI;
        this._rootQName = rootQName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws IOException {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            if (this._hash != null && this._hash.isDirty()) {
                ObjectStore io = this.getIO();
                io.save(this.getUserStorageURL(), (Object)this._hash);
                Index.getInstance().commit(this._sharedStorageURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashStructure getProperties() {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            if (this._hash == null) {
                try {
                    URL userStorageURL = this.getUserStorageURL();
                    if (URLFileSystem.exists((URL)userStorageURL)) {
                        ObjectStore io = this.getIO();
                        HashStructure hashStructure = this._hash = (HashStructure)io.load(userStorageURL);
                        return hashStructure;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this._hash = HashStructure.newInstance();
            }
            HashStructure hashStructure = this._hash;
            return hashStructure;
        }
    }

    public Object copyTo(Object target) {
        UserProperties copy = target != null ? (UserProperties)target : new UserProperties(this._sharedStorageURL, this._namespaceURI, this._rootQName);
        this.copyToImpl(copy);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void copyToImpl(UserProperties copy) {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            UserProperties userProperties2 = copy;
            synchronized (userProperties2) {
                if (this._hash != null) {
                    if (copy._hash != null) {
                        this._hash.copyTo(copy._hash);
                    } else {
                        copy._hash = this._hash.copyTo(null);
                    }
                } else {
                    copy._hash = null;
                }
                copy._userStorageURL = this._userStorageURL;
            }
        }
    }

    protected final ObjectStore getIO() {
        return new HashStructureIO(this._namespaceURI, this._rootQName);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((UserProperties)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean equalsImpl(UserProperties other) {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            UserProperties userProperties2 = other;
            synchronized (userProperties2) {
                boolean bl = URLFileSystem.equals((URL)this._sharedStorageURL, (URL)other._sharedStorageURL) && URLFileSystem.equals((URL)this._userStorageURL, (URL)other._userStorageURL) && ModelUtil.areEqual((Object)this._hash, (Object)other._hash);
                return bl;
            }
        }
    }

    private URL getUserStorageURL() throws IOException {
        if (this._userStorageURL == null) {
            this._userStorageURL = Index.getInstance().getUserStorageURL(this._sharedStorageURL);
        }
        return this._userStorageURL;
    }

    private static class Index {
        private static Index _instance;
        private final HashStructure _hash;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Index() throws IOException {
            File indexFile = new File(this.projectsDir(), "index2.xml");
            if (!indexFile.exists()) {
                this.convertOldIndex();
            }
            this._hash = indexFile.exists() ? (HashStructure)new HashStructureIO(null, null).load(URLFactory.newFileURL((File)indexFile)) : HashStructure.newInstance();
            ExitCommand.addShutdownHook(new 1());
        }

        static synchronized Index getInstance() throws IOException {
            if (_instance == null) {
                _instance = new Index();
            }
            return _instance;
        }

        private String encode(URL key) {
            return URLEncoder.encode(key.getPath());
        }

        private File projectsDir() {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL url = er.getSystemDirectory("oracle.ide");
            File dir = new File(url.getPath(), "projects");
            dir.mkdirs();
            return dir;
        }

        private void convertOldIndex() throws IOException {
            File projectsDir = this.projectsDir();
            File oldIndex = new File(projectsDir, "index.xml");
            if (!oldIndex.exists()) {
                return;
            }
            ListStructureIO listIO = new ListStructureIO(null, null);
            ListStructure list = (ListStructure)listIO.load(URLFactory.newFileURL((File)oldIndex));
            HashStructure hsNew = HashStructure.newInstance();
            for (Object o : list) {
                HashStructure h = (HashStructure)o;
                String user = h.getString("user");
                if (!new File(projectsDir, user).exists()) continue;
                URL shared = h.getURL("shared");
                HashStructure hs = HashStructure.newInstance();
                hs.putString("user", user);
                hsNew.putHashStructure(this.encode(shared), hs);
            }
            this.save(hsNew);
            oldIndex.delete();
        }

        private void save(HashStructure hsNew) throws IOException {
            File newIndex = new File(this.projectsDir(), "index2.xml");
            new HashStructureIO(null, "index").save(URLFactory.newFileURL((File)newIndex), (Object)hsNew);
            hsNew.markDirty(false);
        }

        private String generateUserStorageName(URL shared) {
            String checksum = Index.checksum(shared.getPath());
            String name = URLFileSystem.getName((URL)shared) + checksum + URLFileSystem.getSuffix((URL)shared);
            int index = 0;
            while (new File(this.projectsDir(), name).exists()) {
                name = URLFileSystem.getName((URL)shared) + checksum + String.valueOf(index) + URLFileSystem.getSuffix((URL)shared);
                ++index;
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        URL getUserStorageURL(URL sharedStorageURL) {
            HashStructure hashStructure = this._hash;
            synchronized (hashStructure) {
                HashStructure result = this._hash.getHashStructure(this.encode(sharedStorageURL));
                if (result == null) {
                    result = HashStructure.newInstance();
                    result.putBoolean("committed", false);
                    result.putString("user", this.generateUserStorageName(sharedStorageURL));
                    this._hash.putHashStructure(this.encode(sharedStorageURL), result);
                }
                String user = result.getString("user");
                URL uRL = URLFactory.newFileURL((File)new File(this.projectsDir(), user));
                return uRL;
            }
        }

        static {
            $assertionsDisabled = Index.class.desiredAssertionStatus() ^ true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit(URL sharedStorageURL) {
            HashStructure hashStructure = this._hash;
            synchronized (hashStructure) {
                HashStructure result = this._hash.getHashStructure(this.encode(sharedStorageURL));
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError();
                }
                result.remove("committed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() throws IOException {
            HashStructure hashStructure = this._hash;
            synchronized (hashStructure) {
                if (!this._hash.isDirty()) {
                    return;
                }
                ArrayList<String> keysToRemove = new ArrayList<String>();
                for (String key : this._hash.keySet()) {
                    HashStructure hs = this._hash.getHashStructure(key);
                    if (hs.getBoolean("committed", true)) continue;
                    keysToRemove.add(key);
                }
                for (String key : keysToRemove) {
                    this._hash.remove(key);
                }
                this.save(this._hash);
            }
        }

        private static String checksum(String filename) {
            byte[] b = Index.md5(filename);
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < b.length) {
                result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
                ++i;
            }
            return result.toString();
        }

        private static byte[] md5(String filename) {
            MessageDigest complete = null;
            try {
                complete = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nse) {
                throw new IllegalStateException(nse);
            }
            return complete.digest(filename.getBytes());
        }

        static void mav$save(Index index) {
            index.save();
        }

        final class 1
        implements ShutdownHook {
            public void shutdown() {
                try {
                    Index.mav$save(Index.this);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public boolean canShutdown() {
                return true;
            }
        }
    }
}

