/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public final class UserPropertiesMigrator
implements Migrator {
    private static final int MY_CATEGORY = 0;

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return "Custom Project Properties";
    }

    public boolean canMigrate(int category, File sourceDir) {
        return category == 0;
    }

    public void setSelected(int category, boolean selected) {
    }

    public boolean isSelected(int category) {
        return category == 0;
    }

    public String[] migrate(File srcDir, File dstDir) {
        URL srcProjectsURL = UserPropertiesMigrator.getProjectsURL(srcDir);
        if (URLFileSystem.exists((URL)srcProjectsURL)) {
            URL dstProjectsURL = UserPropertiesMigrator.getProjectsURL(dstDir);
            ListStructure index = null;
            URL srcIndexURL = UserPropertiesMigrator.getIndexURL(srcProjectsURL);
            ListStructureIO io = new ListStructureIO(null, "index");
            try {
                index = (ListStructure)io.load(srcIndexURL);
                if (index != null) {
                    URL dstIndexURL = UserPropertiesMigrator.getIndexURL(dstProjectsURL);
                    io.save(dstIndexURL, (Object)index);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (index != null) {
                for (Object obj : index) {
                    URL srcUserFileURL;
                    HashStructure hash;
                    String userFileName;
                    if (!(obj instanceof HashStructure) || (userFileName = (hash = (HashStructure)obj).getString("user")) == null || !URLFileSystem.exists((URL)(srcUserFileURL = URLFactory.newURL((URL)srcProjectsURL, (String)userFileName)))) continue;
                    URL dstUserFileURL = URLFactory.newURL((URL)dstProjectsURL, (String)userFileName);
                    try {
                        HashStructureIO io2 = new HashStructureIO("http://xmlns.oracle.com/ide/project", "jpr:project");
                        HashStructure jprHash = (HashStructure)io2.load(srcUserFileURL);
                        if (jprHash == null) continue;
                        io2.save(dstUserFileURL, (Object)jprHash);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private static URL getProjectsURL(File dir) {
        return URLFactory.newDirURL((File)new File(dir, "projects"));
    }

    private static URL getIndexURL(URL projectsDir) {
        return URLFactory.newURL((URL)projectsDir, (String)"index.xml");
    }
}

