/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Iterator;
import java.util.List;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;

public class WorkingSetsMigratorHelper
extends NodeMigratorHelper {
    private static final WorkingSetsMigratorHelper _instance = new WorkingSetsMigratorHelper();

    public static WorkingSetsMigratorHelper getInstance() {
        return _instance;
    }

    private WorkingSetsMigratorHelper() {
    }

    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        MigrationInfo[] migrationInfoArray = infos;
        int n = 0;
        while (n < migrationInfoArray.length) {
            MigrationInfo info = migrationInfoArray[n];
            Node node = info.getNode();
            if (node instanceof Workspace) {
                Workspace workspace = (Workspace)node;
                WorkingSets appWorkingSets = WorkingSets.getInstance(workspace);
                Iterator<Element> children = workspace.getChildren();
                while (children.hasNext()) {
                    Element nextChild = children.next();
                    if (!(nextChild instanceof Project)) continue;
                    Project project = (Project)nextChild;
                    this.migrateWorkingSets(project, appWorkingSets);
                }
            }
            ++n;
        }
    }

    private void migrateWorkingSets(Project project, WorkingSets appWorkingSets) {
        HashStructure properties = project.getPropertiesForOverriding();
        if (properties.containsKey("working-sets")) {
            HashStructure projWorkingSetsHash = properties.getHashStructure("working-sets");
            WorkingSets projWorkingSets = WorkingSets.projectWorkingSets(projWorkingSetsHash);
            List namedWorkingSets = projWorkingSets.getWorkingSetNames();
            for (String name : namedWorkingSets) {
                if (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(name)) continue;
                WorkingSet set = projWorkingSets.getWorkingSet(name);
                WorkingSet appWS = appWorkingSets.getWorkingSet(name);
                if (appWS.getPatternFilters(project) != null) continue;
                appWS.includeProject(project);
                PatternFilters patternFilters = appWS.getOrCreatePatternFilters(project);
                patternFilters.setFilters(set.getPatternFilters() != null ? set.getPatternFilters().getFilters() : null);
            }
        }
    }

    public String getNodeMigratorHelperKey() {
        return ProjectMigrator.MIGRATOR_NAME;
    }
}

