/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspaces;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Workspace
extends HashStructureNode {
    public static final String DATA_KEY = "Application";
    public static final String EXT = ".jws";
    static final String NAMESPACE_URI = "http://xmlns.oracle.com/ide/project";
    static final String ROOT_QNAME = "jws:workspace";
    private transient Project _activeProject;
    private transient URL _activeProjectURL;

    public Workspace() {
        this.getAttributes().set(ElementAttributes.BUILDABLE | ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.NAVIGABLE | ElementAttributes.CLOSEABLE | ElementAttributes.NON_HISTORIED);
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"application.png");
    }

    @Override
    public boolean canAdd(Element element) {
        return element instanceof Project;
    }

    @Override
    public boolean remove(Element doc, boolean notifyObservers) {
        boolean removeOk = super.remove(doc, notifyObservers);
        if (removeOk && (doc == this._activeProject || this.size() == 0)) {
            this._activeProject = null;
            this._activeProjectURL = null;
            this.markWorkspacesDirty();
        }
        return removeOk;
    }

    @Override
    protected final HashStructureIO newHashStructureIO() {
        HashStructureIO io = super.newHashStructureIO();
        io.addXpathToFlatten("/*[local-name()='workspace']/list[@n='listOfChildren']/hash");
        return io;
    }

    @Override
    protected final String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    @Override
    protected final String getRootQName() {
        return ROOT_QNAME;
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._activeProject = null;
        this.markWorkspacesDirty();
    }

    @Override
    protected void saveImpl() throws IOException {
        ListStructure listOfChildren = this.getListOfChildrenListStructure();
        try {
            listOfChildren.internalPreprsist();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.saveImpl();
    }

    @Override
    public final Object copyTo(Object object) {
        Workspace copy = object != null ? (Workspace)object : new Workspace();
        this.copyToImpl(copy);
        return copy;
    }

    @Override
    public boolean isDefault() {
        return Ide.isRunning() && !Ide.isStarting() && this == Ide.getDefaultWorkspace();
    }

    public URL getActiveProjectURL() throws TransientMarker {
        return this._activeProjectURL;
    }

    public void setActiveProjectURL(URL activeProjectURL) {
        if (ModelUtil.areDifferent((Object)this._activeProjectURL, (Object)activeProjectURL)) {
            this._activeProjectURL = activeProjectURL;
            this._activeProject = (Project)NodeFactory.find(this._activeProjectURL);
        }
    }

    public Project currentActiveProject() {
        if (this._activeProject != null) {
            return this._activeProject;
        }
        if (this._activeProjectURL != null) {
            try {
                this._activeProject = (Project)NodeFactory.findOrCreate(this._activeProjectURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this._activeProject;
    }

    public void setActiveProject(Project activeProject) {
        if (this._activeProject != activeProject && this.size() > 0) {
            this._activeProject = activeProject;
            if (this._activeProject != null) {
                if (ModelUtil.areDifferent((Object)this._activeProject.getURL(), (Object)this._activeProjectURL)) {
                    this._activeProjectURL = this._activeProject.getURL();
                }
            } else {
                this._activeProjectURL = null;
            }
            this.markWorkspacesDirty();
        }
    }

    public Project getActiveProject() {
        return this._activeProject;
    }

    @NotNull
    public Collection<Project> projects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        Iterator<Element> i = this.getChildren();
        while (i.hasNext()) {
            Element e = i.next();
            if (!(e instanceof Project)) continue;
            projects.add((Project)e);
        }
        return Collections.unmodifiableCollection(projects);
    }

    private void markWorkspacesDirty() {
        Workspaces wsps = Ide.getWorkspaces();
        if (wsps != null) {
            wsps.markDirty(true);
        }
    }
}

