/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TitledPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProjectPropertiesArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;

final class ProjectPropertiesMDDPanel
extends MDDPanel {
    private JButton customizeButton;
    private JRadioButton useCustomSettingsOption;
    private JRadioButton useProjectSettingsOption;
    private JPanel userSharedOptionsPanel;
    private JPanel propertiesPanel;
    private JPanel content;
    private Border lineBorder;
    Namespace propertyData;
    private boolean optionsAreVisible;
    private HashMap stateMap;
    private static final String USER_PROPERTIES_ACTIVE = "userPropertiesAreActive";

    private void $init$() {
        this.stateMap = new HashMap();
    }

    ProjectPropertiesMDDPanel(Navigable[] rootNavigables, boolean useDetailTree, Namespace propertyData, String objectLabel) {
        super(rootNavigables, useDetailTree);
        this.$init$();
        this.addMDDListener((MDDListener)new TraversableListener(null));
        this.propertyData = propertyData;
        ResourceUtils.resButton((AbstractButton)this.useProjectSettingsOption, (String)ProjectPropertiesArb.format(3, objectLabel));
    }

    protected TitledPanel createTitledPanel(JPanel propertyPanel) {
        this.propertiesPanel = propertyPanel;
        this.lineBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.propertiesPanel.setBorder(this.lineBorder);
        this.content = new JPanel(new BorderLayout(0, 3));
        this.content.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.content.add((Component)this.createOptionsPanel(), "North");
        this.content.add((Component)this.propertiesPanel, "Center");
        TitledPanel tPanel = new TitledPanel((Component)this.content);
        tPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.optionsAreVisible = true;
        return tPanel;
    }

    private boolean loadDialog() {
        Navigable navigable = this.getCurrentNavigable();
        Traversable traversable = navigable.newTraversable((ApplyNotifier)this);
        String name = navigable.getShortLabel();
        String title = ProjectPropertiesArb.format(4, name);
        this.propertyData.put("IsUserPropertyData", (Object)Boolean.TRUE);
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)Ide.getMainWindow()), title, traversable, this.propertyData);
        JEWTDialog dlg = launcher.initDialog();
        dlg.pack();
        dlg.setMaximumInitialSize(500, 420);
        boolean okay = launcher.showDialog();
        launcher.dispose();
        this.propertyData.put("IsUserPropertyData", (Object)Boolean.FALSE);
        return okay;
    }

    private JPanel createOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.userSharedOptionsPanel = new JPanel(gridBagLayout);
        this.customizeButton = new JButton();
        this.customizeButton.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this.customizeButton, (String)ProjectPropertiesArb.getString(2));
        this.customizeButton.addActionListener(new 1());
        this.useCustomSettingsOption = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.useCustomSettingsOption, (String)ProjectPropertiesArb.getString(5));
        this.useProjectSettingsOption = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.useCustomSettingsOption);
        group.add(this.useProjectSettingsOption);
        this.useProjectSettingsOption.setSelected(true);
        OptionListener listener = new OptionListener(null);
        this.useCustomSettingsOption.addItemListener(listener);
        this.useProjectSettingsOption.addItemListener(listener);
        this.userSharedOptionsPanel.add((Component)this.useCustomSettingsOption, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.userSharedOptionsPanel.add((Component)this.customizeButton, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.userSharedOptionsPanel.add((Component)this.useProjectSettingsOption, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return this.userSharedOptionsPanel;
    }

    private void setPanelEnabled(Container container, boolean enable) {
        Component[] children = container.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                try {
                    this.setPanelEnabled((Container)children[i], enable);
                }
                catch (Exception e) {
                    // empty catch block
                }
                children[i].setEnabled(enable);
            }
            ++i;
        }
    }

    private void setOptionsPanelVisible(boolean visible) {
        if (visible) {
            if (!this.optionsAreVisible) {
                this.content.add((Component)this.userSharedOptionsPanel, "North");
                this.propertiesPanel.setBorder(this.lineBorder);
            }
        } else if (this.optionsAreVisible) {
            this.content.remove(this.userSharedOptionsPanel);
            this.propertiesPanel.setBorder(null);
        }
        this.optionsAreVisible = visible;
    }

    private void storePanelState(DefaultTraversablePanel panel, boolean userPropertiesAreActive) {
        if (userPropertiesAreActive) {
            this.stateMap.put(panel, USER_PROPERTIES_ACTIVE);
        } else {
            this.stateMap.put(panel, null);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (!this.useCustomSettingsOption.isSelected()) {
            super.onExit(tc);
        }
        Iterator iter = this.stateMap.keySet().iterator();
        while (iter.hasNext()) {
            try {
                ProjectSettingsTraversablePanel panel = (ProjectSettingsTraversablePanel)((Object)iter.next());
                boolean userProperties = this.stateMap.get((Object)panel) != null;
                panel.activateProperties(tc, userProperties);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.stateMap.clear();
    }

    private void updateRadioButtonsAndPanelState(boolean isUseCustomProperties) {
        try {
            Ide.getWaitCursor().show();
            if (isUseCustomProperties) {
                this.customizeButton.setEnabled(true);
                this.setPanelEnabled(this.propertiesPanel, false);
                ProjectSettingsTraversablePanel panel = (ProjectSettingsTraversablePanel)this.getCurrentTraversable();
                if (this.stateMap.containsKey((Object)panel) && this.stateMap.get((Object)panel) == null) {
                    try {
                        TraversableContext tc = this.newTraversableContext();
                        this.getCurrentTraversable().onExit(tc);
                        panel.activateProperties(tc, true);
                    }
                    catch (TraversalException te) {}
                }
            } else {
                this.customizeButton.setEnabled(false);
                this.setPanelEnabled(this.propertiesPanel, true);
                this.getCurrentTraversable().onEntry(this.newTraversableContext());
            }
            this.storePanelState((DefaultTraversablePanel)this.getCurrentTraversable(), isUseCustomProperties);
        }
        finally {
            Ide.getWaitCursor().hide();
        }
    }

    static JRadioButton ra$useCustomSettingsOption(ProjectPropertiesMDDPanel projectPropertiesMDDPanel) {
        return projectPropertiesMDDPanel.useCustomSettingsOption;
    }

    static void mav$updateRadioButtonsAndPanelState(ProjectPropertiesMDDPanel projectPropertiesMDDPanel, boolean bl) {
        projectPropertiesMDDPanel.updateRadioButtonsAndPanelState(bl);
    }

    static void mav$setOptionsPanelVisible(ProjectPropertiesMDDPanel projectPropertiesMDDPanel, boolean bl) {
        projectPropertiesMDDPanel.setOptionsPanelVisible(bl);
    }

    static HashMap ra$stateMap(ProjectPropertiesMDDPanel projectPropertiesMDDPanel) {
        return projectPropertiesMDDPanel.stateMap;
    }

    static void mav$storePanelState(ProjectPropertiesMDDPanel projectPropertiesMDDPanel, DefaultTraversablePanel defaultTraversablePanel, boolean bl) {
        projectPropertiesMDDPanel.storePanelState(defaultTraversablePanel, bl);
    }

    static JRadioButton ra$useProjectSettingsOption(ProjectPropertiesMDDPanel projectPropertiesMDDPanel) {
        return projectPropertiesMDDPanel.useProjectSettingsOption;
    }

    static boolean mav$loadDialog(ProjectPropertiesMDDPanel projectPropertiesMDDPanel) {
        return projectPropertiesMDDPanel.loadDialog();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ProjectPropertiesMDDPanel.mav$loadDialog(ProjectPropertiesMDDPanel.this);
        }
    }

    private final class OptionListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ProjectPropertiesMDDPanel.mav$updateRadioButtonsAndPanelState(ProjectPropertiesMDDPanel.this, e.getSource() == ProjectPropertiesMDDPanel.ra$useCustomSettingsOption(ProjectPropertiesMDDPanel.this));
            }
        }

        private OptionListener() {
        }

        OptionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TraversableListener
    extends MDDAdapter {
        public void traversableEntered(MDDEvent e) {
            Traversable t = e.getTraversable();
            if (!(t instanceof ProjectSettingsTraversablePanel)) {
                throw new RuntimeException("Error in: " + t.getClass().getName() + "\nProject Properties panels must extend oracle.ide.model.panels.ProjectSettingsTraversablePanel");
            }
            ProjectSettingsTraversablePanel panel = (ProjectSettingsTraversablePanel)e.getTraversable();
            if (panel.isUserOnly()) {
                ProjectPropertiesMDDPanel.mav$setOptionsPanelVisible(ProjectPropertiesMDDPanel.this, false);
            } else {
                boolean userPropertiesAreActive;
                ProjectPropertiesMDDPanel.mav$setOptionsPanelVisible(ProjectPropertiesMDDPanel.this, true);
                if (ProjectPropertiesMDDPanel.ra$stateMap(ProjectPropertiesMDDPanel.this).containsKey((Object)panel)) {
                    Object value = ProjectPropertiesMDDPanel.ra$stateMap(ProjectPropertiesMDDPanel.this).get((Object)panel);
                    userPropertiesAreActive = value != null;
                } else {
                    userPropertiesAreActive = panel.arePropertiesOverridden();
                    ProjectPropertiesMDDPanel.mav$storePanelState(ProjectPropertiesMDDPanel.this, panel, userPropertiesAreActive);
                }
                if (userPropertiesAreActive) {
                    if (ProjectPropertiesMDDPanel.ra$useCustomSettingsOption(ProjectPropertiesMDDPanel.this).isSelected()) {
                        ProjectPropertiesMDDPanel.mav$updateRadioButtonsAndPanelState(ProjectPropertiesMDDPanel.this, true);
                    }
                    ProjectPropertiesMDDPanel.ra$useCustomSettingsOption(ProjectPropertiesMDDPanel.this).setSelected(true);
                } else {
                    if (ProjectPropertiesMDDPanel.ra$useProjectSettingsOption(ProjectPropertiesMDDPanel.this).isSelected()) {
                        ProjectPropertiesMDDPanel.mav$updateRadioButtonsAndPanelState(ProjectPropertiesMDDPanel.this, false);
                    }
                    ProjectPropertiesMDDPanel.ra$useProjectSettingsOption(ProjectPropertiesMDDPanel.this).setSelected(true);
                }
            }
        }

        private TraversableListener() {
        }

        TraversableListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

