/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import oracle.ide.model.Project;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public abstract class ProjectSettingsTraversablePanel
extends DefaultTraversablePanel {
    private int propertiesAreOverridden;
    private static final int OVERRIDDEN = 1;
    private static final int NOT_OVERRIDDEN = 0;
    public static final String DEFAULT_PROJECT_KEY = "IsDefaultProject";
    public static final String EDITING_CUSTOM_PROPERTIES_KEY = "IsUserPropertyData";
    public static final String PROPERTY_DATA_KEY = "PropertyData";
    public static final String CHAINED_PROPERTY_DATA_KEY = "ChainedPropertyData";
    public static final String USER_ONLY_PROPERTY_DATA_KEY = "UserOnlyPropertyData";

    private void $init$() {
        this.propertiesAreOverridden = -1;
    }

    public final void onEntry(TraversableContext traversableContext) {
        if (traversableContext.contains(EDITING_CUSTOM_PROPERTIES_KEY) && Boolean.FALSE.equals(traversableContext.get(EDITING_CUSTOM_PROPERTIES_KEY))) {
            String[] propertyKeys = this.getPropertyKeys();
            if (this.propertiesAreOverridden < 0) {
                HashStructure allChainedProperties = (HashStructure)traversableContext.find(CHAINED_PROPERTY_DATA_KEY);
                HashStructure chained = this.getPanelProperties(allChainedProperties);
                this.propertiesAreOverridden = chained.isAnyValueOverridden(propertyKeys) ? 1 : 0;
            }
        }
        this.onProjectPanelEntry(traversableContext);
    }

    public abstract void onProjectPanelEntry(TraversableContext var1);

    public abstract String getDataKey();

    public abstract String[] getPropertyKeys();

    protected static Project getProject(Namespace data) {
        return (Project)data.find("Project");
    }

    protected static PropertyStorage getPropertyData(Namespace data) {
        HashStructure properties = (HashStructure)data.find(PROPERTY_DATA_KEY);
        return new PropertyData(properties);
    }

    public boolean isUserOnly() {
        return false;
    }

    public static final boolean isDefaultProject(Namespace data) {
        return Boolean.TRUE.equals(data.find(DEFAULT_PROJECT_KEY));
    }

    public static final boolean editingUserProperties(Namespace data) {
        return Boolean.TRUE.equals(data.find(EDITING_CUSTOM_PROPERTIES_KEY));
    }

    public final void activateProperties(TraversableContext tc, boolean useCustom) {
        HashStructure allUserProperties = (HashStructure)tc.get(USER_ONLY_PROPERTY_DATA_KEY);
        HashStructure user = this.getPanelProperties(allUserProperties);
        String[] propertyKeys = this.getPropertyKeys();
        if (useCustom) {
            user.recoverValues(propertyKeys);
        } else {
            user.hideValues(propertyKeys);
        }
    }

    public boolean arePropertiesOverridden() {
        return 1 == this.propertiesAreOverridden;
    }

    private HashStructure getPanelProperties(HashStructure hash) {
        String dataKey = this.getDataKey();
        if (dataKey != null) {
            return hash.getOrCreateHashStructure(dataKey);
        }
        return hash;
    }

    public ProjectSettingsTraversablePanel() {
        this.$init$();
    }

    private static class PropertyData
    implements PropertyStorage {
        private HashStructure propertyData;

        public PropertyData(HashStructure hash) {
            if (hash == null) {
                throw new IllegalArgumentException("The HashStructure cannot be null.");
            }
            this.propertyData = hash;
        }

        public HashStructure getProperties() {
            return this.propertyData;
        }
    }
}

