/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.io.File;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.natives.OpenDocumentException;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.AddinPolicyUtils;
import oracle.ide.util.Assert;

public class NativeHandler
implements Addin {
    private static final String LIBNAME = "idenative";
    private static boolean isLoaded;
    private static long hiPerfFreq;
    private static String _libDirectory;
    private static WatchListener _watchListener;
    static final int FILE_ADDED = 1;
    static final int FILE_REMOVED = 2;
    static final int FILE_MODIFIED = 3;
    static final int FILE_RENAMED_OLD = 4;
    static final int FILE_RENAMED_NEW = 5;

    public static native URLFileSystem.FileInfo[] ls(File var0);

    private static native long GetHiPerfTick();

    private static native long GetHiPerfFreq();

    private native void installHandler();

    private native void uninstallHandler();

    public static native boolean runAsAdmin(String var0, String var1);

    private static native void openDocumentImpl(String var0);

    public static native boolean makeFileWriteable(String var0);

    public static long getHiPerfTick() {
        if (isLoaded) {
            return NativeHandler.GetHiPerfTick();
        }
        return System.currentTimeMillis();
    }

    public static long getHiPerfFreq() {
        if (isLoaded) {
            if (hiPerfFreq > 0L) {
                return hiPerfFreq;
            }
            return NativeHandler.GetHiPerfFreq();
        }
        return 1000L;
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static Registry getRegistry() throws RegistryNotAvailableException {
        if (!isLoaded) {
            throw new RegistryNotAvailableException();
        }
        return new Registry();
    }

    public static void openDocument(String document) throws OpenDocumentException {
        if (!isLoaded) {
            throw new UnsupportedOperationException();
        }
        NativeHandler.openDocumentImpl(document);
    }

    static void setLibDirectory(String libDirectory) {
        Assert.println((String)"Warning: NativesHandler.setLibDirectory() called");
        Assert.println((String)"         This method should only be used from");
        Assert.println((String)"         a JUnit test for testing purposes.");
        _libDirectory = libDirectory;
    }

    public void initialize() {
        String ideLibDir = Ide.getOracleHomeDirectory() + "/ide/lib/";
        String libDir = _libDirectory != null ? _libDirectory : ideLibDir;
        String sPath = System.mapLibraryName(libDir + LIBNAME);
        try {
            File f = new File(sPath);
            if (!f.exists()) {
                return;
            }
            System.load(sPath);
            isLoaded = true;
            FileNativeHelper.setFileNativeHelper((FileNativeHelper)new 1());
        }
        catch (UnsatisfiedLinkError ex) {
            Assert.println((String)("Failed to load " + sPath));
        }
    }

    static native void enterWatcherThread();

    static synchronized void startWatcherThread(WatchListener listener) {
        if (_watchListener != null) {
            throw new IllegalStateException("watch listener already set");
        }
        _watchListener = listener;
        2 watcherRunnable = new 2();
        boolean oldwarn = AddinPolicyUtils.setWarnWhenCreatingThreads((boolean)false);
        Thread t = new Thread((Runnable)watcherRunnable, "Native Directory Watcher");
        AddinPolicyUtils.setWarnWhenCreatingThreads((boolean)oldwarn);
        t.setPriority(1);
        t.start();
    }

    static native void stopWatcherThread();

    static native boolean isWatcherThreadRunning();

    static native int startDirectoryWatch(String var0, boolean var1);

    static native void stopDirectoryWatch(String var0, int var1);

    static void notifyWatchEvent(int cookie, int action, String filename) {
        if (_watchListener != null) {
            _watchListener.notifyWatchEvent(cookie, action, filename);
        }
    }

    static void notifyWatchEnded(int cookie) {
        if (_watchListener != null) {
            _watchListener.notifyWatchEnded(cookie);
        }
    }

    static {
        hiPerfFreq = 0L;
        _libDirectory = null;
        _watchListener = null;
    }

    final class 1
    extends FileNativeHelper {
        public boolean isLoaded() {
            return NativeHandler.isLoaded();
        }

        public URLFileSystem.FileInfo[] ls(File file) {
            return NativeHandler.ls(file);
        }
    }

    static final class 2
    implements Runnable {
        public void run() {
            NativeHandler.enterWatcherThread();
        }
    }

    static interface WatchListener {
        public void notifyWatchEvent(int var1, int var2, String var3);

        public void notifyWatchEnded(int var1);
    }
}

