/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigation;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.EditorNavigationPoint;
import oracle.ide.navigation.NavigationPointEvent;
import oracle.ide.navigation.NavigationPointListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ContextHolder;
import oracle.ide.util.ContextWatcher;
import oracle.ide.view.View;

public class DefaultNavigationPoint
implements EditorNavigationPoint,
ContextHolder {
    protected URL nodeURL;
    protected URL prjURL;
    protected URL wspURL;
    protected Class viewClass;
    protected String viewID;
    protected boolean done;
    private NavigationPointListener listener;

    public final int navigate() throws Exception {
        if (!this.done) {
            return this.navigateImpl();
        }
        return this.renavigate();
    }

    public void refresh() {
    }

    public Context getContext() {
        EditorInfo info = DefaultNavigationPoint.findEditorInfo(this.viewID, this.nodeURL);
        Context context = Context.newIdeContext();
        try {
            context.setNode(NodeFactory.findOrCreate(this.nodeURL));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            context.setProject((Project)NodeFactory.findOrCreate(this.prjURL));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            context.setWorkspace((Workspace)NodeFactory.findOrCreate(this.wspURL));
        }
        catch (Exception e) {
            // empty catch block
        }
        context.setView(info != null ? info._getEditor() : null);
        return context;
    }

    public void setContext(Context context) {
        if (this.nodeURL != null || this.prjURL != null || this.wspURL != null) {
            ContextWatcher.stopWatching(this);
        }
        if (context != null) {
            Node node = context.getNode();
            Project prj = context.getProject();
            Workspace wsp = context.getWorkspace();
            View view = context.getView();
            this.nodeURL = node != null ? node.getURL() : null;
            this.prjURL = prj != null ? prj.getURL() : null;
            this.wspURL = wsp != null ? wsp.getURL() : null;
            this.viewClass = view != null ? view.getClass() : null;
            String string = this.viewID = view != null ? view.getId() : null;
        }
        if (this.nodeURL != null || this.prjURL != null || this.wspURL != null) {
            ContextWatcher.startWatching(this);
        }
    }

    public Object copyTo(Object target) {
        DefaultNavigationPoint point = target != null ? (DefaultNavigationPoint)target : new DefaultNavigationPoint();
        this.copyToImpl(point);
        return point;
    }

    protected final void copyToImpl(DefaultNavigationPoint point) {
        point.nodeURL = this.nodeURL;
        point.prjURL = this.prjURL;
        point.wspURL = this.wspURL;
        point.viewClass = this.viewClass;
        point.viewID = this.viewID;
        point.done = this.done;
    }

    public String toString() {
        Node node = null;
        if (this.nodeURL != null) {
            try {
                node = NodeFactory.findOrCreate(this.nodeURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return node != null ? node.getShortLabel() : IdeArb.getString(208);
    }

    public String getShortLabel() {
        return this.toString();
    }

    public String getLongLabel() {
        StringBuffer result = new StringBuffer(this.getShortLabel());
        if (this.viewClass != null && Editor.class.isAssignableFrom(this.viewClass)) {
            EditorAddin addin;
            EditorManager mgr = EditorManager.getEditorManager();
            EditorAddin editorAddin = addin = mgr != null ? mgr.getEditorAddin(this.viewClass) : null;
            if (addin != null) {
                result.append(" [");
                result.append(addin.getMenuSpecification().label);
                result.append("]");
            }
        }
        return result.toString();
    }

    public Icon getIcon() {
        Node node = null;
        if (this.nodeURL != null) {
            try {
                node = NodeFactory.findOrCreate(this.nodeURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return node != null ? node.getIcon() : null;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public void addNavigationPointListener(NavigationPointListener l) throws TooManyListenersException {
        if (this.listener != null && l != null && l != this.listener) {
            throw new TooManyListenersException();
        }
        this.listener = l;
    }

    public void removeNavigationPointListener(NavigationPointListener l) {
        if (l == this.listener) {
            this.listener = null;
        }
    }

    protected void fireExpired(NavigationPointEvent e) {
        if (this.listener != null) {
            long startTime = System.nanoTime();
            this.listener.expired(e);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("NavigationPointListener.expired", this.listener.getClass().getName(), endTime - startTime);
        }
    }

    protected void fireDescriptionChanged(NavigationPointEvent e) {
        if (this.listener != null) {
            long startTime = System.nanoTime();
            this.listener.descriptionChanged(e);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("NavigationPointListener.descriptionChanged", this.listener.getClass().getName(), endTime - startTime);
        }
    }

    protected int navigateImpl() throws Exception {
        this.done = true;
        return 0;
    }

    protected int renavigate() throws Exception {
        Editor editor;
        EditorInfo info = DefaultNavigationPoint.findEditorInfo(this.viewID, this.nodeURL);
        Editor editor2 = editor = info != null ? info._getEditor() : null;
        if (editor == null) {
            if (this.viewClass != null) {
                EditorManager mgr = EditorManager.getEditorManager();
                Editor editor3 = editor = mgr != null ? mgr.openEditorInFrame(this.viewClass, this.getContext()) : null;
            }
            if (editor != null) {
                this.viewClass = editor.getClass();
                this.viewID = editor.getId();
                this.fireDescriptionChanged(new NavigationPointEvent(this));
                return 0;
            }
        } else {
            EditorManager mgr = EditorManager.getEditorManager();
            if (mgr != null) {
                mgr.activateEditor(info);
                return 0;
            }
        }
        return 1;
    }

    protected static final EditorInfo findEditorInfo(String viewID, URL nodeURL) {
        Iterator i;
        if (viewID == null) {
            return null;
        }
        EditorManager mgr = EditorManager.getEditorManager();
        List editors = mgr != null ? mgr.getEditorsInfo() : null;
        Iterator iterator = i = editors != null ? editors.iterator() : null;
        if (i != null) {
            while (i.hasNext()) {
                EditorInfo info = (EditorInfo)i.next();
                Editor editor = info._getEditor();
                if (editor == null || !editor.getId().equals(viewID)) continue;
                Context ctx = editor.getContext();
                Node node = ctx.getNode();
                if (node == null || !URLFileSystem.equals((URL)node.getURL(), (URL)nodeURL)) {
                    return null;
                }
                return info;
            }
        }
        return null;
    }

    public void nodeRenamed(Context context) {
        URL url;
        Node node = context != null ? context.getNode() : null;
        this.nodeURL = url = node != null ? node.getURL() : null;
        this.fireDescriptionChanged(new NavigationPointEvent(this));
    }

    public void projectRenamed(Context context) {
        URL url;
        Project prj = context != null ? context.getProject() : null;
        this.prjURL = url = prj != null ? prj.getURL() : null;
    }

    public void workspaceRenamed(Context context) {
        URL url;
        Workspace wsp = context != null ? context.getWorkspace() : null;
        this.wspURL = url = wsp != null ? wsp.getURL() : null;
    }

    public void contextRemoved() {
        this.fireExpired(new NavigationPointEvent(this));
    }
}

