/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.EventQueue;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NavigatorWindow
extends DockableWindow {
    public static final String NAVIGATOR_WINDOW_ID = "NavigatorWindow";

    public NavigatorWindow() {
        super((String)null);
    }

    public abstract void setRootVisible(boolean var1);

    public abstract void collapse(TNode var1, boolean var2);

    public abstract void expand(TNode var1, boolean var2);

    public abstract TNode findTNode(Element var1, TNode var2);

    public abstract void refresh(TNode var1);

    public abstract TreeExplorer getTreeExplorer();

    public abstract NavigatorManager getManager();

    public boolean isUsingDrawer() {
        return false;
    }

    public List<DockableWindow> getHostedDockables() {
        return null;
    }

    public boolean openContext(Context context) {
        return this.openContext(context, true);
    }

    public boolean openContext(Context context, boolean activateDockable) {
        TNode rootTNode;
        TNode tnode;
        Node node;
        TreeExplorer explorer;
        if (context != null && (explorer = this.getTreeExplorer()) != null && (node = context.getNode()) != null && (tnode = explorer.searchTNode(node, rootTNode = explorer.getRoot())) != null) {
            explorer.setSelected(tnode);
            if (activateDockable) {
                this.show();
                DockStation.getDockStation().activateDockable(this);
            }
            return true;
        }
        return false;
    }

    public static void openContextInLastActiveNavigator(Context context) {
        NavigatorWindow realWindow;
        NavigatorManager manager;
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        NavigatorWindow window = Ide.getLastActiveNavigator();
        if (window != null && (manager = window.getManager()) != null && (realWindow = manager.getNavigatorWindow()) != null) {
            EventQueue.invokeLater(new 1(realWindow, context));
        }
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ NavigatorWindow v$realWindow;
        private final /* synthetic */ Context v$context;

        public void run() {
            this.v$realWindow.openContext(this.v$context);
        }

        public 1(NavigatorWindow navigatorWindow, Context context) {
            this.v$context = context;
            this.v$realWindow = navigatorWindow;
        }
    }
}

