/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;

public class TraceFileSystemAccess
extends URLFileSystemHelperDecorator {
    private static CopyOnWriteArrayList<TraceFileSystemAccess> _tracers = new CopyOnWriteArrayList();
    private final String _outputPathName;
    private PrintStream _output;
    private long _t0;
    private boolean _fsHitOnly;

    public static TraceFileSystemAccess start(URLFileSystemHelper helper, String outputFileName, boolean fsHitOnly) {
        TraceFileSystemAccess tracer = new TraceFileSystemAccess(helper, outputFileName, fsHitOnly);
        _tracers.add(tracer);
        return tracer;
    }

    public static TraceFileSystemAccess start(URLFileSystemHelper helper, PrintStream printStream, boolean fsHitOnly) {
        TraceFileSystemAccess tracer = new TraceFileSystemAccess(helper, printStream, fsHitOnly);
        _tracers.add(tracer);
        return tracer;
    }

    public static void shutdown() {
        for (TraceFileSystemAccess tracer : _tracers) {
            tracer.close();
        }
    }

    public void close() {
        PrintStream output = this._output;
        this._output = null;
        output.close();
        System.err.println("TraceFileSystemAccess ended: " + this._outputPathName);
    }

    private TraceFileSystemAccess(URLFileSystemHelper helper, String outputFileName, boolean fsHitOnly) {
        super(helper);
        this._fsHitOnly = fsHitOnly;
        File outputFile = new File(outputFileName);
        this._outputPathName = outputFile.getAbsolutePath();
        try {
            this._output = new PrintStream(outputFileName);
            this._t0 = System.currentTimeMillis();
            this.trace("Method", "Returned Value", "Parameters");
            System.err.println("TraceFileSystemAccess started: " + this._outputPathName);
        }
        catch (FileNotFoundException e) {
            System.err.println("Failed to create the TraceFileSystemAccess output at " + outputFile.getAbsolutePath());
        }
    }

    private TraceFileSystemAccess(URLFileSystemHelper helper, PrintStream outputStream, boolean fsHitOnly) {
        super(helper);
        this._fsHitOnly = fsHitOnly;
        this._outputPathName = "[no name]";
        this._output = outputStream;
        this._t0 = System.currentTimeMillis();
        this.trace("Method", "Returned Value", "Parameters");
        System.err.println("TraceFileSystemAccess started: " + this._outputPathName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace(String method, Object ret, Object ... params) {
        if (this._output != null) {
            String string = this._outputPathName;
            synchronized (string) {
                long t = System.currentTimeMillis() - this._t0;
                this._output.print(Long.toString(t) + "\t" + method + "\t" + TraceFileSystemAccess.toString(ret));
                int i = 0;
                while (i < params.length) {
                    Object param = params[i];
                    this._output.print("\t" + TraceFileSystemAccess.toString(param));
                    ++i;
                }
                this._output.println();
            }
        }
    }

    private static String toString(Object object) {
        if (object instanceof URL) {
            URL url = (URL)object;
            return url.toExternalForm();
        }
        if (object == null) {
            return "[null]";
        }
        if (object instanceof Boolean || object instanceof String || object instanceof Number) {
            return object.toString();
        }
        return "[" + object.getClass().getName() + "]";
    }

    public URL canonicalize(URL url) {
        URL ret = this.getHelper().canonicalize(url);
        if (!this._fsHitOnly) {
            this.trace("canonicalize", ret, url);
        }
        return ret;
    }

    public boolean canRead(URL url) {
        boolean ret = this.getHelper().canRead(url);
        this.trace("canRead", ret, url);
        return ret;
    }

    public boolean canCreate(URL url) {
        boolean ret = this.getHelper().canCreate(url);
        this.trace("canCreate", ret, url);
        return ret;
    }

    public boolean canDelete(URL url) {
        boolean ret = this.getHelper().canDelete(url);
        this.trace("canDelete", ret, url);
        return ret;
    }

    public boolean isValid(URL url) {
        boolean ret = this.getHelper().isValid(url);
        this.trace("isValid", ret, url);
        return ret;
    }

    public void delete(URL url) throws IOException {
        this.getHelper().delete(url);
        this.trace("delete", "", url);
    }

    public URL convertSuffix(URL url, String oldSuffix, String newSuffix) {
        URL ret = this.getHelper().convertSuffix(url, oldSuffix, newSuffix);
        if (!this._fsHitOnly) {
            this.trace("convertSuffix", ret, url, oldSuffix, newSuffix);
        }
        return ret;
    }

    public URL ensureSuffix(URL url, String suffix) {
        URL ret = this.getHelper().ensureSuffix(url, suffix);
        if (!this._fsHitOnly) {
            this.trace("ensureSuffix", ret, url, suffix);
        }
        return ret;
    }

    public boolean equals(URL url1, URL url2) {
        boolean ret = this.getHelper().equals(url1, url2);
        if (!this._fsHitOnly) {
            this.trace("equals", ret, url1, url2);
        }
        return ret;
    }

    public boolean exists(URL url) {
        boolean ret = this.getHelper().exists(url);
        this.trace("exists", ret, url);
        return ret;
    }

    public Icon getDefaultIcon(URL url) {
        Icon ret = this.getHelper().getDefaultIcon(url);
        this.trace("getDefaultIcon", ret, url);
        return ret;
    }

    public String getFileName(URL url) {
        String ret = this.getHelper().getFileName(url);
        if (!this._fsHitOnly) {
            this.trace("getFileName", ret, url);
        }
        return ret;
    }

    public long getLength(URL url) {
        long ret = this.getHelper().getLength(url);
        this.trace("getLength", ret, url);
        return ret;
    }

    public String getName(URL url) {
        String ret = this.getHelper().getName(url);
        if (!this._fsHitOnly) {
            this.trace("getName", ret, url);
        }
        return ret;
    }

    public URL getParent(URL url) {
        URL ret = this.getHelper().getParent(url);
        if (!this._fsHitOnly) {
            this.trace("getParent", ret, url);
        }
        return ret;
    }

    public String getPath(URL url) {
        String ret = this.getHelper().getPath(url);
        if (!this._fsHitOnly) {
            this.trace("getPath", ret, url);
        }
        return ret;
    }

    public String getPathNoExt(URL url) {
        String ret = this.getHelper().getPathNoExt(url);
        if (!this._fsHitOnly) {
            this.trace("getPathNoExt", ret, url);
        }
        return ret;
    }

    public String getPlatformPathName(URL url) {
        String ret = this.getHelper().getPlatformPathName(url);
        if (!this._fsHitOnly) {
            this.trace("getPlatformPathName", ret, url);
        }
        return ret;
    }

    public String getSuffix(URL url) {
        String ret = this.getHelper().getSuffix(url);
        if (!this._fsHitOnly) {
            this.trace("getSuffix", ret, url);
        }
        return ret;
    }

    public String getSystemDisplayName(URL url) {
        String ret = this.getHelper().getSystemDisplayName(url);
        if (!this._fsHitOnly) {
            this.trace("getSystemDisplayName", ret, url);
        }
        return ret;
    }

    public Icon getSystemIcon(URL url) {
        Icon ret = this.getHelper().getSystemIcon(url);
        this.trace("getSystemIcon", ret, url);
        return ret;
    }

    public boolean hasSuffix(URL url, String suffix) {
        boolean ret = this.getHelper().hasSuffix(url, suffix);
        if (!this._fsHitOnly) {
            this.trace("hasSuffix", ret, url, suffix);
        }
        return ret;
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        boolean ret = this.getHelper().isBaseURLFor(url1, url2);
        if (!this._fsHitOnly) {
            this.trace("isBaseURLFor", ret, url1, url2);
        }
        return ret;
    }

    public boolean isDirectory(URL url) {
        boolean ret = this.getHelper().isDirectory(url);
        this.trace("isDirectory", ret, url);
        return ret;
    }

    public boolean isDirectoryPath(URL url) {
        boolean ret = this.getHelper().isDirectoryPath(url);
        if (!this._fsHitOnly) {
            this.trace("isDirectoryPath", ret, url);
        }
        return ret;
    }

    public boolean isHidden(URL url) {
        boolean ret = this.getHelper().isHidden(url);
        this.trace("isHidden", ret, url);
        return ret;
    }

    public boolean isReadOnly(URL url) {
        boolean ret = this.getHelper().isReadOnly(url);
        this.trace("isReadOnly", ret, url);
        return ret;
    }

    public boolean isRegularFile(URL url) {
        boolean ret = this.getHelper().isRegularFile(url);
        this.trace("isRegularFile", ret, url);
        return ret;
    }

    public long lastModified(URL url) {
        long ret = this.getHelper().lastModified(url);
        this.trace("lastModified", ret, url);
        return ret;
    }

    public URL[] list(URL url) {
        URL[] ret = this.getHelper().list(url);
        this.trace("list", ret, url);
        return ret;
    }

    public URL[] list(URL url, URLFilter filter) {
        URL[] ret = this.getHelper().list(url, filter);
        this.trace("list", ret, url, filter);
        return ret;
    }

    public URL[] listRoots() {
        URL[] ret = this.getHelper().listRoots();
        this.trace("listRoots", ret, new Object[0]);
        return ret;
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        URLFileSystem.FileInfo[] ret = this.getHelper().ls(url);
        this.trace("ls", ret, url);
        return ret;
    }

    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        URLFileSystem.FileInfo[] ret = this.getHelper().ls(url, filter);
        this.trace("ls", ret, url, filter);
        return ret;
    }

    public URLFileSystem.FileInfo[] lsCached(URL url) {
        URLFileSystem.FileInfo[] ret = this.getHelper().lsCached(url);
        this.trace("lsCached", ret, url);
        return ret;
    }

    public URLFileSystem.FileInfo[] lsCached(URL url, URLFilter filter) {
        URLFileSystem.FileInfo[] ret = this.getHelper().lsCached(url, filter);
        this.trace("lsCached", ret, url);
        return ret;
    }

    public boolean mkdir(URL url) {
        boolean ret = this.getHelper().mkdir(url);
        this.trace("mkdir", ret, url);
        return ret;
    }

    public boolean mkdirs(URL url) {
        boolean ret = this.getHelper().mkdirs(url);
        this.trace("mkdirs", ret, url);
        return ret;
    }

    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        URL ret = this.getHelper().createTempFile(prefix, suffix, directory);
        this.trace("createTempFile", ret, prefix, suffix, directory);
        return ret;
    }

    public InputStream openInputStream(URL url) throws IOException {
        InputStream ret = this.getHelper().openInputStream(url);
        this.trace("openInputStream", ret, url);
        return ret;
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        OutputStream ret = this.getHelper().openOutputStream(url);
        this.trace("openOutputStream", ret, url);
        return ret;
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
        this.getHelper().rename(oldURL, newURL);
        this.trace("rename", "", oldURL, newURL);
    }

    public boolean setLastModified(URL url, long time) {
        boolean ret = this.getHelper().setLastModified(url, time);
        this.trace("setLastModified", ret, url, time);
        return ret;
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        boolean ret = this.getHelper().setReadOnly(url, readOnly);
        this.trace("setReadOnly", ret, url, readOnly);
        return ret;
    }

    public String toDisplayString(URL url) {
        String ret = this.getHelper().toDisplayString(url);
        if (!this._fsHitOnly) {
            this.trace("toDisplayString", ret, url);
        }
        return ret;
    }

    public String toEncodedString(URL url) {
        String ret = this.getHelper().toEncodedString(url);
        if (!this._fsHitOnly) {
            this.trace("toEncodedString", ret, url);
        }
        return ret;
    }

    public String toRelativeSpec(URL url, URL base) {
        String ret = this.getHelper().toRelativeSpec(url, base);
        if (!this._fsHitOnly) {
            this.trace("toRelativeSpec", ret, url, base);
        }
        return ret;
    }

    public String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        String ret = this.getHelper().toRelativeSpec(url, base, mustConsumeBase);
        if (!this._fsHitOnly) {
            this.trace("toRelativeSpec", ret, url, base, mustConsumeBase);
        }
        return ret;
    }

    public URL getBaseParent(URL url, String relativeSpec) {
        URL ret = this.getHelper().getBaseParent(url, relativeSpec);
        if (!this._fsHitOnly) {
            this.trace("getBaseParent", ret, url, relativeSpec);
        }
        return ret;
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        Reader ret = this.getHelper().createReader(url, encoding);
        this.trace("createReader", ret, url, encoding);
        return ret;
    }

    public void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        this.getHelper().addURLFileSystemListener(rootURL, listener);
        this.trace("addURLFileSystemListener", "", rootURL, listener);
    }

    public void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        this.getHelper().removeURLFileSystemListener(rootURL, listener);
        this.trace("removeURLFileSystemListener", "", rootURL, listener);
    }

    public boolean canWrite(URL url) {
        boolean ret = this.getHelper().canWrite(url);
        this.trace("canWrite", ret, url);
        return ret;
    }
}

