/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.KeyNavigableTree;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLChooserEvent;
import oracle.ide.net.URLChooserListener;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialog;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.NetArb;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.controls.WashedIcon;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingUtils;

public class URLChooser
extends DefaultTraversablePanel
implements GridBagConstants {
    public static final URLFilter ALL_FILES_FILTER = new DefaultURLFilter(NetArb.getString((int)19));
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int MULTIPLE_INTERVAL_SELECTION = 2;
    public static final int SINGLE_INTERVAL_SELECTION = 1;
    public static final int SINGLE_SELECTION = 0;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int DIRECTORIES_OR_FILES = 2;
    private static final int OPEN_DIALOG = 0;
    private static final int SAVE_DIALOG = 1;
    protected static final String HELP_TOPIC_SELECT_FILES = "f1_idedurlchooserfile_html";
    protected static final String HELP_TOPIC_SELECT_DIRECTORIES = "f1_idedurlchooserdir_html";
    protected static final String HELP_TOPIC_SELECT_FILES_OR_DIRECTORIES = "f1_idedurlchooserfiledir_html";
    private static final Pattern FILE_SEPARATORS_PATTERN;
    private static final boolean _isCaseSensitive;
    private static final Comparator _comparator;
    private static final Dimension DEFAULT_DIALOG_SIZE;
    private static Dimension _preferredSize;
    private static final Dimension SHORTCUT_BUTTON_SIZE;
    private static final AlphaComposite SHORTCUT_BACKGROUND_COMPOSITE;
    private static final String[] FILE_TABLE_COLUMN_NAMES;
    private static final Color INACTIVE_BACKGROUND_SELECTION_COLOR;
    private static final Color INACTIVE_TEXT_SELECTION_COLOR;
    private static final NumberFormat NUMBER_FORMATTER;
    private static final DateFormat DATE_FORMATTER;
    private static final KeyStroke REFRESH_KEYSTROKE;
    private static final KeyStroke TABLE_DESCEND_KEYSTROKE;
    private static final KeyStroke TABLE_ASCEND_KEYSTROKE;
    private static final KeyStroke[] TABLE_SELECT_CURRENT_KEYSTROKES;
    private static final KeyStroke TABLE_TOGGLE_SELECT_KEYSTROKE;
    private final L _listener;
    private final ShortcutBar _shortcutBar;
    private final JLabel _lblLocation;
    private final JComboBox _cbLocation;
    private final CommandBar _commandBar;
    private final URLNode _root;
    private final DefaultTreeModel _dtm;
    private final JScrollPane _spDirs;
    private final JTree _dirTree;
    private final FileView _fileView;
    private final JLabel _lblFileName;
    private final TF _tfFileName;
    private final DefaultComboBoxModel _modelFileType;
    private final JLabel _lblFileType;
    private final JComboBox _cbFileType;
    private boolean _forceUseList;
    private boolean _showJarsAsDirs;
    private final transient Comparator _urlNodeComparator;
    private final transient ArrayList _historyList;
    private transient int _selectionMode;
    private transient int _selectionScope;
    private transient Dlg _urlChooserDialog;
    private transient URLNode _selectedNode;
    private transient URL _selectedURL;
    private transient URLFilter _curFilter;
    private final boolean _disableCompletionPopup;
    private transient JWindow _completionWindow;
    private transient JScrollPane _completionScrollPane;
    private transient CL _completionList;
    private transient Set _extraURLs;
    private List _chooserListener;
    private DialogRunnerCallback _dialogCallback;

    private void $init$() {
        this._listener = new L(null);
        this._shortcutBar = new ShortcutBar();
        this._lblLocation = new JLabel();
        this._cbLocation = new JComboBox();
        this._commandBar = new CommandBar();
        this._root = new URLNode();
        this._dtm = new DefaultTreeModel(this._root);
        this._spDirs = new JScrollPane();
        this._dirTree = new KeyNavigableTree(this._dtm);
        this._fileView = new FileView();
        this._lblFileName = new JLabel();
        this._tfFileName = new TF();
        this._modelFileType = new DefaultComboBoxModel();
        this._lblFileType = new JLabel();
        this._cbFileType = new JComboBox(this._modelFileType);
        this._forceUseList = Boolean.getBoolean("URLChooser.forceUseList");
        this._showJarsAsDirs = true;
        this._urlNodeComparator = new URLNodeComparator(true, _isCaseSensitive);
        this._historyList = new ArrayList();
        this._selectionMode = 0;
        this._selectionScope = -1;
        this._disableCompletionPopup = Boolean.getBoolean("URLChooser.disableCompletionPopup");
    }

    static {
        _isCaseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();
        _comparator = _isCaseSensitive ? null : String.CASE_INSENSITIVE_ORDER;
        DEFAULT_DIALOG_SIZE = new Dimension(600, 450);
        _preferredSize = new Dimension(550, 300);
        SHORTCUT_BUTTON_SIZE = new Dimension(73, 60);
        SHORTCUT_BACKGROUND_COMPOSITE = AlphaComposite.getInstance(3, 0.5f);
        FILE_TABLE_COLUMN_NAMES = new String[]{NetArb.getString((int)31), NetArb.getString((int)12), NetArb.getString((int)4)};
        INACTIVE_BACKGROUND_SELECTION_COLOR = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        INACTIVE_TEXT_SELECTION_COLOR = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
        NUMBER_FORMATTER = NumberFormat.getNumberInstance();
        DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3);
        REFRESH_KEYSTROKE = KeyStroke.getKeyStroke(116, 0);
        TABLE_DESCEND_KEYSTROKE = KeyStroke.getKeyStroke(10, 0);
        TABLE_ASCEND_KEYSTROKE = KeyStroke.getKeyStroke(8, 0);
        TABLE_SELECT_CURRENT_KEYSTROKES = new KeyStroke[]{KeyStroke.getKeyStroke(32, 0), KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(226, 0), KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(227, 0)};
        TABLE_TOGGLE_SELECT_KEYSTROKE = KeyStroke.getKeyStroke(32, 2);
        String fileSeparatorsRegex = "[" + WildcardURLFilter.makeLiteral((String)File.separator) + (File.separatorChar == '/' ? "" : "/") + "]";
        FILE_SEPARATORS_PATTERN = Pattern.compile(fileSeparatorsRegex);
    }

    public URLChooser() {
        this(null);
    }

    public URLChooser(URL defaultSelection) {
        this(null, defaultSelection);
    }

    public URLChooser(URL[] roots, URL defaultSelection) {
        this.$init$();
        this.initHelpID();
        ResourceUtils.resLabel((JLabel)this._lblLocation, (Component)this._cbLocation, (String)NetArb.getString((int)13));
        ResourceUtils.resLabel((JLabel)this._lblFileName, (Component)this._tfFileName, (String)NetArb.getString((int)8));
        ResourceUtils.resLabel((JLabel)this._lblFileType, (Component)this._cbFileType, (String)NetArb.getString((int)32));
        this._cbLocation.setMaximumRowCount(25);
        this._cbLocation.setRenderer(new LCR1(null));
        this._cbLocation.addPopupMenuListener(this._listener);
        this._cbLocation.setPrototypeDisplayValue(this._root);
        if (!this._forceUseList) {
            this._dirTree.setRootVisible(false);
            this._dirTree.setShowsRootHandles(true);
            this._dirTree.setScrollsOnExpand(true);
            this._dirTree.getSelectionModel().setSelectionMode(1);
            this._dirTree.setCellRenderer(new TCR(null));
            this._dirTree.addTreeSelectionListener(this._listener);
            this._dirTree.addTreeWillExpandListener(this._listener);
            this._spDirs.setViewportView(this._dirTree);
        }
        this._commandBar.setDetailsView(this._fileView.isDetailsView());
        this._fileView.addViewListSelectionListener(this._listener);
        this._fileView.addViewMouseListener(this._listener);
        this._tfFileName.getDocument().addDocumentListener(this._listener);
        this._cbFileType.addActionListener(this._listener);
        this.addAncestorListener(this._listener);
        this.addChooseableURLFilter(ALL_FILES_FILTER);
        this.setURLFilter(null);
        this.setSelectionScope(0);
        this.setRoots(roots != null ? roots : URLFileSystem.listRoots());
        this.setSelectedURL(defaultSelection);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(_preferredSize);
        this.setMinimumSize(new Dimension(20, 20));
        Insets in0500 = new Insets(0, 5, 0, 0);
        Insets in5050 = new Insets(5, 0, 5, 0);
        Insets in5550 = new Insets(5, 5, 5, 0);
        this.add(this._lblLocation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, in0500, 0, 0));
        this.add(this._cbLocation, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, in0500, 0, 0));
        this.add(this._commandBar, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, in0500, 0, 0));
        this.add(this._shortcutBar, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 18, 1, in5050, 0, 0));
        this.add(this._fileView, new GridBagConstraints(1, 1, 3, 1, 0.0, 1.0, 18, 1, in5550, 0, 0));
        this.add(this._lblFileName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, in5550, 0, 0));
        this.add(this._tfFileName, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 17, 2, in5550, 0, 0));
        this.add(this._lblFileType, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, in5550, 0, 0));
        this.add(this._cbFileType, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 2, in5550, 0, 0));
    }

    public URLChooser(URL defaultSelection, boolean showJarsAsDirs) {
        this(null, defaultSelection);
        this.setShowJarsAsDirs(showJarsAsDirs);
    }

    public URLChooser(URL[] roots, URL defaultSelection, boolean showJarsAsDirs) {
        this(roots, defaultSelection);
        this.setShowJarsAsDirs(showJarsAsDirs);
    }

    public void setExtraURLs(URL[] extraURLs) {
        URL baseURL;
        if (extraURLs != null) {
            if (this._extraURLs == null) {
                this._extraURLs = new HashSet();
            } else {
                this._extraURLs.clear();
            }
            int i = 0;
            while (i < extraURLs.length) {
                URL extraURL = extraURLs[i];
                while (extraURL != null && !URLFileSystem.exists((URL)extraURL)) {
                    this._extraURLs.add(extraURL);
                    extraURL = URLFileSystem.getParent((URL)extraURL);
                }
                ++i;
            }
        } else {
            this._extraURLs = null;
        }
        this.refreshNode(this._selectedNode);
        String fileName = this.getFileNameURL();
        if (ModelUtil.hasLength((String)fileName) && (baseURL = this.getSelectedURL()) != null) {
            if (!URLFileSystem.isDirectoryPath((URL)baseURL)) {
                baseURL = URLFileSystem.getParent((URL)baseURL);
            }
            URL selectedURL = URLFactory.newURL((URL)baseURL, (String)fileName);
            this.clearHistoryList();
            this.setSelectedURL(selectedURL);
        }
    }

    public URL[] getExtraURLs() {
        return this._extraURLs != null ? this._extraURLs.toArray(new URL[this._extraURLs.size()]) : null;
    }

    public void setDialogRunnerCallback(DialogRunnerCallback callBack) {
        this._dialogCallback = callBack;
    }

    public DialogRunnerCallback getDialogRunnerCallback() {
        return this._dialogCallback;
    }

    public void setShowJarsAsDirs(boolean showJarsAsDirs) {
        this._showJarsAsDirs = showJarsAsDirs;
        this.refreshAll();
    }

    public boolean getShowJarsAsDirs() {
        return this._showJarsAsDirs;
    }

    public boolean accept(URL url) {
        return this._curFilter.accept(url);
    }

    public void addChooseableURLFilter(URLFilter filter) {
        if (filter != null && this._modelFileType.getIndexOf(filter) < 0) {
            this._modelFileType.addElement(filter);
        }
    }

    public void clearChooseableURLFilters() {
        this._modelFileType.removeAllElements();
    }

    public URLFilter[] getChooseableURLFilters() {
        int n = this._modelFileType.getSize();
        URLFilter[] filters = new URLFilter[n];
        int i = 0;
        while (i < n) {
            filters[i] = (URLFilter)this._modelFileType.getElementAt(i);
            ++i;
        }
        return filters;
    }

    public void addShortcutButton(Icon icon, String description, URL url) {
        this._shortcutBar.addShortcutButton(icon, description, url);
    }

    public void removeShortcutButtons() {
        this._shortcutBar.removeShortcutButtons();
    }

    private String expandHomeDir(String filename) {
        if (PlatformUtils.isWindows()) {
            return filename;
        }
        if (filename.length() > 0 && filename.charAt(0) == '~') {
            int endOfUsername = filename.indexOf(File.separatorChar);
            if (endOfUsername == -1) {
                endOfUsername = filename.length();
            }
            String username = filename.substring(1, endOfUsername);
            String userdir = null;
            userdir = username.length() == 0 || username.equals(this.currentUserName()) ? System.getProperty("user.home") : this.otherUserHome(username);
            if (userdir != null) {
                this._tfFileName.setText(userdir);
                return URLFileSystem.getPlatformPathName((URL)URLFactory.newDirURL((String)userdir));
            }
        }
        return filename;
    }

    private String otherUserHome(String username) {
        String currentUserDir = System.getProperty("user.home");
        URL currentUserDirUrl = URLFactory.newDirURL((String)currentUserDir);
        URL parentOfUserDir = URLFileSystem.getParent((URL)currentUserDirUrl);
        URL otherUserDir = URLFactory.newDirURL((URL)parentOfUserDir, (String)username);
        if (URLFileSystem.exists((URL)otherUserDir)) {
            return URLFileSystem.getPlatformPathName((URL)otherUserDir);
        }
        return null;
    }

    private String currentUserName() {
        return System.getProperty("user.name");
    }

    public boolean approveSelection() {
        URL canonicalURL;
        String urlSuffix;
        URL url;
        File file;
        URL approvalURL = this.getApprovalFileListURL();
        if (!(approvalURL == null || this._selectionScope == 0 && URLFileSystem.isDirectoryPath((URL)approvalURL))) {
            this._selectedURL = null;
            return true;
        }
        String fileName = this.expandHomeDir(this.getFileNameURL());
        URLNode selectedDirTreeNode = this.getSelectedDirTreeNode();
        if (!(this._selectionScope != 1 && this._selectionScope != 2 || ModelUtil.hasLength((String)fileName) || selectedDirTreeNode == null)) {
            this._selectedURL = selectedDirTreeNode.getURL();
            return true;
        }
        if (WildcardURLFilter.hasWildcard((String)fileName)) {
            this.setURLFilter((URLFilter)new WildcardURLFilter(fileName, _isCaseSensitive));
            this._tfFileName.selectAll();
            return false;
        }
        if (fileName.length() == 2 && fileName.endsWith(":") && File.separatorChar == '\\') {
            File dirFile = new File(fileName + '\\');
            File file2 = file = dirFile.exists() ? dirFile : null;
            if (file == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), NetArb.format((int)1, (Object)fileName), NetArb.getString((int)14), 0);
                this._tfFileName.selectAll();
                return false;
            }
        } else {
            file = new File(fileName);
        }
        if (file.isAbsolute()) {
            url = URLFactory.newFileURL((File)file);
        } else {
            TreeNode[] nodePath;
            String sanitizedFileName = fileName.replace(File.separatorChar, '/');
            URLNode dirNode = sanitizedFileName.startsWith("/") && selectedDirTreeNode != null ? ((nodePath = selectedDirTreeNode.getPath()).length > 1 ? (URLNode)nodePath[1] : null) : selectedDirTreeNode;
            if (dirNode == null) {
                return false;
            }
            URL dirURL = dirNode.getURL();
            url = URLFactory.newURL((URL)dirURL, (String)sanitizedFileName);
        }
        if (this.getShowJarsAsDirs() && ((urlSuffix = URLFileSystem.getSuffix((URL)url)).equals(".jar") || urlSuffix.equals(".zip") || urlSuffix.equals(".war") || urlSuffix.equals(".ear")) && URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectory((URL)url)) {
            url = URLFactory.newJarURL((URL)url, (String)"");
        }
        if (this._selectionScope == 1 && !URLFileSystem.isDirectoryPath((URL)url)) {
            url = URLFactory.newURL((URL)url, (String)"");
        }
        if (URLFileSystem.isDirectory((URL)(canonicalURL = this.canonicalizeApprovalURL(url))) || this.isExtraDirectoryURL(canonicalURL)) {
            this.setSelectedURL(URLFactory.newURL((URL)canonicalURL, (String)""));
            this.setFileNameURL(null);
            return false;
        }
        if (this.checkApprovalParentExists(canonicalURL)) {
            this._selectedURL = canonicalURL;
            return true;
        }
        this.showNotFoundError(canonicalURL);
        return false;
    }

    public void cancelSelection() {
    }

    public void changeToParentDirectory() {
        this.runLater(1);
    }

    public URL getSelectedURL() {
        if (this._selectedURL != null) {
            return this._selectedURL;
        }
        URL fileURL = this.getApprovalFileListURL();
        if (fileURL != null) {
            return fileURL;
        }
        return this._selectedNode != null ? this._selectedNode.getURL() : null;
    }

    public String getFileNameURL() {
        return this._tfFileName.getText();
    }

    public void setFileNameURL(String text) {
        this._tfFileName.setText(text != null ? text : "");
    }

    public URL[] getSelectedURLs() {
        boolean directoryMayBeSelected = false;
        if (this._forceUseList || this._selectionScope == 0 || this._selectionScope == 2) {
            if (this._selectedURL != null) {
                return new URL[]{this._selectedURL};
            }
            Object[] objs = this._fileView.getSelectedValues();
            if (objs != null) {
                int n = objs.length;
                URL[] urls = new URL[n];
                int i = 0;
                while (i < n) {
                    URLNode node = (URLNode)objs[i];
                    urls[i] = node.getURL();
                    ++i;
                }
                return urls;
            }
            if (this._selectionScope == 0) {
                return null;
            }
            directoryMayBeSelected = true;
        }
        if (this._selectionScope == 1 || directoryMayBeSelected) {
            TreePath[] tps = this._dirTree.getSelectionPaths();
            int n = tps.length;
            URL[] urls = new URL[n];
            int i = 0;
            while (i < n) {
                URLNode urlNode = (URLNode)tps[i].getLastPathComponent();
                urls[i] = urlNode.getURL();
                ++i;
            }
            return urls;
        }
        return null;
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != 2 && selectionMode != 1 && selectionMode != 0) {
            throw new IllegalArgumentException();
        }
        this._selectionMode = selectionMode;
        if (!this._forceUseList && this._selectionScope == 1) {
            int treeSelectionMode = URLChooser.toTreeSelectionMode(selectionMode);
            this._dirTree.getSelectionModel().setSelectionMode(treeSelectionMode);
        } else {
            this._fileView.setSelectionMode(selectionMode);
        }
    }

    public void setRoots(URL[] roots) {
        this._root.removeAllChildren();
        if (roots != null) {
            int i = 0;
            while (i < roots.length) {
                URL url = roots[i];
                URLNode child = new URLNode(url);
                this._root.add(child);
                ++i;
            }
            this._root.setExpanded(true);
        }
        if (this._selectionScope == 1) {
            this._dtm.nodeStructureChanged(this._root);
        }
    }

    public void setSelectedURL(URL selection) {
        this.setSelectedURLImpl(selection, true);
    }

    public void setSelectionScope(int selectionScope) {
        if (this._selectionScope == selectionScope) {
            return;
        }
        switch (selectionScope) {
            case 0: 
            case 2: {
                if (!this._forceUseList) {
                    this.remove(this._spDirs);
                    this.add(this._fileView, new GridBagConstraints(1, 1, 3, 1, 0.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
                }
                this._lblFileType.setVisible(true);
                this._cbFileType.setVisible(true);
                ResourceUtils.resLabel((JLabel)this._lblFileName, (Component)this._tfFileName, (String)NetArb.getString((int)8));
                break;
            }
            case 1: {
                if (!this._forceUseList) {
                    int treeSelectionMode = URLChooser.toTreeSelectionMode(this._selectionMode);
                    this._dirTree.getSelectionModel().setSelectionMode(treeSelectionMode);
                    this.remove(this._fileView);
                    this.add(this._spDirs, new GridBagConstraints(1, 1, 3, 1, 0.0, 1.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
                }
                this._lblFileType.setVisible(false);
                this._cbFileType.setVisible(false);
                ResourceUtils.resLabel((JLabel)this._lblFileName, (Component)this._tfFileName, (String)NetArb.getString((int)10));
                this.setFileNameURL(null);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this._selectionScope = selectionScope;
        this._commandBar.setSelectionScope(selectionScope);
        this.refreshAll();
        this.initHelpID();
    }

    public void setURLFilter(URLFilter filter) {
        URLFilter newCurrentFilter;
        if (filter != null) {
            int index = this._modelFileType.getIndexOf(filter);
            if (index < 0) {
                this.addChooseableURLFilter(filter);
            }
            newCurrentFilter = filter;
        } else {
            newCurrentFilter = ALL_FILES_FILTER;
        }
        this._modelFileType.setSelectedItem(newCurrentFilter);
        this._curFilter = newCurrentFilter;
    }

    public void flush() {
        this.flushNodes();
    }

    public int showOpenDialog(Component parent) {
        return this.showDialog(parent, (Traversable)this, 0, null);
    }

    public int showOpenDialog(Component parent, String title) {
        return this.showDialog(parent, (Traversable)this, 0, title);
    }

    public int showOpenDialog(Component parent, Traversable content, String title) {
        return this.showDialog(parent, content, 0, title);
    }

    public int showSaveDialog(Component parent) {
        return this.showDialog(parent, (Traversable)this, 1, null);
    }

    public int showSaveDialog(Component parent, String title) {
        return this.showDialog(parent, (Traversable)this, 1, title);
    }

    public int showSaveDialog(Component parent, Traversable content, String title) {
        return this.showDialog(parent, content, 1, title);
    }

    protected URL canonicalizeApprovalURL(URL url) {
        return URLFileSystem.canonicalize((URL)url);
    }

    protected URL getApprovalFileListURL() {
        URLNode fileNode = this.getSelectedFileListNode();
        return fileNode != null ? fileNode.getURL() : null;
    }

    protected boolean checkApprovalParentExists(URL url) {
        URL parentURL = URLFileSystem.getParent((URL)url);
        return URLFileSystem.exists((URL)parentURL) || this.isExtraDirectoryURL(parentURL);
    }

    public void addURLChooserListener(URLChooserListener ucl) {
        if (this._chooserListener == null) {
            this._chooserListener = new ArrayList();
        }
        this._chooserListener.add(ucl);
    }

    public void removeURLChooserListener(URLChooserListener ucl) {
        if (this._chooserListener == null || !this._chooserListener.contains(ucl)) {
            throw new IllegalArgumentException("Not a listener for this object");
        }
        this._chooserListener.remove(ucl);
        if (this._chooserListener.size() == 0) {
            this._chooserListener = null;
        }
    }

    public void addNotify() {
        super.addNotify();
        URLChooser keyComponent = this._urlChooserDialog != null ? (JComponent)this._urlChooserDialog.getRootPane() : this;
        URLChooser.addKeyboardAction((JComponent)((Object)keyComponent), (Action)new RefreshAction(null), "urlchooser-refresh", REFRESH_KEYSTROKE, 1);
    }

    public void removeNotify() {
        super.removeNotify();
        URLChooser keyComponent = this._urlChooserDialog != null ? (JComponent)this._urlChooserDialog.getRootPane() : this;
        URLChooser.removeKeyboardAction((JComponent)((Object)keyComponent), REFRESH_KEYSTROKE, 1);
    }

    private boolean isExtraDirectoryURL(URL url) {
        if (url == null || this._extraURLs == null) {
            return false;
        }
        url = URLFactory.newURL((URL)url, (String)"");
        return this._extraURLs.contains(url);
    }

    private void checkIsExtra(URLNode node) {
        if (this._extraURLs != null && node != null && !node.isLeaf() && !node.exists() && this._extraURLs.contains(node.getURL())) {
            node.setExtra(true);
            return;
        }
    }

    private void initHelpID() {
        String helpID = this.getHelpID();
        switch (this._selectionScope) {
            case 1: {
                if (helpID != null && !helpID.equals(HELP_TOPIC_SELECT_FILES) && !helpID.equals(HELP_TOPIC_SELECT_FILES_OR_DIRECTORIES)) break;
                this.setHelpID(HELP_TOPIC_SELECT_DIRECTORIES);
                break;
            }
            case 2: {
                if (helpID != null && !helpID.equals(HELP_TOPIC_SELECT_FILES) && !helpID.equals(HELP_TOPIC_SELECT_DIRECTORIES)) break;
                this.setHelpID(HELP_TOPIC_SELECT_FILES_OR_DIRECTORIES);
                break;
            }
            default: {
                if (helpID != null && !helpID.equals(HELP_TOPIC_SELECT_DIRECTORIES)) break;
                this.setHelpID(HELP_TOPIC_SELECT_FILES);
                break;
            }
        }
    }

    private void showNotFoundError(URL url) {
        if (this.getParent() != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), NetArb.format((int)33, (Object)URLFileSystem.getPlatformPathName((URL)url)), NetArb.getString((int)23), 0);
        }
    }

    private void showSpecificError(URL url, String message) {
        if (this.getParent() != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot add " + url.getFile() + ": " + message, NetArb.getString((int)23), 0);
        }
    }

    private void pushHistoryList(URLNode node) {
        URL url = node != null ? node.getURL() : null;
        int historySize = this._historyList.size();
        if (historySize > 0) {
            URL lastURL = (URL)this._historyList.get(historySize - 1);
            if (historySize == 1 && lastURL == null) {
                this._historyList.remove(0);
            } else if (URLFileSystem.equals((URL)url, (URL)lastURL)) {
                return;
            }
        }
        this._historyList.add(url);
        this.updateHistoryButtonStatus();
    }

    private void popHistoryList() {
        int historySize = this._historyList.size();
        if (historySize > 1) {
            this._historyList.remove(historySize - 1);
            URL lastURL = (URL)this._historyList.get(historySize - 2);
            this.setSelectedURLImpl(lastURL, false);
            this.updateHistoryButtonStatus();
        }
    }

    private void clearHistoryList() {
        this._historyList.clear();
    }

    private void updateHistoryButtonStatus() {
        this._commandBar.enableBackButton(this._historyList.size() > 1);
    }

    private int showDialog(Component parent, Traversable content, int urlChooserType, String userTitle) {
        try {
            String title;
            String approveText;
            switch (urlChooserType) {
                case 0: {
                    if (this._selectionScope == 0 || this._selectionScope == 2) {
                        approveText = NetArb.getString((int)15);
                        title = userTitle != null ? userTitle : NetArb.getString((int)37);
                        break;
                    }
                    approveText = NetArb.getString((int)20);
                    title = userTitle != null ? userTitle : NetArb.getString((int)7);
                    break;
                }
                default: {
                    if (this._selectionScope == 0) {
                        approveText = NetArb.getString((int)11);
                        title = userTitle != null ? userTitle : NetArb.getString((int)26);
                        break;
                    }
                    approveText = NetArb.getString((int)20);
                    title = userTitle != null ? userTitle : NetArb.getString((int)7);
                    break;
                }
            }
            1 launcher = new 1(this, parent, title, content, null, content, approveText);
            this._urlChooserDialog = (Dlg)launcher.initDialog();
            this._urlChooserDialog.setPreferredSize(DEFAULT_DIALOG_SIZE);
            this._fileView.addViewMouseListener(this._urlChooserDialog);
            this._dirTree.addMouseListener(this._urlChooserDialog);
            if (this._dialogCallback != null) {
                this._dialogCallback.dialogAboutToRun((JDialog)((Object)this._urlChooserDialog));
            }
            boolean dialogResult = launcher.showDialog();
            this._urlChooserDialog = null;
            int n = dialogResult ? 0 : 1;
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
    }

    private void runNow(int type) {
        UI ui = new UI(type);
        ui.run();
    }

    private void runLater(int type) {
        UI ui = new UI(type);
        SwingUtilities.invokeLater(ui);
    }

    private boolean isRootURL(URL url) {
        return URLChooser.isChildURL(this._root, url);
    }

    private void setSelectedURLImpl(URL selection, boolean updateRelativePath) {
        if (selection == null) {
            if (this._forceUseList || this._selectionScope != 1) {
                this._selectedNode = this._root;
                this.runLater(10);
            }
            return;
        }
        if (this._selectionScope == 1 && !URLFileSystem.isDirectoryPath((URL)selection)) {
            selection = URLFileSystem.getParent((URL)selection);
        }
        this.setSelectedURLImpl0(selection);
        if (this._selectedNode != null) {
            String relativeSpec;
            if (this._forceUseList || this._selectionScope != 1) {
                this.maybeLoadTreeNode(this._selectedNode, true, true);
            }
            URL selectedURL = this._selectedNode.getURL();
            if (updateRelativePath && !JarUtil.isJarURL((URL)selectedURL) && (relativeSpec = URLFileSystem.toRelativeSpec((URL)selection, (URL)this._selectedNode.getURL())) != null) {
                this.setFileNameURL(relativeSpec);
            }
        }
        if (!this._forceUseList && this._selectionScope == 1) {
            this.runLater(10);
        }
    }

    private void setSelectedURLImpl0(URL selection) {
        if (selection == null) {
            return;
        }
        URL parent = URLFileSystem.getParent((URL)selection);
        if (parent == null || this.isRootURL(selection)) {
            this.setSelectedURLImpl(this._root, selection);
        } else {
            this.setSelectedURLImpl0(parent);
            if (this._selectedNode != null) {
                this.setSelectedURLImpl(this._selectedNode, selection);
            }
        }
    }

    private void setSelectedURLImpl(URLNode node, URL url) {
        URLNode child = URLChooser.findChildByURL(node, url);
        if (child != null) {
            if (!this._forceUseList && this._selectionScope == 1) {
                this.maybeLoadTreeNode(child, true, false);
                this._selectedNode = child;
            } else if (child.exists()) {
                this._selectedNode = child;
            }
            return;
        }
        if (this._forceUseList || this._selectionScope != 1 && !node.isExpanded()) {
            child = new URLNode(url);
            this.checkIsExtra(child);
            node.add(child);
            if (!child.isLeaf() && child.exists()) {
                this._selectedNode = child;
            }
        }
    }

    private boolean setSelectedNode(URLNode node) {
        URLNode lastSelectedNode = this._selectedNode;
        this._selectedNode = node;
        if (node != null) {
            if (!this._forceUseList && this._selectionScope == 1) {
                Object[] nodePath = node.getPath();
                TreePath tp = new TreePath(nodePath);
                this._dirTree.setSelectionPath(tp);
                this._dirTree.scrollPathToVisible(tp);
            } else {
                this.maybeLoadTreeNode(node, true, true);
                if (!node.isExpanded()) {
                    this._selectedNode = lastSelectedNode;
                    return false;
                }
            }
        }
        return true;
    }

    private void maybeLoadTreeNode(URLNode node, boolean mustBeSynchronous, boolean firePostUpdateTreeSelection) {
        if (node == null || node.isLeaf()) {
            return;
        }
        if (!node.isExpanded()) {
            node.buildChildren(mustBeSynchronous, firePostUpdateTreeSelection);
        } else if (firePostUpdateTreeSelection) {
            this.runLater(12);
        }
    }

    private URLNode getSelectedDirComboBoxNode() {
        return (URLNode)this._cbLocation.getSelectedItem();
    }

    private URLNode getSelectedDirTreeNode() {
        if (!this._forceUseList && this._selectionScope == 1) {
            TreePath tp = this._dirTree.getSelectionPath();
            return tp != null ? (URLNode)tp.getLastPathComponent() : null;
        }
        URLNode fileNode = this.getSelectedFileListNode();
        if (fileNode != null && !fileNode.isLeaf()) {
            return fileNode;
        }
        return this.getSelectedDirComboBoxNode();
    }

    private URLNode getSelectedFileListNode() {
        return !this._forceUseList && this._selectionScope == 1 ? null : this._fileView.getSelectedNode();
    }

    public final URLFilter getSelectedFilter() {
        return (URLFilter)this._cbFileType.getSelectedItem();
    }

    private static int compare(String s1, String s2) {
        if (_comparator != null) {
            return _comparator.compare(s1, s2);
        }
        return s1.compareTo(s2);
    }

    private void fireUrlFilterChanged(URLFilter current, URLFilter previous) {
        if (this._chooserListener != null) {
            URLChooserEvent event = null;
            int i = this._chooserListener.size();
            while (--i >= 0) {
                try {
                    if (event == null) {
                        event = new URLChooserEvent((Object)this, 1);
                        event.setCurrentFilter(current);
                        event.setPreviousFilter(previous);
                    }
                    URLChooserListener listener = (URLChooserListener)this._chooserListener.get(i);
                    long startTime = System.nanoTime();
                    listener.urlFilterChanged(event);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("URLChooserListener.urlFilterChanged", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void fireListSelectionChanged(ListSelectionEvent e) {
        if (this._chooserListener != null) {
            URLChooserEvent event = null;
            int i = this._chooserListener.size();
            while (--i >= 0) {
                try {
                    if (event == null) {
                        event = new URLChooserEvent((Object)this, 2);
                        event.setEventObject(e);
                    }
                    URLChooserListener listener = (URLChooserListener)this._chooserListener.get(i);
                    long startTime = System.nanoTime();
                    listener.listSelectionChanged(event);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("URLChooserListener.listSelectionChanged", listener.getClass().getName(), endTime - startTime);
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private boolean isSingleDirectoryChooser() {
        return this._selectionScope == 1 && this._selectionMode == 0;
    }

    private void flushNodes() {
        Enumeration e = this._root.children();
        while (e.hasMoreElements()) {
            URLNode child = (URLNode)e.nextElement();
            child.removeAllChildren();
        }
        if (this._selectionScope == 1) {
            this._dtm.nodeStructureChanged(this._root);
        }
    }

    private void refreshAll() {
        this.flushNodes();
        if (this._selectedNode != null) {
            String fileName = this.getFileNameURL();
            this.setSelectedURL(this._selectedNode.getURL());
            this.setFileNameURL(fileName);
        }
    }

    private void refreshNode(URLNode node) {
        if (node != null && node != this._root && !node.isLeaf() && node.isExpanded()) {
            node.rebuildChildren(true, true);
        }
    }

    private static boolean isChildURL(URLNode node, URL url) {
        return URLChooser.findChildByURL(node, url) != null;
    }

    private static URLNode findChildByURL(URLNode node, URL url) {
        if (node != null) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                URLNode child = (URLNode)e.nextElement();
                if (!URLFileSystem.equals((URL)child.getURL(), (URL)url)) continue;
                return child;
            }
        }
        return null;
    }

    private static int toTreeSelectionMode(int chooserSelectionMode) {
        switch (chooserSelectionMode) {
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    private static void addKeyboardAction(JComponent component, Action action, String key, KeyStroke keystroke) {
        URLChooser.addKeyboardAction(component, action, key, keystroke, 0);
    }

    private static void addKeyboardAction(JComponent component, Action action, String key, KeyStroke keystroke, int condition) {
        ActionMap actionMap = component.getActionMap();
        InputMap inputMap = component.getInputMap(condition);
        actionMap.put(key, action);
        inputMap.put(keystroke, key);
    }

    private static void addKeyboardAction(JComponent component, Action action, String key, KeyStroke[] keystrokes) {
        URLChooser.addKeyboardAction(component, action, key, keystrokes, 0);
    }

    private static void addKeyboardAction(JComponent component, Action action, String key, KeyStroke[] keystrokes, int condition) {
        ActionMap actionMap = component.getActionMap();
        InputMap inputMap = component.getInputMap(condition);
        actionMap.put(key, action);
        int i = 0;
        while (i < keystrokes.length) {
            inputMap.put(keystrokes[i], key);
            ++i;
        }
    }

    private static void removeKeyboardAction(JComponent component, KeyStroke keystroke, int condition) {
        InputMap inputMap = component.getInputMap(condition);
        inputMap.remove(keystroke);
    }

    private static void setLabelIcon(JLabel label, Object value, boolean washHidden) {
        if (value instanceof URLNode) {
            URLNode node = (URLNode)value;
            label.setIcon(washHidden && node.isHidden() ? node.getWashedIcon() : node.getIcon());
        } else {
            label.setIcon(null);
        }
    }

    private static void setLabelFont(JLabel label, Object value, Font font) {
        if (value instanceof URLNode) {
            URLNode node = (URLNode)value;
            label.setFont(node.isExtra() ? font.deriveFont(2) : font);
        }
    }

    static boolean ra$_forceUseList(URLChooser uRLChooser) {
        return uRLChooser._forceUseList;
    }

    static int ra$_selectionScope(URLChooser uRLChooser) {
        return uRLChooser._selectionScope;
    }

    static DefaultTreeModel ra$_dtm(URLChooser uRLChooser) {
        return uRLChooser._dtm;
    }

    static void mav$runNow(URLChooser uRLChooser, int n) {
        uRLChooser.runNow(n);
    }

    static JTree ra$_dirTree(URLChooser uRLChooser) {
        return uRLChooser._dirTree;
    }

    static FileView ra$_fileView(URLChooser uRLChooser) {
        return uRLChooser._fileView;
    }

    static void mav$showSpecificError(URLChooser uRLChooser, URL uRL, String string) {
        uRLChooser.showSpecificError(uRL, string);
    }

    static void mav$showNotFoundError(URLChooser uRLChooser, URL uRL) {
        uRLChooser.showNotFoundError(uRL);
    }

    static Comparator ra$_urlNodeComparator(URLChooser uRLChooser) {
        return uRLChooser._urlNodeComparator;
    }

    static boolean ra$_showJarsAsDirs(URLChooser uRLChooser) {
        return uRLChooser._showJarsAsDirs;
    }

    static Set ra$_extraURLs(URLChooser uRLChooser) {
        return uRLChooser._extraURLs;
    }

    static boolean mav$setSelectedNode(URLChooser uRLChooser, URLNode uRLNode) {
        return uRLChooser.setSelectedNode(uRLNode);
    }

    static TF ra$_tfFileName(URLChooser uRLChooser) {
        return uRLChooser._tfFileName;
    }

    static JWindow ra$_completionWindow(URLChooser uRLChooser) {
        return uRLChooser._completionWindow;
    }

    static Dlg ra$_urlChooserDialog(URLChooser uRLChooser) {
        return uRLChooser._urlChooserDialog;
    }

    static JLabel ra$_lblFileName(URLChooser uRLChooser) {
        return uRLChooser._lblFileName;
    }

    static void mav$maybeLoadTreeNode(URLChooser uRLChooser, URLNode uRLNode, boolean bl, boolean bl2) {
        uRLChooser.maybeLoadTreeNode(uRLNode, bl, bl2);
    }

    static boolean ra$_disableCompletionPopup(URLChooser uRLChooser) {
        return uRLChooser._disableCompletionPopup;
    }

    static void mav$runLater(URLChooser uRLChooser, int n) {
        uRLChooser.runLater(n);
    }

    static JComboBox ra$_cbLocation(URLChooser uRLChooser) {
        return uRLChooser._cbLocation;
    }

    static URLNode mav$getSelectedDirComboBoxNode(URLChooser uRLChooser) {
        return uRLChooser.getSelectedDirComboBoxNode();
    }

    static JComboBox ra$_cbFileType(URLChooser uRLChooser) {
        return uRLChooser._cbFileType;
    }

    static void mav$fireListSelectionChanged(URLChooser uRLChooser, ListSelectionEvent listSelectionEvent) {
        uRLChooser.fireListSelectionChanged(listSelectionEvent);
    }

    static CL ra$_completionList(URLChooser uRLChooser) {
        return uRLChooser._completionList;
    }

    static int maS$compare(String string, String string2) {
        return URLChooser.compare(string, string2);
    }

    static void wa$_completionWindow(URLChooser uRLChooser, JWindow jWindow) {
        uRLChooser._completionWindow = jWindow;
    }

    static void wa$_completionList(URLChooser uRLChooser, CL cL) {
        uRLChooser._completionList = cL;
    }

    static L ra$_listener(URLChooser uRLChooser) {
        return uRLChooser._listener;
    }

    static URLNode ra$_root(URLChooser uRLChooser) {
        return uRLChooser._root;
    }

    static Pattern ra$FILE_SEPARATORS_PATTERN() {
        return FILE_SEPARATORS_PATTERN;
    }

    static URLNode maS$findChildByURL(URLNode uRLNode, URL uRL) {
        return URLChooser.findChildByURL(uRLNode, uRL);
    }

    static boolean ra$_isCaseSensitive() {
        return _isCaseSensitive;
    }

    static void wa$_completionScrollPane(URLChooser uRLChooser, JScrollPane jScrollPane) {
        uRLChooser._completionScrollPane = jScrollPane;
    }

    static JScrollPane ra$_completionScrollPane(URLChooser uRLChooser) {
        return uRLChooser._completionScrollPane;
    }

    static boolean mav$isSingleDirectoryChooser(URLChooser uRLChooser) {
        return uRLChooser.isSingleDirectoryChooser();
    }

    static URLFilter ra$_curFilter(URLChooser uRLChooser) {
        return uRLChooser._curFilter;
    }

    static CommandBar ra$_commandBar(URLChooser uRLChooser) {
        return uRLChooser._commandBar;
    }

    static boolean mav$isRootURL(URLChooser uRLChooser, URL uRL) {
        return uRLChooser.isRootURL(uRL);
    }

    static void mav$pushHistoryList(URLChooser uRLChooser, URLNode uRLNode) {
        uRLChooser.pushHistoryList(uRLNode);
    }

    static void mav$refreshAll(URLChooser uRLChooser) {
        uRLChooser.refreshAll();
    }

    static void mav$flushNodes(URLChooser uRLChooser) {
        uRLChooser.flushNodes();
    }

    static void mav$setSelectedURLImpl(URLChooser uRLChooser, URL uRL, boolean bl) {
        uRLChooser.setSelectedURLImpl(uRL, bl);
    }

    static URLNode ra$_selectedNode(URLChooser uRLChooser) {
        return uRLChooser._selectedNode;
    }

    static JScrollPane ra$_spDirs(URLChooser uRLChooser) {
        return uRLChooser._spDirs;
    }

    static void wa$_curFilter(URLChooser uRLChooser, URLFilter uRLFilter) {
        uRLChooser._curFilter = uRLFilter;
    }

    static void mav$fireUrlFilterChanged(URLChooser uRLChooser, URLFilter uRLFilter, URLFilter uRLFilter2) {
        uRLChooser.fireUrlFilterChanged(uRLFilter, uRLFilter2);
    }

    static URLNode mav$getSelectedFileListNode(URLChooser uRLChooser) {
        return uRLChooser.getSelectedFileListNode();
    }

    static URLNode mav$getSelectedDirTreeNode(URLChooser uRLChooser) {
        return uRLChooser.getSelectedDirTreeNode();
    }

    static void wa$_selectedNode(URLChooser uRLChooser, URLNode uRLNode) {
        uRLChooser._selectedNode = uRLNode;
    }

    static void mav$popHistoryList(URLChooser uRLChooser) {
        uRLChooser.popHistoryList();
    }

    static void maS$setLabelIcon(JLabel jLabel, Object object, boolean bl) {
        URLChooser.setLabelIcon(jLabel, object, bl);
    }

    static AlphaComposite ra$SHORTCUT_BACKGROUND_COMPOSITE() {
        return SHORTCUT_BACKGROUND_COMPOSITE;
    }

    static Dimension ra$SHORTCUT_BUTTON_SIZE() {
        return SHORTCUT_BUTTON_SIZE;
    }

    static KeyStroke ra$TABLE_DESCEND_KEYSTROKE() {
        return TABLE_DESCEND_KEYSTROKE;
    }

    static void maS$addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke keyStroke) {
        URLChooser.addKeyboardAction(jComponent, action, string, keyStroke);
    }

    static KeyStroke ra$TABLE_ASCEND_KEYSTROKE() {
        return TABLE_ASCEND_KEYSTROKE;
    }

    static KeyStroke[] ra$TABLE_SELECT_CURRENT_KEYSTROKES() {
        return TABLE_SELECT_CURRENT_KEYSTROKES;
    }

    static void maS$addKeyboardAction(JComponent jComponent, Action action, String string, KeyStroke[] keyStrokeArray) {
        URLChooser.addKeyboardAction(jComponent, action, string, keyStrokeArray);
    }

    static KeyStroke ra$TABLE_TOGGLE_SELECT_KEYSTROKE() {
        return TABLE_TOGGLE_SELECT_KEYSTROKE;
    }

    static NumberFormat ra$NUMBER_FORMATTER() {
        return NUMBER_FORMATTER;
    }

    static DateFormat ra$DATE_FORMATTER() {
        return DATE_FORMATTER;
    }

    static String[] ra$FILE_TABLE_COLUMN_NAMES() {
        return FILE_TABLE_COLUMN_NAMES;
    }

    static Color ra$INACTIVE_BACKGROUND_SELECTION_COLOR() {
        return INACTIVE_BACKGROUND_SELECTION_COLOR;
    }

    static Color ra$INACTIVE_TEXT_SELECTION_COLOR() {
        return INACTIVE_TEXT_SELECTION_COLOR;
    }

    static void maS$setLabelFont(JLabel jLabel, Object object, Font font) {
        URLChooser.setLabelFont(jLabel, object, font);
    }

    final class 1
    extends TDialogLauncher {
        private final /* synthetic */ Traversable v$content;
        private final /* synthetic */ String v$approveText;
        final /* synthetic */ URLChooser this$0;

        protected TDialog newDialog() {
            Window parentWindow = SwingUtils.findAncestorFrameOrDialog((Component)this.getParent());
            Dlg dialog = parentWindow instanceof Dialog ? this.this$0.new Dlg((TDialogLauncher)this, (Dialog)parentWindow, this.v$content, this.v$approveText) : this.this$0.new Dlg((TDialogLauncher)this, (Frame)parentWindow, this.v$content, this.v$approveText);
            if (this.v$content.getHelpID() == null) {
                dialog.setButtonMask(3);
            }
            return dialog;
        }

        public 1(URLChooser uRLChooser, Component component, String string, Traversable traversable, Namespace namespace, Traversable traversable2, String string2) {
            this.v$approveText = string2;
            this.v$content = traversable2;
            this.this$0 = uRLChooser;
            super(component, string, traversable, namespace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class URLNode
    implements TreeNode,
    Comparable {
        static final int DIRS_ALWAYS_EXCLUDED = 0;
        static final int DIRS_FILTERED = 1;
        static final int DIRS_ALWAYS_INCLUDED = 2;
        static final int DIRS_ONLY = 3;
        private final URL _url;
        private final boolean _isLeaf;
        private final List _children;
        private TreeNode _parent;
        private Object _userObject;
        private String _name;
        private Icon _icon;
        private Icon _washedIcon;
        private boolean _expanded;
        private boolean _extra;

        private void $init$() {
            this._children = new ArrayList();
        }

        URLNode() {
            this((URL)null);
        }

        URLNode(URLFileSystem.FileInfo info) {
            this(info.getURL());
            this.setUserObject(info);
        }

        URLNode(URL url) {
            this.$init$();
            this._url = url;
            this._isLeaf = url != null && !URLFileSystem.isRoot((URL)url) && !URLFileSystem.isDirectoryPath((URL)url);
        }

        public Enumeration children() {
            return new Vector(this._children).elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return (TreeNode)this._children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this._children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this._children.indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this._parent;
        }

        @Override
        public boolean isLeaf() {
            return this._isLeaf;
        }

        public Object getUserObject() {
            return this._userObject;
        }

        public void setUserObject(Object userObject) {
            this._userObject = userObject;
        }

        public void add(URLNode node) {
            int n = this.getChildCount();
            int i = 0;
            while (i < n) {
                URLNode child = (URLNode)this.getChildAt(i);
                int result = URLChooser.ra$_urlNodeComparator(URLChooser.this).compare(node, child);
                if (result < 0) break;
                ++i;
            }
            this._children.add(i, node);
            node._parent = this;
        }

        public void removeAllChildren() {
            this._expanded = false;
            this._children.clear();
        }

        public TreeNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
            TreeNode[] retNodes;
            if (aNode == null) {
                if (depth == 0) {
                    return null;
                }
                retNodes = new TreeNode[depth];
            } else {
                retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
                retNodes[retNodes.length - depth] = aNode;
            }
            return retNodes;
        }

        public int compareTo(Object o) {
            return URLChooser.ra$_urlNodeComparator(URLChooser.this).compare(this, (URLNode)o);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof URLNode && URLFileSystem.equals((URL)this._url, (URL)((URLNode)o)._url);
        }

        public String toString() {
            if (this._name == null) {
                this._name = this._url != null ? (URLFileSystem.isRoot((URL)this._url) ? URLFileSystem.getSystemDisplayName((URL)this._url) : URLFileSystem.getFileName((URL)this._url)) : "";
            }
            return this._name;
        }

        public Icon getIcon() {
            if (this._icon == null) {
                this._icon = this._url != null ? URLFileSystem.getDefaultIcon((URL)this._url) : IdeIcons.getIcon((int)23);
            }
            return this._icon;
        }

        public Icon getWashedIcon() {
            Icon icon;
            if (this._washedIcon == null && (icon = this.getIcon()) != null) {
                this._washedIcon = new WashedIcon(icon);
            }
            return this._washedIcon;
        }

        public boolean exists() {
            if (this.getFileInfo() != null || this.isExtra()) {
                return true;
            }
            return this._url != null ? URLFileSystem.exists((URL)this._url) : false;
        }

        public boolean isRoot() {
            return this._url != null && URLFileSystem.isRoot((URL)this._url);
        }

        public boolean isHidden() {
            URLFileSystem.FileInfo info = this.getFileInfo();
            return info != null ? info.isHidden() : URLFileSystem.isHidden((URL)this._url) && !this.isRoot();
        }

        public long lastModified() {
            URLFileSystem.FileInfo info = this.getFileInfo();
            return info != null ? info.lastModified() : URLFileSystem.lastModified((URL)this._url);
        }

        public long length() {
            URLFileSystem.FileInfo info = this.getFileInfo();
            return info != null ? info.length() : URLFileSystem.getLength((URL)this._url);
        }

        URL getURL() {
            return this._url;
        }

        boolean isExpanded() {
            return this._expanded;
        }

        void setExpanded(boolean expanded) {
            this._expanded = expanded;
        }

        boolean isExtra() {
            return this._extra;
        }

        void setExtra(boolean extra) {
            this._extra = extra;
        }

        void rebuildChildren(boolean mustBeSynchronous, boolean firePostUpdateTreeSelection) {
            this.removeAllChildren();
            this.buildChildren(mustBeSynchronous, firePostUpdateTreeSelection);
        }

        void buildChildren(boolean mustBeSynchronous, boolean firePostUpdateTreeSelection) {
            this.buildChildren(mustBeSynchronous, firePostUpdateTreeSelection, false);
        }

        void buildChildren(boolean mustBeSynchronous, boolean firePostUpdateTreeSelection, boolean nowait) {
            WaitCursor waitCursor;
            if (this._url == null) {
                return;
            }
            if (nowait) {
                waitCursor = null;
            } else {
                waitCursor = new WaitCursor((Component)((Object)URLChooser.this));
                waitCursor.show(400);
            }
            this._expanded = true;
            if (mustBeSynchronous) {
                URLNode[] children = this.getChildURLNodes();
                this.processChildURLNodes(children, waitCursor, firePostUpdateTreeSelection, nowait);
            } else {
                URLChooser.ra$_fileView(URLChooser.this).setKeyboardEnabled(false);
                1 worker = new 1(this, waitCursor, firePostUpdateTreeSelection, nowait);
                worker.start();
            }
        }

        void insertDir(URL dirURL) {
            if (!this._expanded) {
                this.buildChildren(true, false);
            }
            URLNode dirNode = new URLNode(dirURL);
            this.add(dirNode);
            if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                URLChooser.ra$_dtm(URLChooser.this).nodeStructureChanged(this);
            } else {
                URLChooser.mav$runNow(URLChooser.this, 19);
            }
            URLChooser.mav$setSelectedNode(URLChooser.this, dirNode);
            URLChooser.mav$runNow(URLChooser.this, 10);
        }

        Vector getFiles(URLFilter filter, int dirMode) {
            if (filter == null) {
                filter = ALL_FILES_FILTER;
            }
            Vector<URLNode> files = new Vector<URLNode>();
            block4: for (URLNode child : this._children) {
                URL url = child.getURL();
                if (!child.isLeaf()) {
                    switch (dirMode) {
                        case 2: {
                            files.add(child);
                            continue block4;
                        }
                        case 0: {
                            continue block4;
                        }
                    }
                } else if (dirMode == 3) continue;
                if (!filter.accept(url)) continue;
                files.add(child);
            }
            return files;
        }

        private URLNode[] getChildURLNodes() {
            Object[] children = FileNativeHelper.getInstance().isLoaded() ? URLFileSystem.ls((URL)this._url) : URLFileSystem.list((URL)this._url);
            int n = children != null ? children.length : 2;
            TreeSet<URLNode> urlNodes = new TreeSet<URLNode>(URLChooser.ra$_urlNodeComparator(URLChooser.this));
            if (children != null) {
                int i = 0;
                while (i < n) {
                    URL childURL;
                    String lowerSpec;
                    String parentProtocol;
                    URLNode child = children instanceof URLFileSystem.FileInfo[] ? new URLNode(children[i]) : new URLNode((URL)children[i]);
                    if (URLChooser.ra$_selectionScope(URLChooser.this) != 1 || !child.isLeaf()) {
                        urlNodes.add(child);
                    }
                    if (URLChooser.ra$_showJarsAsDirs(URLChooser.this) && child.isLeaf() && !(parentProtocol = this._url.getProtocol()).equals("jar") && ((lowerSpec = URLFileSystem.getFileName((URL)(childURL = child.getURL())).toLowerCase()).endsWith(".jar") || lowerSpec.endsWith(".zip") || lowerSpec.endsWith(".war") || lowerSpec.endsWith(".ear"))) {
                        URLNode jarNode = new URLNode(URLFactory.newJarURL((URL)childURL, (String)""));
                        urlNodes.add(jarNode);
                    }
                    ++i;
                }
            }
            if (URLChooser.ra$_extraURLs(URLChooser.this) != null) {
                for (URL url : URLChooser.ra$_extraURLs(URLChooser.this)) {
                    if (!URLFileSystem.isBaseURLFor((URL)this._url, (URL)url) || !URLFileSystem.equals((URL)this._url, (URL)URLFileSystem.getParent((URL)url))) continue;
                    URLNode child = new URLNode(url);
                    child.setExtra(true);
                    urlNodes.add(child);
                }
            }
            if (!urlNodes.isEmpty() || children != null) {
                return urlNodes.toArray(new URLNode[urlNodes.size()]);
            }
            return null;
        }

        private void processChildURLNodes(URLNode[] children, WaitCursor waitCursor, boolean firePostUpdateTreeSelection, boolean nowait) {
            this._children.clear();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    URLNode child = children[i];
                    child._parent = this;
                    this._children.add(child);
                    ++i;
                }
                if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                    URLChooser.ra$_dtm(URLChooser.this).nodeStructureChanged(this);
                }
                if (firePostUpdateTreeSelection) {
                    URLChooser.mav$runNow(URLChooser.this, 12);
                }
            } else {
                this._expanded = false;
                if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                    Object[] nodePath = this.getPath();
                    TreePath tp = new TreePath(nodePath);
                    URLChooser.ra$_dirTree(URLChooser.this).collapsePath(tp);
                    URLChooser.ra$_dtm(URLChooser.this).nodeStructureChanged(this);
                }
            }
            URLChooser.ra$_fileView(URLChooser.this).setKeyboardEnabled(true);
            if (waitCursor != null) {
                waitCursor.hide();
                waitCursor.dispose();
            }
            if (children == null && !nowait) {
                try {
                    URLFileSystem.findHelper((URL)this._url).verifyList(this._url);
                }
                catch (IOException e) {
                    String error = e.getMessage();
                    if (error != null) {
                        URLChooser.mav$showSpecificError(URLChooser.this, this._url, error);
                    } else {
                        URLChooser.mav$showNotFoundError(URLChooser.this, this._url);
                    }
                    return;
                }
                URLChooser.mav$showNotFoundError(URLChooser.this, this._url);
            }
        }

        private URLFileSystem.FileInfo getFileInfo() {
            Object userObject = this.getUserObject();
            return userObject instanceof URLFileSystem.FileInfo ? (URLFileSystem.FileInfo)userObject : null;
        }

        static void mav$processChildURLNodes(URLNode uRLNode, URLNode[] uRLNodeArray, WaitCursor waitCursor, boolean bl, boolean bl2) {
            uRLNode.processChildURLNodes(uRLNodeArray, waitCursor, bl, bl2);
        }

        static URLNode[] mav$getChildURLNodes(URLNode uRLNode) {
            return uRLNode.getChildURLNodes();
        }

        final class 1
        extends SwingWorker {
            private final /* synthetic */ WaitCursor v$waitCursor;
            private final /* synthetic */ boolean v$firePostUpdateTreeSelection;
            private final /* synthetic */ boolean v$nowait;
            final /* synthetic */ URLNode this$0;

            public Object construct() {
                return URLNode.mav$getChildURLNodes(this.this$0);
            }

            public void finished() {
                URLNode[] children = (URLNode[])this.getValue();
                URLNode.mav$processChildURLNodes(this.this$0, children, this.v$waitCursor, this.v$firePostUpdateTreeSelection, this.v$nowait);
            }

            public 1(URLNode uRLNode, WaitCursor waitCursor, boolean bl, boolean bl2) {
                this.v$nowait = bl2;
                this.v$firePostUpdateTreeSelection = bl;
                this.v$waitCursor = waitCursor;
                this.this$0 = uRLNode;
            }
        }
    }

    private class L
    implements TreeSelectionListener,
    TreeWillExpandListener,
    ListDataListener,
    ListSelectionListener,
    ActionListener,
    PopupMenuListener,
    AncestorListener,
    DocumentListener,
    MouseListener,
    AWTEventListener {
        private final DoubleClickTrigger _trigger;
        private boolean _enabled;
        private URLNode _lastSelectedNode;

        private void $init$() {
            this._trigger = new DoubleClickTrigger();
            this._enabled = true;
        }

        boolean isEnabled() {
            return this._enabled;
        }

        void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            URLNode node = (URLNode)tp.getLastPathComponent();
            URLChooser.mav$maybeLoadTreeNode(URLChooser.this, node, true, false);
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 2);
            }
        }

        public void contentsChanged(ListDataEvent e) {
            if (e.getType() == 0 && e.getIndex0() == -1 && e.getIndex1() == -1) {
                URLNode selectedDirNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
                String tip = selectedDirNode != null ? URLFileSystem.getPlatformPathName((URL)selectedDirNode.getURL()) : null;
                URLChooser.ra$_cbLocation(URLChooser.this).setToolTipText(tip);
            }
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 5);
                URLChooser.mav$fireListSelectionChanged(URLChooser.this, e);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this._enabled) {
                Object source = e.getSource();
                if (source == null) {
                    return;
                }
                if (source == URLChooser.ra$_cbFileType(URLChooser.this)) {
                    URLChooser.mav$runNow(URLChooser.this, 6);
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            if (this._enabled) {
                this._lastSelectedNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this._enabled) {
                URLChooser.mav$runNow(URLChooser.this, 0);
                URLNode node = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
                if (node != this._lastSelectedNode && !node.isExpanded()) {
                    URLChooser.ra$_cbLocation(URLChooser.this).setSelectedItem(this._lastSelectedNode);
                }
            }
            this._lastSelectedNode = null;
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            if (this._enabled) {
                URLChooser.ra$_cbLocation(URLChooser.this).setSelectedItem(this._lastSelectedNode);
                this._lastSelectedNode = null;
            }
        }

        public void ancestorAdded(AncestorEvent e) {
            URLChooser.mav$runLater(URLChooser.this, 9);
        }

        public void ancestorMoved(AncestorEvent e) {
        }

        public void ancestorRemoved(AncestorEvent e) {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (this._enabled) {
                if (!URLChooser.ra$_disableCompletionPopup(URLChooser.this)) {
                    URLChooser.mav$runNow(URLChooser.this, 7);
                } else {
                    this._lastSelectedNode = null;
                    URLChooser.mav$runNow(URLChooser.this, 6);
                }
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (this._enabled) {
                if (!URLChooser.ra$_disableCompletionPopup(URLChooser.this)) {
                    URLChooser.mav$runNow(URLChooser.this, 8);
                } else {
                    this._lastSelectedNode = null;
                    URLChooser.mav$runNow(URLChooser.this, 6);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            URLNode fileNode;
            if ((URLChooser.ra$_forceUseList(URLChooser.this) || URLChooser.ra$_selectionScope(URLChooser.this) != 1) && this._trigger.isDoubleClick(e) && (fileNode = URLChooser.ra$_fileView(URLChooser.this).getNodeAt(e.getPoint())) != null && !fileNode.isLeaf()) {
                URLChooser.mav$maybeLoadTreeNode(URLChooser.this, fileNode, false, true);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void eventDispatched(AWTEvent e) {
            Component component;
            Object source = e.getSource();
            Component component2 = component = source instanceof Component ? (Component)source : null;
            if (component != null) {
                switch (e.getID()) {
                    case 501: {
                        if (source == URLChooser.ra$_tfFileName(URLChooser.this) || source == URLChooser.ra$_completionWindow(URLChooser.this) || SwingUtilities.windowForComponent(component) == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 205: {
                        if (source == URLChooser.ra$_completionWindow(URLChooser.this) || source == URLChooser.ra$_urlChooserDialog(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 203: {
                        if (source == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 100: {
                        if (source == URLChooser.ra$_completionWindow(URLChooser.this) || SwingUtilities.windowForComponent(component) == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 101: {
                        if (source == URLChooser.ra$_completionWindow(URLChooser.this) || SwingUtilities.windowForComponent(component) == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                        break;
                    }
                    case 1004: {
                        if (source == URLChooser.ra$_tfFileName(URLChooser.this) || source == URLChooser.ra$_lblFileName(URLChooser.this) || source == URLChooser.ra$_completionWindow(URLChooser.this) || SwingUtilities.windowForComponent(component) == URLChooser.ra$_completionWindow(URLChooser.this)) break;
                        URLChooser.mav$runNow(URLChooser.this, 13);
                    }
                }
            }
        }

        private L() {
            this.$init$();
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class UI
    implements Runnable {
        static final int SYNC_TO_LOCATION_COMBOBOX = 0;
        static final int CHDIR_TO_PARENT = 1;
        static final int SYNC_TO_TREE_SELECTION = 2;
        static final int SYNC_TO_LIST_SELECTION = 5;
        static final int SYNC_TO_FILE_TYPE_COMBOBOX = 6;
        static final int FILE_NAME_INSERT_UPDATE = 7;
        static final int FILE_NAME_REMOVE_UPDATE = 8;
        static final int SYNC_TO_SHORTCUT_BUTTON = 9;
        static final int UPDATE_TREE_SELECTION = 10;
        static final int POST_UPDATE_TREE_SELECTION = 12;
        static final int HIDE_COMPLETION_LIST = 13;
        private static final int AUTO_FILL_FILE_NAME = 14;
        static final int TAB_COMPLETION = 15;
        static final int SELECT_NEXT_COMPLETION = 16;
        static final int SELECT_PREV_COMPLETION = 17;
        static final int NEW_DIR = 18;
        static final int UPDATE_FILE_LIST = 19;
        static final int POP_LAST_DIRECTORY = 20;
        static final int REFRESH_FILE_LIST = 21;
        static final int PAGE_UP_COMPLETION = 22;
        static final int PAGE_DOWN_COMPLETION = 23;
        private final int _type;

        UI(int type) {
            this._type = type;
        }

        public void run() {
            boolean isEnabled = URLChooser.ra$_listener(URLChooser.this).isEnabled();
            try {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(false);
                switch (this._type) {
                    case 1: {
                        this.chdirToParent();
                        break;
                    }
                    case 0: {
                        this.syncToDirComboBox();
                        break;
                    }
                    case 2: {
                        this.syncToTreeSelection();
                        break;
                    }
                    case 5: {
                        this.syncToListSelection();
                        break;
                    }
                    case 6: {
                        this.syncToFileTypeComboBox();
                        this.updateSelectedFile();
                        break;
                    }
                    case 7: {
                        this.updateCompletionList(true);
                        URLChooser.ra$_fileView(URLChooser.this).clearSelection();
                        break;
                    }
                    case 8: {
                        this.updateCompletionList(false);
                        URLChooser.ra$_fileView(URLChooser.this).clearSelection();
                        break;
                    }
                    case 9: 
                    case 10: {
                        if (URLChooser.ra$_selectedNode(URLChooser.this) != null) {
                            this.updateTreeSelection();
                            URLChooser.mav$maybeLoadTreeNode(URLChooser.this, URLChooser.ra$_selectedNode(URLChooser.this), false, true);
                        }
                        break;
                    }
                    case 12: {
                        if (URLChooser.ra$_selectedNode(URLChooser.this) != null) {
                            this.updateLocationComboBox(URLChooser.ra$_selectedNode(URLChooser.this));
                            this.updateFileList(URLChooser.ra$_selectedNode(URLChooser.this));
                            this.updateFilename();
                            this.updateSelectedFile();
                            this.syncToListSelection();
                        }
                        break;
                    }
                    case 13: {
                        this.hideCompletionList();
                        break;
                    }
                    case 14: {
                        this.autoFillFileName();
                        break;
                    }
                    case 15: {
                        this.tabCompletion();
                        break;
                    }
                    case 16: {
                        this.selectNextCompletion();
                        break;
                    }
                    case 17: {
                        this.selectPrevCompletion();
                        break;
                    }
                    case 18: {
                        this.createNewDir();
                        break;
                    }
                    case 19: {
                        if (URLChooser.ra$_selectedNode(URLChooser.this) != null) {
                            this.updateFileList(URLChooser.ra$_selectedNode(URLChooser.this));
                        }
                        break;
                    }
                    case 20: {
                        URLChooser.mav$popHistoryList(URLChooser.this);
                        break;
                    }
                    case 21: {
                        this.refreshFileList(URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this));
                        break;
                    }
                    case 22: {
                        this.pageUpCompletion();
                        break;
                    }
                    case 23: {
                        this.pageDownCompletion();
                        break;
                    }
                }
            }
            finally {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(isEnabled);
            }
        }

        private void syncToDirComboBox() {
            URLNode selectedDirNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (URLChooser.mav$setSelectedNode(URLChooser.this, selectedDirNode) && !URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                this.updateFileList(selectedDirNode);
                this.updateSelectedFile();
            }
        }

        private void chdirToParent() {
            TreeNode[] nodePath;
            URLNode selectedDirNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (selectedDirNode != null && (nodePath = selectedDirNode.getPath()).length > 2) {
                this.setLocation((URLNode)nodePath[nodePath.length - 2]);
                this.syncToDirComboBox();
            }
        }

        private void syncToTreeSelection() {
            URLChooser.wa$_selectedNode(URLChooser.this, URLChooser.mav$getSelectedDirTreeNode(URLChooser.this));
            URLChooser.mav$maybeLoadTreeNode(URLChooser.this, URLChooser.ra$_selectedNode(URLChooser.this), false, true);
            URLChooser.ra$_commandBar(URLChooser.this).enableNewDirButton(URLChooser.ra$_selectedNode(URLChooser.this) != null);
        }

        private void syncToListSelection() {
            URLNode fileNode = URLChooser.mav$getSelectedFileListNode(URLChooser.this);
            URLChooser.wa$_selectedNode(URLChooser.this, fileNode != null ? fileNode : URLChooser.mav$getSelectedDirTreeNode(URLChooser.this));
            if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                URLChooser.this.setFileNameURL(null);
            } else if (fileNode != null && fileNode.isLeaf() || URLChooser.mav$isSingleDirectoryChooser(URLChooser.this)) {
                String fileName = fileNode != null ? fileNode.toString() : "";
                URLChooser.this.setFileNameURL(fileName);
            }
        }

        private void syncToFileTypeComboBox() {
            URLFilter previous = URLChooser.ra$_curFilter(URLChooser.this);
            URLChooser.wa$_curFilter(URLChooser.this, URLChooser.this.getSelectedFilter());
            URLNode selectedDir = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            this.updateFileList(selectedDir);
            URLChooser.mav$fireUrlFilterChanged(URLChooser.this, URLChooser.ra$_curFilter(URLChooser.this), previous);
        }

        private void updateTreeSelection() {
            if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                Object[] nodePath = URLChooser.ra$_selectedNode(URLChooser.this).getPath();
                TreePath tp = new TreePath(nodePath);
                URLChooser.ra$_dirTree(URLChooser.this).expandPath(tp);
                this.scrollTreeToSelection();
            }
        }

        private void scrollTreeToSelection() {
            if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                int treeHeight;
                Object[] nodePath = URLChooser.ra$_selectedNode(URLChooser.this).getPath();
                TreePath tp = new TreePath(nodePath);
                URLChooser.ra$_dirTree(URLChooser.this).setSelectionPath(tp);
                Rectangle pathRect = URLChooser.ra$_dirTree(URLChooser.this).getPathBounds(tp);
                JViewport viewPort = URLChooser.ra$_spDirs(URLChooser.this).getViewport();
                Rectangle viewRect = viewPort.getViewRect();
                viewRect.y = pathRect.y - (viewRect.height - pathRect.height >> 1);
                if (viewRect.y < 0) {
                    viewRect.y = 0;
                }
                if (viewRect.y + viewRect.height > (treeHeight = URLChooser.ra$_dirTree(URLChooser.this).getHeight())) {
                    viewRect.y = treeHeight - viewRect.height;
                }
                URLChooser.ra$_dirTree(URLChooser.this).scrollRectToVisible(viewRect);
            }
        }

        private void updateLocationComboBox(URLNode selectedNode) {
            Object[] treeNodes;
            if (selectedNode == null) {
                this.setLocation(null);
                return;
            }
            TreeNode[] nodePath = selectedNode.getPath();
            if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                int selectedCount = nodePath.length - 1;
                treeNodes = new Object[selectedCount];
                int i = 0;
                while (i < selectedCount) {
                    treeNodes[i++] = nodePath[i];
                }
            } else {
                int n = URLChooser.ra$_root(URLChooser.this).getChildCount();
                ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(n + nodePath.length - 1);
                int i = 0;
                while (i < n) {
                    URLNode childNode = (URLNode)URLChooser.ra$_root(URLChooser.this).getChildAt(i);
                    nodes.add(childNode);
                    if (nodePath.length > 1) {
                        int j = 1;
                        while (j < nodePath.length) {
                            URLNode node = (URLNode)nodePath[j];
                            if (URLFileSystem.equals((URL)node.getURL(), (URL)childNode.getURL())) {
                                while (++j < nodePath.length) {
                                    nodes.add(nodePath[j]);
                                }
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                treeNodes = nodes.toArray(new TreeNode[nodes.size()]);
            }
            ComboBoxModel cbm = URLChooser.ra$_cbLocation(URLChooser.this).getModel();
            if (cbm != null) {
                cbm.removeListDataListener(URLChooser.ra$_listener(URLChooser.this));
            }
            cbm = new DefaultComboBoxModel<Object>(treeNodes);
            cbm.addListDataListener(URLChooser.ra$_listener(URLChooser.this));
            this.setLocationsModel(cbm);
            this.setLocation(selectedNode);
        }

        private void refreshFileList(URLNode selectedNode) {
            if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                URLChooser.mav$refreshAll(URLChooser.this);
                this.scrollTreeToSelection();
            } else {
                URLChooser.mav$flushNodes(URLChooser.this);
                URLChooser.ra$_fileView(URLChooser.this).clearList(true);
                if (selectedNode != null) {
                    URLChooser.mav$setSelectedURLImpl(URLChooser.this, selectedNode.getURL(), false);
                }
                this.updateSelectedFile();
            }
        }

        private void updateFileList(URLNode selectedNode) {
            URLChooser.ra$_fileView(URLChooser.this).updateList(selectedNode, URLChooser.ra$_curFilter(URLChooser.this));
            URLChooser.ra$_commandBar(URLChooser.this).enableUpDirButton(selectedNode != null && !URLChooser.mav$isRootURL(URLChooser.this, selectedNode.getURL()));
            URLChooser.mav$pushHistoryList(URLChooser.this, selectedNode);
        }

        private void updateFilename() {
            if (URLChooser.mav$isSingleDirectoryChooser(URLChooser.this)) {
                URLChooser.this.setFileNameURL(null);
            }
        }

        private void updateSelectedFile() {
            URLChooser.ra$_fileView(URLChooser.this).updateSelectedFile(URLChooser.this.getFileNameURL());
        }

        private void updateCompletionList(boolean doAutoFill) {
            if (!URLChooser.ra$_tfFileName(URLChooser.this).isShowing()) {
                return;
            }
            if (URLChooser.ra$_completionWindow(URLChooser.this) == null) {
                Window urlChooserDialog = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)URLChooser.this));
                if (urlChooserDialog == null) {
                    return;
                }
                URLChooser.wa$_completionWindow(URLChooser.this, new JWindow(urlChooserDialog));
                URLChooser.ra$_completionWindow(URLChooser.this).setFocusableWindowState(false);
                Point tfScreenLoc = URLChooser.ra$_tfFileName(URLChooser.this).getLocationOnScreen();
                Dimension tfSize = URLChooser.ra$_tfFileName(URLChooser.this).getSize();
                URLChooser.ra$_completionWindow(URLChooser.this).setLocation(tfScreenLoc.x, tfScreenLoc.y + tfSize.height + 1);
                URLChooser.wa$_completionList(URLChooser.this, new CL());
                if (this.setCompletionListData(doAutoFill)) {
                    URLChooser.wa$_completionScrollPane(URLChooser.this, new JScrollPane());
                    URLChooser.ra$_completionScrollPane(URLChooser.this).setViewportView(URLChooser.ra$_completionList(URLChooser.this));
                    Dimension size = URLChooser.ra$_completionScrollPane(URLChooser.this).getPreferredSize();
                    size.width = tfSize.width;
                    ++size.height;
                    URLChooser.ra$_completionScrollPane(URLChooser.this).setPreferredSize(size);
                    URLChooser.ra$_completionWindow(URLChooser.this).getContentPane().add(URLChooser.ra$_completionScrollPane(URLChooser.this));
                    URLChooser.ra$_completionWindow(URLChooser.this).pack();
                    Toolkit.getDefaultToolkit().addAWTEventListener(URLChooser.ra$_listener(URLChooser.this), 85);
                    URLChooser.ra$_completionWindow(URLChooser.this).setVisible(true);
                }
            } else {
                this.setCompletionListData(doAutoFill);
            }
        }

        private boolean setCompletionListData(boolean doAutoFill) {
            URLNode dirNode;
            String fileName = URLChooser.this.getFileNameURL();
            if (!ModelUtil.hasLength((String)fileName)) {
                this.hideCompletionList();
                return false;
            }
            boolean isAbsolute = new File(fileName).isAbsolute() || fileName.startsWith(File.separator) || fileName.startsWith("/");
            URLNode uRLNode = dirNode = isAbsolute ? URLChooser.ra$_root(URLChooser.this) : URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (dirNode == null) {
                this.hideCompletionList();
                return false;
            }
            String[] pathComponents = URLChooser.ra$FILE_SEPARATORS_PATTERN().split(fileName, -1);
            StringBuffer pathPrefix = new StringBuffer();
            if (pathComponents.length > 1) {
                int i = 0;
                while (i < pathComponents.length - 1) {
                    URL childURL;
                    String pathComponent = pathComponents[i];
                    if (!ModelUtil.hasLength((String)pathComponent) && i > 0) {
                        this.hideCompletionList();
                        return false;
                    }
                    URL dirURL = dirNode.getURL();
                    if (dirURL == null) {
                        Assert.check((boolean)isAbsolute);
                        childURL = !ModelUtil.hasLength((String)pathComponent) ? this.getRootURL(URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this).getURL()) : URLFactory.newDirURL((String)(pathComponent + '/'));
                    } else {
                        childURL = URLFactory.newDirURL((URL)dirURL, (String)pathComponent);
                    }
                    URLNode childNode = URLChooser.maS$findChildByURL(dirNode, childURL);
                    if (childNode != null) {
                        dirNode = childNode;
                    } else {
                        URLNode parent = (URLNode)dirNode.getParent();
                        if (parent != null && URLFileSystem.equals((URL)parent.getURL(), (URL)childURL)) {
                            dirNode = parent;
                        } else {
                            this.hideCompletionList();
                            return false;
                        }
                    }
                    if (!dirNode.isExpanded()) {
                        dirNode.buildChildren(true, false, true);
                    }
                    pathPrefix.append(pathComponent).append(File.separator);
                    ++i;
                }
                fileName = pathComponents[pathComponents.length - 1];
            }
            String escapedFileName = WildcardURLFilter.makeLiteral((String)fileName);
            WildcardURLFilter filter = new WildcardURLFilter(escapedFileName + "*", URLChooser.ra$_isCaseSensitive());
            int dirMode = URLChooser.ra$_selectionScope(URLChooser.this) == 1 ? 3 : 1;
            Vector filteredFiles = new Vector();
            if (pathComponents.length <= 1) {
                filteredFiles.addAll(URLChooser.ra$_root(URLChooser.this).getFiles((URLFilter)filter, dirMode));
            }
            filteredFiles.addAll(dirNode.getFiles((URLFilter)filter, dirMode));
            int numFilteredFiles = filteredFiles.size();
            if (numFilteredFiles <= 0) {
                this.hideCompletionList();
                return false;
            }
            if (doAutoFill && numFilteredFiles == 1) {
                URLChooser.mav$runLater(URLChooser.this, 14);
            }
            URLChooser.ra$_completionList(URLChooser.this).setPathPrefix(pathPrefix.toString());
            URLChooser.ra$_completionList(URLChooser.this).setListData(filteredFiles);
            return true;
        }

        private void autoFillFileName() {
            String fileName;
            int fileNameLen;
            String completedFileName;
            int completedFileNameLen;
            int nMinus1;
            String relSpec;
            URL dirURL;
            if (URLChooser.ra$_completionList(URLChooser.this) == null) {
                return;
            }
            URLNode matchingURLNode = (URLNode)URLChooser.ra$_completionList(URLChooser.this).getModel().getElementAt(0);
            URL fileURL = matchingURLNode.getURL();
            String pathPrefix = URLChooser.ra$_completionList(URLChooser.this).getPathPrefix().replace(File.separatorChar, '/');
            if (new File(pathPrefix).isAbsolute()) {
                dirURL = URLFactory.newURL((String)pathPrefix);
            } else if (pathPrefix.startsWith(File.separator) || pathPrefix.startsWith("/")) {
                dirURL = URLFactory.newURL((URL)this.getRootURL(URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this).getURL()), (String)pathPrefix);
            } else {
                URLNode dirNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
                dirURL = URLFactory.newURL((URL)dirNode.getURL(), (String)pathPrefix);
            }
            if (JarUtil.isJarURL((URL)fileURL) && !JarUtil.isJarURL((URL)dirURL)) {
                fileURL = JarUtil.getJarFileURL((URL)fileURL);
            }
            if (!ModelUtil.hasLength((String)(relSpec = URLFileSystem.toRelativeSpec((URL)fileURL, (URL)dirURL, (boolean)true)))) {
                return;
            }
            StringBuffer completionBuf = new StringBuffer(pathPrefix + relSpec);
            if (completionBuf.charAt(nMinus1 = completionBuf.length() - 1) == '/') {
                completionBuf.setLength(nMinus1);
            }
            if ((completedFileNameLen = (completedFileName = completionBuf.toString()).length()) >= (fileNameLen = (fileName = URLChooser.this.getFileNameURL()).length())) {
                String fnameFrag;
                String fileNameFrag = completedFileName.substring(0, fileNameLen);
                String fname = fileName.replace('/', File.separatorChar);
                if (URLChooser.maS$compare(fname, fnameFrag = fileNameFrag.replace('/', File.separatorChar)) == 0) {
                    URLChooser.this.setFileNameURL(fileName + completedFileName.substring(fileNameLen));
                    URLChooser.ra$_tfFileName(URLChooser.this).setCaretPosition(completedFileName.length());
                    URLChooser.ra$_tfFileName(URLChooser.this).moveCaretPosition(fileNameLen);
                }
            }
        }

        private URL getRootURL(URL url) {
            if (url == null) {
                return null;
            }
            URL u;
            while ((u = URLFileSystem.getParent((URL)url)) != null) {
                url = u;
            }
            return url;
        }

        private void hideCompletionList() {
            if (URLChooser.ra$_completionWindow(URLChooser.this) != null) {
                URLChooser.ra$_completionWindow(URLChooser.this).dispose();
                URLChooser.wa$_completionWindow(URLChooser.this, null);
                URLChooser.wa$_completionList(URLChooser.this, null);
                Toolkit.getDefaultToolkit().removeAWTEventListener(URLChooser.ra$_listener(URLChooser.this));
            }
        }

        private void tabCompletion() {
            String completedFrag;
            String curFrag = completedFrag = URLChooser.this.getFileNameURL();
            int curLen = curFrag.length();
            ListModel listModel = URLChooser.ra$_completionList(URLChooser.this).getModel();
            int n = listModel.getSize();
            String fileName = "";
            String fileNameStart = curFrag;
            block0: while (true) {
                int i = n;
                while (--i >= 0) {
                    URLNode curNode = (URLNode)listModel.getElementAt(i);
                    URL curURL = curNode.getURL();
                    fileName = URLFileSystem.getFileName((URL)curURL);
                    if (curLen > fileName.length() || URLChooser.maS$compare(curFrag, fileNameStart = fileName.substring(0, curLen)) != 0) break block0;
                }
                completedFrag = fileNameStart;
                if (++curLen > fileName.length()) break;
                curFrag = fileName.substring(0, curLen);
            }
            URLChooser.this.setFileNameURL(completedFrag);
        }

        private void selectNextCompletion() {
            int max = URLChooser.ra$_completionList(URLChooser.this).getModel().getSize() - 1;
            int curIndex = URLChooser.ra$_completionList(URLChooser.this).getSelectedIndex();
            if (curIndex < max) {
                this.setCompletionIndex(curIndex + 1);
            }
        }

        private void selectPrevCompletion() {
            int curIndex = URLChooser.ra$_completionList(URLChooser.this).getSelectedIndex();
            if (curIndex > 0) {
                this.setCompletionIndex(curIndex - 1);
            } else if (curIndex < 0) {
                int max = URLChooser.ra$_completionList(URLChooser.this).getModel().getSize() - 1;
                this.setCompletionIndex(max);
            }
        }

        private void pageUpCompletion() {
            int numVisibleRows;
            int curIndex = URLChooser.ra$_completionList(URLChooser.this).getSelectedIndex();
            int newIndex = curIndex - (numVisibleRows = URLChooser.ra$_completionList(URLChooser.this).getVisibleRowCount());
            this.setCompletionIndex(newIndex >= 0 ? newIndex : 0);
        }

        private void pageDownCompletion() {
            int max;
            int numVisibleRows;
            int curIndex = URLChooser.ra$_completionList(URLChooser.this).getSelectedIndex();
            int newIndex = curIndex + (numVisibleRows = URLChooser.ra$_completionList(URLChooser.this).getVisibleRowCount());
            this.setCompletionIndex(newIndex <= (max = URLChooser.ra$_completionList(URLChooser.this).getModel().getSize() - 1) ? newIndex : max);
        }

        private void setCompletionIndex(int index) {
            URLChooser.ra$_completionList(URLChooser.this).setSelectedIndex(index);
            URLChooser.ra$_completionList(URLChooser.this).ensureIndexIsVisible(index);
        }

        private void createNewDir() {
            URLNode curDirNode = URLChooser.mav$getSelectedDirComboBoxNode(URLChooser.this);
            if (curDirNode != null) {
                URL newDir;
                URL curDir = curDirNode.getURL();
                String dirName = "";
                while (true) {
                    if ((dirName = this.showNewDirectoryDialog((Component)((Object)URLChooser.this), dirName)) == null) {
                        return;
                    }
                    if (dirName.indexOf(47) >= 0 || dirName.indexOf(File.separatorChar) >= 0) {
                        JOptionPane.showMessageDialog((Component)((Object)URLChooser.this), NetArb.getString((int)34), NetArb.getString((int)35), 0);
                        continue;
                    }
                    newDir = URLFactory.newDirURL((URL)curDir, (String)dirName);
                    if (URLFileSystem.mkdirs((URL)newDir)) break;
                    JOptionPane.showMessageDialog((Component)((Object)URLChooser.this), NetArb.getString((int)28), NetArb.getString((int)35), 0);
                }
                curDirNode.insertDir(newDir);
                return;
            }
        }

        private String showNewDirectoryDialog(Component parent, String dirName) {
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel();
            JTextField dirNameField = new JTextField(30);
            ResourceUtils.resLabel((JLabel)label, (Component)dirNameField, (String)NetArb.getString((int)5));
            int y = 0;
            panel.add((Component)label, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)dirNameField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel(), new GridBagConstraints(0, y++, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JEWTDialog dlg = new JEWTDialog(SwingUtils.findFrame((Component)((Object)URLChooser.this)), NetArb.getString((int)9), 3);
            dlg.setInitialFocus((Component)dirNameField);
            dlg.setContent((Component)panel);
            dlg.setOKButtonEnabled(false);
            dirNameField.getDocument().addDocumentListener(new 1(this, dlg, dirNameField));
            dirNameField.setText(dirName);
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return dirNameField.getText();
            }
            return null;
        }

        private void setLocation(URLNode node) {
            ListCellRenderer renderer = URLChooser.ra$_cbLocation(URLChooser.this).getRenderer();
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(null);
            URLChooser.ra$_cbLocation(URLChooser.this).setSelectedItem(node);
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(renderer);
        }

        private void setLocationsModel(ComboBoxModel cbm) {
            ListCellRenderer renderer = URLChooser.ra$_cbLocation(URLChooser.this).getRenderer();
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(null);
            URLChooser.ra$_cbLocation(URLChooser.this).setModel(cbm);
            URLChooser.ra$_cbLocation(URLChooser.this).setRenderer(renderer);
        }

        final class 1
        implements DocumentListener {
            private final /* synthetic */ JEWTDialog v$dlg;
            private final /* synthetic */ JTextField v$dirNameField;
            final /* synthetic */ UI this$0;

            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                this.v$dlg.setOKButtonEnabled(this.canOk());
            }

            private boolean canOk() {
                return this.v$dirNameField.getText().trim().length() > 0;
            }

            public 1(UI uI, JEWTDialog jEWTDialog, JTextField jTextField) {
                this.v$dirNameField = jTextField;
                this.v$dlg = jEWTDialog;
                this.this$0 = uI;
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public static final String KEY = "urlchooser-refresh";

        public boolean isEnabled() {
            if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                return URLChooser.ra$_dirTree(URLChooser.this).isEnabled();
            }
            return URLChooser.ra$_fileView(URLChooser.this).isEnabled();
        }

        public void actionPerformed(ActionEvent e) {
            URLChooser.mav$runNow(URLChooser.this, 21);
        }

        private RefreshAction() {
        }

        RefreshAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLNodeComparator
    implements Comparator {
        private final boolean _dirsBeforeFiles;
        private final boolean _caseSensitive;

        public URLNodeComparator(boolean dirsBeforeFiles, boolean caseSensitive) {
            this._dirsBeforeFiles = dirsBeforeFiles;
            this._caseSensitive = caseSensitive;
        }

        public int compare(Object o1, Object o2) {
            boolean isDir2;
            boolean isDir1;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            URL url1 = ((URLNode)o1).getURL();
            URL url2 = ((URLNode)o2).getURL();
            if (this._dirsBeforeFiles && (isDir1 = URLFileSystem.isDirectoryPath((URL)url1)) != (isDir2 = URLFileSystem.isDirectoryPath((URL)url2))) {
                return isDir1 ? -1 : 1;
            }
            String name1 = URLFileSystem.getFileName((URL)url1);
            String name2 = URLFileSystem.getFileName((URL)url2);
            if (this._caseSensitive) {
                return name1.compareTo(name2);
            }
            return name1.compareToIgnoreCase(name2);
        }
    }

    private class Dlg
    extends TDialog
    implements MouseListener {
        private final DoubleClickTrigger _trigger;

        Dlg(TDialogLauncher launcher, Frame parentFrame, Traversable content, String approveText) {
            super(launcher, parentFrame);
            this.$init$();
            this.init(content, approveText);
        }

        Dlg(TDialogLauncher launcher, Dialog parentDialog, Traversable content, String approveText) {
            super(launcher, parentDialog);
            this.$init$();
            this.init(content, approveText);
        }

        private void init(Traversable content, String approveText) {
            this.setResizable(true);
            this.setOKButtonText(approveText);
            this.setContent(content.getComponent());
            this.setInitialFocus(URLChooser.ra$_tfFileName(URLChooser.this));
        }

        protected void dismissDialog(boolean canceled) {
            if (canceled) {
                URLChooser.this.cancelSelection();
                super.dismissDialog(canceled);
                return;
            }
            boolean okEnabled = this.isOKButtonEnabled();
            this.setOKButtonEnabled(false);
            boolean approved = URLChooser.this.approveSelection();
            this.setOKButtonEnabled(okEnabled);
            if (approved) {
                super.dismissDialog(canceled);
            }
        }

        private void $init$() {
            this._trigger = new DoubleClickTrigger();
        }

        public void mouseClicked(MouseEvent e) {
            if (this._trigger.isDoubleClick(e)) {
                Point pt = e.getPoint();
                if (!URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1) {
                    int row = URLChooser.ra$_dirTree(URLChooser.this).getRowForLocation(pt.x, pt.y);
                    if (URLChooser.ra$_dirTree(URLChooser.this).isRowSelected(row)) {
                        this.dismissDialog(false);
                    }
                } else {
                    URLNode fileNode = URLChooser.ra$_fileView(URLChooser.this).getNodeAt(pt);
                    if (fileNode != null && fileNode.isLeaf()) {
                        this.dismissDialog(false);
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class TF
    extends JTextField {
        private final boolean _doTabCompletion;

        private void $init$() {
            this._doTabCompletion = Boolean.getBoolean("jdev.tab.completion");
        }

        public TF() {
            this.$init$();
            if (this._doTabCompletion) {
                this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            }
        }

        protected void processKeyEvent(KeyEvent e) {
            if (!URLChooser.ra$_disableCompletionPopup(URLChooser.this) && e.getID() == 401) {
                int keyCode = e.getKeyCode();
                if (keyCode == 9 && this._doTabCompletion) {
                    boolean focusNextComponent;
                    if (URLChooser.ra$_completionWindow(URLChooser.this) != null) {
                        URLChooser.mav$runNow(URLChooser.this, 15);
                        focusNextComponent = false;
                    } else {
                        focusNextComponent = true;
                    }
                    if (focusNextComponent) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
                    }
                    e.consume();
                } else if (URLChooser.ra$_completionWindow(URLChooser.this) != null) {
                    switch (keyCode) {
                        case 27: {
                            URLChooser.mav$runNow(URLChooser.this, 13);
                            e.consume();
                            return;
                        }
                        case 38: {
                            URLChooser.mav$runNow(URLChooser.this, 17);
                            e.consume();
                            return;
                        }
                        case 40: {
                            URLChooser.mav$runNow(URLChooser.this, 16);
                            e.consume();
                            return;
                        }
                        case 33: {
                            URLChooser.mav$runNow(URLChooser.this, 22);
                            e.consume();
                            break;
                        }
                        case 34: {
                            URLChooser.mav$runNow(URLChooser.this, 23);
                            e.consume();
                            break;
                        }
                    }
                }
            }
            super.processKeyEvent(e);
        }

        protected void clear() {
            this.setText("");
        }
    }

    private class CL
    extends JList
    implements KeyListener,
    ListSelectionListener,
    MouseListener {
        private String _pathPrefix;
        private final DoubleClickTrigger _trigger;

        private void $init$() {
            this._pathPrefix = "";
            this._trigger = new DoubleClickTrigger();
        }

        CL() {
            this.$init$();
            this.setSelectionMode(0);
            this.setCellRenderer(new LCR2());
            this.setVisibleRowCount(7);
            this.addKeyListener(this);
            this.addListSelectionListener(this);
            this.addMouseListener(this);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        String getPathPrefix() {
            return this._pathPrefix;
        }

        void setPathPrefix(String pathPrefix) {
            this._pathPrefix = pathPrefix != null ? pathPrefix : "";
        }

        public void valueChanged(ListSelectionEvent e) {
            boolean isEnabled = URLChooser.ra$_listener(URLChooser.this).isEnabled();
            try {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(false);
                URLNode urlNode = (URLNode)this.getSelectedValue();
                if (urlNode != null) {
                    URL url = urlNode.getURL();
                    if (URLFileSystem.isRoot((URL)url)) {
                        URLChooser.this.setFileNameURL(URLFileSystem.getPlatformPathName((URL)url));
                    } else {
                        URLChooser.this.setFileNameURL(this._pathPrefix + URLFileSystem.getFileName((URL)url));
                    }
                }
            }
            finally {
                URLChooser.ra$_listener(URLChooser.this).setEnabled(isEnabled);
            }
        }

        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 10: {
                    URLChooser.mav$runNow(URLChooser.this, 13);
                    if (URLChooser.ra$_urlChooserDialog(URLChooser.this) == null) break;
                    URLChooser.ra$_urlChooserDialog(URLChooser.this).dismissDialog(false);
                    break;
                }
                case 27: {
                    URLChooser.mav$runNow(URLChooser.this, 13);
                    e.consume();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            URLChooser.mav$runNow(URLChooser.this, 13);
            if (this._trigger.isDoubleClick(e)) {
                URLChooser.ra$_urlChooserDialog(URLChooser.this).dismissDialog(false);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        static String ra$_pathPrefix(CL cL) {
            return cL._pathPrefix;
        }

        private final class LCR2
        extends DefaultListCellRenderer {
            LCR2() {
                this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                URLChooser.maS$setLabelIcon(label, value, false);
                this.setText(CL.ra$_pathPrefix(CL.this) + value.toString());
                this.setEnabled(list.isEnabled());
                return label;
            }
        }
    }

    private class ShortcutBar
    extends JPanel
    implements ComponentListener {
        private final JScrollPane _shortcutScrollPane;
        private final ShortcutPanel _shortcutPanel;

        public ShortcutBar() {
            BoxLayout layout = new BoxLayout(this, 1);
            this.setLayout(layout);
            this.setBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeelDefaults().getColor("controlShadow")));
            this.setVisible(false);
            this._shortcutPanel = new ShortcutPanel();
            this._shortcutScrollPane = new JScrollPane(20, 31);
            this._shortcutScrollPane.setOpaque(false);
            this._shortcutScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._shortcutScrollPane.setViewportView(this._shortcutPanel);
            this._shortcutScrollPane.getViewport().setOpaque(false);
            this._shortcutScrollPane.getVerticalScrollBar().addComponentListener(this);
            this.add(this._shortcutScrollPane);
        }

        public void addShortcutButton(Icon icon, String description, URL url) {
            if (url == null) {
                return;
            }
            ShortcutButton shortcut = new ShortcutButton(icon, description, url);
            this._shortcutPanel.add(shortcut);
        }

        public void removeShortcutButtons() {
            this._shortcutPanel.removeAll();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComposite = g2.getComposite();
            Rectangle clipRect = g2.getClipBounds();
            g2.setComposite(URLChooser.ra$SHORTCUT_BACKGROUND_COMPOSITE());
            g2.setColor(Color.white);
            g2.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            g2.setComposite(oldComposite);
        }

        public Dimension getPreferredSize() {
            JScrollBar vsb;
            Dimension size = this._shortcutPanel.getMinimumSize();
            int paneWidth = size != null ? size.width : this._shortcutPanel.getWidth();
            Insets insets = this._shortcutPanel.getInsets();
            if (insets != null) {
                paneWidth += insets.left + insets.right;
            }
            if ((insets = this.getInsets()) != null) {
                paneWidth += insets.left + insets.right;
            }
            if ((insets = this._shortcutScrollPane.getViewport().getInsets()) != null) {
                paneWidth += insets.left + insets.right;
            }
            if ((vsb = this._shortcutScrollPane.getVerticalScrollBar()) != null && vsb.isVisible()) {
                paneWidth += vsb.getWidth();
            }
            int paneHeight = URLChooser.ra$_cbFileType(URLChooser.this).getY() + URLChooser.ra$_cbFileType(URLChooser.this).getHeight() - URLChooser.ra$_fileView(URLChooser.this).getY();
            return new Dimension(paneWidth, paneHeight);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void componentHidden(ComponentEvent e) {
            if (e.getSource() == this._shortcutScrollPane.getVerticalScrollBar()) {
                URLChooser.this.revalidate();
            }
        }

        public void componentShown(ComponentEvent e) {
            this.componentHidden(e);
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        private class ShortcutPanel
        extends JToolBar
        implements Scrollable {
            public ShortcutPanel() {
                super(1);
                this.setFloatable(false);
                this.setRollover(true);
                this.setOpaque(false);
                this.setBorder(BorderFactory.createEmptyBorder());
            }

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(URLChooser.ra$SHORTCUT_BUTTON_SIZE().width, URLChooser.ra$_cbFileType(URLChooser.this).getY() + URLChooser.ra$_cbFileType(URLChooser.this).getHeight() - URLChooser.ra$_fileView(URLChooser.this).getY());
            }

            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return orientation == 1 ? visibleRect.height / URLChooser.ra$SHORTCUT_BUTTON_SIZE().height * URLChooser.ra$SHORTCUT_BUTTON_SIZE().height : visibleRect.width / URLChooser.ra$SHORTCUT_BUTTON_SIZE().width * URLChooser.ra$SHORTCUT_BUTTON_SIZE().width;
            }

            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return orientation == 1 ? URLChooser.ra$SHORTCUT_BUTTON_SIZE().height : URLChooser.ra$SHORTCUT_BUTTON_SIZE().width;
            }

            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            protected void addImpl(Component component, Object constraints, int index) {
                super.addImpl(component, constraints, index);
                ShortcutBar.this.setVisible(true);
            }

            public void removeAll() {
                super.removeAll();
                ShortcutBar.this.setVisible(false);
            }
        }

        private class ShortcutButton
        extends JButton
        implements ActionListener {
            private final URL _targetURL;

            public ShortcutButton(Icon icon, String description, URL url) {
                super(icon);
                this.setMargin(new Insets(1, 1, 1, 1));
                this.setMinimumSize(URLChooser.ra$SHORTCUT_BUTTON_SIZE());
                this.setPreferredSize(URLChooser.ra$SHORTCUT_BUTTON_SIZE());
                this.setMaximumSize(URLChooser.ra$SHORTCUT_BUTTON_SIZE());
                this.setOpaque(false);
                URL uRL = this._targetURL = URLFileSystem.isDirectoryPath((URL)url) ? URLFactory.newURL((URL)url, (String)"") : URLFileSystem.getParent((URL)url);
                if (icon == null) {
                    this.setIcon(OracleIcons.getIcon((String)"folder.png"));
                }
                this.setText(description);
                this.setToolTipText(NetArb.format((int)39, (Object)description, (Object)URLFileSystem.getPlatformPathName((URL)this._targetURL)));
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.addActionListener(this);
            }

            public void actionPerformed(ActionEvent e) {
                URLChooser.mav$setSelectedURLImpl(URLChooser.this, this._targetURL, false);
                URLChooser.ra$_tfFileName(URLChooser.this).requestFocus();
            }
        }
    }

    private class CommandBar
    extends JToolBar
    implements ActionListener {
        private JButton _btnBack;
        private JButton _btnChdirToParent;
        private JButton _btnNewDir;
        private JToggleButton _btnListView;
        private JToggleButton _btnDetailsView;

        public CommandBar() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFloatable(false);
            this.setRollover(true);
            this.createButtons();
        }

        public void enableBackButton(boolean enabled) {
            if (this._btnBack != null) {
                this._btnBack.setEnabled(enabled);
            }
        }

        public void enableUpDirButton(boolean enabled) {
            if (this._btnChdirToParent != null) {
                this._btnChdirToParent.setEnabled(enabled);
            }
        }

        public void enableNewDirButton(boolean enabled) {
            if (this._btnNewDir != null) {
                this._btnNewDir.setEnabled(enabled);
            }
        }

        public void setDetailsView(boolean detailsView) {
            if (this._btnListView != null && this._btnDetailsView != null) {
                URLChooser.ra$_fileView(URLChooser.this).setDetailsView(detailsView);
            }
        }

        public void setSelectionScope(int selectionScope) {
            this.removeAll();
            if (selectionScope == 1) {
                if (this._btnNewDir != null) {
                    this.add(this._btnNewDir);
                }
            } else {
                if (this._btnBack != null) {
                    this.add(this._btnBack);
                }
                if (this._btnChdirToParent != null) {
                    this.add(this._btnChdirToParent);
                }
                if (this._btnNewDir != null) {
                    this.add(this._btnNewDir);
                }
                if (this._btnListView != null && this._btnDetailsView != null) {
                    if (this.getComponentCount() > 0) {
                        this.add(Box.createHorizontalStrut(5));
                    }
                    this.add(this._btnListView);
                    this.add(this._btnDetailsView);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (URLChooser.ra$_listener(URLChooser.this).isEnabled()) {
                Object source = e.getSource();
                if (source == null) {
                    return;
                }
                if (source == this._btnBack) {
                    URLChooser.mav$runNow(URLChooser.this, 20);
                } else if (source == this._btnChdirToParent) {
                    URLChooser.mav$runNow(URLChooser.this, 1);
                } else if (source == this._btnNewDir) {
                    URLChooser.mav$runNow(URLChooser.this, 18);
                } else if (source == this._btnListView) {
                    this.setDetailsView(false);
                } else if (source == this._btnDetailsView) {
                    this.setDetailsView(true);
                }
            }
        }

        private JButton createButton(Icon icon, String tooltip) {
            JButton button = new JButton(icon);
            this.initButton(button, tooltip);
            return button;
        }

        private JToggleButton createToggleButton(Icon icon, String tooltip) {
            JToggleButton button = new JToggleButton(icon);
            this.initButton(button, tooltip);
            return button;
        }

        private void initButton(AbstractButton button, String tooltip) {
            button.setMargin(new Insets(1, 1, 1, 1));
            button.addActionListener(this);
            if (tooltip != null) {
                button.setToolTipText(tooltip);
            }
        }

        private void createButtons() {
            Icon backIcon = OracleIcons.getIcon((String)"navigateBack.png");
            if (backIcon != null) {
                this._btnBack = this.createButton(backIcon, NetArb.getString((int)18));
                this._btnBack.setEnabled(false);
            } else {
                this._btnBack = null;
            }
            Icon upDirIcon = NetArb.getIcon((int)0);
            this._btnChdirToParent = upDirIcon != null ? this.createButton(upDirIcon, NetArb.getString((int)3)) : null;
            Icon newDirIcon = NetArb.getIcon((int)36);
            this._btnNewDir = newDirIcon != null ? this.createButton(newDirIcon, NetArb.getString((int)6)) : null;
            Icon listViewIcon = NetArb.getIcon((int)27);
            Icon detailsViewIcon = NetArb.getIcon((int)30);
            if (listViewIcon != null && detailsViewIcon != null) {
                this._btnListView = this.createToggleButton(listViewIcon, NetArb.getString((int)38));
                this._btnDetailsView = this.createToggleButton(detailsViewIcon, NetArb.getString((int)25));
                ButtonGroup group = new ButtonGroup();
                group.add(this._btnListView);
                group.add(this._btnDetailsView);
                this._btnListView.setSelected(true);
            } else {
                this._btnDetailsView = null;
                this._btnListView = null;
            }
        }
    }

    private class FileView
    extends JPanel
    implements KeyListener {
        private final FileTable _fileTable;
        private final JScrollPane _fileScrollPane;

        private void $init$() {
            this._fileTable = new FileTable();
            this._fileScrollPane = this._fileTable.getScrollPaneForTable();
        }

        public FileView() {
            this.$init$();
            this.setSelectionMode(2);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this._fileScrollPane);
        }

        public void clearSelection() {
            this._fileTable.clearSelection();
        }

        public URLNode getNodeAt(Point p) {
            return this._fileTable.getNodeAt(p);
        }

        public URLNode getSelectedNode() {
            return this._fileTable.getSelectedNode();
        }

        public URL getSelectedURL() {
            URLNode node = this.getSelectedNode();
            return node != null ? node.getURL() : null;
        }

        public Object[] getSelectedValues() {
            return this._fileTable.getSelectedValues();
        }

        public void resetSelection() {
            this._fileTable.resetSelection();
        }

        public void setDetailsView(boolean detailsView) {
            this._fileTable.setDetailsView(detailsView);
            this.updateColumnHeader();
        }

        public boolean isDetailsView() {
            return this._fileTable.isDetailsView();
        }

        public void setKeyboardEnabled(boolean enabled) {
            if (enabled) {
                this._fileTable.removeKeyListener(this);
            } else {
                this._fileTable.addKeyListener(this);
            }
        }

        public void setSelectionMode(int selectionMode) {
            this._fileTable.setSelectionMode(selectionMode);
        }

        public void setSelectionModel(ListSelectionModel model) {
            if (model != null) {
                DefaultListSelectionModel newModel = new DefaultListSelectionModel();
                newModel.setSelectionMode(model.getSelectionMode());
                newModel.setAnchorSelectionIndex(model.getAnchorSelectionIndex());
                newModel.setLeadSelectionIndex(model.getLeadSelectionIndex());
                this._fileTable.setSelectionModel(newModel);
            }
        }

        public void updateList(URLNode node, URLFilter filter) {
            this._fileTable.updateList(node, filter);
        }

        public void clearList(boolean forceRepaint) {
            this._fileTable.clearList();
            if (forceRepaint) {
                this.paint(this.getGraphics());
            }
        }

        public void updateSelectedFile(String filename) {
            this._fileTable.updateSelectedFile(filename);
        }

        public void addViewMouseListener(MouseListener l) {
            this._fileTable.addMouseListener(l);
        }

        public void removeViewMouseListener(MouseListener l) {
            this._fileTable.removeMouseListener(l);
        }

        public void addViewListSelectionListener(ListSelectionListener l) {
            this._fileTable.getSelectionModel().addListSelectionListener(l);
        }

        public void removeViewListSelectionListener(ListSelectionListener l) {
            this._fileTable.getSelectionModel().removeListSelectionListener(l);
        }

        public void keyPressed(KeyEvent e) {
            Toolkit.getDefaultToolkit().beep();
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        protected void updateColumnHeader() {
            this._fileTable.getTableHeader().setVisible(this.isDetailsView());
            this._fileScrollPane.setColumnHeaderView(this.isDetailsView() ? this._fileTable.getTableHeader() : null);
        }

        static JScrollPane ra$_fileScrollPane(FileView fileView) {
            return fileView._fileScrollPane;
        }

        private class FileTable
        extends NiceTable
        implements FocusListener {
            private final FileTableModel _model;
            private final KeyNavigationManager _knm;
            private TableColumn[] columns;
            private boolean columnsSized;

            private void $init$() {
                this._model = new FileTableModel();
                this._knm = new KeyNavigationManager();
            }

            public FileTable() {
                super(null);
                this.$init$();
                this.setFocusTraversalKeys(0, null);
                this.setFocusTraversalKeys(1, null);
                this._knm.setKeyComponentAdapter(new KeyNavigationManager.TableKeyAdapter((JTable)((Object)this)));
                this.addFocusListener(this);
                this.setModel(this._model);
                this.setSorted(true);
                this.setDefaultRenderer(URLNode.class, (TableCellRenderer)((Object)new URLNodeCellRenderer(null)));
                this.setDefaultRenderer(FileSize.class, (TableCellRenderer)((Object)new NoSelectionCellRenderer(null)));
                this.setDefaultRenderer(FileDate.class, (TableCellRenderer)((Object)new NoSelectionCellRenderer(null)));
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableDescendDirectoryAction(null), "table-descend-into-child", URLChooser.ra$TABLE_DESCEND_KEYSTROKE());
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableAscendDirectoryAction(null), "table-ascend-to-parent", URLChooser.ra$TABLE_ASCEND_KEYSTROKE());
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableSelectCurrentAction(null), "table-select-current", URLChooser.ra$TABLE_SELECT_CURRENT_KEYSTROKES());
                URLChooser.maS$addKeyboardAction((JComponent)((Object)this), (Action)new TableToggleSelectAction(null), "table-toggle-selection", URLChooser.ra$TABLE_TOGGLE_SELECT_KEYSTROKE());
            }

            public void setDetailsView(boolean detailsView) {
                this._model.setDetailsView(detailsView);
                this.setAutoResizeMode(detailsView ? 0 : 2);
                if (!detailsView) {
                    this.removeDetailColumns();
                } else {
                    this.addDetailColumns();
                }
            }

            public boolean isDetailsView() {
                return this._model.isDetailsView();
            }

            public void updateSelectedFile(String filename) {
                int row = this._model.findNode(filename);
                if (row >= 0) {
                    this.selectRow(row);
                } else {
                    this.resetSelection();
                }
            }

            public void resetSelection() {
                if (this.getModel().getRowCount() > 0) {
                    this.selectRow(0);
                    this.removeRowSelectionInterval(0, 0);
                }
            }

            public void clearList() {
                this._model.setData(new URLNode[0]);
            }

            public void updateList(URLNode node, URLFilter filter) {
                if (node == null) {
                    this.clearList();
                } else {
                    int dirMode = !URLChooser.ra$_forceUseList(URLChooser.this) && URLChooser.ra$_selectionScope(URLChooser.this) == 1 ? 0 : (URLChooser.ra$_selectionScope(URLChooser.this) == 1 ? 3 : 2);
                    Vector files = node.getFiles(filter, dirMode);
                    URLNode[] children = files.toArray(new URLNode[files.size()]);
                    this._model.setData(children);
                }
            }

            public Object[] getSelectedValues() {
                int[] rows = this.getSelectedRows();
                Object[] ret = new Object[rows.length];
                int i = 0;
                while (i < rows.length) {
                    ret[i] = this.getModel().getValueAt(rows[i], 0);
                    ++i;
                }
                return ret;
            }

            public URLNode getSelectedNode() {
                int row = this.getSelectedRow();
                return row >= 0 ? (URLNode)this.getModel().getValueAt(row, 0) : null;
            }

            public URLNode getNodeAt(Point p) {
                int col = this.columnAtPoint(p);
                if (col != this.convertColumnIndexToView(0)) {
                    return null;
                }
                int row = this.rowAtPoint(p);
                return col >= 0 && row >= 0 ? (URLNode)this.getModel().getValueAt(row, 0) : null;
            }

            public void focusGained(FocusEvent e) {
                if (this.isDetailsView()) {
                    ListSelectionModel columnSelectionModel = this.getColumnModel().getSelectionModel();
                    int anchorColumn = columnSelectionModel.getAnchorSelectionIndex();
                    int leadColumn = columnSelectionModel.getLeadSelectionIndex();
                    int urlnodeColumn = this.convertColumnIndexToView(0);
                    if (leadColumn != -1 && leadColumn != urlnodeColumn || anchorColumn != -1 && anchorColumn != urlnodeColumn) {
                        this.changeSelection(this.getSelectionModel().getAnchorSelectionIndex(), urlnodeColumn, false, false);
                    }
                }
                this.repaintSelectedRows();
            }

            public void focusLost(FocusEvent e) {
                this.repaintSelectedRows();
            }

            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                if (column == -1 || column == this.convertColumnIndexToView(0)) {
                    super.changeSelection(row, column, toggle, extend);
                }
            }

            public void doLayout() {
                if (!this.columnsSized && this.isDetailsView()) {
                    this.initColumnSizes();
                    this.columnsSized = true;
                }
                super.doLayout();
            }

            public boolean isManagingFocus() {
                return false;
            }

            protected void processKeyEvent(KeyEvent e) {
                if (this._knm != null) {
                    this._knm.preProcessKeyEvent(e);
                }
                super.processKeyEvent(e);
                if (this._knm != null) {
                    this._knm.postProcessKeyEvent(e);
                }
            }

            protected void configureEnclosingScrollPane() {
                super.configureEnclosingScrollPane();
                FileView.this.updateColumnHeader();
            }

            private void repaintSelectedRows() {
                this.repaint();
            }

            private void selectRow(int row) {
                this.changeSelection(row, -1, false, false);
            }

            private void removeDetailColumns() {
                if (this.columns == null) {
                    TableColumnModel columnModel = this.getColumnModel();
                    int columnCount = columnModel.getColumnCount();
                    this.columns = new TableColumn[columnCount];
                    int urlNodeIndex = this.convertColumnIndexToView(0);
                    int i = columnCount;
                    while (--i >= 0) {
                        if (i != urlNodeIndex) {
                            TableColumn column;
                            this.columns[i] = column = columnModel.getColumn(i);
                            columnModel.removeColumn(column);
                            continue;
                        }
                        this.columns[i] = null;
                    }
                }
            }

            private void addDetailColumns() {
                if (this.columns != null) {
                    TableColumnModel columnModel = this.getColumnModel();
                    TableColumn urlNodeColumn = columnModel.getColumn(0);
                    int i = 0;
                    while (i < this.columns.length) {
                        TableColumn column = this.columns[i];
                        if (column != null) {
                            columnModel.addColumn(column);
                        } else {
                            columnModel.removeColumn(urlNodeColumn);
                            columnModel.addColumn(urlNodeColumn);
                        }
                        ++i;
                    }
                    this.columns = null;
                }
            }

            private void initColumnSizes() {
                TableColumnModel columnModel = this.getColumnModel();
                int nrows = this.getRowCount();
                int ncols = columnModel.getColumnCount();
                int totalwidth = 0;
                int col = 0;
                while (col < ncols) {
                    TableColumn column = columnModel.getColumn(col);
                    Component comp = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)this), column.getHeaderValue(), false, false, -1, col);
                    int width = comp.getPreferredSize().width;
                    Class columnClass = this.getColumnClass(col);
                    int row = 0;
                    while (row < nrows) {
                        comp = this.getDefaultRenderer(columnClass).getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(row, col), false, false, row, col);
                        width = Math.max(width, comp.getPreferredSize().width);
                        ++row;
                    }
                    column.setPreferredWidth(width);
                    totalwidth += width;
                    ++col;
                }
                int width = FileView.ra$_fileScrollPane(FileView.this).getViewport().getWidth();
                this.setSize(width, this.getHeight());
                if (width > totalwidth) {
                    int extrawidth = width - totalwidth;
                    TableColumn column = columnModel.getColumn(0);
                    int columnWidth = column.getPreferredWidth();
                    int extra = extrawidth * 6 / 10;
                    extrawidth -= extra;
                    column.setPreferredWidth(columnWidth + extra);
                    column = columnModel.getColumn(1);
                    columnWidth = column.getPreferredWidth();
                    extra = extrawidth / 2;
                    extrawidth -= extra;
                    column.setPreferredWidth(columnWidth + extra);
                    column = columnModel.getColumn(2);
                    columnWidth = column.getPreferredWidth();
                    extra = extrawidth;
                    extrawidth -= extra;
                    column.setPreferredWidth(columnWidth + extra);
                }
                this.resizeAndRepaint();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private final class FileSize
            implements Comparable {
                private final URLNode node;

                public FileSize(URLNode node) {
                    this.node = node;
                }

                public String toString() {
                    if (!this.isLeaf()) {
                        return "";
                    }
                    return NetArb.format((int)17, (Object)URLChooser.ra$NUMBER_FORMATTER().format(this.getKbSize()));
                }

                public int compareTo(Object o) {
                    long otherSize;
                    FileSize other = (FileSize)o;
                    if (this.isLeaf() != other.isLeaf()) {
                        return this.isLeaf() ? 1 : -1;
                    }
                    long size = this.getSize();
                    if (size != (otherSize = other.getSize())) {
                        return size > otherSize ? 1 : -1;
                    }
                    return this.node.compareTo(other.node);
                }

                boolean isLeaf() {
                    return this.node.isLeaf();
                }

                long getSize() {
                    return this.isLeaf() ? this.node.length() : 0L;
                }

                long getKbSize() {
                    long size = this.getSize();
                    if (size <= 0L) {
                        return 0L;
                    }
                    long kb = (size + 512L) / 1024L;
                    return kb > 0L ? kb : 1L;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private final class FileDate
            implements Comparable {
                private final URLNode node;

                public FileDate(URLNode node) {
                    this.node = node;
                }

                public String toString() {
                    return URLChooser.ra$DATE_FORMATTER().format(this.getDate());
                }

                public int compareTo(Object o) {
                    long otherDate;
                    FileDate other = (FileDate)o;
                    if (this.isLeaf() != other.isLeaf()) {
                        return this.isLeaf() ? 1 : -1;
                    }
                    long date = this.lastModified();
                    if (date != (otherDate = other.lastModified())) {
                        return date > otherDate ? 1 : -1;
                    }
                    return this.node.compareTo(other.node);
                }

                boolean isLeaf() {
                    return this.node.isLeaf();
                }

                long lastModified() {
                    return this.node.lastModified();
                }

                Date getDate() {
                    return new Date(this.lastModified());
                }
            }

            private final class FileTableModel
            extends AbstractTableModel
            implements NiceTableModel {
                private static final int URLNODE_COLUMN = 0;
                private static final int SIZE_COLUMN = 1;
                private static final int DATE_MODIFIED_COLUMN = 2;
                private URLNode[] _data;
                private boolean _detailsView;

                public void setDetailsView(boolean detailsView) {
                    this._detailsView = detailsView;
                }

                public boolean isDetailsView() {
                    return this._detailsView;
                }

                public void setData(URLNode[] data) {
                    Assert.precondition((data != null ? 1 : 0) != 0);
                    this._data = data;
                    this.fireTableDataChanged();
                }

                public int findNode(String filename) {
                    if (filename != null && filename.length() != 0 && this._data != null) {
                        int i = 0;
                        while (i < this._data.length) {
                            URLNode node = this._data[i];
                            if (URLChooser.maS$compare(node.toString(), filename) == 0) {
                                return i;
                            }
                            ++i;
                        }
                    }
                    return -1;
                }

                public int getColumnAlignment(int col) {
                    switch (col) {
                        case 1: {
                            return 4;
                        }
                    }
                    return 2;
                }

                public Comparator getColumnSortComparator(int col) {
                    return null;
                }

                public int getColumnCount() {
                    return URLChooser.ra$FILE_TABLE_COLUMN_NAMES().length;
                }

                public String getColumnName(int col) {
                    return URLChooser.ra$FILE_TABLE_COLUMN_NAMES()[col];
                }

                public int getRowCount() {
                    return this._data != null ? this._data.length : 0;
                }

                public Object getValueAt(int row, int col) {
                    if (this._data == null || row < 0 || row >= this._data.length) {
                        return null;
                    }
                    URLNode node = this._data[row];
                    switch (col) {
                        case 0: {
                            return node;
                        }
                        case 1: {
                            return new FileSize(node);
                        }
                        case 2: {
                            return new FileDate(node);
                        }
                    }
                    return null;
                }

                public Class getColumnClass(int col) {
                    switch (col) {
                        case 0: {
                            return URLNode.class;
                        }
                        case 1: {
                            return FileSize.class;
                        }
                        case 2: {
                            return FileDate.class;
                        }
                    }
                    return null;
                }
            }

            private final class URLNodeCellRenderer
            extends NiceTableCellRenderer {
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (isSelected && this.isActiveColumn(table, column)) {
                        if (table.hasFocus()) {
                            this.setBackground(table.getSelectionBackground());
                            this.setForeground(table.getSelectionForeground());
                        } else {
                            this.setBackground(URLChooser.ra$INACTIVE_BACKGROUND_SELECTION_COLOR());
                            this.setForeground(URLChooser.ra$INACTIVE_TEXT_SELECTION_COLOR());
                        }
                    }
                    URLChooser.maS$setLabelIcon((JLabel)((Object)this), value, true);
                    URLChooser.maS$setLabelFont((JLabel)((Object)this), value, table.getFont());
                    this.setEnabled(table.isEnabled());
                    this.setValue(value);
                    return this;
                }

                private boolean isActiveColumn(JTable table, int column) {
                    return column == table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                }

                private URLNodeCellRenderer() {
                }

                URLNodeCellRenderer(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private final class NoSelectionCellRenderer
            extends NiceTableCellRenderer {
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
                }

                private NoSelectionCellRenderer() {
                }

                NoSelectionCellRenderer(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private class TableDescendDirectoryAction
            extends AbstractAction {
                public static final String KEY = "table-descend-into-child";

                public boolean isEnabled() {
                    if (!FileTable.this.isEnabled()) {
                        return false;
                    }
                    URL fileURL = FileView.this.getSelectedURL();
                    return fileURL != null && URLFileSystem.isDirectoryPath((URL)fileURL);
                }

                public void actionPerformed(ActionEvent e) {
                    URLChooser.this.setSelectedURL(FileView.this.getSelectedURL());
                }

                private TableDescendDirectoryAction() {
                }

                TableDescendDirectoryAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private class TableAscendDirectoryAction
            extends AbstractAction {
                public static final String KEY = "table-ascend-to-parent";

                public boolean isEnabled() {
                    return FileTable.this.isEnabled();
                }

                public void actionPerformed(ActionEvent e) {
                    URLChooser.mav$runNow(URLChooser.this, 1);
                }

                private TableAscendDirectoryAction() {
                }

                TableAscendDirectoryAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private final class TableSelectCurrentAction
            extends TableSelectAction {
                public static final String KEY = "table-select-current";

                protected int getDelta() {
                    return 0;
                }

                private TableSelectCurrentAction() {
                    super(null);
                }

                TableSelectCurrentAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private final class TableToggleSelectAction
            extends TableSelectAction {
                public static final String KEY = "table-toggle-selection";

                protected int getDelta() {
                    return 0;
                }

                public void actionPerformed(ActionEvent e) {
                    JTable table = (JTable)e.getSource();
                    if (table.getSelectionModel().isSelectionEmpty()) {
                        super.actionPerformed(e);
                    } else {
                        FileTable.this.clearSelection();
                    }
                }

                private TableToggleSelectAction() {
                    super(null);
                }

                TableToggleSelectAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }

            private abstract class TableSelectAction
            extends AbstractAction {
                protected abstract int getDelta();

                public boolean isEnabled() {
                    return FileTable.this.isEnabled();
                }

                public void actionPerformed(ActionEvent e) {
                    JTable table = (JTable)e.getSource();
                    int index = this.getIndexForSelection(table);
                    if (index >= 0 && index < table.getModel().getRowCount()) {
                        table.changeSelection(index, -1, false, false);
                    }
                }

                protected int getIndexForSelection(JTable table) {
                    int size = table.getModel().getRowCount();
                    int delta = this.getDelta();
                    int index = table.getSelectionModel().getAnchorSelectionIndex();
                    if (index == -1) {
                        if (size > 0) {
                            index = delta >= 0 ? 0 : size - 1;
                        }
                    } else if ((index += delta) < 0) {
                        index = 0;
                    } else if (index >= size) {
                        index = size - 1;
                    }
                    return index;
                }

                private TableSelectAction() {
                }

                TableSelectAction(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }
        }
    }

    private static class TCR
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            URLChooser.maS$setLabelIcon(label, value, false);
            this.setEnabled(tree.isEnabled());
            return label;
        }

        private TCR() {
        }

        TCR(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class LCR1
    extends DefaultListCellRenderer {
        private static final Border _defaultBorder = BorderFactory.createEmptyBorder(0, 2, 0, 0);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int indent;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof URLNode) {
                URL url;
                URLNode node = (URLNode)value;
                TreeNode[] nodePath = node.getPath();
                indent = Math.max(nodePath.length - 2, 0);
                if (index < 0 && (url = node.getURL()) != null) {
                    label.setText(URLFileSystem.getPlatformPathName((URL)url));
                }
            } else {
                indent = 0;
            }
            label.setBorder(index > 0 ? BorderFactory.createEmptyBorder(0, indent * 10 + 2, 0, 0) : _defaultBorder);
            URLChooser.maS$setLabelIcon(label, value, false);
            this.setEnabled(list.isEnabled());
            return label;
        }

        private LCR1() {
        }

        LCR1(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

