/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ModelUtil;

public class URLTextField
extends FileField
implements ActionListener {
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    private final Comparator _comparator;
    private boolean _isDir;
    private boolean _showJarsAsDirs;
    private String _lastSetText;
    private URL _url;
    private URL _baseURL;
    private String _title;
    private String _helpCtx;
    private List _filterList;
    private URLChooserInit _chooserInit;
    private URLFilter _filter;
    private boolean _clearAllFilters;
    private URL _defaultChooserURL;
    private int _dialogType;

    private void $init$() {
        this._clearAllFilters = false;
        this._dialogType = 0;
    }

    public URLTextField() {
        this(null);
    }

    public URLTextField(URL url) {
        this(url, true, true);
    }

    public URLTextField(URL url, boolean isDir) {
        this(url, isDir, true);
    }

    public URLTextField(URL url, boolean isDir, boolean showJarsAsDirs) {
        this.$init$();
        this._comparator = URLFileSystem.isLocalFileSystemCaseSensitive() ? null : String.CASE_INSENSITIVE_ORDER;
        this.setURL(url);
        this.setDirectoryOnly(isDir);
        this._showJarsAsDirs = showJarsAsDirs;
    }

    public static URLTextField newForSavingFile() {
        return new URLTextField(null, false, false);
    }

    public URL getURL() {
        String curText = this.getText().trim();
        if (!ModelUtil.hasLength((String)curText)) {
            return this._baseURL;
        }
        if (this.compare(curText, this._lastSetText) == 0) {
            return this._url;
        }
        URL url = URLFactory.newURL((String)curText, (boolean)this._isDir, (boolean)false);
        if (url != null) {
            return URLFileSystem.canonicalize((URL)url);
        }
        if (this._baseURL == null) {
            return null;
        }
        URL resolvedURL = this._isDir ? URLFactory.newDirURL((URL)this._baseURL, (String)curText) : URLFactory.newURL((URL)this._baseURL, (String)curText);
        return URLFileSystem.canonicalize((URL)resolvedURL);
    }

    public void setURL(URL url) {
        this._url = url;
        if (this._url == null) {
            this._lastSetText = "";
            this.setText("");
        } else if (this._baseURL == null) {
            this._lastSetText = URLFileSystem.getPlatformPathName((URL)url);
            this.setText(this._lastSetText);
        } else {
            String relSpec = URLFileSystem.toRelativeSpec((URL)url, (URL)this._baseURL, (boolean)true);
            if (relSpec != null) {
                this._lastSetText = relSpec.endsWith("/") ? relSpec.substring(0, relSpec.length() - 1) : relSpec;
                this.setText(this._lastSetText);
            } else {
                this._lastSetText = URLFileSystem.getPlatformPathName((URL)url);
                this.setText(this._lastSetText);
            }
        }
    }

    public boolean isDirectoryOnly() {
        return this._isDir;
    }

    public void setDirectoryOnly(boolean isDir) {
        this._isDir = isDir;
        this.setOnlyDirectories(isDir);
    }

    public void setClearAllFilters(boolean clearFilters) {
        this._clearAllFilters = clearFilters;
    }

    public void setDefaultChooserURL(URL url) {
        this._defaultChooserURL = url;
    }

    public void addChooseableURLFilter(URLFilter filter) {
        if (this._filterList == null) {
            this._filterList = new ArrayList();
        }
        this._filterList.add(filter);
    }

    public void clearChooseableURLFilters() {
        this._clearAllFilters = true;
        if (this._filterList != null) {
            this._filterList.clear();
            this._filterList = null;
        }
    }

    public URLFilter getFilter() {
        return this._filter;
    }

    public void setFilter(URLFilter filter) {
        this._filter = filter;
    }

    public void setDialogType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("type not OPEN_DIALOG or SAVE_DIALOG");
        }
        this._dialogType = type;
    }

    public int getDialogType() {
        return this._dialogType;
    }

    public URLChooserInit getChooserInit() {
        return this._chooserInit;
    }

    public void setChooserInit(URLChooserInit chooserInit) {
        this._chooserInit = chooserInit;
    }

    public void setBaseURL(URL baseURL) {
        this._baseURL = baseURL;
    }

    public void setDialogTitle(String title) {
        this._title = title;
    }

    public void setDialogHelpContext(String helpContext) {
        this._helpCtx = helpContext;
    }

    public void actionPerformed(ActionEvent e) {
        this.browseForURL();
    }

    public boolean browseForURL() {
        boolean result = false;
        URL url = this.getURL() != null ? this.getURL() : this._defaultChooserURL;
        URLChooser urlChooser = this.createChooser(url);
        int response = this._dialogType == 0 ? urlChooser.showOpenDialog((Component)((Object)this), this._title) : urlChooser.showSaveDialog((Component)((Object)this), this._title);
        if (response == 0) {
            this.setURL(urlChooser.getSelectedURL());
            result = true;
        }
        return result;
    }

    protected URLChooser createChooser(URL url) {
        URLChooser urlChooser = DialogUtil.newURLChooser(url);
        if (this._chooserInit != null) {
            this._chooserInit.initURLChooser(urlChooser);
        }
        if (this._baseURL != null) {
            urlChooser.setRoots(new URL[]{this._baseURL});
        }
        if (this._helpCtx != null) {
            urlChooser.setHelpID(this._helpCtx);
        }
        urlChooser.setShowJarsAsDirs(this._showJarsAsDirs);
        urlChooser.setSelectionMode(0);
        urlChooser.setSelectionScope(this._isDir ? 1 : 0);
        if (this._clearAllFilters) {
            urlChooser.clearChooseableURLFilters();
        }
        if (this._filterList != null) {
            for (URLFilter filter : this._filterList) {
                urlChooser.addChooseableURLFilter(filter);
            }
        }
        if (this._filter != null) {
            urlChooser.setURLFilter(this._filter);
        }
        return urlChooser;
    }

    private int compare(String s1, String s2) {
        if (this._comparator != null) {
            return this._comparator.compare(s1, s2);
        }
        return s1.compareTo(s2);
    }
}

