/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ResourceUtils;

public class NewWorkspacePanel
extends DefaultTraversablePanel
implements VetoableChangeListener {
    private static final String HELP_TOPIC = "f1_idednewworkspace_html";
    private NewFilePanel _filePanel;
    private JCheckBox _addProjectCheckBox;
    private JCheckBox _openNavigatorCheckBox;
    private JEWTDialog _dlg;

    private void $init$() {
        this._filePanel = new NewFilePanel();
    }

    public NewWorkspacePanel(boolean showAddProject, boolean showOpenNavigator, boolean defaultWorkspaceFiles) {
        this.$init$();
        this.setLayout(new GridBagLayout());
        this.setFilePrompt(ComponentArb.getString(25));
        this._filePanel.setFileExtension(".jws");
        this._filePanel.setFileType(IdeArb.getString(27));
        this._filePanel.setShowExtension(false);
        if (defaultWorkspaceFiles) {
            URL wspDirURL = NewWorkspacePanel.getDefaultWorkspaceDirURL();
            String wspFileName = NewWorkspacePanel.getDefaultWorkspaceFileName(wspDirURL);
            this._filePanel.setDirectoryURL(wspDirURL);
            this._filePanel.setFileName(wspFileName);
        }
        this.add(this._filePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (showAddProject) {
            this._addProjectCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._addProjectCheckBox, (String)IdeArb.getString(53));
            this._addProjectCheckBox.setSelected(true);
            this.add(this._addProjectCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        }
        if (showOpenNavigator) {
            this._openNavigatorCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._openNavigatorCheckBox, (String)IdeArb.getString(2));
            this._openNavigatorCheckBox.setSelected(false);
            this.add(this._openNavigatorCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    public static URL getDefaultWorkspaceDirURL() {
        URL wspDirURL;
        URL workDirURL;
        Workspaces workspaces = Ide.getWorkspaces();
        URL uRL = workDirURL = workspaces != null ? workspaces.getWorkDirectory() : null;
        if (workDirURL == null) {
            String dir = Ide.getWorkDirectory();
            workDirURL = URLFactory.newDirURL((String)dir);
        }
        String wspName = ModelArb.getString(44);
        int ctr = 1;
        while (URLFileSystem.exists((URL)(wspDirURL = URLFactory.newURL((URL)workDirURL, (String)(wspName + Integer.toString(ctr++)))))) {
        }
        return wspDirURL;
    }

    public static String getDefaultWorkspaceFileName(URL workspaceDirURL) {
        return URLFileSystem.getName((URL)workspaceDirURL) + ".jws";
    }

    public void defaultWorkspaceDirToURL(URL workspaceDirURL) {
        URL wspDirURL;
        if (workspaceDirURL == null) {
            String dir = Ide.getWorkDirectory();
            workspaceDirURL = URLFactory.newDirURL((String)dir);
        }
        String wspName = ModelArb.getString(44);
        int ctr = 1;
        while (URLFileSystem.exists((URL)(wspDirURL = URLFactory.newURL((URL)workspaceDirURL, (String)(wspName + Integer.toString(ctr++)))))) {
        }
        String wspFileName = NewWorkspacePanel.getDefaultWorkspaceFileName(wspDirURL);
        this._filePanel.setDirectoryURL(wspDirURL);
        this._filePanel.setFileName(wspFileName);
    }

    public void setDirectoryURL(URL directoryURL) {
        this._filePanel.setDirectoryURL(directoryURL);
    }

    public void setFileName(String fileName) {
        this._filePanel.setFileName(fileName);
    }

    public void setSupportsAutoFill(boolean supportsAutoFill) {
        this._filePanel.setSupportsAutoFill(supportsAutoFill);
    }

    public boolean runDialog() {
        return this.runDialog(IdeArb.getString(71));
    }

    public boolean runDialog(String title) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), HELP_TOPIC);
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)this), this._filePanel.getDefaultFocusComponent(), title);
        this._dlg.setDefaultButton(1);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        return WizardLauncher.runDialog((JDialog)this._dlg);
    }

    public boolean validatePanel() {
        URL url = null;
        try {
            url = this._filePanel.getFileURL();
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
        }
        return url != null;
    }

    public boolean isAddProject() {
        return this._addProjectCheckBox.isSelected();
    }

    public void setAddProject(boolean addProject) {
        this._addProjectCheckBox.setSelected(addProject);
    }

    public boolean isOpenNavigator() {
        return this._openNavigatorCheckBox.isSelected();
    }

    public void setOpenNavigator(boolean openNavigator) {
        this._openNavigatorCheckBox.setSelected(openNavigator);
    }

    public URL getFileURL() {
        try {
            URL uRL = this._filePanel.getFileURL();
            return uRL;
        }
        catch (TraversalException ex) {
            URL uRL = null;
            return uRL;
        }
    }

    public void setDirectoryPrompt(String directoryPrompt) {
        this._filePanel.setDirectoryPrompt(directoryPrompt);
    }

    public void setFilePrompt(String filePrompt) {
        this._filePanel.setFilePrompt(filePrompt);
    }

    public NewFilePanel getNewFilePanel() {
        return this._filePanel;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !this.validatePanel()) {
            throw new PropertyVetoException("no", evt);
        }
    }
}

