/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import oracle.ide.persistence.Page;
import oracle.ide.persistence.PersistenceLogger;
import oracle.ide.persistence.RefPage;
import oracle.ide.persistence.StorageFile;
import oracle.ide.util.IntHashMap;

final class BPageCache {
    private static final int PAGE_IN_CACHE = 200;
    private static final int MAX_PAGE_IN_CACHE = 500;
    private StorageFile _store;
    private IntHashMap _cache;
    private RefPage _oldestPage;
    private RefPage _newestPage;
    private int _syncLevel;
    private int _nload;
    private int _nsave;
    private int _nacc;
    private int _nhits;
    private int _nfree;
    private int _nnew;
    static int cleanupRover = 0;

    private void $init$() {
        this._syncLevel = 0;
        this._nload = 0;
        this._nsave = 0;
        this._nacc = 0;
        this._nhits = 0;
        this._nfree = 0;
        this._nnew = 0;
    }

    BPageCache(StorageFile store) {
        this.$init$();
        this._store = store;
        this._oldestPage = new RefPage();
        this._oldestPage._next = this._newestPage = new RefPage();
        this._newestPage._prev = this._oldestPage;
        this._cache = new IntHashMap(250);
    }

    void unlinkPage(RefPage pg) {
        if (pg._next != null) {
            pg._next._prev = pg._prev;
            pg._prev._next = pg._next;
        }
    }

    void setNewest(RefPage pg) {
        if (pg == this._newestPage._prev) {
            return;
        }
        this.unlinkPage(pg);
        pg._prev = this._newestPage._prev;
        pg._next = this._newestPage;
        pg._prev._next = pg;
        this._newestPage._prev = pg;
    }

    synchronized Page getPage(int addr, int group) throws IOException {
        RefPage p = (RefPage)this._cache.get(addr);
        ++this._nacc;
        if (p == null) {
            p = new RefPage();
            p._ref = new Page();
            p._group = group;
            this._cache.put(addr, p);
            p._addr = addr;
            InputStream is = this._store.getISFromRec(addr);
            p._ref.loadFromBlob(is);
            ++this._nload;
        } else {
            ++this._nhits;
        }
        this.setNewest(p);
        return p._ref;
    }

    synchronized void freePage(int addr) throws IOException {
        RefPage p = (RefPage)this._cache.get(addr);
        ++this._nfree;
        if (p != null) {
            this.unlinkPage(p);
            this._cache.remove(addr);
        }
        this._store.deleteBlob(addr);
    }

    synchronized int getNewPage(int group) throws IOException {
        int addr = this._store.getFreePage();
        RefPage p = new RefPage();
        ++this._nnew;
        p._ref = new Page();
        p._group = group;
        OutputStream os = this._store.getNewOSFromRec(addr, group);
        p._ref.saveToBlob(os);
        this._cache.put(addr, p);
        p._addr = addr;
        this.setNewest(p);
        return addr;
    }

    synchronized void startTrans() {
        ++this._syncLevel;
    }

    synchronized void endTrans() {
        --this._syncLevel;
        if (this._syncLevel == 0) {
            try {
                this.cleanup();
            }
            catch (IOException ex) {
                PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to clean up cache", ex);
            }
        }
    }

    private void savePage(RefPage p) throws IOException {
        block0: {
            if (!p._ref.isDirty()) break block0;
            OutputStream os = this._store.getOSFromRec(p._addr, p._group);
            p._ref.saveToBlob(os);
            ++this._nsave;
        }
    }

    private void cleanup() throws IOException {
        if (this._cache.size() < 500) {
            return;
        }
        ArrayList<RefPage> al = new ArrayList<RefPage>();
        while (this._cache.size() > 200) {
            RefPage p = this._oldestPage._next;
            this.unlinkPage(p);
            if (p._ref.isDirty()) {
                al.add(p);
            }
            this._cache.remove(p._addr);
        }
        Object[] pg = al.toArray(new RefPage[al.size()]);
        Arrays.sort(pg);
        int i = 0;
        while (i < pg.length) {
            this.savePage((RefPage)pg[i]);
            ++i;
        }
    }

    synchronized void flush(int group) throws IOException {
        RefPage p = this._oldestPage._next;
        ArrayList<RefPage> al = new ArrayList<RefPage>();
        while (p != this._newestPage) {
            if (p._group == group && p._ref.isDirty()) {
                al.add(p);
            }
            p = p._next;
        }
        Object[] pg = al.toArray(new RefPage[al.size()]);
        Arrays.sort(pg);
        int i = 0;
        while (i < pg.length) {
            this.savePage((RefPage)pg[i]);
            ++i;
        }
    }

    synchronized void cleanGroup(int group) {
        RefPage p = this._oldestPage._next;
        int cnt = 0;
        while (p != this._newestPage) {
            if (p._group == group) {
                this.unlinkPage(p);
                ++cnt;
                this._cache.remove(p._addr);
            }
            p = p._next;
        }
    }
}

