/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

final class FreePageMap {
    private static final int BYTES_PER_PAGE = 1023;
    private int _minRindex = 0;
    private byte[][] _mainMap = new byte[0][0];
    private boolean[] _dirty = new boolean[0];

    FreePageMap() {
    }

    private void checkPage(int pgnum) {
        if (pgnum >= this._mainMap.length) {
            byte[][] newmap = new byte[pgnum + 1][0];
            boolean[] newdirty = new boolean[pgnum + 1];
            System.arraycopy(this._mainMap, 0, newmap, 0, this._mainMap.length);
            System.arraycopy(this._dirty, 0, newdirty, 0, this._mainMap.length);
            int i = 0;
            while (i < newmap.length) {
                byte[] bytes = newmap[i];
                if (bytes.length != 1023) {
                    newmap[i] = new byte[1023];
                    newdirty[i] = true;
                }
                ++i;
            }
            this._mainMap = newmap;
            this._dirty = newdirty;
        }
    }

    void setFree(int index) {
        int rindex = index / 8;
        int rrem = index % 8;
        int pgnum = rindex / 1023;
        int prem = rindex % 1023;
        this.checkPage(pgnum);
        byte[] byArray = this._mainMap[pgnum];
        int n = prem;
        byArray[n] = (byte)(byArray[n] | 1 << rrem);
        this._dirty[pgnum] = true;
        if (rindex < this._minRindex) {
            this._minRindex = rindex;
        }
    }

    boolean isFree(int index) {
        int rindex = index / 8;
        int rrem = index % 8;
        int pgnum = rindex / 1023;
        int prem = rindex % 1023;
        this.checkPage(pgnum);
        return (this._mainMap[pgnum][prem] & 1 << rrem) != 0;
    }

    /*
     * Exception decompiling
     */
    int getFreePos() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getDirtyIndex() {
        int i = 0;
        while (i < this._dirty.length) {
            if (this._dirty[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void clearDirty(int index) {
        this._dirty[index] = false;
    }

    byte[] getPageDatas(int index) {
        return this._mainMap[index];
    }

    void setPageDatas(int index, byte[] datas, int offset, int len) {
        this.checkPage(index);
        System.arraycopy(datas, offset, this._mainMap[index], 0, len);
        int nrindex = index * 1023;
        if (nrindex < this._minRindex) {
            this._minRindex = nrindex;
        }
    }
}

