/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import oracle.ide.persistence.CrossIndex;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.UniqueIdFactory;

class Tests {
    static void dumpFile(String s) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(s));
            String line = br.readLine();
            int i = 0;
            while (line != null) {
                System.out.println(i++ + " : " + line);
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void loadTestFile(String s) {
        try {
            NameSpace curns = null;
            BufferedReader br = new BufferedReader(new FileReader(s));
            String line = br.readLine();
            int i = 0;
            byte[] dumm = new byte[1];
            while (line != null) {
                String cname;
                if (line.startsWith("+++")) {
                    int pos = line.lastIndexOf(92);
                    if (pos == -1) {
                        pos = 3;
                    }
                    String nsName = "LIB:" + line.substring(pos + 1);
                    curns = NameSpace.getNameSpace(nsName);
                    System.out.println("NameSpace created for " + nsName);
                } else if (line.startsWith("---")) {
                    System.out.println("NameSpace flushed " + i + " elements");
                    i = 0;
                    curns.flush();
                } else if (line.endsWith(".class") && (cname = line.substring(0, line.length() - 6)).indexOf(36) == -1) {
                    cname = cname.replace('/', '.');
                    int seppos = cname.lastIndexOf(46);
                    String pack = "";
                    String bname = cname;
                    if (seppos != -1) {
                        pack = cname.substring(0, seppos);
                        bname = cname.substring(seppos + 1);
                    }
                    curns.putRecord(pack + "|" + bname, dumm);
                    curns.putRecord("@" + bname + "@" + pack, null);
                    ++i;
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void recAdd(String ident, CrossIndex ci, String s) {
        File f = new File(s);
        String[] childs = f.list();
        if (childs != null) {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < childs.length) {
                if (!childs[i].startsWith(".")) {
                    Tests.recAdd(ident, ci, s + File.separatorChar + childs[i]);
                }
                ++i;
            }
            System.out.println(ident + s + " parsed in " + (System.currentTimeMillis() - start) + " ms");
        } else if (s.endsWith(".java")) {
            ci.parseFile(s);
        }
    }

    static void test2(String nsid, String s) {
        long start = System.currentTimeMillis();
        CrossIndex cid = new CrossIndex("TCI", nsid);
        Tests.recAdd("", cid, s);
        cid.flush();
        System.out.println(" Total time " + (System.currentTimeMillis() - start) + " ms");
    }

    static void recAddDir(String ident, CrossIndex ci, String s) {
        File f = new File(s);
        String[] childs = f.list();
        if (childs != null) {
            long start = System.currentTimeMillis();
            ci.parseDirectory(s);
            ident = ident + "  ";
            int i = 0;
            while (i < childs.length) {
                Tests.recAddDir(ident, ci, s + File.separatorChar + childs[i]);
                ++i;
            }
            System.out.println(ident + s + " parsed in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    static void testDirect(String s) {
        long start = System.currentTimeMillis();
        CrossIndex cid = new CrossIndex("TCI", "TCI");
        Tests.recAddDir("", cid, s);
        cid.flush();
        System.out.println(" Total time " + (System.currentTimeMillis() - start) + " ms");
    }

    static void look(String s, String nsid) {
        CrossIndex cid = new CrossIndex("TCI", nsid);
        cid.printKeyRef(s);
        cid.flush();
    }

    static void test3(String s) {
        System.out.println("Checking UID for " + s);
        UniqueIdFactory UIF = new UniqueIdFactory("testUID", '|');
        try {
            BufferedReader br = new BufferedReader(new FileReader(s));
            String line = br.readLine();
            while (line != null) {
                String uid = UIF.getUID(line);
                System.out.println("[" + line + "] = [" + uid + "]");
                line = br.readLine();
            }
            UIF.flush();
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

