/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.persistence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import oracle.ide.persistence.NameSpace;

class UniqueIdFactory {
    private NameSpace _directNS;
    private NameSpace _reverseNS;
    private int curLastID;
    private char _sep;
    private static final String BASEDIGITS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,.<>?;':[]{}-=_+`~";

    UniqueIdFactory(String nsRootName, char sep) {
        this._sep = sep;
        this._directNS = NameSpace.getNameSpace(nsRootName + "_D");
        this._reverseNS = NameSpace.getNameSpace(nsRootName + "_R");
        try {
            InputStream is = this._directNS.getRecordStream("" + this._sep + this._sep + this._sep);
            if (is != null) {
                DataInputStream dis = new DataInputStream(is);
                this.curLastID = dis.readInt();
            } else {
                System.out.println("LastID not found, cleaning ...");
                NameSpace.deleteNameSpace(nsRootName + "_D");
                NameSpace.deleteNameSpace(nsRootName + "_R");
                this._directNS = NameSpace.getNameSpace(nsRootName + "_D");
                this._reverseNS = NameSpace.getNameSpace(nsRootName + "_R");
                this.curLastID = 1;
                this.updateLastID();
                this.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void flush() {
        System.out.println("Flushing UID system");
        this.updateLastID();
        this._directNS.flush();
        this._reverseNS.flush();
    }

    private void updateLastID() {
        try {
            System.out.println("Saving lastID " + this.curLastID);
            DataOutputStream dos = new DataOutputStream(this._directNS.putRecordStream("" + this._sep + this._sep + this._sep));
            dos.writeInt(this.curLastID);
            dos.flush();
            dos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getNewUID() {
        int numb = this.curLastID++;
        StringBuffer sb = new StringBuffer(15);
        int len = BASEDIGITS.length();
        while (numb != 0) {
            sb.append(BASEDIGITS.charAt(numb % len));
            numb /= len;
        }
        return sb.toString();
    }

    String getUID(String s) {
        String res;
        Iterator<String> it = this._directNS.getKeyIterator(s + this._sep);
        if (it.hasNext()) {
            res = it.next();
            res = res.substring(res.lastIndexOf(this._sep) + 1);
        } else {
            res = this.getNewUID();
            this._directNS.putRecord(s + this._sep + res, null);
            this._reverseNS.putRecord(res + this._sep + s, null);
        }
        return res;
    }

    String keyFromUID(String s) {
        String res;
        Iterator<String> it = this._reverseNS.getKeyIterator(s + this._sep);
        if (it.hasNext()) {
            res = it.next();
            res = res.substring(res.lastIndexOf(this._sep) + 1);
        } else {
            res = null;
        }
        return res;
    }
}

