/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import oracle.ide.util.FastStringBuffer;
import sun.security.action.GetPropertyAction;

public class FastStringWriter
extends PrintWriter {
    private FastStringBuffer buf;
    private String lineSeparator;

    public FastStringWriter() {
        super(System.out, true);
        this.out = this;
        this.buf = new FastStringBuffer();
        this.lock = null;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public FastStringWriter(int initialSize) {
        super(System.out, true);
        this.out = this;
        this.buf = new FastStringBuffer(initialSize);
        this.lock = null;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public void write(int c) {
        this.buf.append((char)c);
    }

    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    public void write(String str) {
        this.buf.append(str);
    }

    public void write(String str, int off, int len) {
        this.buf.append(str.substring(off, off + len));
    }

    public String toString() {
        return this.buf.toString();
    }

    public FastStringBuffer getBuffer() {
        return this.buf;
    }

    public void flush() {
    }

    public void close() {
    }

    private void newLine() throws IOException {
        this.out.write(this.lineSeparator);
        this.out.flush();
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        try {
            this.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    public void println(char x) {
        this.print(x);
        this.println();
    }

    public void println(int x) {
        this.print(x);
        this.println();
    }

    public void println(long x) {
        this.print(x);
        this.println();
    }

    public void println(float x) {
        this.print(x);
        this.println();
    }

    public void println(double x) {
        this.print(x);
        this.println();
    }

    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    public void println(String x) {
        this.print(x);
        this.println();
    }

    public void println(Object x) {
        this.print(x);
        this.println();
    }
}

