/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.ide.util.Assert;

public class FilePath {
    public static final int LOADING = 1;
    public static final int SAVING = 2;

    public static final boolean isAbsolute(String filename) {
        return new File(filename).isAbsolute();
    }

    public static final String makeQualified(String root, String relative) {
        String result = null;
        if (root == null || relative == null || root.length() == 0 || relative.length() == 0) {
            result = "";
        } else {
            File relFile;
            String oldRelative = null;
            if (relative.startsWith("[") && relative.indexOf("]") > 0) {
                oldRelative = relative;
                relative = relative.substring(1, relative.indexOf("]"));
            }
            if ((relFile = new File(relative)).isAbsolute()) {
                try {
                    relative = relFile.getCanonicalPath();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                result = relative;
            }
            if (result == null) {
                if (!root.endsWith(File.separator)) {
                    root = root + File.separator;
                }
                try {
                    result = new File(root + relative).getCanonicalPath();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    result = root + relative;
                }
            }
            if (oldRelative != null) {
                result = "[" + result + oldRelative.substring(oldRelative.indexOf("]"));
            }
        }
        return result;
    }

    public static final String makeRelative(String root, String path) {
        return FilePath.makeRelative(root, path, false);
    }

    public static final String makeRelative(String root, String path, boolean childrenOnly) {
        if (root == null || path == null || root.length() == 0 || path.length() == 0) {
            return "";
        }
        String result = path;
        String oldResult = null;
        if (result.startsWith("[") && result.indexOf("]") > 0) {
            oldResult = result;
            result = result.substring(1, result.indexOf("]"));
        }
        if (!FilePath.isAbsolute(result)) {
            return path;
        }
        try {
            root = new File(root.trim()).getCanonicalPath();
            result = new File(result.trim()).getCanonicalPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (root.equals(result)) {
            result = "." + File.separator;
        } else if (!childrenOnly || result.startsWith(root)) {
            int len = result.length();
            if (len == 0) {
                result = "";
            } else {
                String startPath;
                if (!root.endsWith(File.separator)) {
                    root = root + File.separator;
                }
                if (root.equals(startPath = result.substring(0, len = Math.min(result.length(), root.length())))) {
                    result = result.substring(root.length(), result.length());
                } else {
                    String dotdot = "";
                    String tempRoot = root;
                    while (tempRoot.length() > 2) {
                        len = Math.min(result.length(), tempRoot.length());
                        if (tempRoot.equals(result.substring(0, len))) {
                            StringBuffer buf = new StringBuffer(result.substring(tempRoot.length()));
                            if (buf.charAt(0) != File.separatorChar) {
                                buf.insert(0, File.separator);
                            }
                            buf.insert(0, dotdot);
                            result = buf.toString();
                            break;
                        }
                        if (tempRoot.endsWith(File.separator)) {
                            tempRoot = tempRoot.substring(0, tempRoot.length() - 1);
                        }
                        if ((tempRoot = FilePath.getParent(tempRoot)) == null) break;
                        dotdot = dotdot.length() > 0 ? dotdot + File.separator + ".." : dotdot + "..";
                    }
                }
            }
        }
        if (oldResult != null) {
            result = "[" + result + oldResult.substring(oldResult.indexOf("]"));
        }
        return result;
    }

    public static String makePathQualified(String root, String path) {
        Assert.precondition((root != null && path != null ? 1 : 0) != 0);
        String result = null;
        if (path != null) {
            if (path.indexOf(File.pathSeparator) < 0) {
                result = path.length() == 0 ? path : FilePath.makeQualified(root, path);
            } else {
                StringBuffer buf = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
                String elem = null;
                if (tok.hasMoreTokens()) {
                    elem = tok.nextToken();
                    if (elem.length() == 0) {
                        buf.append(elem);
                    } else {
                        buf.append(FilePath.makeQualified(root, elem));
                    }
                    while (tok.hasMoreTokens()) {
                        buf.append(File.pathSeparator);
                        elem = tok.nextToken();
                        if (elem.length() == 0 || FilePath.isAbsolute(elem)) {
                            buf.append(elem);
                            continue;
                        }
                        buf.append(FilePath.makeQualified(root, elem));
                    }
                }
                result = buf.toString();
            }
        }
        return result;
    }

    public static String makePathRelative(String root, String path) {
        return FilePath.makePathRelative(root, path, false);
    }

    public static String makePathRelative(String root, String path, boolean childrenOnly) {
        Assert.precondition((root != null && path != null ? 1 : 0) != 0);
        String result = null;
        if (path != null) {
            if (path.indexOf(File.pathSeparatorChar) < 0) {
                result = FilePath.makeRelative(root, path, childrenOnly);
            } else {
                StringBuffer buf = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
                if (tok.hasMoreTokens()) {
                    buf.append(FilePath.makeRelative(root, tok.nextToken(), childrenOnly));
                    while (tok.hasMoreTokens()) {
                        buf.append(File.pathSeparator);
                        buf.append(FilePath.makeRelative(root, tok.nextToken(), childrenOnly));
                    }
                }
                result = buf.toString();
            }
        }
        return result;
    }

    public static final String getParent(String path) {
        return new File(path).getParent();
    }

    public static final String getFilename(String path) {
        return new File(path).getName();
    }

    public static final String getExtension(String path) {
        String name = FilePath.getFilename(path);
        int i = Math.min(name.lastIndexOf("."), name.length());
        if (i < 0) {
            return "";
        }
        return name.substring(i, name.length());
    }

    public static final String getName(String path) {
        String name = FilePath.getFilename(path);
        int i = Math.min(name.lastIndexOf("."), name.length());
        if (i < 0) {
            return name;
        }
        return name.substring(0, i);
    }

    public static final boolean mayBeADirectory(String fname) {
        File path = new File(fname);
        if (path.isDirectory()) {
            return true;
        }
        if (path.exists()) {
            return false;
        }
        return FilePath.getExtension(path.getAbsolutePath()).length() == 0;
    }

    public static final String convertPath(String path, int direction) {
        if (File.pathSeparatorChar == ';' && File.separatorChar == '\\') {
            return path;
        }
        if (direction == 1) {
            path = path.replace(';', File.pathSeparatorChar);
            path = path.replace('\\', File.separatorChar);
        } else if (direction == 2) {
            path = path.replace(File.pathSeparatorChar, ';');
            path = path.replace(File.separatorChar, '\\');
        } else {
            throw new IllegalArgumentException("direction must be 1 or 2");
        }
        return path;
    }

    public static final String getBasePath(String absolutePath, String relativePath) {
        String newPath = FilePath.makeQualified(absolutePath, relativePath);
        int i = newPath.indexOf(relativePath);
        if (i < 0) {
            return null;
        }
        return newPath.substring(0, i - 1);
    }
}

