/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.ide.util.PropertyAccess;

public class HistoryList {
    private String name;
    private LinkedList items;
    private int maxHistorySize;
    private PropertyAccess properties;
    private static final int defaultMaxHistorySize = 32;
    private static String KEY_SUFFIX_COUNT = "HistoryCount";
    private static String KEY_SUFFIX_ITEM = "HistoryItem";

    public HistoryList(String name) {
        this(name, null);
    }

    public HistoryList(String name, PropertyAccess properties) {
        this.name = name;
        this.items = new LinkedList();
        this.maxHistorySize = 32;
        if (properties != null) {
            this.load(properties);
        }
    }

    public synchronized int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public synchronized void setMaxHistorySize(int maxHistorySize) {
        this.maxHistorySize = maxHistorySize;
        while (this.items.size() > maxHistorySize) {
            this.items.removeLast();
        }
    }

    public synchronized void load(PropertyAccess properties) {
        this.properties = properties;
        try {
            String s = properties.getProperty(this.name + KEY_SUFFIX_COUNT, null);
            int count = Integer.parseInt(s);
            int i = 0;
            while (i < count) {
                s = properties.getProperty(this.name + KEY_SUFFIX_ITEM + i, null);
                if (s != null) {
                    this.items.add(s);
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public synchronized void clear() {
        this.items.clear();
    }

    public synchronized String[] getHistory() {
        return this.items.toArray(new String[this.items.size()]);
    }

    public int getSize() {
        return this.items.size();
    }

    public void fill(String[] itemsToAdd) {
        if (this.items.size() == 0) {
            int length = itemsToAdd.length;
            int i = 0;
            while (i < length) {
                this.items.add(itemsToAdd[i]);
                ++i;
            }
        } else {
            int i = itemsToAdd.length;
            while (i >= 0) {
                this.update(itemsToAdd[i]);
                --i;
            }
        }
    }

    public synchronized void update(String item) {
        int i = this.items.indexOf(item);
        if (i == -1) {
            this.items.add(0, item);
            int size = this.items.size();
            if (size > this.maxHistorySize) {
                this.items.remove(size - 1);
            }
        } else {
            this.items.remove(i);
            this.items.add(0, item);
        }
    }

    public synchronized boolean remove(String item) {
        return this.items.remove(item);
    }

    public synchronized void save() {
        this.saveAs(this.properties);
    }

    public synchronized void saveAs(PropertyAccess properties) {
        this.properties = properties;
        int count = this.items.size();
        properties.setProperty(this.name + KEY_SUFFIX_COUNT, Integer.toString(count));
        int i = 0;
        while (i < count) {
            properties.setProperty(this.name + KEY_SUFFIX_ITEM + i, (String)this.items.get(i));
            ++i;
        }
        int i2 = count;
        while (i2 < this.maxHistorySize) {
            properties.removeProperty(this.name + KEY_SUFFIX_ITEM + i2);
            ++i2;
        }
    }

    public String comboBoxGetSelectedItem(JComboBox comboBox) {
        JTextField editor = (JTextField)comboBox.getEditor().getEditorComponent();
        return this.comboBoxGetSelectedItem(editor);
    }

    public String comboBoxGetSelectedItem(JTextField editor) {
        String s = editor.getText();
        this.updateHistory(s);
        return s;
    }

    public void updateHistory(String s) {
        this.update(s);
        this.save();
    }
}

