/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Locale;

public class MenuCJKUtil {
    private static final String INVOKED_TOKEN = "...";
    private static final String LOCAL_LANG = Locale.getDefault().getLanguage();
    private static final boolean isCJK = LOCAL_LANG.equals(Locale.CHINESE.getLanguage()) || LOCAL_LANG.equals(Locale.JAPANESE.getLanguage()) || LOCAL_LANG.equals(Locale.KOREAN.getLanguage());

    public static String addSingleByteCharsForMnemonics(String menuLabel) {
        if (isCJK) {
            return menuLabel + "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        }
        return menuLabel;
    }

    public static String getCJKMenuLabel(String label, Integer mnemonic) {
        if (mnemonic == null) {
            return label;
        }
        return MenuCJKUtil.getCJKMenuLabel(label, (int)mnemonic);
    }

    public static String getCJKMenuLabel(String label, int key) {
        return MenuCJKUtil.getModifiedMenuLabel(label, key);
    }

    private static String getModifiedMenuLabel(String label, int key) {
        boolean hasInvokedString = false;
        if (!isCJK || label == null) {
            return label;
        }
        label = label.trim();
        int length = label.length();
        boolean hasAmp = false;
        if (MenuCJKUtil.isInvoked(label)) {
            hasInvokedString = true;
            length -= 3;
        }
        if (length >= 4 && label.charAt(length - 4) == '(' && label.charAt(length - 3) == '&' && label.charAt(length - 1) == ')') {
            hasAmp = true;
            if (label.charAt(length - 2) == (char)key) {
                return label;
            }
            length -= 4;
        }
        if (length >= 3 && !hasAmp && label.charAt(length - 3) == '(' && label.charAt(length - 1) == ')') {
            if (label.charAt(length - 2) == (char)key) {
                return label;
            }
            length -= 3;
        }
        label = label.substring(0, length).trim();
        if (key != 0) {
            label = label + MenuCJKUtil.getMnemonicToken(key, hasAmp);
        }
        if (hasInvokedString) {
            label = label + INVOKED_TOKEN;
        }
        return label;
    }

    private static String getMnemonicToken(int key, boolean hasAmp) {
        String nmStr = "";
        if (key >= 97 && key <= 122 || key >= 65 && key <= 90) {
            if (hasAmp) {
                char[] keys = new char[]{'(', '&', (char)key, ')'};
                nmStr = new String(keys).toUpperCase();
            } else {
                char[] keys = new char[]{'(', (char)key, ')'};
                nmStr = new String(keys).toUpperCase();
            }
        }
        return nmStr;
    }

    private static boolean isInvoked(String label) {
        return label.trim().endsWith(INVOKED_TOKEN);
    }
}

