/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import oracle.ide.util.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternFiltersOptimizer {
    private static final String ASTERISK_ASTERISK = "**";
    private static final String ASTERISK_ASTERISK_SLASH = "**/";
    private static final String ASTERISK = "*";
    private ArrayList<Evaluator> m_endsWithEvaluators;
    private ArrayList<Evaluator> m_containsEvaluators;
    private ArrayList<Evaluator> m_vanillaEvaluators;

    private void $init$() {
        this.m_endsWithEvaluators = new ArrayList();
        this.m_containsEvaluators = new ArrayList();
        this.m_vanillaEvaluators = new ArrayList();
    }

    public PatternFiltersOptimizer() {
        this.$init$();
    }

    public void setPatternFilters(PatternFilter[] filters) {
        this.categorizeFilters(filters);
    }

    public PatternFilter getMatchingFilter(String target) {
        for (Evaluator evaluator : this.m_endsWithEvaluators) {
            if (!evaluator.matches(target)) continue;
            return evaluator.getFilter();
        }
        for (Evaluator evaluator : this.m_containsEvaluators) {
            if (!evaluator.matches(target)) continue;
            return evaluator.getFilter();
        }
        for (Evaluator evaluator : this.m_vanillaEvaluators) {
            if (!evaluator.matches(target)) continue;
            return evaluator.getFilter();
        }
        return null;
    }

    private void categorizeFilters(PatternFilter[] filters) {
        this.m_endsWithEvaluators.clear();
        this.m_containsEvaluators.clear();
        this.m_vanillaEvaluators.clear();
        PatternFilter[] patternFilterArray = filters;
        int n = 0;
        while (n < patternFilterArray.length) {
            PatternFilter patternFilter = patternFilterArray[n];
            String pattern = patternFilter.getPattern();
            if (this.startsWithAsteriskAsteriskSlash(pattern)) {
                String patternSuffixAfterAAS = pattern.substring(ASTERISK_ASTERISK_SLASH.length());
                if (!this.endWithAsterisk(patternSuffixAfterAAS) && this.containsSingleOrNoneAstreisk(patternSuffixAfterAAS)) {
                    this.m_endsWithEvaluators.add(new EndsWithEvaluator(patternFilter));
                } else {
                    this.m_containsEvaluators.add(new SequenceContainsEvaluator(patternFilter));
                }
            } else if (pattern.equals(ASTERISK_ASTERISK)) {
                this.m_vanillaEvaluators.add(new VanillaEvaluator(patternFilter));
            } else if (pattern.contains(ASTERISK)) {
                this.m_containsEvaluators.add(new SequenceContainsEvaluator(patternFilter));
            } else {
                this.m_endsWithEvaluators.add(new EndsWithEvaluator(patternFilter));
            }
            ++n;
        }
    }

    private boolean startsWithAsteriskAsteriskSlash(String source) {
        return source.startsWith(ASTERISK_ASTERISK_SLASH);
    }

    private boolean endWithAsterisk(String source) {
        return source.endsWith(ASTERISK);
    }

    private boolean containsSingleOrNoneAstreisk(String source) {
        int indexOfAsterisk = source.indexOf(ASTERISK);
        if (indexOfAsterisk != -1) {
            return indexOfAsterisk == source.lastIndexOf(ASTERISK);
        }
        return true;
    }

    public ArrayList<Evaluator> getEndsWithEvaluators() {
        return this.m_endsWithEvaluators;
    }

    public ArrayList<Evaluator> getContainsEvaluators() {
        return this.m_containsEvaluators;
    }

    public ArrayList<Evaluator> getOtherEvaluators() {
        return this.m_vanillaEvaluators;
    }

    abstract class Evaluator {
        private final PatternFilter m_filter;

        public Evaluator(PatternFilter filter) {
            this.m_filter = filter;
        }

        PatternFilter getFilter() {
            return this.m_filter;
        }

        abstract boolean matches(String var1);
    }

    class EndsWithEvaluator
    extends Evaluator {
        private final String m_suffix;

        public EndsWithEvaluator(PatternFilter filter) {
            super(filter);
            String patternToMatchAgainst = filter.getPattern();
            int indexOfAsterisk = patternToMatchAgainst.lastIndexOf(PatternFiltersOptimizer.ASTERISK);
            this.m_suffix = indexOfAsterisk != -1 ? (indexOfAsterisk + 1 < patternToMatchAgainst.length() ? patternToMatchAgainst.substring(indexOfAsterisk + 1) : patternToMatchAgainst) : filter.getPattern();
        }

        public boolean matches(String target) {
            return target.endsWith(this.m_suffix);
        }
    }

    class SequenceContainsEvaluator
    extends Evaluator {
        private String[] m_tokens;

        public SequenceContainsEvaluator(PatternFilter filter) {
            super(filter);
            String patternToMatchAgainst = filter.getPattern();
            this.m_tokens = patternToMatchAgainst.split("\\*{1,2}");
        }

        public boolean matches(String target) {
            int currentIndex = 0;
            String[] stringArray = this.m_tokens;
            int n = 0;
            while (n < stringArray.length) {
                String token = stringArray[n];
                if (!token.equals("")) {
                    int indexOfNextMatch = target.indexOf(token, currentIndex);
                    if (indexOfNextMatch == -1) {
                        return false;
                    }
                    currentIndex += token.length();
                }
                ++n;
            }
            return true;
        }
    }

    class VanillaEvaluator
    extends Evaluator {
        private final boolean isAsteriskAsterisk;

        public VanillaEvaluator(PatternFilter filter) {
            super(filter);
            this.isAsteriskAsterisk = PatternFiltersOptimizer.ASTERISK_ASTERISK.equals(filter.getPattern());
        }

        public boolean matches(String target) {
            return this.isAsteriskAsterisk ? true : this.getFilter().matches(target);
        }
    }
}

