/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTokenizerEx
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private boolean allowQuotedStrings;
    private boolean keepQuotes;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m = '\u0000';
        int i = 0;
        while (i < this.delimiters.length()) {
            char c = this.delimiters.charAt(i);
            if (m < c) {
                m = c;
            }
            ++i;
        }
        this.maxDelimChar = m;
    }

    public StringTokenizerEx(String str, String delim, boolean returnDelims, boolean allowQuotedStrings, boolean keepQuotes) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.allowQuotedStrings = allowQuotedStrings;
        this.keepQuotes = keepQuotes;
        this.setMaxDelimChar();
        if (allowQuotedStrings && delim.indexOf(34) > -1) {
            throw new IllegalArgumentException("A '\"' character can not be a delimiter if allowQuotedStrings==-true");
        }
    }

    public StringTokenizerEx(String str, String delim, boolean returnDelims) {
        this(str, delim, returnDelims, false, false);
    }

    public StringTokenizerEx(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizerEx(String str) {
        this(str, " \t\n\r\f", false);
    }

    private int skipDelimiters(int startPos) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int position = startPos;
        while (!this.retDelims && position < this.maxPosition) {
            char c = this.str.charAt(position);
            if (this.allowQuotedStrings && c == '\"' || c > this.maxDelimChar || this.delimiters.indexOf(c) < 0) break;
            ++position;
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position = startPos;
        int lastone = 32;
        boolean inquote = false;
        while (position < this.maxPosition) {
            char c2 = this.str.charAt(position);
            if (this.allowQuotedStrings && c2 == '\"' && lastone != 92) {
                if (inquote) {
                    ++position;
                    break;
                }
                inquote = true;
            }
            if (c2 <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0 && !inquote) break;
            lastone = c2 == '\\' && lastone == 92 ? 32 : (int)c2;
            ++position;
        }
        if (this.retDelims && startPos == position && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        if (this.allowQuotedStrings && this.str.charAt(start) == '\"' && this.str.charAt(this.currentPosition - 1) == '\"') {
            if (this.keepQuotes) {
                return this.str.substring(start, this.currentPosition);
            }
            return this.str.substring(start + 1, this.currentPosition - 1);
        }
        return this.str.substring(start, this.currentPosition);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition) {
            if ((currpos = this.skipDelimiters(currpos)) >= this.maxPosition) break;
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }

    public static void main(String[] args) {
        String s = "\"1 2 \"3  4                ";
        int i = 0;
        StringTokenizerEx st = new StringTokenizerEx(s, " \t\n\r\f", false, true, true);
        while (st.hasMoreTokens()) {
            System.out.println("[" + i + "] [" + st.nextToken() + "]");
            ++i;
        }
    }
}

