/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.javatools.buffer.TextBuffer;

public final class TextBufferStreamFactory {
    public static InputStream getInputStream(TextBuffer textBuffer) {
        return TextBufferStreamFactory.getInputStream(textBuffer, null);
    }

    public static InputStream getInputStream(TextBuffer textBuffer, String encoding) {
        if (textBuffer == null) {
            throw new IllegalArgumentException("null text buffer");
        }
        char[] charData = TextBufferStreamFactory.getCharData(textBuffer);
        byte[] byteData = TextBufferStreamFactory.char2Byte(charData, encoding);
        return new ByteArrayInputStream(byteData);
    }

    public static OutputStream getOutputStream(TextBuffer textBuffer) {
        if (textBuffer == null) {
            throw new IllegalArgumentException("null text buffer");
        }
        textBuffer.writeLock();
        1 out = new 1(textBuffer);
        return out;
    }

    private static char[] getCharData(TextBuffer textBuffer) {
        textBuffer.readLock();
        try {
            int length = textBuffer.getLength();
            char[] cArray = textBuffer.getChars(0, length);
            return cArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private static byte[] char2Byte(char[] charData, String encoding) {
        String stringData = new String(charData);
        if (encoding != null) {
            try {
                byte[] byArray = stringData.getBytes(encoding);
                return byArray;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringData.getBytes();
    }

    static final class 1
    extends ByteArrayOutputStream {
        private final /* synthetic */ TextBuffer v$textBuffer;

        public void close() throws IOException {
            super.close();
            byte[] byteData = this.toByteArray();
            String stringData = new String(byteData);
            char[] charData = stringData.toCharArray();
            int length = this.v$textBuffer.getLength();
            this.v$textBuffer.remove(0, length);
            this.v$textBuffer.insert(0, charData);
            this.v$textBuffer.writeUnlock();
        }

        public 1(TextBuffer textBuffer) {
            this.v$textBuffer = textBuffer;
        }
    }
}

