/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.util.WeightedList;

public class WeightedController
implements Controller {
    public static final Controller USE_ACTIVE_VIEW_CONTROLLER = new 1();
    public static final Controller NOOP_CONTROLLER = new 2();
    private WeightedList _controllers;
    private static final String ACTION_CONTROLLER = "WeightedController";

    private void $init$() {
        this._controllers = new WeightedList(3);
    }

    public WeightedController() {
        this.$init$();
    }

    public WeightedController(Controller firstController, Controller lastController) {
        this.$init$();
        if (firstController != null) {
            this._controllers.add((Object)firstController, Double.MIN_VALUE);
        }
        if (lastController != null) {
            this._controllers.add((Object)lastController, Double.MAX_VALUE);
        }
    }

    public void addController(Controller controller, double weight) {
        if (controller == null || weight == Double.MAX_VALUE || weight == Double.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        this._controllers.add((Object)controller, weight);
    }

    public void removeController(Controller controller) {
        this._controllers.remove((Object)controller);
    }

    public boolean update(IdeAction action, Context context) {
        boolean ret = false;
        String key = "WeightedController.update()";
        Assert.startTracking((String)"WeightedController.update()");
        Iterator iterator = this._controllers.iterator();
        while (!ret && iterator.hasNext()) {
            Controller controller = (Controller)iterator.next();
            Assert.markTracking((String)"WeightedController.update()");
            ret = controller.update(action, context);
            Assert.checkTracking((String)"WeightedController.update()", (Object)controller);
            if (!ret) continue;
            action.putValue(ACTION_CONTROLLER, new WeakReference<Controller>(controller));
            if (!IdeAction.DEBUG) continue;
            action.putValue("controller-handling-update", controller.getClass().getName());
        }
        Assert.endTracking((String)"WeightedController.update()");
        return ret;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        WeakReference weakReference = (WeakReference)action.getValue(ACTION_CONTROLLER);
        if (weakReference != null) {
            Controller controller = (Controller)weakReference.get();
            if (controller != null) {
                if (controller.handleEvent(action, context)) {
                    return true;
                }
                Assert.println((String)("Warning: " + controller.getClass().toString() + ".update() returns true but handleEvent() returns false"));
            }
            action.putValue(ACTION_CONTROLLER, null);
        }
        for (Controller controller : this._controllers) {
            if (!controller.handleEvent(action, context)) continue;
            return true;
        }
        return false;
    }

    static final class 1
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            Controller controller;
            View view = context.getView();
            if (view != null && (controller = view.getController()) != null) {
                return controller.update(action, context);
            }
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            Controller controller;
            View view = context.getView();
            if (view != null && (controller = view.getController()) != null) {
                return controller.handleEvent(action, context);
            }
            return false;
        }
    }

    static final class 2
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            action.setEnabled(false);
            return true;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            return true;
        }
    }
}

