/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public abstract class AbstractPinnable
extends DockableWindow
implements ViewSelectionListener,
Pinnable,
Observer {
    public static final String TOOLBAR_ITEM = "Toolbar.item";
    public static final String TOOLBAR_ITEM_COUNT = "Toolbar.count";
    private View pinnedView;
    private int pinState;
    private ViewMonitor viewMonitor;
    protected Toolbar toolbar;
    protected boolean isToolbarVisible;
    protected Node _node;
    protected boolean forceUpdate;

    private void $init$() {
        this.pinState = 0;
    }

    protected AbstractPinnable(String viewId) {
        super(viewId);
        this.$init$();
        this.viewMonitor = new ViewMonitor(null);
        this.viewMonitor.start();
    }

    protected AbstractPinnable(IdeMainWindow mw, String viewId) {
        this(viewId);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public void setToolbarVisible(boolean visible) {
        this.isToolbarVisible = visible;
    }

    public void setContext(Context context) {
        View view;
        View view2 = view = context != null ? context.getView() : null;
        if (!this.isViewSupported(view) && view instanceof AbstractPinnable && (view = ((AbstractPinnable)view).getPinnedView()) == null) {
            view = Ide.getMainWindow().getLastActiveView();
        }
        ActiveViewEvent e = new ActiveViewEvent(Ide.getMainWindow(), this.getPinnedView(), view);
        this.activeViewChanged(e);
    }

    protected boolean isSingleton() {
        return false;
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 1: {
                super.stateChange(newState);
                if (this.getPinnedView() == null && this.getPinState() == 0) {
                    this.setPinState(0);
                    break;
                }
                if (this.getPinnedView() != null) {
                    this.getPinnedView().addViewSelectionListener(this);
                }
                this.restorePinTarget();
                this.setPinState(this.getPinState());
                break;
            }
            case 2: {
                super.stateChange(newState);
                if (this.getPinnedView() == null) break;
                this.getPinnedView().removeViewSelectionListener(this);
                this.persistPinTarget();
                if (this.getPinState() == 2) break;
                this.clear();
                break;
            }
            case 3: {
                if (!this.isSingleton()) {
                    this.viewMonitor.stop();
                }
                super.stateChange(newState);
                break;
            }
        }
    }

    protected synchronized void activeViewChanged(ActiveViewEvent e) {
        View newView = e.getNewView();
        if (!this.isViewSupported(newView)) {
            return;
        }
        if (this.getPinState() != 0) {
            return;
        }
        this.setPinnedView(newView);
    }

    public synchronized void viewSelectionChanged(ViewSelectionEvent e) {
        if (this.getPinState() == 2) {
            return;
        }
        this.viewSelectionChangedImpl(e.getView());
    }

    private void viewSelectionChangedImpl(View view) {
        Context context = view.getContext();
        this.viewSelectionChanged(context);
    }

    public synchronized int getPinState() {
        return this.pinState;
    }

    public synchronized void setPinState(int newState) {
        this.pinState = newState;
        switch (newState) {
            case 0: {
                View view = this.getPinnedView();
                if (view == null || view != this.viewMonitor.getLastSupportedView()) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    ActiveViewEvent e = new ActiveViewEvent(mainWindow, view, this.viewMonitor.getLastSupportedView());
                    this.activeViewChanged(e);
                    break;
                }
                this.viewSelectionChangedImpl(view);
                break;
            }
            case 1: {
                View view = this.getPinnedView();
                if (view != null) {
                    this.viewSelectionChangedImpl(view);
                    break;
                }
                this.clear();
                break;
            }
            case 2: {
                this.updateTitle(this.getTitleName());
                break;
            }
        }
    }

    protected abstract boolean isViewSupported(View var1);

    protected void persistPinTarget() {
    }

    protected void restorePinTarget() {
    }

    protected void viewSelectionChanged(Context context) {
        Node doc;
        Node node = doc = context != null ? context.getNode() : null;
        if (doc != this._node) {
            if (this._node != null) {
                this._node.detach(this);
            }
            this._node = doc;
            if (this._node != null) {
                this._node.attach(this);
            }
        }
    }

    public void update(Object subject, UpdateMessage msg) {
        int id;
        int n = id = msg != null ? msg.getMessageID() : -1;
        if (id == UpdateMessage.OBJECT_CLOSED) {
            this.objectClosed((Subject)subject, msg);
        } else if (id == UpdateMessage.OBJECT_RENAMED) {
            this.objectRenamed((Subject)subject, msg);
        }
    }

    protected void objectClosed(Subject subject, UpdateMessage msg) {
        this.setPinnedView(null);
        this.clear();
        1 runner = new 1();
        SwingUtilities.invokeLater(runner);
    }

    protected void objectRenamed(Subject subject, UpdateMessage msg) {
        this.setPinnedView(null);
        this.clear();
        this.setPinState(this.getPinState());
    }

    protected void clear() {
        if (this._node != null) {
            this._node.detach(this);
            this._node = null;
        }
    }

    protected synchronized View getPinnedView() {
        return this.pinnedView;
    }

    protected synchronized void setPinnedView(View view) {
        if (view != null && view == this.pinnedView) {
            if (!this.forceUpdate) {
                return;
            }
            this.forceUpdate = false;
        }
        if (this.pinnedView != null) {
            this.pinnedView.removeViewSelectionListener(this);
        }
        this.pinnedView = view;
        if (this.pinnedView == null) {
            if (this.getPinState() != 2) {
                this.clear();
            }
        } else {
            this.pinnedView.addViewSelectionListener(this);
            this.viewSelectionChangedImpl(this.pinnedView);
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            AbstractPinnable.this.setPinState(AbstractPinnable.this.getPinState());
        }
    }

    private final class ViewMonitor
    implements ActiveViewListener,
    ViewListener {
        private View lastSupportedView;

        public View getLastSupportedView() {
            return this.lastSupportedView;
        }

        public void start() {
            IdeMainWindow mainWin = Ide.getMainWindow();
            this.lastSupportedView = AbstractPinnable.this.isViewSupported(mainWin.getLastActiveView()) ? mainWin.getLastActiveView() : null;
            mainWin.addActiveViewListener(this);
        }

        public void stop() {
            Ide.getMainWindow().removeActiveViewListener(this);
            if (this.lastSupportedView != null) {
                this.lastSupportedView.removeViewListener(this);
            }
            this.lastSupportedView = null;
        }

        public void activeViewChanged(ActiveViewEvent e) {
            View newView = e.getNewView();
            if (AbstractPinnable.this.isViewSupported(newView)) {
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.removeViewListener(this);
                }
                this.lastSupportedView = newView;
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.addViewListener(this);
                }
                if (AbstractPinnable.this.isVisible()) {
                    AbstractPinnable.this.activeViewChanged(e);
                }
            }
        }

        public void viewActivated(ViewEvent e) {
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
            View view = e.getView();
            if (view == this.lastSupportedView) {
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.removeViewListener(this);
                }
                this.lastSupportedView = null;
            }
            if (view == AbstractPinnable.this.getPinnedView()) {
                AbstractPinnable.this.setPinnedView(null);
                AbstractPinnable.this.setPinState(AbstractPinnable.this.getPinState());
            }
        }

        private ViewMonitor() {
        }

        ViewMonitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

