/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;

public abstract class MultiManager
implements Controller,
Addin {
    private IdeAction _showAction;
    private IdeAction _toggleToolbarAction;
    private final List _views;
    private final L _listener;
    private static final String TOOLBAR_VISIBLE_PROP = ".Toolbar.visible";

    private void $init$() {
        this._views = new ArrayList();
        this._listener = new L(null);
    }

    public void initialize() {
        Menubar mgr;
        DockStation dockStation;
        DockableFactory factory = this.getDockableFactory();
        if (factory != null && (dockStation = DockStation.getDockStation()) != null) {
            dockStation.registerDockableFactory(this.getViewCategory(), factory);
        }
        Menubar menubar = mgr = Ide.getIdeArgs().getCreateUI() ? Ide.getMenubar() : null;
        if (mgr != null) {
            String acceleratorFile;
            this._toggleToolbarAction = this.createToggleToolbarAction();
            if (this._toggleToolbarAction != null) {
                this._toggleToolbarAction.putValue("Check", Boolean.TRUE);
                this._toggleToolbarAction.addController(this);
                JMenuItem item = mgr.createMenuItem(this._toggleToolbarAction, this.getToggleToolbarMenuWeight());
                mgr.add((Component)item, MenuManager.getJMenu("ViewToolbars"));
            }
            if ((acceleratorFile = this.getAcceleratorFile()) != null) {
                KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
                keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), acceleratorFile);
            }
        }
    }

    public final IdeAction getShowAction() {
        if (this._showAction == null) {
            this._showAction = this.createShowAction();
        }
        return this._showAction;
    }

    public DockableView showLastView(Context context) {
        DockableView last = this.getLastView();
        if (last == null) {
            return this.showView(context);
        }
        if (last == Ide.getMainWindow().getLastActiveView() && this._views.size() > 1) {
            this._views.remove(last);
            this._views.add(0, last);
            last = this.getLastView();
        }
        last.show();
        DockStation.getDockStation().activateDockable(last);
        return last;
    }

    public DockableView showView(Context context) {
        DockableView view = this.findOrCreateView(context);
        if (view != null) {
            view.show();
            DockStation.getDockStation().activateDockable(view);
        }
        return view;
    }

    public DockableView getLastView() {
        if (this._views.isEmpty()) {
            return null;
        }
        return (DockableView)this._views.get(this._views.size() - 1);
    }

    public DockableView getNewView(Context context, ViewId viewId) {
        DockableView view = this.createDockableView(context, viewId);
        if (view != null) {
            view.setToolbarVisible(this.isToolbarVisible());
            this.registerView(view);
        }
        return view;
    }

    public Collection getViews() {
        return new ArrayList(this._views);
    }

    public ViewId getDefaultViewId() {
        return new ViewId(this.getViewCategory(), this.getDefaultName());
    }

    protected abstract String getViewCategory();

    protected abstract String getDefaultName();

    protected String getAcceleratorFile() {
        return null;
    }

    protected abstract DockableView createDockableView(Context var1, ViewId var2);

    protected abstract IdeAction createShowAction();

    protected abstract DockableFactory getDockableFactory();

    protected IdeAction createToggleToolbarAction() {
        return null;
    }

    protected float getToggleToolbarMenuWeight() {
        return Float.MAX_VALUE;
    }

    protected ViewId getViewId(Context context) {
        return this.getDefaultViewId();
    }

    protected DockableView findView(ViewId viewId) {
        Dockable dockable;
        if (viewId != null && (dockable = DockStation.getDockStation().getDockable(viewId)) instanceof DockableView) {
            return (DockableView)dockable;
        }
        return null;
    }

    protected DockableView findOrCreateView(Context context) {
        DockableView view;
        ViewId viewId = this.getViewId(context);
        if (viewId == null || viewId.getName() == null) {
            viewId = new ViewId(this.getViewCategory(), Long.toString(new Date().getTime()));
        }
        if ((view = this.findView(viewId)) == null) {
            DockableView relative = this.getRelativeView(context, viewId);
            Collection views = this.getViews();
            int count = views != null ? views.size() : 0;
            view = this.getNewView(context, viewId);
            if (view != null) {
                int status;
                DockStation ds = DockStation.getDockStation();
                if (relative != null && ((status = ds.getDockableStatus(relative)) & 1) != 1) {
                    relative = null;
                }
                DockingParam dockingParam = new DockingParam();
                if (count == 0) {
                    int orientation = this.getOrientation(viewId, relative);
                    if (relative != null) {
                        dockingParam.setPosition(relative, orientation);
                    } else {
                        dockingParam.setPosition(orientation);
                    }
                } else {
                    dockingParam.setTabbedWith(relative);
                }
                ds.dock(view, dockingParam);
            }
        }
        return view;
    }

    protected DockableView getRelativeView(Context context, ViewId viewId) {
        ActionEvent actionEvent;
        String name;
        String string = name = viewId != null ? viewId.getName() : null;
        if (name != null && name.equals(this.getDefaultName())) {
            return null;
        }
        EventObject eventObject = context.getEvent();
        if (eventObject instanceof ActionEvent && (actionEvent = (ActionEvent)eventObject).getActionCommand().equals(IdeArb.getString(93)) && this instanceof NavigatorManager) {
            return ((NavigatorManager)this).getNavigatorWindow();
        }
        return this.getLastView();
    }

    protected int getOrientation(ViewId viewId, DockableView relative) {
        return relative != null ? 4 : 0;
    }

    protected boolean isToolbarVisible() {
        String visible = Ide.getProperty(this.getViewCategory() + TOOLBAR_VISIBLE_PROP, Boolean.TRUE.toString());
        return Boolean.valueOf(visible);
    }

    protected void setToolbarVisible(boolean visible) {
        Ide.setProperty(this.getViewCategory() + TOOLBAR_VISIBLE_PROP, Boolean.toString(visible));
        Iterator i = this._views.iterator();
        if (i != null) {
            while (i.hasNext()) {
                ((View)i.next()).setToolbarVisible(visible);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action != null) {
            int cmdId = action.getCommandId();
            if (cmdId == 67) {
                this.showView(context);
                return true;
            }
            if (this._toggleToolbarAction != null && cmdId == this._toggleToolbarAction.getCommandId()) {
                this.setToolbarVisible(this.isToolbarVisible() ^ true);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action != null) {
            int cmdId = action.getCommandId();
            if (cmdId == 67) {
                action.setEnabled(true);
                return true;
            }
            if (this._toggleToolbarAction != null && cmdId == this._toggleToolbarAction.getCommandId()) {
                action.setEnabled(true);
                action.setState(this.isToolbarVisible());
                return true;
            }
        }
        return false;
    }

    private void registerView(View view) {
        this.addView(view);
        view.addViewListener(this._listener);
    }

    private void addView(View view) {
        this._views.remove(view);
        this._views.add(view);
    }

    private void removeView(View view) {
        if (this._views.contains(view)) {
            this._views.remove(view);
        }
    }

    public MultiManager() {
        this.$init$();
    }

    static void mav$addView(MultiManager multiManager, View view) {
        multiManager.addView(view);
    }

    static void mav$removeView(MultiManager multiManager, View view) {
        multiManager.removeView(view);
    }

    private class L
    implements ViewListener {
        public void viewClosed(ViewEvent e) {
            View view;
            if (e != null && (view = e.getView()) != null) {
                MultiManager.mav$removeView(MultiManager.this, view);
            }
        }

        public void viewActivated(ViewEvent e) {
            View view;
            if (e != null && (view = e.getView()) != null) {
                MultiManager.mav$addView(MultiManager.this, view);
            }
        }

        public void viewDeactivated(ViewEvent e) {
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

