/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import javax.swing.Timer;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ide.view.ViewStateEvent;
import oracle.ide.view.ViewStateListener;

public abstract class View
implements ControllerProvider,
Helpable {
    public static final String VISIBLE_PROP = ".visible";
    public static final String PROJECT_PROP = ".project";
    public static final String WORKSPACE_PROP = ".workspace";
    public static final Element[] EMPTY_SELECTION = new Element[0];
    private static int COUNTER = 0;
    private View owner;
    private String viewId;
    private Element[] selection;
    private Timer timer;
    private final CopyOnWriteArrayList<ViewListener> viewListeners;
    private final CopyOnWriteArrayList<ViewSelectionListener> viewSelectionListeners;
    private final CopyOnWriteArrayList<ViewStateListener> viewStateListeners;

    private void $init$() {
        this.selection = EMPTY_SELECTION;
        this.viewListeners = new CopyOnWriteArrayList();
        this.viewSelectionListeners = new CopyOnWriteArrayList();
        this.viewStateListeners = new CopyOnWriteArrayList();
    }

    protected View() {
        this(null);
    }

    protected View(String viewId) {
        this.$init$();
        this.viewId = viewId;
    }

    public View getViewWithoutDecoration() {
        return this;
    }

    public void saveLayout(PropertyAccess p) {
    }

    public void loadLayout(PropertyAccess p) {
    }

    public Controller getController() {
        return null;
    }

    public HelpInfo getHelpInfo() {
        return HelpInfo.getDefaultHelpInfo();
    }

    public final View owner() {
        return this.ownerImpl();
    }

    View ownerImpl() {
        return this.owner;
    }

    public void close() {
        this.fireViewClosed();
    }

    public void show() {
        this.getGUI().setVisible(true);
        this.updateSelection();
    }

    public boolean isVisible() {
        Component gui = this.getGUI();
        return gui != null && gui.isVisible();
    }

    public abstract Component getGUI();

    public final Context getContext() {
        return this.getContext(null);
    }

    public Context getContext(EventObject event) {
        return Context.newIdeContext(this, event);
    }

    public ContextMenu getContextMenu() {
        return null;
    }

    public void activate() {
        this.fireViewActivated();
    }

    public void deactivate() {
        this.fireViewDeactivated();
    }

    public final Element[] getSelection() {
        return this.getSelectionImpl();
    }

    Element[] getSelectionImpl() {
        return this.selection;
    }

    public final String getId() {
        return this.getIdImpl();
    }

    String getIdImpl() {
        if (this.viewId == null) {
            this.viewId = this.newId();
        }
        return this.viewId;
    }

    public void updateTitle(Object obj) {
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        View.updateToolbarActions(this.getToolbar());
    }

    public Toolbar getToolbar() {
        return null;
    }

    public void setToolbarVisible(boolean visible) {
    }

    public void addViewListener(ViewListener l) {
        this.addViewListenerImpl(l);
    }

    void addViewListenerImpl(ViewListener l) {
        this.viewListeners.addIfAbsent(l);
    }

    public void removeViewListener(ViewListener l) {
        this.removeViewListenerImpl(l);
    }

    void removeViewListenerImpl(ViewListener l) {
        this.viewListeners.remove(l);
    }

    public void addViewSelectionListener(ViewSelectionListener l) {
        this.addViewSelectionListenerImpl(l);
    }

    void addViewSelectionListenerImpl(ViewSelectionListener l) {
        this.viewSelectionListeners.addIfAbsent(l);
    }

    public void removeViewSelectionListener(ViewSelectionListener l) {
        this.removeViewSelectionListenerImpl(l);
    }

    void removeViewSelectionListenerImpl(ViewSelectionListener l) {
        this.viewSelectionListeners.remove(l);
    }

    public final void addViewStateListener(ViewStateListener l) {
        this.addViewStateListenerImpl(l);
    }

    void addViewStateListenerImpl(ViewStateListener l) {
        this.viewStateListeners.addIfAbsent(l);
    }

    public final void removeViewStateListener(ViewStateListener l) {
        this.removeViewStateListenerImpl(l);
    }

    void removeViewStateListenerImpl(ViewStateListener l) {
        this.viewStateListeners.remove(l);
    }

    public final void updateSelection() {
        this.updateSelectionImpl(false);
    }

    public final void scheduleUpdateSelection() {
        this.scheduleUpdateSelectionImpl();
    }

    void scheduleUpdateSelectionImpl() {
        if (EventQueue.isDispatchThread()) {
            Element[] newSelection = this.getSelectionFromUI();
            if (this.setSelection(newSelection)) {
                if (this.timer == null) {
                    this.createTimer();
                }
                this.timer.restart();
            }
            return;
        }
        EventQueue.invokeLater(new 1());
    }

    private void createTimer() {
        this.timer = new Timer(250, new 2());
        this.timer.setRepeats(false);
    }

    public final void updateVisibleActions() {
        this.updateVisibleActionsImpl();
    }

    void updateVisibleActionsImpl() {
        this.updateVisibleActions(new UpdateMessage(Controller.UPDATE_FROM_USER_EXTENSION, null));
    }

    public static final void updateToolbarActions(Toolbar toolbar) {
        if (toolbar == null || !toolbar.isShowing()) {
            return;
        }
        toolbar.setPrimaryViewToolbar(true);
        Action[] actions = toolbar.getActions();
        if (actions == null) {
            return;
        }
        PerformanceLogger logger = PerformanceLogger.get();
        String LOGGER_ID = "View.updateToolbarActions";
        int i = 0;
        while (i < actions.length) {
            logger.startTiming("View.updateToolbarActions");
            Action action = actions[i];
            View.updateAction(action);
            logger.stopTiming("View.updateToolbarActions", 10, "Updated action {0}", new Object[]{action});
            ++i;
        }
    }

    private static void updateAction(Action action) {
        if (action instanceof IdeAction) {
            ((IdeAction)action).updateAction();
        }
    }

    public static final void loadManifestToolbar(String toolbarId, Toolbar toolbar, View view) {
        ToolbarManager.getToolbarManager().installToolbar(toolbarId, toolbar, view);
    }

    public static final void loadManifestToolbar(String toolbarId, Toolbar toolbar) {
        View.loadManifestToolbar(toolbarId, toolbar, null);
    }

    protected Element[] getSelectionFromUI() {
        return EMPTY_SELECTION;
    }

    protected final void updateSelectionImpl(boolean doNotifyOnInvokeLater) {
        this.updateSelectionImpl0(doNotifyOnInvokeLater);
    }

    void updateSelectionImpl0(boolean doNotifyOnInvokeLater) {
        if (EventQueue.isDispatchThread()) {
            Element[] newSelection = this.getSelectionFromUI();
            if (this.setSelection(newSelection)) {
                ViewSelectionEvent event = new ViewSelectionEvent(this);
                if (doNotifyOnInvokeLater) {
                    EventQueue.invokeLater(new 3(this, event));
                } else {
                    this.fireViewSelectionChanged(event);
                }
            }
            return;
        }
        EventQueue.invokeLater(new 4(this, doNotifyOnInvokeLater));
    }

    protected final void setId(String id) {
        this.setIdImpl(id);
    }

    void setIdImpl(String id) {
        this.viewId = id;
    }

    protected String newId() {
        return "UnknownView" + ++COUNTER;
    }

    public String toString() {
        return this.getId();
    }

    protected void setOwner(View owner) {
        this.owner = owner;
    }

    protected final void fireViewSelectionChanged(ViewSelectionEvent e) {
        this.fireViewSelectionChangedImpl(e);
    }

    void fireViewSelectionChangedImpl(ViewSelectionEvent e) {
        for (ViewSelectionListener listener : this.viewSelectionListeners) {
            try {
                long startTime = System.nanoTime();
                listener.viewSelectionChanged(e);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ViewSelectionListener.viewSelectionChanged", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception ex) {
                FeedbackManager.reportException(ex);
            }
        }
    }

    public final void fireViewExpanded() {
        this.fireViewExpandedImpl();
    }

    void fireViewExpandedImpl() {
        ViewStateEvent event = new ViewStateEvent(this);
        for (ViewStateListener l : this.viewStateListeners) {
            try {
                long startTime = System.nanoTime();
                l.viewExpanded(event);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ViewStateListener.viewExpanded", l.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    public final void fireViewCollapsed() {
        this.fireViewCollapsedImpl();
    }

    void fireViewCollapsedImpl() {
        ViewStateEvent event = new ViewStateEvent(this);
        for (ViewStateListener l : this.viewStateListeners) {
            try {
                long startTime = System.nanoTime();
                l.viewCollapsed(event);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ViewStateListener.viewCollapsed", l.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    void fireViewClosed() {
        Iterator<ViewListener> i = this.viewListeners.iterator();
        if (!i.hasNext()) {
            return;
        }
        ViewEvent event = this.newViewEvent(3);
        do {
            i.next().viewClosed(event);
        } while (i.hasNext());
    }

    private ViewEvent newViewEvent(int type) {
        return new ViewEvent(this, type);
    }

    private void fireViewActivated() {
        Iterator<ViewListener> i = this.viewListeners.iterator();
        if (!i.hasNext()) {
            return;
        }
        ViewEvent event = this.newViewEvent(1);
        do {
            i.next().viewActivated(event);
        } while (i.hasNext());
    }

    private void fireViewDeactivated() {
        Iterator<ViewListener> i = this.viewListeners.iterator();
        if (!i.hasNext()) {
            return;
        }
        ViewEvent event = this.newViewEvent(2);
        do {
            i.next().viewDeactivated(event);
        } while (i.hasNext());
    }

    private boolean setSelection(Element[] newSelection) {
        if (newSelection == null) {
            newSelection = EMPTY_SELECTION;
        }
        if (newSelection == this.selection) {
            return false;
        }
        if (newSelection.length != this.selection.length) {
            this.selection = newSelection;
            return true;
        }
        int i = 0;
        while (i < newSelection.length) {
            if (newSelection[i] != this.selection[i]) {
                this.selection = newSelection;
                return true;
            }
            ++i;
        }
        return false;
    }

    static void wa$timer(View view, Timer timer) {
        view.timer = timer;
    }

    final class 1
    implements Runnable {
        public void run() {
            View.this.scheduleUpdateSelection();
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            View.wa$timer(View.this, null);
            View.this.fireViewSelectionChanged(new ViewSelectionEvent(View.this));
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ ViewSelectionEvent v$event;
        final /* synthetic */ View this$0;

        public void run() {
            this.this$0.fireViewSelectionChanged(this.v$event);
        }

        public 3(View view, ViewSelectionEvent viewSelectionEvent) {
            this.v$event = viewSelectionEvent;
            this.this$0 = view;
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ boolean v$doNotifyOnInvokeLater;
        final /* synthetic */ View this$0;

        public void run() {
            this.this$0.updateSelectionImpl(this.v$doNotifyOnInvokeLater);
        }

        public 4(View view, boolean bl) {
            this.v$doNotifyOnInvokeLater = bl;
            this.this$0 = view;
        }
    }
}

