/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ide.wizard.WizardWelcomePage;

public class WelcomePanel
extends DefaultTraversablePanel {
    private String _saveKey;
    private final MultiLineLabel _welcomeText;
    private final MultiLineLabel _descriptiveText;
    private final JCheckBox _stateCheckBox;
    private transient WizardCallbacks _callbacks;

    private void $init$() {
        this._saveKey = null;
        this._welcomeText = new MultiLineLabel();
        this._descriptiveText = new MultiLineLabel();
        this._stateCheckBox = new JCheckBox();
    }

    public WelcomePanel(String wizardName, String welcomeText, String descriptiveText, String saveKey) {
        this.$init$();
        if (saveKey == null || saveKey.length() == 0) {
            throw new IllegalArgumentException("The specified saveKey must not be null or empty.  Please pass a non-null key that uniquely identifies your wizard for preferences purposes, such as the fully-qualified name of your wizard class.");
        }
        this.setDefaultTitle(PanelsArb.getString(9));
        this._saveKey = saveKey;
        this.setLayout(new BorderLayout());
        this._welcomeText.setFont(WelcomePanel.getTitleFont(this._welcomeText.getFont()));
        this._welcomeText.setTextWrapper(WordWrapper.getTextWrapper());
        this._welcomeText.setPreferredAspectRatio(0.0f);
        this._welcomeText.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this._welcomeText.setText(welcomeText);
        this.add((Component)this._welcomeText, "North");
        this._descriptiveText.setTextWrapper(WordWrapper.getTextWrapper());
        this._descriptiveText.setText(descriptiveText);
        this.add((Component)this._descriptiveText, "Center");
        ResourceUtils.resButton((AbstractButton)this._stateCheckBox, (String)PanelsArb.getString(4));
        Box stateBox = new Box(0);
        stateBox.add(this._stateCheckBox);
        this.add(stateBox, "South");
    }

    public static Step newStep(String wizardName, String welcomeText, String descriptiveText, String saveKey, String helpID) {
        Class<String> strClass = String.class;
        Class[] argTypes = new Class[]{strClass, strClass, strClass, strClass};
        Object[] args = new Object[]{wizardName, welcomeText, descriptiveText, saveKey};
        Step step = new Step(WelcomePanel.class, argTypes, args);
        step.setHelpID(helpID);
        return step;
    }

    public void onEntry(TraversableContext tc) {
        this._callbacks = tc.getWizardCallbacks();
        boolean showing = this._isPageShown();
        this._stateCheckBox.setSelected(showing ^ true);
        if (!showing && tc.getDirection() != 2) {
            this._callbacks.wizardSkipCurrentStep();
        }
        this._callbacks.wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
        this._callbacks.wizardSetInitialFocus((Component)this._stateCheckBox);
    }

    public void onExit(TraversableContext tc) {
        this._setPageShown(this._stateCheckBox.isSelected() ^ true);
    }

    public static Font getTitleFont(Font font) {
        int fSize = (int)((float)font.getSize() * 1.5f);
        return font.deriveFont((float)fSize);
    }

    private boolean _isPageShown() {
        return WizardWelcomePage.isWelcomeShown(this._saveKey);
    }

    private void _setPageShown(boolean shown) {
        WizardWelcomePage.setWelcomeShown(shown, this._saveKey);
    }
}

