/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.MenuSpec;
import oracle.ide.wizard.Wizard;

public final class WizardManager {
    private static final Logger LOG = Logger.getLogger(WizardManager.class.getName());
    public static final int OPEN_WIZARD_CMD_ID = Ide.findOrCreateCmdID("OpenWizardCommand");
    public static final String OPEN_WIZARD_CMD = "oracle.ide.cmd.OpenWizardCommand";
    private static WizardManager _instance = new WizardManager();
    private final ArrayList _wizards;
    private WizardKeyContext _keyContext;
    private IntHashMap _actionHash;
    private final Controller _controller;

    private void $init$() {
        this._wizards = new ArrayList();
        this._actionHash = new IntHashMap();
        this._controller = new L(null);
    }

    public static WizardManager getInstance() {
        return _instance;
    }

    public synchronized Wizard getWizard(Class clazz) {
        String wizName = clazz.getName();
        try {
            int numWizards = this._wizards.size();
            int i = 0;
            while (i < numWizards) {
                Wizard candidate = (Wizard)this._wizards.get(i);
                Class<?> cls = candidate.getClass();
                if (cls != null && cls.getName().equals(wizName)) {
                    Wizard wizard = candidate;
                    return wizard;
                }
                ++i;
            }
            Wizard newWiz = (Wizard)AddinManager.getAddinManager().getAddin(clazz);
            if (newWiz == null) {
                try {
                    newWiz = (Wizard)clazz.newInstance();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    Wizard wizard = null;
                    return wizard;
                }
            }
            this.registerWizard(newWiz);
            Wizard wizard = newWiz;
            return wizard;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Failed to create wizard " + wizName, t);
            return null;
        }
    }

    public Wizard getWizard(String className) {
        try {
            Wizard wizard = this.getWizard(Class.forName(className));
            return wizard;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Failed to create wizard " + className, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWizard(Wizard wizard) {
        if (wizard != null) {
            ArrayList arrayList = this._wizards;
            synchronized (arrayList) {
                if (!this._wizards.contains(wizard)) {
                    this._wizards.add(wizard);
                }
            }
            this.addToToolsMenuIfNonNullMenuSpec(wizard);
        }
    }

    private void addToToolsMenuIfNonNullMenuSpec(Wizard wizard) {
        MenuSpec menuSpec = wizard.getMenuSpecification();
        if (menuSpec == null) {
            return;
        }
        Menubar menuBar = Ide.getMenubar();
        ResourceBundle bundle = menuSpec.getResourceBundle();
        String cmd = wizard.getClass().getName();
        int id = Ide.findOrCreateCmdID(cmd);
        this._actionHash.put(id, cmd);
        IdeAction action = bundle != null ? (bundle instanceof ArrayResourceBundle ? IdeAction.get(id, cmd, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, (ArrayResourceBundle)bundle, (Integer)menuSpec.getBundleKey(), (Object)wizard, false) : IdeAction.get(id, cmd, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, bundle, (String)menuSpec.getBundleKey(), (Object)wizard, false)) : IdeAction.get(id, cmd, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, menuSpec.getIcon(), wizard, false);
        if (this._keyContext == null) {
            this._keyContext = new WizardKeyContext(null);
            Ide.getKeyStrokeContextRegistry().addContext(this._keyContext);
        }
        this._keyContext.addAction(action);
        action.addController(this._controller);
        JMenuItem menuItem = menuBar.createMenuItem(action);
        if (menuItem != null) {
            JMenu toolsMenu = MenuManager.getJMenu("Tools");
            menuBar.add(menuItem, toolsMenu, MenuConstants.SECTION_TOOLS_ADDINS);
        }
    }

    public boolean invokeWizard(Wizard wizard, Context context, String[] params, String[] technologyKeys) {
        boolean ret = false;
        if (wizard != null) {
            try {
                Project project;
                Wizard.setLegacyParams(context, params);
                ret = wizard.invoke(context);
                if (ret && context != null && technologyKeys != null && (project = context.getProject()) != null) {
                    TechnologyScopeConfiguration.getInstance(project).updateTechnologyScope(technologyKeys);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                ExceptionDialog.showExceptionDialog(context, t);
            }
        }
        return ret;
    }

    public void invokeSecondaryWizard(Wizard wizard, Context context, String[] params, String[] technologyKeys) {
        1 r = new 1(this, wizard, context, params, technologyKeys);
        IdeUtil.invokeAfterRepaint(new 2(this, r));
    }

    private WizardManager() {
        this.$init$();
    }

    private boolean isWizardAction(IdeAction action) {
        return this._actionHash.containsKey(action.getCommandId());
    }

    static boolean mav$isWizardAction(WizardManager wizardManager, IdeAction ideAction) {
        return wizardManager.isWizardAction(ideAction);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Wizard v$wizard;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ String[] v$params;
        private final /* synthetic */ String[] v$technologyKeys;
        final /* synthetic */ WizardManager this$0;

        public void run() {
            this.this$0.invokeWizard(this.v$wizard, this.v$context, this.v$params, this.v$technologyKeys);
        }

        public 1(WizardManager wizardManager, Wizard wizard, Context context, String[] stringArray, String[] stringArray2) {
            this.v$technologyKeys = stringArray2;
            this.v$params = stringArray;
            this.v$context = context;
            this.v$wizard = wizard;
            this.this$0 = wizardManager;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Runnable v$r;
        final /* synthetic */ WizardManager this$0;

        public void run() {
            IdeUtil.invokeAfterRepaint(this.v$r);
        }

        public 2(WizardManager wizardManager, Runnable runnable) {
            this.v$r = runnable;
            this.this$0 = wizardManager;
        }
    }

    private static class WizardKeyContext
    implements KeyStrokeContext {
        private static final String KEY = WizardKeyContext.class.getName();
        private HashSet _actions;

        private void $init$() {
            this._actions = new HashSet();
        }

        public String getAcceleratorFile() {
            return null;
        }

        public List getAllPresets() {
            return null;
        }

        public String getName() {
            return KEY;
        }

        public KeyStrokeMap getPresetKeyStrokeMap(Object preset, boolean bGlobal) {
            return null;
        }

        public Set getAllActions(boolean bGlobal) {
            return bGlobal ? this._actions : null;
        }

        void addAction(IdeAction action) {
            this._actions.add(action);
        }

        private WizardKeyContext() {
            this.$init$();
        }

        WizardKeyContext(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class L
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            CommandProcessor cmdProc = CommandProcessor.getInstance();
            Command command = null;
            if (WizardManager.mav$isWizardAction(WizardManager.this, action)) {
                String cmd = AddinManager.getAddinManager().getCommand(OPEN_WIZARD_CMD_ID, WizardManager.OPEN_WIZARD_CMD);
                command = CommandProcessor.createCommand(cmd, context);
                command.setData(action.getValue("UserData"));
            }
            if (command != null) {
                try {
                    cmdProc.invoke(command);
                }
                catch (Exception e) {
                    ExceptionDialog.showExceptionDialog(context, (Throwable)e);
                }
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            if (WizardManager.mav$isWizardAction(WizardManager.this, action)) {
                Object value = action.getValue("UserData");
                Wizard wizard = (Wizard)value;
                action.setEnabled(wizard.isAvailable(context));
                action.putValue("controller-handling-update", wizard.getClass().getName());
                return true;
            }
            return false;
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

