/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WaitCursor {
    private static final int DEFAULT_DELAY = 500;
    private static final MouseAdapter BEEPER = new 1();
    private final List<Component> _glassPanes;
    private boolean _disposed;
    private int _waitCount;
    private final Timer _timer;
    private TimerTask _currentTask;

    private void $init$() {
        this._glassPanes = new ArrayList<Component>(1);
        this._disposed = false;
        this._waitCount = 0;
        this._timer = new Timer();
    }

    public WaitCursor() {
        this.$init$();
    }

    public WaitCursor(Component component) {
        this.$init$();
        if (component == null) {
            return;
        }
        this.attach(this.findRootPaneContainer(component));
    }

    protected final RootPaneContainer findRootPaneContainer(Component component) {
        if (component instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)component);
        }
        return (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component));
    }

    protected void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(RootPaneContainer rootPaneContainer) {
        Component glassPane;
        this.checkDisposed();
        if (rootPaneContainer != null && (glassPane = rootPaneContainer.getGlassPane()) != null) {
            List<Component> list = this._glassPanes;
            synchronized (list) {
                this._glassPanes.add(glassPane);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDisposed() {
        List<Component> list = this._glassPanes;
        synchronized (list) {
            if (this._disposed) {
                throw new IllegalStateException("WaitCursor has been disposed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(RootPaneContainer rootPaneContainer) {
        this.checkDisposed();
        if (rootPaneContainer != null) {
            Component glassPane = rootPaneContainer.getGlassPane();
            boolean containsGlassPane = false;
            List<Component> list = this._glassPanes;
            synchronized (list) {
                containsGlassPane = this._glassPanes.contains(glassPane);
                if (containsGlassPane) {
                    this._glassPanes.remove(glassPane);
                }
            }
            if (containsGlassPane) {
                this.setWaitCursor(glassPane, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<Component> list = this._glassPanes;
        synchronized (list) {
            try {
                for (Component c : this._glassPanes) {
                    this.setWaitCursor(c, false);
                }
            }
            finally {
                this._disposed = true;
                this._glassPanes.clear();
            }
        }
    }

    public void show() {
        this.show(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void show(int delay) {
        if (!EventQueue.isDispatchThread()) {
            new IllegalStateException("show called from non-event thread").printStackTrace();
        }
        this.checkDisposed();
        WaitCursor waitCursor = this;
        synchronized (waitCursor) {
            if (this._waitCount++ == 0) {
                if (delay > 0) {
                    if (this._currentTask != null) {
                        this._currentTask.cancel();
                    }
                    this._currentTask = new 2();
                    this._timer.schedule(this._currentTask, delay);
                } else {
                    this.setWaitCursor(true);
                }
            }
        }
    }

    public void show(long delay) {
        if (delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Delay is too long.");
        }
        this.show((int)delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        if (!EventQueue.isDispatchThread()) {
            new IllegalStateException("show called from non-event thread").printStackTrace();
        }
        this.checkDisposed();
        WaitCursor waitCursor = this;
        synchronized (waitCursor) {
            if (this._waitCount > 0) {
                --this._waitCount;
                if (this._waitCount == 0) {
                    if (this._currentTask != null) {
                        this._currentTask.cancel();
                        this._currentTask = null;
                    }
                    this.setWaitCursor(false);
                }
            }
        }
    }

    private void setWaitCursorUnsafe(boolean bWait) {
        this.setWaitCursor(true, bWait);
    }

    private void setWaitCursor(boolean bWait) {
        this.setWaitCursor(false, bWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWaitCursor(boolean unsafe, boolean bWait) {
        Component[] glasses;
        int n;
        List<Component> list = this._glassPanes;
        synchronized (list) {
            n = this._glassPanes.size();
            glasses = new Component[n];
            this._glassPanes.toArray(glasses);
        }
        if (n > 0) {
            int i = 0;
            while (i < n) {
                this.setWaitCursor(unsafe, glasses[i], bWait);
                ++i;
            }
        }
    }

    private void setWaitCursorUnsafe(Component glass, boolean bWait) {
        this.setWaitCursor(true, glass, bWait);
    }

    private void setWaitCursor(Component glass, boolean bWait) {
        this.setWaitCursor(false, glass, bWait);
    }

    private void setWaitCursor(boolean unsafe, Component glass, boolean bWait) {
        if (!unsafe && !EventQueue.isDispatchThread()) {
            new IllegalStateException("setWaitCursor called from non-event thread").printStackTrace();
        }
        int cursorType = bWait ? 3 : 0;
        Cursor c = Cursor.getPredefinedCursor(cursorType);
        glass.setCursor(c);
        glass.setVisible(bWait);
        if (bWait) {
            glass.addMouseListener(BEEPER);
        } else {
            glass.removeMouseListener(BEEPER);
        }
    }

    static void mav$setWaitCursorUnsafe(WaitCursor waitCursor, boolean bl) {
        waitCursor.setWaitCursorUnsafe(bl);
    }

    static final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    final class 2
    extends TimerTask {
        public void run() {
            WaitCursor.mav$setWaitCursorUnsafe(WaitCursor.this, true);
        }
    }
}

