/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.JTreeCellRenderer;
import oracle.ide.controls.tree.JTreeListener;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.controls.tree.TreeCellRadioSelectedListener;

public class CustomJTree
extends JTree {
    private final JTreeListener _treeListener;
    private final JTreeCellRenderer _treeCellRenderer;
    private boolean _trackingKeyboard;
    MouseEvent _currentMouseEvent;

    private void $init$() {
        this._treeListener = new JTreeListener();
        this._treeCellRenderer = new JTreeCellRenderer();
        this._trackingKeyboard = false;
        this._currentMouseEvent = null;
    }

    public CustomJTree() {
        this(new JMutableTreeNode());
    }

    public CustomJTree(JMutableTreeNode root) {
        this(root, false);
    }

    public CustomJTree(JMutableTreeNode root, boolean asksAllowsChildren) {
        this(new DefaultTreeModel(root, asksAllowsChildren));
    }

    public CustomJTree(TreeModel newModel) {
        this(newModel, true);
    }

    public CustomJTree(TreeModel newModel, boolean fixedRowHeight) {
        super(newModel);
        this.$init$();
        if (!fixedRowHeight) {
            this.setRowHeight(0);
        }
        this.setCellRenderer(this._treeCellRenderer);
        this.addMouseListener(this._treeListener);
        this.addTreeWillExpandListener(this._treeListener);
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
    }

    public void addTreeCellCheckedListener(TreeCellCheckedListener l) {
        this._treeListener.addTreeCellCheckedListener(l);
    }

    public void removeTreeCellCheckedListener(TreeCellCheckedListener l) {
        this._treeListener.removeTreeCellCheckedListener(l);
    }

    public void addTreeCellRadioSelectedListener(TreeCellRadioSelectedListener l) {
        this._treeListener.addTreeCellRadioSelectedListener(l);
    }

    public void removeTreeCellCheckedListener(TreeCellRadioSelectedListener l) {
        this._treeListener.removeTreeCellRadioSelectedListener(l);
    }

    public void enableToolTips(boolean enabled) {
        if (enabled) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public boolean isPropagateCheckState() {
        return this._treeListener.isPropagateCheckState();
    }

    public void setPropagateCheckState(boolean propagate) {
        this._treeListener.setPropagateCheckState(propagate);
    }

    public JTreeCellData getLeadSelectionData() {
        TreePath currentSelectionPath = this.getLeadSelectionPath();
        return CustomJTree.getLastPathComponentData(currentSelectionPath);
    }

    public void expandAllRows() {
        TreePath currentlySelectedPath = this.getSelectionPath();
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i++);
        }
        if (currentlySelectedPath != null) {
            this.setSelectionPath(currentlySelectedPath);
        } else {
            this.setSelectionRow(0);
        }
    }

    protected void fireCellChecked(JMutableTreeNode cell) {
        this._treeListener.fireCellChecked(cell);
    }

    protected void fireCellUnchecked(JMutableTreeNode cell) {
        this._treeListener.fireCellUnchecked(cell);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this._trackingKeyboard && e.getKeyCode() == 27) {
            this._trackingKeyboard = false;
            this._treeListener.keyReleaseRow(this, -1);
            return;
        }
        if (e.getKeyCode() != 32) {
            super.processKeyEvent(e);
            return;
        }
        int row = this._treeCellRenderer.getLastRowWithFocus();
        if (row < 0) {
            return;
        }
        switch (e.getID()) {
            case 401: {
                if (this._trackingKeyboard) break;
                this._trackingKeyboard = true;
                this._treeListener.keyPressRow(this, row);
                break;
            }
            case 402: {
                if (!this._trackingKeyboard) break;
                this._trackingKeyboard = false;
                this._treeListener.keyReleaseRow(this, row);
                break;
            }
            case 400: {
                break;
            }
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (this._trackingKeyboard && e.getSource() == this) {
            this._trackingKeyboard = false;
            this._treeListener.keyReleaseRow(this, -1);
        }
        super.processFocusEvent(e);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this._trackingKeyboard) {
            return;
        }
        this._currentMouseEvent = e;
        super.processMouseEvent(e);
        this._currentMouseEvent = null;
    }

    public static void updateNodes(TreePath actionPath) {
        Object actionObj;
        if (actionPath != null && (actionObj = actionPath.getLastPathComponent()) instanceof JMutableTreeNode) {
            ((JMutableTreeNode)actionObj).updateNodes();
        }
    }

    public static JTreeCellData getLastPathComponentData(TreePath treePath) {
        Object pathObj = treePath.getLastPathComponent();
        return pathObj instanceof JMutableTreeNode ? ((JMutableTreeNode)pathObj).getModel() : null;
    }
}

