/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.lang.reflect.Array;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Array2Dom
implements ToDomConverter {
    public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        if (!type.isArray()) {
            return false;
        }
        Object array = wrapper.getObject();
        int arrayLength = Array.getLength(array);
        boolean namedArrayElems = o2d.isNamedArrayElems();
        if (namedArrayElems && !o2d.isIncludeNulls() && arrayLength <= 0) {
            return true;
        }
        String tag = namedArrayElems ? element.getTagName() : "Item";
        Class<?> componentType = type.getComponentType();
        String namespaceURI = element.getNamespaceURI();
        int i = 0;
        while (i < arrayLength) {
            Object item = Array.get(array, i);
            Element itemElement = o2d.toElement(item, tag, componentType, namespaceURI);
            if (itemElement != null) {
                element.appendChild(itemElement);
            }
            ++i;
        }
        return true;
    }

    public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        NodeList children;
        if (!type.isArray()) {
            return false;
        }
        boolean namedArrayElems = o2d.isNamedArrayElems();
        if (namedArrayElems) {
            String tag = element.getTagName();
            Element parent = (Element)element.getParentNode();
            children = Object2Dom.getChildrenByTagName(parent, tag);
        } else {
            children = element.getChildNodes();
        }
        int numChildren = children.getLength();
        Class<?> componentType = type.getComponentType();
        Object resultArray = Array.newInstance(componentType, numChildren);
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1) {
                Element childElement = (Element)childNode;
                Object childObj = o2d.toObject(childElement, componentType);
                Array.set(resultArray, i, childObj);
            }
            ++i;
        }
        wrapper.setObject(resultArray);
        return true;
    }

    Array2Dom() {
    }
}

