/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class File2Dom
implements ToDomConverter {
    private static final Class _fileClass = File.class;

    public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        URL documentURL;
        if (type != _fileClass) {
            return false;
        }
        File file = (File)wrapper.getObject();
        File canonicalFile = File2Dom.getCanonicalFile(file);
        URL fileURL = URLFactory.newFileURL((File)canonicalFile);
        String relativeSpec = URLFileSystem.toRelativeSpec((URL)fileURL, (URL)(documentURL = o2d.getDocumentURL()));
        if (relativeSpec == null || relativeSpec.length() == 0) {
            relativeSpec = ".";
        }
        Text text = element.getOwnerDocument().createTextNode(relativeSpec);
        element.appendChild(text);
        return true;
    }

    private static File getCanonicalFile(File file) {
        try {
            File file2 = file.getCanonicalFile();
            return file2;
        }
        catch (IOException e) {
            File absoluteFile = file.getAbsoluteFile();
            System.err.println("\n*** Warning: I/O error occurred when trying to determine the canonical path for " + absoluteFile.getPath());
            System.err.println("*** Attempting to continue.  Stack trace is:");
            e.printStackTrace();
            File file3 = absoluteFile;
            return file3;
        }
    }

    public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        if (type != _fileClass) {
            return false;
        }
        CharacterData textNode = null;
        NodeList elementChildren = element.getChildNodes();
        int elementChildrenLen = elementChildren.getLength();
        int i = 0;
        while (i < elementChildrenLen) {
            Node tempNode = elementChildren.item(i);
            if (tempNode != null && tempNode.getNodeType() == 3) {
                textNode = (Text)tempNode;
                break;
            }
            ++i;
        }
        if (textNode == null) {
            wrapper.setObject(null);
            return true;
        }
        String fileText = textNode.getData();
        if (fileText.startsWith("/")) {
            File file = new File(fileText);
            wrapper.setObject(file);
            return true;
        }
        URL documentURL = o2d.getDocumentURL();
        URL documentDir = URLFileSystem.getParent((URL)documentURL);
        URL url = URLFactory.newURL((URL)documentDir, (String)fileText);
        if (url != null) {
            String urlPath = url.getPath();
            File file = new File(urlPath);
            wrapper.setObject(file);
        } else {
            wrapper.setObject(null);
        }
        return true;
    }

    File2Dom() {
    }
}

