/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.marshal.xml.HashMapProxy;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.util.StringComparator;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Map2Dom
implements ToDomConverter {
    private static final boolean HASH_MAP_PROXY_ENABLED = Boolean.getBoolean("use.HashMapProxy");
    static final String KEY_TAG = "Key";
    static final String VALUE_TAG = "Value";
    private static final Class _stringClass = String.class;
    private static final Class _mapClass = Map.class;
    private static final Class _hashMapClass = HashMap.class;
    private static final Class _hashMapProxyClass = HashMapProxy.class;
    private final Comparator _stringComparator;

    private void $init$() {
        this._stringComparator = new StringComparator();
    }

    public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        if (!_mapClass.isAssignableFrom(type)) {
            return false;
        }
        Map map = (Map)wrapper.getObject();
        Object[] keyArray = map.keySet().toArray();
        Arrays.sort(keyArray, this._stringComparator);
        Iterator<Object> iter = Arrays.asList(keyArray).iterator();
        boolean useHashMapProxy = HASH_MAP_PROXY_ENABLED && type == _hashMapProxyClass;
        String namespaceURI = element.getNamespaceURI();
        while (iter.hasNext()) {
            Object key = iter.next();
            Element keyElement = o2d.toElement(key, KEY_TAG, _stringClass, namespaceURI);
            Document ownerDocument = element.getOwnerDocument();
            Element valueElement = this.getValueElement(useHashMapProxy, o2d, ownerDocument, map, key, namespaceURI);
            Element itemElement = ownerDocument.createElementNS(namespaceURI, "Item");
            itemElement.appendChild(keyElement);
            itemElement.appendChild(valueElement);
            element.appendChild(itemElement);
        }
        return true;
    }

    public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        if (!_mapClass.isAssignableFrom(type)) {
            return false;
        }
        boolean useHashMapProxy = HASH_MAP_PROXY_ENABLED && type == _hashMapClass;
        try {
            NodeList children = element.getChildNodes();
            int numItems = children.getLength();
            Map map = useHashMapProxy ? new HashMapProxy(o2d) : (Map)type.newInstance();
            int i = 0;
            while (i < numItems) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() == 1) {
                    Element itemElement = (Element)childNode;
                    NodeList itemKeyValuePair = itemElement.getChildNodes();
                    int numChildren = itemKeyValuePair.getLength();
                    int j = 0;
                    Element keyElement = null;
                    while (j < numChildren) {
                        Node itemChildNode = itemKeyValuePair.item(j);
                        if (itemChildNode.getNodeType() == 1) {
                            keyElement = (Element)itemChildNode;
                            ++j;
                            break;
                        }
                        ++j;
                    }
                    Element valueElement = null;
                    while (j < numChildren) {
                        Node itemChildNode = itemKeyValuePair.item(j);
                        if (itemChildNode.getNodeType() == 1) {
                            valueElement = (Element)itemChildNode;
                            break;
                        }
                        ++j;
                    }
                    Object keyObject = Map2Dom.toObject(o2d, keyElement);
                    Object valueObject = this.getValueObject(useHashMapProxy, o2d, valueElement);
                    map.put(keyObject, valueObject);
                }
                ++i;
            }
            wrapper.setObject(map);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            wrapper.setObject(null);
            boolean bl = true;
            return bl;
        }
    }

    static Object toObject(Object2Dom o2d, Element elem) {
        return o2d.toObject(elem, _stringClass);
    }

    private Object getValueObject(boolean useHashMapProxy, Object2Dom o2d, Element valueElement) {
        if (valueElement != null) {
            String classAttr = o2d.getClassAttr(valueElement);
            if (!useHashMapProxy || classAttr == null || classAttr.startsWith("java.lang")) {
                return Map2Dom.toObject(o2d, valueElement);
            }
        }
        return valueElement;
    }

    private Element getValueElement(boolean useHashMapProxy, Object2Dom o2d, Document ownerDocument, Map map, Object key, String namespaceURI) {
        Object valueObject;
        if (useHashMapProxy) {
            HashMapProxy proxy = (HashMapProxy)map;
            valueObject = proxy.superGet(key);
        } else {
            valueObject = map.get(key);
        }
        if (valueObject instanceof DocumentFragment) {
            return (Element)((DocumentFragment)valueObject).getFirstChild();
        }
        if (valueObject instanceof XMLElement) {
            return (Element)ownerDocument.importNode((Node)((XMLElement)valueObject), true);
        }
        return o2d.toElement(valueObject, VALUE_TAG, _stringClass, namespaceURI);
    }

    Map2Dom() {
        this.$init$();
    }
}

