/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.ObjectStore;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XMLObjectStore
implements ObjectStore {
    public static final String CLASS_ATTR = "class";
    public static final String NSELEM_ATTR = "nselem";
    private static final HashMap _transforms = new HashMap();

    XMLObjectStore() {
    }

    public static void registerTransform(String oldClassStr, String oldNamespaceURI, String oldLocalElemName, URL xsltURL) {
        HashMap<TransformKey, URL> classTransforms = (HashMap<TransformKey, URL>)_transforms.get(oldClassStr);
        if (classTransforms == null) {
            classTransforms = new HashMap<TransformKey, URL>();
            _transforms.put(oldClassStr, classTransforms);
        }
        classTransforms.put(new TransformKey(oldClassStr, oldNamespaceURI, oldLocalElemName), xsltURL);
    }

    Element applyTransforms(Element element, Class defaultClass, ArrayList alreadySeen) throws ClassNotFoundException {
        String nsElem;
        String namespaceURI;
        TransformKey transformKey;
        HashMap classTransformMap;
        URL xsltURL;
        String classStr = this.getClassStr(element, defaultClass);
        Object classTransformsObj = _transforms.get(classStr);
        if (!(classTransformsObj == null || (xsltURL = (URL)(classTransformMap = (HashMap)classTransformsObj).get(transformKey = new TransformKey(classStr, namespaceURI = XMLObjectStore.getNamespaceURI(element), nsElem = XMLObjectStore.getNselem(element)))) == null || alreadySeen != null && alreadySeen.contains(transformKey))) {
            try {
                XSLStylesheet style = XMLUtil.loadXSLT(xsltURL);
                Document doc = element.getOwnerDocument();
                XMLDocumentFragment frag = (XMLDocumentFragment)doc.createDocumentFragment();
                frag.appendChild(element.cloneNode(true));
                XSLProcessor xslp = new XSLProcessor();
                XMLDocumentFragment resultFrag = xslp.processXSL(style, frag);
                Element resultElem = (Element)resultFrag.getFirstChild();
                element.getParentNode().replaceChild(resultElem, element);
                ArrayList alreadySeenList = alreadySeen != null ? alreadySeen : new ArrayList();
                alreadySeenList.add(transformKey);
                Element element2 = this.applyTransforms(resultElem, defaultClass, alreadySeenList);
                return element2;
            }
            catch (Exception e) {
                this.logOtherExceptionImpl(e);
            }
        }
        return element;
    }

    void logOtherExceptionImpl(Throwable t) {
    }

    private static String getNselem(Element element) {
        Attr nsElemAttr = element.getAttributeNode(NSELEM_ATTR);
        return nsElemAttr != null ? nsElemAttr.getValue() : element.getLocalName();
    }

    private static String getNamespaceURI(Element element) {
        return ModelUtil.nullifyIfEmpty((String)element.getNamespaceURI());
    }

    private String getClassStr(Element element, Class defaultClass) {
        String classStr = ModelUtil.nullifyIfEmpty((String)element.getAttribute(CLASS_ATTR));
        return ModelUtil.hasLength((String)classStr) ? classStr : defaultClass.getName();
    }

    private static class TransformKey {
        final String classStr;
        final String namespaceURI;
        final String localElemName;
        private Integer _hashCode;

        TransformKey(String classStr, String namespaceURI, String localElemName) {
            this.classStr = classStr;
            this.namespaceURI = namespaceURI;
            this.localElemName = localElemName;
        }

        public boolean equals(Object o) {
            TransformKey other = (TransformKey)o;
            return ModelUtil.areEqual((Object)this.classStr, (Object)other.classStr) && ModelUtil.areEqual((Object)this.namespaceURI, (Object)other.namespaceURI) && ModelUtil.areEqual((Object)this.localElemName, (Object)other.localElemName);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int hcClass = this.classStr != null ? this.classStr.hashCode() : 0;
                int hcUri = this.namespaceURI != null ? this.namespaceURI.hashCode() : 0;
                int hcElem = this.localElemName != null ? this.localElemName.hashCode() : 0;
                this._hashCode = new Integer(hcClass ^ hcUri ^ hcElem);
            }
            return this._hashCode;
        }
    }
}

