/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Namespace {
    private final Map _data;
    private Namespace _parent;

    public Namespace() {
        this((Namespace)null);
    }

    public Namespace(Map data) {
        this(data == null ? new HashMap() : new HashMap(data), null);
    }

    public Namespace(Namespace parent) {
        this(new HashMap(), parent);
    }

    protected Namespace(Map data, Namespace parent) {
        this._data = data;
        this.setParent(parent != null ? parent : this);
    }

    protected Namespace(Namespace original, boolean copyDataMap) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        Map data = original.getData();
        this._data = copyDataMap ? new HashMap(data) : data;
        this.setParent(original.getParent());
    }

    public boolean isRoot() {
        return this.getParent() == this;
    }

    public Namespace getParent() {
        return this._parent;
    }

    public Namespace getRoot() {
        Namespace parent;
        Namespace ns = this;
        while (ns != (parent = ns.getParent())) {
            ns = parent;
        }
        return ns;
    }

    public boolean contains(String key) {
        return this.getData().containsKey(key);
    }

    public final <T> T find(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is null");
        }
        Object o = this.find(clazz.getName());
        return (T)o;
    }

    public final <T> T get(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is null");
        }
        Object o = this.get(clazz.getName());
        return (T)o;
    }

    public Object find(String key) {
        String translatedKey = this.translateKey(key);
        Namespace ns = this;
        while (!ns.contains(translatedKey)) {
            Namespace parent = ns.getParent();
            if (ns == parent) {
                return null;
            }
            ns = parent;
        }
        return ns.get(translatedKey);
    }

    public void findAndReplace(String key, Object data) {
        String translatedKey = this.translateKey(key);
        Namespace ns = this;
        while (true) {
            if (ns.contains(translatedKey)) {
                ns.put(translatedKey, data);
                return;
            }
            Namespace parent = ns.getParent();
            if (ns == parent) {
                ns.put(translatedKey, data);
                return;
            }
            ns = parent;
        }
    }

    public Object get(String key) {
        return this.getData().get(key);
    }

    public Object get(String[] keyPath) {
        if (keyPath == null || keyPath.length <= 0) {
            return this.get((String)null);
        }
        int n = keyPath.length - 1;
        Namespace ns = this.findNamespace(keyPath, n);
        if (ns != null) {
            String lastKey = keyPath[n];
            return ns.get(lastKey);
        }
        return null;
    }

    public void put(String key, Object data) {
        this.getData().put(key, data);
    }

    public void put(String key, Namespace ns) {
        if (ns != null) {
            ns.setParent(this);
        }
        this.put(key, (Object)ns);
    }

    public void put(String[] keyPath, Object data) {
        if (keyPath == null || keyPath.length <= 0) {
            this.put((String)null, data);
            return;
        }
        int n = keyPath.length - 1;
        Namespace ns = this.findNamespace(keyPath, n);
        if (ns != null) {
            String lastKey = keyPath[n];
            ns.put(lastKey, data);
        }
    }

    public void put(String[] keyPath, Namespace ns) {
        if (keyPath == null || keyPath.length <= 0) {
            this.put((String)null, ns);
            return;
        }
        int n = keyPath.length - 1;
        Namespace foundNs = this.findNamespace(keyPath, n);
        if (foundNs != null) {
            String lastKey = keyPath[n];
            foundNs.put(lastKey, ns);
        }
    }

    public Object remove(String key) {
        return this.getData().remove(key);
    }

    public Map toMap() {
        return new HashMap(this.getData());
    }

    protected void setParent(Namespace parent) {
        this._parent = parent;
    }

    protected Map getData() {
        return this._data;
    }

    protected String translateKey(String key) {
        return key;
    }

    private Namespace findNamespace(String[] keyPath, int n) {
        Namespace ns = this;
        int i = 0;
        while (i < n) {
            Object obj = ns.get(keyPath[i]);
            if (obj == null || obj.getClass() != Namespace.class) {
                return null;
            }
            ns = (Namespace)obj;
            ++i;
        }
        return ns;
    }
}

