/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import oracle.ide.wizard.FSMException;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMStateInfo;
import oracle.ide.wizard.FSMTransitionException;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardArb;

public final class FSM {
    static final String START_STATE = "__START_STATE__";
    static final String IS_FINAL_STATE = "__IS_FINAL_STATE__";
    static final String FSMState_OBJ = "__FSMState_OBJ__";
    static final String TRANSITIONS = "__TRANSITIONS__";
    static final String ANY_TRANS = "__*__";
    private final Map _fsmSpec;
    private boolean _starting;
    private boolean _halted;
    private int _initialStepNumber;
    private int _stepNumber;
    private int _expectedStepCount;
    private FSMStateInfo _curStateInfo;
    private int _curStateIndex;
    private Map _curTransMap;
    private FSM _curSubFsm;
    private Map _statePool;
    private Stack _history;

    FSM(Map fsmSpec) throws FSMInvalidException {
        this.$init$();
        FSM.validateFSM(fsmSpec);
        this._fsmSpec = fsmSpec;
        this._starting = true;
    }

    void reset() {
        this._starting = true;
        this._halted = false;
        this._stepNumber = this._initialStepNumber;
        this._curStateInfo = null;
        this._curStateIndex = 0;
        this._curTransMap = null;
        this._curSubFsm = null;
        this._history.clear();
        this._expectedStepCount = 0;
    }

    int getStepNumber() {
        return this._stepNumber;
    }

    boolean isStarting() {
        return this._starting;
    }

    boolean inFinalState() {
        if (this._curStateInfo == null) {
            return false;
        }
        if (!this._curStateInfo.isFinalState()) {
            return false;
        }
        if (this._curSubFsm == null) {
            return true;
        }
        return this._curSubFsm.inFinalState();
    }

    boolean isHalted() {
        return this._halted;
    }

    FSMStateInfo nextState(Object transition) throws FSMException {
        if (this._halted) {
            return null;
        }
        if (this._curSubFsm != null) {
            FSMStateInfo nextSubStateInfo = this._curSubFsm.nextState(transition);
            if (!this._curSubFsm._halted) {
                ++this._stepNumber;
                return nextSubStateInfo;
            }
            this._curStateInfo.setSubFSM(this._curSubFsm);
            this._curSubFsm = null;
            if (transition instanceof FSM) {
                throw new FSMException(WizardArb.getString(30));
            }
        }
        if (transition instanceof FSM && !this._starting) {
            this._curSubFsm = (FSM)transition;
            this._curSubFsm._initialStepNumber = this._stepNumber;
            this._curSubFsm.reset();
            return this.nextState(null);
        }
        int nextStateIndex = this._curStateIndex + 1;
        FSMStateInfo lastStateInfo = this._curStateInfo;
        FSMStateInfo nextStateInfo = null;
        if (this._starting) {
            nextStateInfo = this.gotoState(START_STATE, 1);
            this._starting = false;
        } else {
            if (this._curTransMap == null) {
                throw new FSMException(WizardArb.getString(1));
            }
            if (this._curTransMap.containsKey(transition)) {
                nextStateInfo = this.gotoState(this._curTransMap.get(transition), nextStateIndex);
            } else if (this._curTransMap.containsKey(ANY_TRANS)) {
                nextStateInfo = this.gotoState(this._curTransMap.get(ANY_TRANS), nextStateIndex);
            } else if (this._curStateInfo.isFinalState()) {
                this._halted = true;
                this._curStateIndex = nextStateIndex;
                nextStateInfo = null;
            } else {
                throw new FSMTransitionException(WizardArb.format(20, transition != null ? transition.toString() : "<null>"));
            }
        }
        this._history.push(lastStateInfo);
        ++this._stepNumber;
        return nextStateInfo;
    }

    FSMStateInfo previousState() throws FSMException {
        int prevStateIndex;
        FSMStateInfo prevStateInfo;
        if (this._starting) {
            return null;
        }
        if (this._curSubFsm != null) {
            FSMStateInfo prevSubStateInfo = this._curSubFsm.previousState();
            if (!this._curSubFsm._starting) {
                --this._stepNumber;
                return prevSubStateInfo;
            }
            this._curSubFsm = null;
            --this._stepNumber;
            return this._curStateInfo;
        }
        try {
            prevStateInfo = (FSMStateInfo)this._history.pop();
        }
        catch (EmptyStackException e) {
            throw new FSMException(WizardArb.getString(4), e);
        }
        catch (ClassCastException e) {
            throw new FSMException(WizardArb.getString(8), e);
        }
        if (this._history.empty()) {
            if (prevStateInfo != null) {
                throw new FSMException(WizardArb.getString(17));
            }
            this.reset();
            return null;
        }
        Object prevStateID = prevStateInfo.getStateID();
        FSMStateInfo prevStateInfo2 = this.gotoState(prevStateID, prevStateIndex = this._curStateIndex - 1);
        if (prevStateInfo != prevStateInfo2) {
            throw new FSMException(WizardArb.getString(25));
        }
        this._halted = false;
        FSM prevStateSubFsm = prevStateInfo.getSubFSM();
        if (prevStateSubFsm != null) {
            this._curSubFsm = prevStateSubFsm;
            prevStateInfo.setSubFSM(null);
            return this.previousState();
        }
        --this._stepNumber;
        return prevStateInfo;
    }

    private static final void validateFSM(Map fsm) throws FSMInvalidException {
        boolean hasFinalState = false;
        if (fsm == null) {
            throw new FSMInvalidException(WizardArb.getString(24));
        }
        if (!fsm.containsKey(START_STATE)) {
            throw new FSMInvalidException(WizardArb.getString(23));
        }
        for (Object stateNodeObj : fsm.values()) {
            Object stateNodeTransitions;
            if (!(stateNodeObj instanceof Map)) {
                throw new FSMInvalidException(WizardArb.getString(26));
            }
            Map stateNode = (Map)stateNodeObj;
            if (!stateNode.containsKey(FSMState_OBJ)) {
                throw new FSMInvalidException(WizardArb.getString(28));
            }
            Object stateObj = stateNode.get(FSMState_OBJ);
            if (!(stateObj instanceof Step)) {
                throw new FSMInvalidException(WizardArb.getString(11));
            }
            if (!stateNode.containsKey(TRANSITIONS)) {
                throw new FSMInvalidException(WizardArb.getString(7));
            }
            if (!hasFinalState && stateNode.containsKey(IS_FINAL_STATE)) {
                hasFinalState = true;
            }
            if (!((stateNodeTransitions = stateNode.get(TRANSITIONS)) instanceof Map)) {
                throw new FSMInvalidException(WizardArb.getString(19));
            }
            Map t = (Map)stateNodeTransitions;
            if (t.size() == 0 && !stateNode.containsKey(IS_FINAL_STATE)) {
                throw new FSMInvalidException(WizardArb.getString(6));
            }
            for (Object targetStateID : t.values()) {
                if (fsm.containsKey(targetStateID)) continue;
                throw new FSMInvalidException(WizardArb.format(12, targetStateID));
            }
        }
        if (!hasFinalState) {
            throw new FSMInvalidException(WizardArb.getString(21));
        }
    }

    int getTotalStepCount() {
        return this._fsmSpec.size();
    }

    int getExpectedStepCount() {
        if (this._expectedStepCount == 0) {
            this.countExpectedSteps();
        }
        return this._expectedStepCount;
    }

    int countExpectedSteps() {
        int upperBound = this.getTotalStepCount();
        int count = this._curStateIndex;
        int subCount = 0;
        try {
            Object stateID;
            if (this._starting) {
                stateID = START_STATE;
                ++count;
            } else {
                stateID = this._curStateInfo.getStateID();
            }
            Map stateNode = this.getStateNode(stateID);
            while (true) {
                Step curStep;
                Object transition;
                if ((transition = (curStep = FSM.getStep(stateNode)).getExpectedTransition()) instanceof FSM) {
                    FSM subFSM = (FSM)transition;
                    subCount += subFSM.countExpectedSteps();
                    FSMStateInfo subInfo = subFSM._curStateInfo;
                    Object object = transition = subInfo != null ? subInfo.getStep().getExpectedTransition() : START_STATE;
                }
                if (!FSM.isFinalState(stateNode) && count < upperBound) {
                    Map transMap = FSM.getTransitionMap(stateNode);
                    if (transMap.containsKey(transition)) {
                        stateID = transMap.get(transition);
                    } else if (transMap.containsKey(ANY_TRANS)) {
                        stateID = transMap.get(ANY_TRANS);
                    } else {
                        throw new FSMTransitionException(WizardArb.format(20, transition != null ? transition.toString() : "<null>"));
                    }
                    stateNode = this.getStateNode(stateID);
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (FSMException e) {
            e.printStackTrace();
            System.err.println("****  Possible causes for this exception:");
            System.err.println("****  -  The expected transition set in the Step is not a transition in the FSM.");
            System.err.println("****  -  A sub-FSM was used but the parent FSM state doesn't have 'null' or FSM.ANY_TRANS as one of its transitions.  When a sub-FSM halts, the next transition is always null.");
        }
        this._expectedStepCount = count + subCount;
        return this._expectedStepCount;
    }

    Map getStateNode(Object stateID) throws FSMException {
        if (this._fsmSpec.containsKey(stateID)) {
            Object stateNodeObj = this._fsmSpec.get(stateID);
            if (stateNodeObj instanceof Map) {
                return (Map)stateNodeObj;
            }
            throw new FSMException(WizardArb.format(0, stateID.toString()));
        }
        throw new FSMTransitionException(WizardArb.format(9, stateID.toString()));
    }

    private static Step getStep(Map stateNode) throws FSMException {
        if (stateNode.containsKey(FSMState_OBJ)) {
            Object fsmStateObj = stateNode.get(FSMState_OBJ);
            if (fsmStateObj instanceof Step) {
                return (Step)fsmStateObj;
            }
            throw new FSMException(WizardArb.getString(29));
        }
        throw new FSMTransitionException(WizardArb.getString(3));
    }

    static Map getTransitionMap(Map stateNode) throws FSMException {
        if (stateNode.containsKey(TRANSITIONS)) {
            Object transMapObj = stateNode.get(TRANSITIONS);
            if (transMapObj instanceof Map) {
                return (Map)transMapObj;
            }
            throw new FSMException(WizardArb.getString(15));
        }
        throw new FSMException(WizardArb.getString(10));
    }

    private static boolean isFinalState(Map stateNode) {
        return stateNode.containsKey(IS_FINAL_STATE);
    }

    private FSMStateInfo gotoState(Object stateID, int stateIndex) throws FSMException {
        FSMStateInfo fsmStateInfo;
        if (this._fsmSpec == null) {
            throw new FSMException(WizardArb.getString(24));
        }
        Map stateNode = this.getStateNode(stateID);
        Step fsmStep = FSM.getStep(stateNode);
        Map transMap = FSM.getTransitionMap(stateNode);
        boolean isFinalState = FSM.isFinalState(stateNode);
        FSMStateInfo fsmStateInfoKey = new FSMStateInfo(stateID, isFinalState, null);
        if (this._statePool.containsKey(fsmStateInfoKey)) {
            fsmStateInfo = (FSMStateInfo)this._statePool.get(fsmStateInfoKey);
        } else {
            try {
                fsmStateInfo = new FSMStateInfo(stateID, isFinalState, fsmStep);
            }
            catch (Exception e) {
                throw new FSMTransitionException(WizardArb.getString(14), e);
            }
            this._statePool.put(fsmStateInfoKey, fsmStateInfo);
        }
        this._curStateInfo = fsmStateInfo;
        this._curStateIndex = stateIndex;
        this._curTransMap = transMap;
        return fsmStateInfo;
    }

    private void $init$() {
        this._initialStepNumber = 0;
        this._statePool = new HashMap();
        this._history = new Stack();
    }
}

