/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPrintDriver;

class XMLPrinter
extends XMLPrintDriver {
    private final int _indent;
    private final boolean _useTabs;
    private final int _tabSize;
    private final Field _mixed;

    XMLPrinter(PrintWriter pw, int indent, boolean useTabs, int tabSize) {
        super(pw);
        this._indent = indent;
        this._useTabs = useTabs;
        this._tabSize = tabSize;
        this._mixed = XMLPrinter.getMixedField();
        if (this._mixed != null) {
            this.out = new XMLOut(pw);
        }
    }

    XMLPrinter(OutputStream os, int indent, boolean useTabs, int tabSize) {
        super(os);
        this._indent = indent;
        this._useTabs = useTabs;
        this._tabSize = tabSize;
        this._mixed = XMLPrinter.getMixedField();
        if (this._mixed != null) {
            this.out = new XMLOut(os);
        }
    }

    private static Field getMixedField() {
        try {
            Class<XMLOutputStream> c = XMLOutputStream.class;
            Field f = c.getDeclaredField("mixed");
            f.setAccessible(true);
            Field field = f;
            return field;
        }
        catch (Exception e) {
            Field field = null;
            return field;
        }
    }

    static Field ra$_mixed(XMLPrinter xMLPrinter) {
        return xMLPrinter._mixed;
    }

    static int ra$_indent(XMLPrinter xMLPrinter) {
        return xMLPrinter._indent;
    }

    static boolean ra$_useTabs(XMLPrinter xMLPrinter) {
        return xMLPrinter._useTabs;
    }

    static int ra$_tabSize(XMLPrinter xMLPrinter) {
        return xMLPrinter._tabSize;
    }

    private class XMLOut
    extends XMLOutputStream {
        private int _curIndent;

        private void $init$() {
            this._curIndent = 0;
        }

        XMLOut(PrintWriter pw) {
            super(pw);
            this.$init$();
        }

        XMLOut(OutputStream os) {
            super(os);
            this.$init$();
        }

        public void addIndent(int offset) {
            this._curIndent += offset;
        }

        public void writeIndent() throws IOException {
            if (this.getOutputStyle() == 1 && XMLPrinter.ra$_indent(XMLPrinter.this) > 0 && this._curIndent > 0 && this.isNotMixed()) {
                int numSpaces = this._curIndent * XMLPrinter.ra$_indent(XMLPrinter.this);
                int numTabs = 0;
                if (XMLPrinter.ra$_useTabs(XMLPrinter.this)) {
                    numTabs = numSpaces / XMLPrinter.ra$_tabSize(XMLPrinter.this);
                    numSpaces %= XMLPrinter.ra$_tabSize(XMLPrinter.this);
                }
                char[] chars = new char[numTabs + numSpaces];
                int i = 0;
                while (i < numTabs) {
                    chars[i] = 9;
                    ++i;
                }
                while (i < chars.length) {
                    chars[i] = 32;
                    ++i;
                }
                this.writeChars(new String(chars));
            }
        }

        private boolean isNotMixed() {
            try {
                boolean bl = XMLPrinter.ra$_mixed(XMLPrinter.this) != null ? XMLPrinter.ra$_mixed(XMLPrinter.this).getBoolean((Object)this) ^ true : true;
                return bl;
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
        }
    }
}

