/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.PlsqlRules;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CYK {
    public static ChomskiTuple[] rules;
    public static Set<Integer>[] singleRhsRules;
    static Proj[] doubleRhsRules;
    public static String[] allSymbols;
    public static Map<String, Integer> symbolIndexes;
    static Set<Integer> keywords;
    static boolean debug;
    public static int skipRangeSymbol;
    public static int skipRangeSymbol2;
    public static int skipRangeSymbol3;
    public static int skipRangeSymbol4;
    public static int decl_part;
    public static int dotdot_basic_decl_item_dotdot;
    public static int dotdot_later_decl_item_dotdot;
    public static int skipExpr;
    public static int orSymbol;
    public static int andSymbol;

    public static void main(String[] stringArray) throws Exception {
        System.out.println("rules = " + rules.length + ",symbols=" + allSymbols.length);
        System.out.println("'SELECT'=" + symbolIndexes.get("'SELECT'"));
        System.out.println("select_list+table_expression=" + symbolIndexes.get("select_list+table_expression"));
        String string = Util.readFile((String)"c:/raptor_trunk/db/src/oracle/dbtools/parser/test.sql");
        long l = System.currentTimeMillis();
        LinkedList<LexerToken> linkedList = LexerToken.parse(string);
        long l2 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (l2 - l));
        long l3 = Runtime.getRuntime().totalMemory();
        long l4 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l3 - l4));
        l = System.currentTimeMillis();
        Matrix matrix = CYK.initArray1(linkedList);
        l2 = System.currentTimeMillis();
        System.out.println("Init array time = " + (l2 - l));
        int n = matrix.size();
        System.out.println("size = " + n);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        l = System.currentTimeMillis();
        CYK.closure(matrix, 0, n + 1, treeMap);
        l2 = System.currentTimeMillis();
        System.out.println("Parse time = " + (l2 - l));
        System.out.println(treeMap);
        CYK.print(matrix, 0, n);
        System.out.println("^^^^^^^^^^^^^");
        int n2 = 19;
        int n3 = 23;
        l = System.currentTimeMillis();
        ParseNode parseNode = CYK.forest(n, matrix);
        l2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (l2 - l));
        l3 = Runtime.getRuntime().totalMemory();
        l4 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l3 - l4));
    }

    public static void printSelectedChomskiRules(String string) {
        System.out.println("-------------Chomsky Rules---------------");
        for (ChomskiTuple chomskiTuple : rules) {
            if (!allSymbols[chomskiTuple.head].contains(string) && !allSymbols[chomskiTuple.rhs0].contains(string) && (chomskiTuple.rhs1 <= 0 || !allSymbols[chomskiTuple.rhs1].contains(string))) continue;
            System.out.println(chomskiTuple.toString());
        }
        System.out.println("-------------------------------------");
    }

    public static void printIds() {
        System.out.println("-------------Id Rules---------------");
        for (ChomskiTuple chomskiTuple : rules) {
            for (int n : singleRhsRules[symbolIndexes.get("digits")]) {
                if (chomskiTuple.head != n) continue;
                System.out.println(chomskiTuple.toString());
            }
        }
        System.out.println("-------------------------------------");
    }

    public static Matrix initArray(List<LexerToken> list) {
        Matrix matrix = new Matrix();
        int n = 0;
        for (LexerToken lexerToken : list) {
            CYK.initArrayElement(matrix, n, lexerToken, false);
            ++n;
        }
        return matrix;
    }

    public static Matrix initArray1(List<LexerToken> list) {
        Matrix matrix = new Matrix();
        int n = 0;
        for (LexerToken lexerToken : list) {
            CYK.initArrayElement(matrix, n, lexerToken, true);
            ++n;
        }
        return matrix;
    }

    public static void initArrayElement(Matrix matrix, int n, LexerToken lexerToken, boolean bl) {
        int n2;
        Integer n3 = symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (n3 != null) {
            treeSet.addAll(singleRhsRules[n3]);
        }
        if (lexerToken.type == Token.IDENTIFIER) {
            if (!bl || n3 == null || !keywords.contains(n3)) {
                n2 = symbolIndexes.get("identifier");
                treeSet.addAll(singleRhsRules[n2]);
            }
        } else if (lexerToken.type == Token.DQUOTED_STRING) {
            n2 = symbolIndexes.get("identifier");
            treeSet.addAll(singleRhsRules[n2]);
        } else if (lexerToken.type == Token.QUOTED_STRING) {
            n2 = symbolIndexes.get("string_literal");
            treeSet.addAll(singleRhsRules[n2]);
        } else if (lexerToken.type == Token.DIGITS) {
            n2 = symbolIndexes.get("digits");
            treeSet.addAll(singleRhsRules[n2]);
        }
        int[] nArray = new int[treeSet.size()];
        int n4 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            nArray[n4++] = Util.pair((int)n5, (int)n);
        }
        matrix.put(Util.pair((int)n, (int)(n + 1)), nArray);
    }

    public static void initArrayElement(SortedMap<Integer, Set<Integer>> sortedMap, int n, int n2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.addAll(singleRhsRules[n2]);
        sortedMap.put(Util.pair((int)n, (int)(n + 1)), treeSet);
    }

    public static boolean containsAndOrSymbol(int[] nArray) {
        for (int n : nArray) {
            if (orSymbol != Util.X((int)n) && andSymbol != Util.X((int)n)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDeclItem(int[] nArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (int n : nArray) {
            if (dotdot_basic_decl_item_dotdot == Util.X((int)n)) {
                bl = true;
                continue;
            }
            if (dotdot_later_decl_item_dotdot != Util.X((int)n)) continue;
            bl2 = true;
        }
        return bl && bl2;
    }

    public static void closure(Matrix matrix, int n, int n2, Map<Integer, Integer> map) {
        for (int i = 1; i < n2; ++i) {
            block1: for (int j = i - 2; j >= n; --j) {
                int n3;
                int n4;
                Integer n5;
                if (map != null && (n5 = map.get(j)) != null) {
                    if (Visual.skipped != null) {
                        for (n4 = j; n4 > n5; --n4) {
                            Visual.skipped[n4][i] = true;
                        }
                    }
                    j = n5;
                    continue;
                }
                int n6 = Util.pair((int)j, (int)i);
                n4 = Util.pair((int)0, (int)(i + 1));
                TreeSet treeSet = new TreeSet();
                SortedMap sortedMap = matrix.subMap(n6, n4);
                Object object = sortedMap.keySet().iterator();
                while (object.hasNext()) {
                    int[] nArray;
                    n3 = object.next();
                    int n7 = Util.X((int)n3);
                    int[] nArray2 = (int[])matrix.get(Util.pair((int)j, (int)n7));
                    if (nArray2 == null || (nArray = (int[])matrix.get(Util.pair((int)n7, (int)i))) == null) continue;
                    for (int n8 : nArray2) {
                        for (int n9 : nArray) {
                            Set<Integer> set;
                            int n10 = Util.X((int)n8);
                            int n11 = Util.X((int)n9);
                            Proj proj = doubleRhsRules[n10];
                            if (proj == null || (set = proj.values[n11]) == null) continue;
                            LinkedList<Integer> linkedList = new LinkedList<Integer>();
                            for (int n12 : set) {
                                linkedList.add(Util.pair((int)n12, (int)n7));
                            }
                            treeSet.addAll(linkedList);
                        }
                    }
                }
                if (treeSet.size() <= 0) continue;
                object = new int[treeSet.size()];
                n3 = 0;
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n13 = (Integer)iterator.next();
                    object[n3++] = n13;
                }
                matrix.put(Util.pair((int)j, (int)i), object);
                if (map == null || i - 1 == j + 1) continue;
                for (Object object2 : object) {
                    int n14 = Util.X((int)object2);
                    if (n14 != skipRangeSymbol && n14 != skipRangeSymbol2 && n14 != skipRangeSymbol3 && n14 != skipRangeSymbol4 && (n14 != decl_part || !CYK.containsDeclItem((int[])object)) && (n14 != skipExpr || j <= 0 || !CYK.containsAndOrSymbol((int[])matrix.get(Util.pair((int)(j - 1), (int)j))) || !CYK.containsAndOrSymbol((int[])matrix.get(Util.pair((int)i, (int)(i + 1)))))) continue;
                    map.put(i - 1, j + 1);
                    continue block1;
                }
            }
        }
    }

    public static void recalculateRectangle(Matrix matrix, Map<Integer, Integer> map, int n, int n2, int n3) {
        for (int i = n3; i < n; ++i) {
            for (int j = n2; j >= 0; --j) {
                int n4;
                Integer n5;
                if (i == j + 1) continue;
                matrix.remove(Util.pair((int)j, (int)i));
                if (map != null && (n5 = map.get(j)) != null) {
                    j = n5;
                    continue;
                }
                int n6 = Util.pair((int)j, (int)i);
                int n7 = Util.pair((int)0, (int)(i + 1));
                TreeSet treeSet = new TreeSet();
                SortedMap sortedMap = matrix.subMap(n6, n7);
                Object object = sortedMap.keySet().iterator();
                while (object.hasNext()) {
                    int[] nArray;
                    n4 = object.next();
                    int n8 = Util.X((int)n4);
                    int[] nArray2 = (int[])matrix.get(Util.pair((int)j, (int)n8));
                    if (nArray2 == null || (nArray = (int[])matrix.get(Util.pair((int)n8, (int)i))) == null) continue;
                    for (int n9 : nArray2) {
                        for (int n10 : nArray) {
                            Set<Integer> set;
                            int n11 = Util.X((int)n9);
                            int n12 = Util.X((int)n10);
                            Proj proj = doubleRhsRules[n11];
                            if (proj == null || (set = proj.values[n12]) == null) continue;
                            LinkedList<Integer> linkedList = new LinkedList<Integer>();
                            for (int n13 : set) {
                                linkedList.add(Util.pair((int)n13, (int)n8));
                            }
                            treeSet.addAll(linkedList);
                        }
                    }
                }
                if (treeSet.size() <= 0) continue;
                object = new int[treeSet.size()];
                n4 = 0;
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n14 = (Integer)iterator.next();
                    object[n4++] = n14;
                }
                matrix.put(Util.pair((int)j, (int)i), object);
            }
        }
    }

    public static void print(Matrix matrix) {
        Iterator iterator = matrix.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            int n2 = Util.X((int)n);
            int n3 = Util.Y((int)n);
            CYK.print(matrix, n2, n3);
        }
    }

    public static void print(Matrix matrix, int n, int n2) {
        System.out.print("[" + n + "," + n2 + ")");
        int[] nArray = (int[])matrix.get(Util.pair((int)n, (int)n2));
        if (nArray == null) {
            System.out.println("- syntactically invalid code fragment");
            return;
        }
        for (int n3 : nArray) {
            int n4 = Util.X((int)n3);
            if (n4 == -1) {
                System.out.print("''");
                continue;
            }
            System.out.print("  " + allSymbols[n4]);
        }
        System.out.println();
    }

    static Set<Integer>[] filterSingleRhsRules() {
        TreeSet<Integer> treeSet;
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < allSymbols.length; ++i) {
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            treeSet2.add(i);
            treeMap.put(i, treeSet2);
        }
        for (ChomskiTuple chomskiTuple : rules) {
            if (chomskiTuple.rhs1 != -1) continue;
            treeSet = (TreeSet<Integer>)treeMap.get(chomskiTuple.rhs0);
            treeSet.add(chomskiTuple.head);
            treeMap.put(chomskiTuple.rhs0, treeSet);
        }
        boolean bl = true;
        TreeMap<Integer, TreeSet<Integer>> treeMap2 = new TreeMap<Integer, TreeSet<Integer>>();
        while (bl) {
            bl = false;
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                treeSet = new TreeSet<Integer>();
                treeSet.addAll((Collection)treeMap.get(n));
                Iterator iterator2 = ((Set)treeMap.get(n)).iterator();
                while (iterator2.hasNext()) {
                    int n2 = (Integer)iterator2.next();
                    Set set = (Set)treeMap.get(n2);
                    if (set == null) continue;
                    treeSet.addAll(set);
                }
                if (treeSet.size() > ((Set)treeMap.get(n)).size()) {
                    bl = true;
                }
                treeMap2.put(n, treeSet);
            }
            treeMap = treeMap2;
        }
        Set[] setArray = new Set[allSymbols.length];
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            setArray[n] = (Set)treeMap.get(n);
        }
        return setArray;
    }

    static Proj[] filterDoubleRhsRules() {
        Proj[] projArray = new Proj[allSymbols.length];
        for (ChomskiTuple chomskiTuple : rules) {
            Set<Integer> set;
            if (chomskiTuple.rhs1 == -1) continue;
            if (projArray[chomskiTuple.rhs0] == null) {
                projArray[chomskiTuple.rhs0] = new Proj();
            }
            if ((set = projArray[chomskiTuple.rhs0].values[chomskiTuple.rhs1]) == null) {
                set = new TreeSet<Integer>();
            }
            set.addAll(singleRhsRules[chomskiTuple.head]);
            projArray[chomskiTuple.rhs0].values[chomskiTuple.rhs1] = set;
        }
        return projArray;
    }

    protected static ChomskiTuple[] getChomskyRules(Set<RuleTuple> set) {
        Set<RuleTuple> set2 = null;
        Set<RuleTuple> set3 = set;
        while ((set3 = CYK.eliminateEmptyProduction(set2 = set3)) != null) {
        }
        return CYK.convertToChomskyRules(set2);
    }

    static Set<RuleTuple> eliminateEmptyProduction(Set<RuleTuple> set) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        String string = null;
        for (RuleTuple ruleTuple : set) {
            if (ruleTuple.rhs.length != 0) continue;
            string = ruleTuple.head;
            break;
        }
        if (string == null) {
            return null;
        }
        for (RuleTuple ruleTuple : set) {
            String[] stringArray;
            int n;
            if (ruleTuple.head.equals(string) && ruleTuple.rhs.length == 0) continue;
            treeSet.add(ruleTuple);
            int n2 = 0;
            for (n = 0; n < ruleTuple.rhs.length; ++n) {
                if (!string.equals(ruleTuple.rhs[n])) continue;
                ++n2;
            }
            if (n2 == 1) {
                for (n = 0; n < ruleTuple.rhs.length; ++n) {
                    if (!string.equals(ruleTuple.rhs[n])) continue;
                    stringArray = new String[ruleTuple.rhs.length - 1];
                    for (int i = 0; i < ruleTuple.rhs.length - 1; ++i) {
                        if (i < n) {
                            stringArray[i] = ruleTuple.rhs[i];
                            continue;
                        }
                        if (i < n) continue;
                        stringArray[i] = ruleTuple.rhs[i + 1];
                    }
                    treeSet.add(new RuleTuple(ruleTuple.head, stringArray));
                }
                continue;
            }
            if (n2 == 2) {
                if (ruleTuple.rhs.length == 2) continue;
                String[] stringArray2 = new String[ruleTuple.rhs.length - 1];
                stringArray = new String[ruleTuple.rhs.length - 1];
                String[] stringArray3 = new String[ruleTuple.rhs.length - 2];
                int n3 = 0;
                for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                    if (string.equals(ruleTuple.rhs[i])) {
                        if (n3 == 0) {
                            stringArray[i] = ruleTuple.rhs[i];
                        } else if (n3 == 1) {
                            stringArray2[i - 1] = ruleTuple.rhs[i];
                        }
                        ++n3;
                        continue;
                    }
                    stringArray2[i - (n3 > 0 ? 1 : 0)] = ruleTuple.rhs[i];
                    stringArray[i - (n3 > 1 ? 1 : 0)] = ruleTuple.rhs[i];
                    stringArray3[i - n3] = ruleTuple.rhs[i];
                }
                treeSet.add(new RuleTuple(ruleTuple.head, stringArray2));
                treeSet.add(new RuleTuple(ruleTuple.head, stringArray));
                treeSet.add(new RuleTuple(ruleTuple.head, stringArray3));
                continue;
            }
            if (n2 <= 2) continue;
            throw new RuntimeException("countEmptySymbols > 2 " + ruleTuple.toString());
        }
        return treeSet;
    }

    private static ChomskiTuple[] convertToChomskyRules(Set<RuleTuple> set) {
        Set<RuleTuple> set2 = CYK.extractBinaryRules(set);
        ChomskiTuple[] chomskiTupleArray = new ChomskiTuple[set2.size()];
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        for (RuleTuple serializable2 : set2) {
            if (serializable2.head == null || serializable2.rhs[0] == null || serializable2.rhs.length > 1 && serializable2.rhs[1] == null) {
                throw new RuntimeException("ct has null symbols");
            }
            treeSet.add(serializable2.head);
            treeSet.add(serializable2.rhs[0]);
            if (serializable2.rhs.length > 1) {
                treeSet.add(serializable2.rhs[1]);
            }
            if (serializable2.rhs.length <= 2) continue;
            throw new RuntimeException("ct.rhs.length > 2");
        }
        allSymbols = new String[treeSet.size() + 1];
        symbolIndexes = new TreeMap<String, Integer>();
        int n2 = 0;
        symbolIndexes.put("exec", n2);
        CYK.allSymbols[n2] = "exec";
        treeSet.remove("exec");
        ++n2;
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (String string : treeSet) {
            if (string.contains("+") || string.charAt(0) == '.') continue;
            symbolIndexes.put(string, n2);
            CYK.allSymbols[n2] = string;
            treeSet2.add(string);
            ++n2;
        }
        treeSet.removeAll(treeSet2);
        TreeSet<String> treeSet3 = new TreeSet<String>();
        for (String string : treeSet) {
            if (string.contains("+")) continue;
            symbolIndexes.put(string, n2);
            CYK.allSymbols[n2] = string;
            treeSet3.add(string);
            ++n2;
        }
        treeSet.removeAll(treeSet3);
        TreeSet<String> treeSet4 = new TreeSet<String>();
        for (String string : treeSet) {
            symbolIndexes.put(string, n2);
            CYK.allSymbols[n2] = string;
            treeSet4.add(string);
            ++n2;
        }
        treeSet.removeAll(treeSet4);
        symbolIndexes.put("identifier", n2);
        CYK.allSymbols[n2] = "identifier";
        ++n2;
        n = 0;
        for (RuleTuple ruleTuple : set2) {
            chomskiTupleArray[n++] = new ChomskiTuple(symbolIndexes.get(ruleTuple.head), symbolIndexes.get(ruleTuple.rhs[0]), ruleTuple.rhs.length > 1 ? symbolIndexes.get(ruleTuple.rhs[1]) : -1);
        }
        return chomskiTupleArray;
    }

    static Set<RuleTuple> split(RuleTuple ruleTuple) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        if (ruleTuple.rhs.length == 0) {
            throw new RuntimeException("Empty Rule!");
        }
        if (ruleTuple.rhs.length == 1 || ruleTuple.rhs.length == 2) {
            treeSet.add(ruleTuple);
        } else {
            int n = ruleTuple.rhs.length / 2;
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                arrayList.add(ruleTuple.rhs[i]);
                if (i > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(ruleTuple.rhs[i]);
            }
            if (n > 1) {
                treeSet.addAll(CYK.split(new RuleTuple(stringBuffer.toString(), arrayList)));
            }
            arrayList = new ArrayList();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = n; i < ruleTuple.rhs.length; ++i) {
                arrayList.add(ruleTuple.rhs[i]);
                if (i > n) {
                    stringBuffer2.append('+');
                }
                stringBuffer2.append(ruleTuple.rhs[i]);
            }
            if (n < ruleTuple.rhs.length) {
                treeSet.addAll(CYK.split(new RuleTuple(stringBuffer2.toString(), arrayList)));
            }
            treeSet.add(new RuleTuple(ruleTuple.head, new String[]{stringBuffer.toString(), stringBuffer2.toString()}));
        }
        return treeSet;
    }

    private static Set<RuleTuple> extractBinaryRules(Set<RuleTuple> set) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (RuleTuple ruleTuple : set) {
            treeSet.addAll(CYK.split(ruleTuple));
        }
        return treeSet;
    }

    static void unitTest() {
        Set<RuleTuple> set = new TreeSet<RuleTuple>();
        set.add(new RuleTuple(".else.", new String[]{"'ELSE'"}));
        set.add(new RuleTuple(".else.", new String[0]));
        set.add(new RuleTuple("e", new String[]{"'IF'", "'THEN'", ".else.", "'END'"}));
        for (RuleTuple ruleTuple : set) {
            System.out.println(ruleTuple.toString());
        }
        System.out.println("-------------------------------------");
        set = CYK.eliminateEmptyProduction(set);
        for (RuleTuple ruleTuple : set) {
            System.out.println(ruleTuple.toString());
        }
        System.out.println("======================================");
        rules = CYK.getChomskyRules(set);
        singleRhsRules = CYK.filterSingleRhsRules();
        doubleRhsRules = CYK.filterDoubleRhsRules();
        for (Iterator<Object> iterator : allSymbols) {
            System.out.println((String)((Object)iterator));
        }
        System.out.println("+++++++++++++++++++++++++++++++++++++");
        for (Iterator<Object> iterator : rules) {
            System.out.println(((ChomskiTuple)((Object)iterator)).toString());
        }
        System.out.println("-------------------------------------");
    }

    public static ParseNode parseInterval(int n, int n2, int n3, Matrix matrix) {
        int n4 = Util.X((int)n3);
        if (n + 1 == n2) {
            return new ParseNode(n, n2, n4, n4);
        }
        int n5 = Util.Y((int)n3);
        int[] nArray = (int[])matrix.get(Util.pair((int)n, (int)n5));
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = (int[])matrix.get(Util.pair((int)n5, (int)n2));
        if (nArray2 == null) {
            return null;
        }
        for (int n6 : nArray) {
            for (int n7 : nArray2) {
                Set<Integer> set;
                int n8 = Util.X((int)n6);
                int n9 = Util.X((int)n7);
                Proj proj = doubleRhsRules[n8];
                if (proj == null || (set = proj.values[n9]) == null || !set.contains(n4)) continue;
                ParseNode parseNode = null;
                for (ChomskiTuple chomskiTuple : rules) {
                    if (chomskiTuple.rhs0 != n8 || chomskiTuple.rhs1 != n9 || !singleRhsRules[chomskiTuple.head].contains(n4)) continue;
                    parseNode = new ParseNode(n, n2, chomskiTuple.head, -1);
                    parseNode.lft = CYK.parseInterval(n, n5, n6, matrix);
                    if (parseNode.lft == null) continue;
                    parseNode.lft.payloadOut = chomskiTuple.rhs0;
                    parseNode.rgt = CYK.parseInterval(n5, n2, n7, matrix);
                    if (parseNode.rgt == null) continue;
                    parseNode.rgt.payloadOut = chomskiTuple.rhs1;
                    return parseNode;
                }
            }
        }
        return null;
    }

    public static ParseNode forest(int n, Matrix matrix) {
        TreeSet<ParseNode> treeSet;
        Object object;
        if (matrix.get(Util.pair((int)0, (int)n)) != null) {
            object = null;
            treeSet = (TreeSet<ParseNode>)((int[])matrix.get(Util.pair((int)0, (int)n)));
            for (Object object2 : treeSet) {
                object = CYK.parseInterval(0, n, (int)object2, matrix);
                if (object == null) continue;
                return object;
            }
        }
        object = new ArrayList();
        treeSet = matrix.keySet().iterator();
        while (treeSet.hasNext()) {
            int n2 = (Integer)treeSet.next();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                if (Util.X((int)n2) <= Util.X((int)n5) && Util.Y((int)n2) > Util.Y((int)n5) || Util.X((int)n2) < Util.X((int)n5) && Util.Y((int)n2) >= Util.Y((int)n5)) {
                    arrayList.add(n5);
                }
                if ((Util.X((int)n2) < Util.X((int)n5) || Util.Y((int)n2) >= Util.Y((int)n5)) && (Util.X((int)n2) <= Util.X((int)n5) || Util.Y((int)n2) > Util.Y((int)n5))) continue;
                n3 = 1;
                break;
            }
            for (Integer n4 : arrayList) {
                object.remove(n4);
            }
            if (n3 != 0) continue;
            object.add(n2);
        }
        treeSet = new TreeSet<ParseNode>();
        Object object3 = object.iterator();
        block4: while (object3.hasNext()) {
            Integer n6 = (Integer)object3.next();
            ParseNode parseNode = null;
            int[] nArray = (int[])matrix.get(n6);
            if (nArray == null) continue;
            for (int n5 : nArray) {
                parseNode = CYK.parseInterval(Util.X((int)n6), Util.Y((int)n6), n5, matrix);
                if (parseNode == null) continue;
                treeSet.add(parseNode);
                continue block4;
            }
        }
        object3 = new ParseNode(0, n, -1, -1);
        ((ParseNode)object3).topLevel = treeSet;
        return object3;
    }

    public static int[] toArray(Set<Integer> set) {
        int[] nArray = new int[set.size()];
        int n = 0;
        for (int n2 : set) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    static {
        keywords = new TreeSet<Integer>();
        debug = true;
        skipRangeSymbol = -1;
        skipRangeSymbol2 = -1;
        skipRangeSymbol3 = -1;
        skipRangeSymbol4 = -1;
        decl_part = -1;
        dotdot_basic_decl_item_dotdot = -1;
        dotdot_later_decl_item_dotdot = -1;
        skipExpr = -1;
        orSymbol = -1;
        andSymbol = -1;
        try {
            Set<RuleTuple> set = PlsqlRules.getRules();
            rules = CYK.getChomskyRules(set);
        }
        catch (Exception exception) {
            Logger.getLogger(CYK.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        singleRhsRules = CYK.filterSingleRhsRules();
        doubleRhsRules = CYK.filterDoubleRhsRules();
        keywords.add(symbolIndexes.get("'IF'"));
        keywords.add(symbolIndexes.get("'BEGIN'"));
        keywords.add(symbolIndexes.get("'END'"));
        keywords.add(symbolIndexes.get("'ELSE'"));
        keywords.add(symbolIndexes.get("'THEN'"));
        keywords.add(symbolIndexes.get("'ELSIF'"));
        keywords.add(symbolIndexes.get("'CHAR'"));
        keywords.add(symbolIndexes.get("'SELECT'"));
        keywords.add(symbolIndexes.get("'FROM'"));
        keywords.add(symbolIndexes.get("'WHERE'"));
        keywords.add(symbolIndexes.get("'AND'"));
        keywords.add(symbolIndexes.get("'NOT'"));
        keywords.add(symbolIndexes.get("'PROCEDURE'"));
        keywords.add(symbolIndexes.get("'IS'"));
        keywords.add(symbolIndexes.get("'AS'"));
        keywords.add(symbolIndexes.get("'EXCEPTION'"));
        keywords.add(symbolIndexes.get("'IN'"));
        keywords.add(symbolIndexes.get("'RETURN'"));
        keywords.add(symbolIndexes.get("'NULL'"));
        skipRangeSymbol = symbolIndexes.get("body");
        skipRangeSymbol2 = symbolIndexes.get("stmt");
        skipRangeSymbol3 = symbolIndexes.get("fml_part");
        skipRangeSymbol4 = symbolIndexes.get("plain_subquery");
        dotdot_later_decl_item_dotdot = symbolIndexes.get("..later_decl_item..");
        dotdot_basic_decl_item_dotdot = symbolIndexes.get("..basic_decl_item..");
        decl_part = symbolIndexes.get("decl_part");
        skipExpr = symbolIndexes.get("expr");
        andSymbol = symbolIndexes.get("'AND'");
        orSymbol = symbolIndexes.get("'OR'");
    }

    static class Proj {
        Set<Integer>[] values = new Set[allSymbols.length];

        Proj() {
        }
    }

    public static class ChomskiTuple
    implements Comparable {
        public int head;
        public int rhs0;
        public int rhs1;

        public ChomskiTuple(int n, int n2, int n3) {
            this.head = n;
            this.rhs0 = n2;
            this.rhs1 = n3;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconssitent with equals");
        }

        public int compareTo(Object object) {
            ChomskiTuple chomskiTuple = (ChomskiTuple)object;
            if (this.head == 0 || chomskiTuple.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int n = this.head - chomskiTuple.head;
            if (n != 0) {
                return n;
            }
            n = this.rhs0 - chomskiTuple.rhs0;
            if (n != 0) {
                return n;
            }
            return this.rhs1 - chomskiTuple.rhs1;
        }

        public String toString() {
            if (this.rhs1 == -1) {
                return allSymbols[this.head] + ": " + allSymbols[this.rhs0] + ";";
            }
            return allSymbols[this.head] + ": " + allSymbols[this.rhs0] + "  " + allSymbols[this.rhs1] + ";";
        }
    }
}

