/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeCompleter {
    public List<LexerToken> fragment;
    public Matrix matrix;
    public ParseNode root;
    public Set<Integer> symbols;
    private static Set<Integer>[] startingSymbolsMap = null;
    private static Set<Integer> allSymbols = null;
    private static Set<Integer> allKeywords = null;
    static final int identifier = CYK.symbolIndexes.get("identifier");
    private static Set<Integer> allKeywordsPlusId = null;
    private static Set<Integer> allOperations = null;

    public void shiftUpperTriangle(int n) {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        arrayList.addAll(this.fragment);
        arrayList.remove(n);
        this.fragment = arrayList;
        Matrix matrix = new Matrix();
        for (Integer n2 : this.matrix.keySet()) {
            int n3 = Util.X((int)n2);
            int n4 = Util.Y((int)n2);
            if (n4 <= n) {
                matrix.put(n2, this.matrix.get(n2));
            }
            if (n >= n3) continue;
            int n5 = Util.pair((int)(n3 - 1), (int)(n4 - 1));
            int[] nArray = (int[])this.matrix.get(n2);
            for (int i = 0; i < nArray.length; ++i) {
                int n6 = nArray[i];
                nArray[i] = Util.pair((int)Util.X((int)n6), (int)(Util.Y((int)n6) - 1));
            }
            matrix.put(n5, nArray);
        }
        this.matrix = matrix;
    }

    public void evaluate(int n) {
        long l = System.currentTimeMillis();
        CYK.closure(this.matrix, 0, this.fragment.size() + 1, null);
        this.root = CYK.forest(this.fragment.size(), this.matrix);
        this.symbols = CodeCompleter.validatedSymbolsAtPos(n, this.matrix);
        long l2 = System.currentTimeMillis();
        System.out.println("Parse time = " + (l2 - l));
    }

    public void reduce(int n) {
        long l = System.currentTimeMillis();
        this.shiftUpperTriangle(n);
        CYK.recalculateRectangle(this.matrix, null, this.fragment.size() + 1, n, n + 1);
        this.root = CYK.forest(this.fragment.size(), this.matrix);
        this.symbols = CodeCompleter.validatedSymbolsAtPos(n, this.matrix);
        long l2 = System.currentTimeMillis();
        System.out.println("Incremental Parse time = " + (l2 - l));
    }

    public static int maxCover(ParseNode parseNode, int n) {
        if (parseNode.isAuxiliary()) {
            int n2 = Util.pair((int)n, (int)n);
            for (ParseNode parseNode2 : parseNode.children()) {
                if (parseNode2.from > n || n >= parseNode2.to) continue;
                n2 = Util.pair((int)parseNode2.from, (int)parseNode2.to);
                break;
            }
            return n2;
        }
        return Util.pair((int)parseNode.from, (int)parseNode.to);
    }

    public static int weightedLength(int n, int n2, int n3) {
        return n3 - n2 + (n2 - n) * (n2 - n);
    }

    public int weightedLength(int n) {
        int n2 = CodeCompleter.maxCover(this.root, n);
        return CodeCompleter.weightedLength(Util.X((int)n2), n, Util.Y((int)n2));
    }

    public static boolean containsAuxiliary(Set<Integer> set) {
        boolean bl = false;
        for (Integer n : set) {
            if (!CodeCompleter.isAuxiliary(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static Set<Integer> validatedSymbolsAtPos(int n, Matrix matrix) {
        Set<SymbolAtCell> set = CodeCompleter.cover(n, matrix);
        TreeSet<SymbolAtCell> treeSet = new TreeSet<SymbolAtCell>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        while (true) {
            for (SymbolAtCell symbolAtCell : set) {
                int n2;
                int n3 = Util.X((int)symbolAtCell.interval);
                if (n3 + 1 == (n2 = Util.Y((int)symbolAtCell.interval))) {
                    for (int i = 0; i < CYK.singleRhsRules.length; ++i) {
                        if (!CYK.singleRhsRules[i].contains(symbolAtCell.symbol)) continue;
                        treeSet2.add(i);
                    }
                    continue;
                }
                for (int n4 : (int[])matrix.get(symbolAtCell.interval)) {
                    int n5 = Util.X((int)n4);
                    if (n5 != symbolAtCell.symbol) continue;
                    int n6 = Util.Y((int)n4);
                    for (int n7 : (int[])matrix.get(Util.pair((int)n3, (int)n6))) {
                        for (int n8 : (int[])matrix.get(Util.pair((int)n6, (int)n2))) {
                            Set<Integer> set2;
                            int n9 = Util.X((int)n7);
                            int n10 = Util.X((int)n8);
                            CYK.Proj proj = CYK.doubleRhsRules[n9];
                            if (proj == null || (set2 = proj.values[n10]) == null || !set2.contains(n5)) continue;
                            if (n6 <= n) {
                                treeSet.add(new SymbolAtCell(Util.pair((int)n6, (int)n2), n10));
                                continue;
                            }
                            treeSet.add(new SymbolAtCell(Util.pair((int)n3, (int)n6), n9));
                        }
                    }
                }
            }
            if (treeSet.size() == 0) {
                return treeSet2;
            }
            set = treeSet;
            treeSet = new TreeSet();
        }
    }

    private static Set<SymbolAtCell> cover(int n, Matrix matrix) {
        int n2;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Object object = matrix.keySet().iterator();
        while (object.hasNext()) {
            n2 = (Integer)object.next();
            if (n < Util.X((int)n2) || Util.Y((int)n2) <= n) continue;
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (Util.X((int)n2) <= Util.X((int)n3) && Util.Y((int)n2) > Util.Y((int)n3) || Util.X((int)n2) < Util.X((int)n3) && Util.Y((int)n2) >= Util.Y((int)n3)) {
                    arrayList.add(n3);
                }
                if ((Util.X((int)n2) < Util.X((int)n3) || Util.Y((int)n2) >= Util.Y((int)n3)) && (Util.X((int)n2) <= Util.X((int)n3) || Util.Y((int)n2) > Util.Y((int)n3))) continue;
                bl = true;
                break;
            }
            treeSet.removeAll(arrayList);
            if (bl) continue;
            treeSet.add(n2);
        }
        object = new TreeSet();
        n2 = 0;
        for (Integer n4 : treeSet) {
            if (Util.Y((int)n4) - Util.X((int)n4) <= n2) continue;
            n2 = Util.Y((int)n4) - Util.X((int)n4);
        }
        for (Integer n5 : treeSet) {
            int[] nArray;
            if (Util.Y((int)n5) - Util.X((int)n5) < n2) continue;
            boolean bl = false;
            for (int n6 : nArray = (int[])matrix.get(n5)) {
                if (CodeCompleter.isAuxiliary(Util.X((int)n6))) continue;
                bl = true;
            }
            for (int n6 : nArray) {
                if (bl && CodeCompleter.isAuxiliary(Util.X((int)n6))) continue;
                object.add(new SymbolAtCell(n5, Util.X((int)n6)));
            }
        }
        return object;
    }

    private static boolean isAuxiliary(int n) {
        return CYK.allSymbols[n].indexOf(43) >= 0;
    }

    public static Set<Integer> startingSymbols(int n) {
        if (startingSymbolsMap == null) {
            startingSymbolsMap = CodeCompleter.startingSymbols();
        }
        return startingSymbolsMap[n];
    }

    public static Set<String> startingKeywords(int n) {
        Set<Integer> set = CodeCompleter.startingSymbols(n);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int n2 : set) {
            String string = CYK.allSymbols[n2];
            if (string.charAt(0) != '\'' || string.lastIndexOf(43) > 1) continue;
            treeSet.add(string.substring(1, string.length() - 1));
        }
        return treeSet;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<Integer>[] startingSymbols() {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (int i = 0; i < CYK.allSymbols.length; ++i) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(i);
            treeMap.put(i, treeSet);
        }
        for (CYK.ChomskiTuple chomskiTuple : CYK.rules) {
            void treeSet;
            Set set = (Set)treeMap.get(chomskiTuple.head);
            if (set == null) {
                TreeSet treeSet2 = new TreeSet();
            }
            treeSet.add(chomskiTuple.rhs0);
            treeMap.put(chomskiTuple.head, treeSet);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (CYK.ChomskiTuple chomskiTuple : CYK.rules) {
                Set set;
                TreeSet treeSet = new TreeSet();
                Set set2 = (Set)treeMap.get(chomskiTuple.rhs0);
                if (set2 != null) {
                    treeSet.addAll(set2);
                }
                if ((set = (Set)treeMap.get(chomskiTuple.head)) != null) {
                    treeSet.addAll(set);
                }
                if (set2 != null && set != null && treeSet.size() > set.size()) {
                    bl = true;
                }
                treeMap.put(chomskiTuple.head, treeSet);
            }
        }
        Set[] setArray = new Set[CYK.allSymbols.length];
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            setArray[n] = (Set)treeMap.get(n);
        }
        return setArray;
    }

    public static Set<Integer> allSymbols() {
        if (allSymbols != null) {
            return allSymbols;
        }
        allSymbols = new TreeSet<Integer>();
        for (int i = 0; i < CYK.allSymbols.length; ++i) {
            allSymbols.add(i);
        }
        return allSymbols;
    }

    public static Set<Integer> allKeywords() {
        if (allKeywords != null) {
            return allKeywords;
        }
        allKeywords = new TreeSet<Integer>();
        for (int i = 0; i < CYK.allSymbols.length; ++i) {
            String string = CYK.allSymbols[i];
            if (string.charAt(0) != '\'' || string.lastIndexOf(43) > 1) continue;
            allKeywords.addAll(CYK.singleRhsRules[i]);
        }
        return allKeywords;
    }

    public static Set<Integer> allKeywordsPlusId() {
        if (allKeywordsPlusId != null) {
            return allKeywordsPlusId;
        }
        allKeywordsPlusId = new TreeSet<Integer>();
        for (int i = 0; i < CYK.allSymbols.length; ++i) {
            String string = CYK.allSymbols[i];
            if ((string.charAt(0) != '\'' || string.lastIndexOf(43) > 1) && i != identifier) continue;
            allKeywordsPlusId.addAll(CYK.singleRhsRules[i]);
        }
        return allKeywordsPlusId;
    }

    public static Set<Integer> allKeywordsPlusId(String string) {
        if ("".equals(string)) {
            return CodeCompleter.allKeywordsPlusId();
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int n : CodeCompleter.allKeywordsPlusId()) {
            if (CYK.allSymbols[n].startsWith("'") && !CYK.allSymbols[n].startsWith("'" + string)) continue;
            treeSet.add(n);
        }
        return treeSet;
    }

    public static Set<Integer> allOperations() {
        if (allOperations != null) {
            return allOperations;
        }
        allOperations = new TreeSet<Integer>();
        for (int i = 0; i < CYK.allSymbols.length; ++i) {
            String string = CYK.allSymbols[i];
            if (string.charAt(0) != '\'' || string.lastIndexOf(43) > 1 || string.length() > 3 || Character.isLetter(string.charAt(1))) continue;
            allOperations.addAll(CYK.singleRhsRules[i]);
        }
        return allOperations;
    }

    private static class SymbolAtCell
    implements Comparable {
        int interval;
        int symbol;

        SymbolAtCell(int n, int n2) {
            this.interval = n;
            this.symbol = n2;
        }

        public int compareTo(Object object) {
            SymbolAtCell symbolAtCell = (SymbolAtCell)object;
            if (symbolAtCell.interval != this.interval) {
                return this.interval - symbolAtCell.interval;
            }
            return this.symbol - symbolAtCell.symbol;
        }

        public String toString() {
            return CYK.allSymbols[this.symbol] + "[" + Util.X((int)this.interval) + "," + Util.Y((int)this.interval) + ")";
        }
    }
}

