/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;

    public LexerToken(CharSequence charSequence, int n, int n2, Token token) {
        this.content = ((Object)charSequence).toString();
        this.begin = n;
        this.end = n2;
        this.type = token;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return "[" + this.begin + "," + this.end + ") " + this.content + "   <" + (Object)((Object)this.type) + ">";
    }

    public static void print(List<LexerToken> list) {
        int n = 0;
        for (LexerToken lexerToken : list) {
            System.out.print(n + "    ");
            lexerToken.print();
            ++n;
        }
    }

    public static void print(List<LexerToken> list, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            System.out.print(" " + list.get((int)i).content);
        }
        System.out.println();
    }

    public static LinkedList<LexerToken> tokenize(String string) {
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()^-|!*+./><='\",;:%@ \n\r\t", true);
        long l = System.currentTimeMillis();
        StringBuffer[] stringBufferArray = new StringBuffer[2];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n += string2.length();
            LexerToken lexerToken = null;
            if (linkedList.size() > 0) {
                lexerToken = linkedList.get(linkedList.size() - 1);
            }
            if (lexerToken != null && lexerToken.type == Token.COMMENT && (!lexerToken.content.endsWith("*/") || lexerToken.content.equals("/*/"))) {
                lexerToken.content = "*".equals(string2) || "/".equals(string2) ? lexerToken.content + string2 : "/* ... ";
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.COMMENT && lexerToken.content.endsWith("*/") && !lexerToken.content.equals("/*/")) {
                lexerToken.end = n - string2.length();
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && !"\n".equals(string2)) {
                lexerToken.content = lexerToken.content + string2;
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && "\n".equals(string2)) {
                lexerToken.end = n - string2.length();
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
            }
            if (!(lexerToken == null || lexerToken.type != Token.QUOTED_STRING || "'".equals(string2) || lexerToken.content.endsWith("'") && lexerToken.content.length() > 1)) {
                lexerToken.content = lexerToken.content + string2;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.QUOTED_STRING && "'".equals(string2) && (!lexerToken.content.endsWith("'") || lexerToken.content.length() <= 1)) {
                lexerToken.content = lexerToken.content + string2;
                lexerToken.end = n;
                continue;
            }
            if (!(lexerToken == null || lexerToken.type != Token.DQUOTED_STRING || "\"".equals(string2) || lexerToken.content.endsWith("\"") && lexerToken.content.length() > 1)) {
                lexerToken.content = lexerToken.content + string2;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.DQUOTED_STRING && "\"".equals(string2)) {
                lexerToken.content = lexerToken.content + string2;
                lexerToken.end = n;
                continue;
            }
            if ("*".equals(string2) && lexerToken != null && "/".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string2;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                lexerToken.type = Token.COMMENT;
                continue;
            }
            if ("-".equals(string2) && lexerToken != null && "-".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string2;
                lexerToken.type = Token.LINE_COMMENT;
                continue;
            }
            if ("'".equals(string2)) {
                linkedList.add(new LexerToken(string2, n - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if ("\"".equals(string2)) {
                linkedList.add(new LexerToken(string2, n - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if ("()^-|!*+./><='\",;:%@".contains(string2)) {
                linkedList.add(new LexerToken(string2, n - 1, n, Token.OPERATION));
                continue;
            }
            if (" \n\r\t".contains(string2)) {
                linkedList.add(new LexerToken(string2, n - 1, n, Token.WS));
                continue;
            }
            if ('0' <= string2.charAt(0) && string2.charAt(0) <= '9') {
                linkedList.add(new LexerToken(string2, n - string2.length(), n, Token.DIGITS));
                continue;
            }
            linkedList.add(new LexerToken(string2, n - string2.length(), n, Token.IDENTIFIER));
        }
        return linkedList;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "  3.5 /* ** / -- ' ' \" \" */\n'/* */'\"/*--*/\"   abc\n'Cannot find the key_id for key: \"'||p_key_name||'\" for table \"'||";
        LinkedList<LexerToken> linkedList = LexerToken.parse(string, true);
        LexerToken.print(linkedList);
    }

    public static LinkedList<LexerToken> parse(String string) {
        return LexerToken.parse(string, false);
    }

    public static LinkedList<LexerToken> parse(String string, boolean bl) {
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        LexerToken lexerToken = null;
        for (LexerToken lexerToken2 : LexerToken.tokenize(string)) {
            if (lexerToken2.type == Token.QUOTED_STRING && lexerToken != null && lexerToken.type == Token.QUOTED_STRING) {
                lexerToken.content = lexerToken.content + lexerToken2.content;
                lexerToken.end = lexerToken2.end;
                continue;
            }
            if (bl || lexerToken2.type != Token.WS && lexerToken2.type != Token.COMMENT && lexerToken2.type != Token.LINE_COMMENT) {
                linkedList.add(lexerToken2);
            }
            lexerToken = lexerToken2;
        }
        return linkedList;
    }
}

