/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.proformatter.ConfigPanelData;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public final class AlignmentAndIndentationPanel
extends DefaultTraversablePanel {
    public static final long serialVersionUID = 1691L;
    public static final String TITLE = "Alignment and Indentation";
    private JLabel jLabel1;
    private JCheckBox alignmentAsCheckbox;
    private JCheckBox alignmentCommaCheckbox;
    private JCheckBox alignmentCommentCheckbox;
    private JCheckBox alignmentConcatCheckbox;
    private JCheckBox alignmentDeclarationCheckbox;
    private JCheckBox alignmentEqualCheckbox;
    private JCheckBox alignmentKeywordCheckbox;
    private JCheckBox alignmentOperatorCheckbox;
    private JPanel alignmentOptionPanel;
    private JCheckBox andOrIndentionCheckbox;
    private JCheckBox doubleIndentionCheckbox;
    private JLabel numSpacesLabel;
    private JLabel numSpacesLabel1;
    private JComboBox numSpaceschoice;
    private JCheckBox useTabCheckbox;
    private JLabel jLabel6;

    public AlignmentAndIndentationPanel() {
        this.setHelpID("f1_idedidesetproformat_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public Color getColor() {
        new ConfigPanelData();
        return ConfigPanelData.getColor();
    }

    private void load(ConfigProFormat configProFormat) {
        this.numSpaceschoice.setSelectedItem(configProFormat.getNumSpaces());
        this.doubleIndentionCheckbox.setSelected(configProFormat.isDoubleIndent());
        this.andOrIndentionCheckbox.setSelected(configProFormat.isIndentAndOr());
        this.useTabCheckbox.setSelected(configProFormat.isUseTabCheckboxOpt());
        this.alignmentEqualCheckbox.setSelected(configProFormat.isAlignEqual());
        this.alignmentOperatorCheckbox.setSelected(configProFormat.isAlignOperator());
        this.alignmentKeywordCheckbox.setSelected(configProFormat.isAlignKeyword());
        this.alignmentAsCheckbox.setSelected(configProFormat.isAlignOnAs());
        this.alignmentCommentCheckbox.setSelected(configProFormat.isAlignComment());
        this.alignmentDeclarationCheckbox.setSelected(configProFormat.isAlignDecl());
        this.alignmentConcatCheckbox.setSelected(configProFormat.isAlignConcat());
        this.alignmentCommaCheckbox.setSelected(configProFormat.isAlignComma());
    }

    private void commit(ConfigProFormat configProFormat) {
        configProFormat.setNumSpaces((Integer)this.numSpaceschoice.getSelectedItem());
        configProFormat.setDoubleIndent(this.doubleIndentionCheckbox.isSelected());
        configProFormat.setIndentAndOr(this.andOrIndentionCheckbox.isSelected());
        configProFormat.setUseTabCheckboxOpt(this.useTabCheckbox.isSelected());
        configProFormat.setAlignEqual(this.alignmentEqualCheckbox.isSelected());
        configProFormat.setAlignOperator(this.alignmentOperatorCheckbox.isSelected());
        configProFormat.setAlignKeyword(this.alignmentKeywordCheckbox.isSelected());
        configProFormat.setAlignOnAs(this.alignmentAsCheckbox.isSelected());
        configProFormat.setAlignComment(this.alignmentCommentCheckbox.isSelected());
        configProFormat.setAlignDecl(this.alignmentDeclarationCheckbox.isSelected());
        configProFormat.setAlignConcat(this.alignmentConcatCheckbox.isSelected());
        configProFormat.setAlignComma(this.alignmentCommaCheckbox.isSelected());
    }

    private void jbInit() throws Exception {
        this.alignmentOptionPanel = new JPanel();
        this.alignmentOptionPanel.setLayout(null);
        this.alignmentEqualCheckbox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.alignmentKeywordCheckbox = new JCheckBox();
        this.alignmentAsCheckbox = new JCheckBox();
        this.alignmentCommentCheckbox = new JCheckBox();
        this.doubleIndentionCheckbox = new JCheckBox();
        this.numSpacesLabel = new JLabel();
        this.numSpaceschoice = new JComboBox();
        this.jLabel6 = new JLabel();
        this.useTabCheckbox = new JCheckBox();
        this.alignmentDeclarationCheckbox = new JCheckBox();
        this.numSpacesLabel1 = new JLabel();
        this.alignmentOperatorCheckbox = new JCheckBox();
        this.andOrIndentionCheckbox = new JCheckBox();
        this.alignmentConcatCheckbox = new JCheckBox();
        this.alignmentCommaCheckbox = new JCheckBox();
        this.alignmentOptionPanel.setAlignmentY(0.0f);
        this.alignmentOptionPanel.setMaximumSize(new Dimension(150, 500));
        this.alignmentOptionPanel.setMinimumSize(new Dimension(150, 500));
        this.alignmentOptionPanel.setPreferredSize(new Dimension(150, 500));
        this.alignmentEqualCheckbox.setForeground(this.getColor());
        this.alignmentEqualCheckbox.setSelected(true);
        this.alignmentEqualCheckbox.setText("Align Equal signs ( = < > ...)");
        this.alignmentEqualCheckbox.setAlignmentY(0.0f);
        this.alignmentEqualCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.alignmentEqualCheckbox);
        this.alignmentEqualCheckbox.setBounds(20, 70, 210, 21);
        this.jLabel1.setForeground(this.getColor());
        this.jLabel1.setText("Alignment");
        this.alignmentOptionPanel.add(this.jLabel1);
        this.jLabel1.setBounds(18, 18, 65, 16);
        this.alignmentKeywordCheckbox.setForeground(this.getColor());
        this.alignmentKeywordCheckbox.setText("Right-Align Master Keywords");
        this.alignmentKeywordCheckbox.setAlignmentY(0.0f);
        this.alignmentKeywordCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentKeywordCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AlignmentAndIndentationPanel.this.alignmentKeywordCheckboxItemStateChanged(itemEvent);
            }
        });
        this.alignmentOptionPanel.add(this.alignmentKeywordCheckbox);
        this.alignmentKeywordCheckbox.setBounds(20, 40, 210, 21);
        this.alignmentAsCheckbox.setForeground(this.getColor());
        this.alignmentAsCheckbox.setSelected(true);
        this.alignmentAsCheckbox.setText("Align on \"AS\" Keyword");
        this.alignmentAsCheckbox.setAlignmentY(0.0f);
        this.alignmentAsCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.alignmentAsCheckbox);
        this.alignmentAsCheckbox.setBounds(20, 110, 200, 21);
        this.alignmentCommentCheckbox.setForeground(this.getColor());
        this.alignmentCommentCheckbox.setSelected(true);
        this.alignmentCommentCheckbox.setText("Align line comments \"--\"");
        this.alignmentCommentCheckbox.setAlignmentY(0.0f);
        this.alignmentCommentCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.alignmentCommentCheckbox);
        this.alignmentCommentCheckbox.setBounds(20, 155, 200, 21);
        this.doubleIndentionCheckbox.setForeground(this.getColor());
        this.doubleIndentionCheckbox.setText("Indent Main Keyword 2x");
        this.doubleIndentionCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.doubleIndentionCheckbox);
        this.doubleIndentionCheckbox.setBounds(20, 325, 200, 21);
        this.numSpacesLabel.setForeground(this.getColor());
        this.numSpacesLabel.setText("Spaces");
        this.alignmentOptionPanel.add(this.numSpacesLabel);
        this.numSpacesLabel.setBounds(80, 285, 40, 18);
        this.numSpaceschoice.setModel(new DefaultComboBoxModel<Integer>(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}));
        this.numSpaceschoice.setSelectedIndex(8);
        this.numSpaceschoice.setForeground(this.getColor());
        this.numSpaceschoice.setMaximumRowCount(10);
        this.alignmentOptionPanel.add(this.numSpaceschoice);
        this.numSpaceschoice.setBounds(20, 285, 54, 24);
        this.jLabel6.setForeground(this.getColor());
        this.jLabel6.setText("Indentation");
        this.alignmentOptionPanel.add(this.jLabel6);
        this.jLabel6.setBounds(20, 265, 72, 16);
        this.useTabCheckbox.setForeground(this.getColor());
        this.useTabCheckbox.setText("Use Tabulator");
        this.useTabCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.useTabCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AlignmentAndIndentationPanel.this.useTabCheckboxItemStateChanged(itemEvent);
            }
        });
        this.alignmentOptionPanel.add(this.useTabCheckbox);
        this.useTabCheckbox.setBounds(130, 285, 140, 21);
        this.alignmentDeclarationCheckbox.setForeground(this.getColor());
        this.alignmentDeclarationCheckbox.setSelected(true);
        this.alignmentDeclarationCheckbox.setText("Align variable declaration");
        this.alignmentDeclarationCheckbox.setAlignmentY(0.0f);
        this.alignmentDeclarationCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.alignmentDeclarationCheckbox);
        this.alignmentDeclarationCheckbox.setBounds(20, 215, 210, 21);
        this.numSpacesLabel1.setForeground(this.getColor());
        this.numSpacesLabel1.setText("for stored procedures");
        this.alignmentOptionPanel.add(this.numSpacesLabel1);
        this.numSpacesLabel1.setBounds(40, 235, 190, 16);
        this.alignmentOperatorCheckbox.setForeground(this.getColor());
        this.alignmentOperatorCheckbox.setSelected(true);
        this.alignmentOperatorCheckbox.setText("Align operators     ( + - * / IN ...)");
        this.alignmentOperatorCheckbox.setAlignmentY(0.0f);
        this.alignmentOperatorCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.alignmentOperatorCheckbox);
        this.alignmentOperatorCheckbox.setBounds(20, 90, 230, 21);
        this.andOrIndentionCheckbox.setForeground(this.getColor());
        this.andOrIndentionCheckbox.setText("Indent AND/OR");
        this.andOrIndentionCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.andOrIndentionCheckbox);
        this.andOrIndentionCheckbox.setBounds(20, 345, 160, 21);
        this.alignmentConcatCheckbox.setForeground(this.getColor());
        this.alignmentConcatCheckbox.setSelected(true);
        this.alignmentConcatCheckbox.setText("Align \"||\" at end of line");
        this.alignmentConcatCheckbox.setAlignmentY(0.0f);
        this.alignmentConcatCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.alignmentConcatCheckbox);
        this.alignmentConcatCheckbox.setBounds(20, 175, 180, 21);
        this.alignmentCommaCheckbox.setForeground(this.getColor());
        this.alignmentCommaCheckbox.setSelected(true);
        this.alignmentCommaCheckbox.setText("Align on Commas");
        this.alignmentCommaCheckbox.setAlignmentY(0.0f);
        this.alignmentCommaCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentOptionPanel.add(this.alignmentCommaCheckbox);
        this.alignmentCommaCheckbox.setBounds(20, 130, 180, 21);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.alignmentOptionPanel);
    }

    private void alignmentKeywordCheckboxItemStateChanged(ItemEvent itemEvent) {
        if (this.alignmentKeywordCheckbox.isSelected()) {
            this.useTabCheckbox.setEnabled(false);
            this.useTabCheckbox.setSelected(false);
        } else {
            this.useTabCheckbox.setEnabled(true);
        }
    }

    private void useTabCheckboxItemStateChanged(ItemEvent itemEvent) {
        if (this.useTabCheckbox.isSelected()) {
            this.numSpaceschoice.setEnabled(false);
            this.numSpacesLabel.setEnabled(false);
            this.alignmentKeywordCheckbox.setEnabled(false);
            this.alignmentKeywordCheckbox.setSelected(false);
        } else {
            this.numSpaceschoice.setEnabled(true);
            this.numSpacesLabel.setEnabled(true);
            this.alignmentKeywordCheckbox.setEnabled(true);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance(traversableContext.getPropertyStorage());
        this.load(configProFormat);
    }

    public void onExit(TraversableContext traversableContext) {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance(traversableContext.getPropertyStorage());
        this.commit(configProFormat);
    }
}

