/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import oracle.dbtools.proformatter.ProFormatOptions;
import oracle.dbtools.proformatter.SpacingType;
import oracle.dbtools.raptor.config.ConfigFormat;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public final class ConfigProFormat
extends ConfigFormat {
    public static final String VARNAME = "VARNAME";
    public static final String USE_TAB = "USETAB";
    public static final String UPPERCASE = "UPPERCASE";
    public static final String TARGET_SQL = "TARGETSQL";
    public static final String SUPPRESS_SPACE = "SUPPRESSSPACE";
    public static final String SUPPRESS_BREAK = "SUPPRESSBREAK";
    public static final String SUPPRESS_COMMENT = "SUPPRESSCOMMENT";
    public static final String SQL_SOURCE_ENCLOSED = "SQLSOURCEENCLOSED";
    public static final String SOURCE_SQL = "SOURCESQL";
    public static final String SMALL_SQL = "SMALLSQL";
    public static final String REPLACE_COMMENT = "REPLACECOMMENT";
    public static final String QUOTE_CHAR = "QUOTECHAR";
    public static final String NUM_SPACES = "NUMSPACES";
    public static final String NUM_COMMAS = "NUMCOMMAS";
    public static final String BRACKET_SPACING = "BRACKETSPACING";
    public static final String COMMA_SPACING = "COMMASPACING";
    public static final String OPERATOR_SPACING = "OPERSPACING";
    public static final String LINE_WIDTH = "LINEWIDTH";
    public static final String LINE_NUM = "LINENUM";
    public static final String BREAK_SELECT_BRACKET = "BREAKSELECTBRACKET";
    public static final String BREAK_SCHEMA = "BREAKSCHEMA";
    public static final String BREAK_KEYWORD = "BREAKKEYWORD";
    public static final String BREAK_JOINON = "BREAKJOINON";
    public static final String BREAK_JOINJOIN = "BREAKJOINJOIN";
    public static final String BREAK_JOIN = "BREAKJOIN";
    public static final String BREAK_CONDITION = "BREAKCONDITION";
    public static final String BREAK_CASE_WHEN = "BREAKCASEWHEN";
    public static final String BREAK_CASE_THEN = "BREAKCASETHEN";
    public static final String BREAK_CASE_ELSE = "BREAKCASEELSE";
    public static final String BREAK_CASE = "BREAKCASE";
    public static final String BREAK_CASE_ANDOR = "BREAKCASEANDOR";
    public static final String BREAK_BEFORE_COMMENT = "BREAKBEFORECOMMENT";
    public static final String BREAK_BEFORE_CONCAT = "BREAKBEFORECONCAT";
    public static final String BREAK_BEFORE_COMMA = "BREAKBEFORECOMMA";
    public static final String BREAK_BEFORE_AND = "BREAKBEFOREAND";
    public static final String BREAK_AFTER_CONCAT = "BREAKAFTERCONCAT";
    public static final String BREAK_AFTER_COMMA = "BREAKAFTERCOMMA";
    public static final String BREAK_AFTER_AND = "BREAKAFTERAND";
    public static final String GRAPH_LEVEL = "GRAPHLEVEL";
    public static final String EMPTYLINE = "EMPTYLINE";
    public static final String DBL_INDENT = "DBLINDENT";
    public static final String COLORED = "COLORED";
    public static final String INDENT_AND = "INDENTAND";
    public static final String ALIGN_OPER = "ALIGNOPER";
    public static final String ALIGN_KEYWORD = "ALIGNKEYWORD";
    public static final String ALIGN_EQUAL = "ALIGNEQUAL";
    public static final String ALIGN_DECL = "ALIGNDECL";
    public static final String ALIGN_CONCAT = "ALIGNCONCAT";
    public static final String ALIGN_COMMENT = "ALIGNCOMMENT";
    public static final String ALIGN_COMMA = "ALIGNCOMMA";
    public static final String ALIGN_AS = "ALIGNAS";
    public static final String KEY = "oracle.dbtools.proformatter.ConfigProFormat";

    private ConfigProFormat(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ConfigProFormat getInstance(PropertyStorage propertyStorage) {
        return new ConfigProFormat(ConfigProFormat.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public static ConfigProFormat getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return ConfigProFormat.getInstance((PropertyStorage)preferences);
    }

    public boolean isAlignOnAs() {
        return this._hash.getBoolean(ALIGN_AS, true);
    }

    public void setAlignOnAs(boolean bl) {
        this._hash.putBoolean(ALIGN_AS, bl);
    }

    public boolean isAlignComma() {
        return this._hash.getBoolean(ALIGN_COMMA, true);
    }

    public void setAlignComma(boolean bl) {
        this._hash.putBoolean(ALIGN_COMMA, bl);
    }

    public boolean isAlignComment() {
        return this._hash.getBoolean(ALIGN_COMMENT, true);
    }

    public void setAlignComment(boolean bl) {
        this._hash.putBoolean(ALIGN_COMMENT, bl);
    }

    public boolean isAlignConcat() {
        return this._hash.getBoolean(ALIGN_CONCAT, true);
    }

    public void setAlignConcat(boolean bl) {
        this._hash.putBoolean(ALIGN_CONCAT, bl);
    }

    public boolean isAlignDecl() {
        return this._hash.getBoolean(ALIGN_DECL, true);
    }

    public void setAlignDecl(boolean bl) {
        this._hash.putBoolean(ALIGN_DECL, bl);
    }

    public boolean isAlignEqual() {
        return this._hash.getBoolean(ALIGN_EQUAL, true);
    }

    public void setAlignEqual(boolean bl) {
        this._hash.putBoolean(ALIGN_EQUAL, bl);
    }

    public boolean isAlignKeyword() {
        return this._hash.getBoolean(ALIGN_KEYWORD, true);
    }

    public void setAlignKeyword(boolean bl) {
        this._hash.putBoolean(ALIGN_KEYWORD, bl);
    }

    public boolean isAlignOperator() {
        return this._hash.getBoolean(ALIGN_OPER, true);
    }

    public void setAlignOperator(boolean bl) {
        this._hash.putBoolean(ALIGN_OPER, bl);
    }

    public boolean isIndentAndOr() {
        return this._hash.getBoolean(INDENT_AND, false);
    }

    public void setIndentAndOr(boolean bl) {
        this._hash.putBoolean(INDENT_AND, bl);
    }

    public boolean isColored() {
        return this._hash.getBoolean(COLORED, false);
    }

    public void setColored(boolean bl) {
        this._hash.putBoolean(COLORED, bl);
    }

    public boolean isDoubleIndent() {
        return this._hash.getBoolean(DBL_INDENT, false);
    }

    public void setDoubleIndent(boolean bl) {
        this._hash.putBoolean(DBL_INDENT, false);
    }

    public boolean isEmptyLine() {
        return this._hash.getBoolean(EMPTYLINE, true);
    }

    public void setEmptyLine(boolean bl) {
        this._hash.putBoolean(EMPTYLINE, bl);
    }

    public boolean isGraphLevel() {
        return this._hash.getBoolean(GRAPH_LEVEL, false);
    }

    public void setGraphLevel(boolean bl) {
        this._hash.putBoolean(GRAPH_LEVEL, bl);
    }

    public boolean isBreakAfterAnd() {
        return this._hash.getBoolean(BREAK_AFTER_AND, false);
    }

    public void setBreakAfterAnd(boolean bl) {
        this._hash.putBoolean(BREAK_AFTER_AND, bl);
    }

    public boolean isBreakAfterComma() {
        return this._hash.getBoolean(BREAK_AFTER_COMMA, true);
    }

    public void setBreakAfterComma(boolean bl) {
        this._hash.putBoolean(BREAK_AFTER_COMMA, bl);
    }

    public boolean isBreakAfterConcat() {
        return this._hash.getBoolean(BREAK_AFTER_CONCAT, false);
    }

    public void setBreakAfterConcat(boolean bl) {
        this._hash.putBoolean(BREAK_AFTER_CONCAT, bl);
    }

    public boolean isBreakBeforeAnd() {
        return this._hash.getBoolean(BREAK_BEFORE_AND, true);
    }

    public void setBreakBeforeAnd(boolean bl) {
        this._hash.putBoolean(BREAK_BEFORE_AND, bl);
    }

    public boolean isBreakBeforeComma() {
        return this._hash.getBoolean(BREAK_BEFORE_COMMA, false);
    }

    public void setBreakBeforeComma(boolean bl) {
        this._hash.putBoolean(BREAK_BEFORE_COMMA, bl);
    }

    public boolean isBreakBeforeConcat() {
        return this._hash.getBoolean(BREAK_BEFORE_CONCAT, true);
    }

    public void setBreakBeforeConcat(boolean bl) {
        this._hash.putBoolean(BREAK_BEFORE_CONCAT, bl);
    }

    public boolean isBreakBeforeLineComment() {
        return this._hash.getBoolean(BREAK_BEFORE_COMMENT, false);
    }

    public void setBreakBeforeLineComment(boolean bl) {
        this._hash.putBoolean(BREAK_BEFORE_COMMENT, bl);
    }

    public boolean isBreakCaseAndOr() {
        return this._hash.getBoolean(BREAK_CASE_ANDOR, true);
    }

    public void setBreakCaseAndOr(boolean bl) {
        this._hash.putBoolean(BREAK_CASE_ANDOR, bl);
    }

    public boolean isBreakCase() {
        return this._hash.getBoolean(BREAK_CASE, true);
    }

    public void setBreakCase(boolean bl) {
        this._hash.putBoolean(BREAK_CASE, bl);
    }

    public boolean isBreakCaseElse() {
        return this._hash.getBoolean(BREAK_CASE_ELSE, true);
    }

    public void setBreakCaseElse(boolean bl) {
        this._hash.putBoolean(BREAK_CASE_ELSE, bl);
    }

    public boolean isBreakCaseThen() {
        return this._hash.getBoolean(BREAK_CASE_THEN, true);
    }

    public void setBreakCaseThen(boolean bl) {
        this._hash.putBoolean(BREAK_CASE_THEN, bl);
    }

    public boolean isBreakCaseWhen() {
        return this._hash.getBoolean(BREAK_CASE_WHEN, true);
    }

    public void setBreakCaseWhen(boolean bl) {
        this._hash.putBoolean(BREAK_CASE_WHEN, bl);
    }

    public boolean isBreakConditionBracket() {
        return this._hash.getBoolean(BREAK_CONDITION, false);
    }

    public void setBreakConditionBracket(boolean bl) {
        this._hash.putBoolean(BREAK_CONDITION, bl);
    }

    public boolean isBreakJoin() {
        return this._hash.getBoolean(BREAK_JOIN, true);
    }

    public void setBreakJoin(boolean bl) {
        this._hash.putBoolean(BREAK_JOIN, bl);
    }

    public boolean isBreakJoinJoin() {
        return this._hash.getBoolean(BREAK_JOINJOIN, true);
    }

    public void setBreakJoinJoin(boolean bl) {
        this._hash.putBoolean(BREAK_JOINJOIN, bl);
    }

    public boolean isBreakJoinOn() {
        return this._hash.getBoolean(BREAK_JOINON, true);
    }

    public void setBreakJoinOn(boolean bl) {
        this._hash.putBoolean(BREAK_JOINON, bl);
    }

    public boolean isBreakKeyword() {
        return this._hash.getBoolean(BREAK_KEYWORD, false);
    }

    public void setBreakKeyword(boolean bl) {
        this._hash.putBoolean(BREAK_KEYWORD, bl);
    }

    public BreakSchemaType getBreakSchema() {
        return BreakSchemaType.valueOf(this._hash.getString(BREAK_SCHEMA, BreakSchemaType.LARGE.name()));
    }

    public void setBreakSchema(BreakSchemaType breakSchemaType) {
        this._hash.putString(BREAK_SCHEMA, breakSchemaType.name());
    }

    public boolean isLinebreakSelectBracketCheckboxOpt() {
        return this._hash.getBoolean(BREAK_SELECT_BRACKET, false);
    }

    public void setLinebreakSelectBracketCheckboxOpt(boolean bl) {
        this._hash.putBoolean(BREAK_SELECT_BRACKET, bl);
    }

    public boolean isLineNumberCheckboxOpt() {
        return this._hash.getBoolean(LINE_NUM, false);
    }

    public void setLineNumberCheckboxOpt(boolean bl) {
        this._hash.putBoolean(LINE_NUM, bl);
    }

    public int getLineWidthTextFieldOpt() {
        return this._hash.getInt(LINE_WIDTH, 999);
    }

    public void setLineWidthTextFieldOpt(int n) {
        this._hash.putInt(LINE_WIDTH, n);
    }

    public SpacingType getOperatorSpacing() {
        return SpacingType.valueOf(this._hash.getString(OPERATOR_SPACING, SpacingType.UNCHANGED.name()));
    }

    public void setOperatorSpacing(SpacingType spacingType) {
        this._hash.putString(OPERATOR_SPACING, spacingType.name());
    }

    public SpacingType getCommaSpacing() {
        return SpacingType.valueOf(this._hash.getString(COMMA_SPACING, SpacingType.UNCHANGED.name()));
    }

    public void setCommaSpacing(SpacingType spacingType) {
        this._hash.putString(COMMA_SPACING, spacingType.name());
    }

    public SpacingType getBracketSpacing() {
        return SpacingType.valueOf(this._hash.getString(BRACKET_SPACING, SpacingType.UNCHANGED.name()));
    }

    public void setBracketSpacing(SpacingType spacingType) {
        this._hash.putString(BRACKET_SPACING, spacingType.name());
    }

    public Integer getNumCommas() {
        return this._hash.getInt(NUM_COMMAS, 1);
    }

    public void setNumCommas(Integer n) {
        this._hash.putInt(NUM_COMMAS, n.intValue());
    }

    public Integer getNumSpaces() {
        return this._hash.getInt(NUM_SPACES, 2);
    }

    public void setNumSpaces(Integer n) {
        this._hash.putInt(NUM_SPACES, n.intValue());
    }

    public String getQuoteCharacter() {
        return this._hash.getString(QUOTE_CHAR, "'");
    }

    public void setQuoteCharacter(String string) {
        this._hash.putString(QUOTE_CHAR, string);
    }

    public boolean isReplaceComment() {
        return this._hash.getBoolean(REPLACE_COMMENT, false);
    }

    public void setReplaceComment(boolean bl) {
        this._hash.putBoolean(REPLACE_COMMENT, bl);
    }

    public int getSmallSQLTextFieldOpt() {
        return this._hash.getInt(SMALL_SQL, 80);
    }

    public void setSmallSQLTextFieldOpt(int n) {
        this._hash.putInt(SMALL_SQL, n);
    }

    public String getSourceSQLChoiceOpt() {
        return this._hash.getString(SOURCE_SQL, "Oracle");
    }

    public void setSourceSQLChoiceOpt(String string) {
        this._hash.putString(SOURCE_SQL, string);
    }

    public boolean isSourceSQLCopied() {
        return this._hash.getBoolean("SQLSOURCE_COPIED", false);
    }

    public void setSourceSQLCopied(boolean bl) {
        this._hash.putBoolean("SQLSOURCE_COPIED", bl);
    }

    public String getSourceSQLEnclosed() {
        return this._hash.getString(SQL_SOURCE_ENCLOSED, "\"");
    }

    public void setSourceSQLEnclosed(String string) {
        this._hash.putString(SQL_SOURCE_ENCLOSED, string);
    }

    public boolean isSuppressComment() {
        return this._hash.getBoolean(SUPPRESS_COMMENT, false);
    }

    public void setSuppressComment(boolean bl) {
        this._hash.putBoolean(SUPPRESS_COMMENT, bl);
    }

    public boolean isSuppressLinebreakCheckboxOpt() {
        return this._hash.getBoolean(SUPPRESS_BREAK, false);
    }

    public void setSuppressLinebreakCheckboxOpt(boolean bl) {
        this._hash.putBoolean(SUPPRESS_BREAK, bl);
    }

    public boolean isSuppressSpacescheckboxOpt() {
        return this._hash.getBoolean(SUPPRESS_SPACE, true);
    }

    public void setSuppressSpacescheckboxOpt(boolean bl) {
        this._hash.putBoolean(SUPPRESS_SPACE, bl);
    }

    public String getTargetSQLChoiceOpt() {
        return this._hash.getString(TARGET_SQL, "SQL");
    }

    public void setTargetSQLChoiceOpt(String string) {
        this._hash.putString(TARGET_SQL, string);
    }

    public String getUCChoiceOpt() {
        return this._hash.getString(UPPERCASE, "Keywords Uppercase");
    }

    public void setUCChoiceOpt(String string) {
        this._hash.putString(UPPERCASE, string);
    }

    public boolean isUseTabCheckboxOpt() {
        return this._hash.getBoolean(USE_TAB, false);
    }

    public void setUseTabCheckboxOpt(boolean bl) {
        this._hash.putBoolean(USE_TAB, bl);
    }

    public String getVariableNameTextFieldOpt() {
        return this._hash.getString(VARNAME, "SQL");
    }

    public void setVariableNameTextFieldOpt(String string) {
        this._hash.putString(VARNAME, string);
    }

    public ProFormatOptions getAdvancedFormatOptions() {
        ProFormatOptions proFormatOptions = new ProFormatOptions();
        proFormatOptions.setIdentifierCase(this.getIdentifierCase().name().toLowerCase());
        proFormatOptions.setKeywordCase(this.getKeywordCase().name().toLowerCase());
        int n = this.getTabSize();
        int n2 = this.getWidthSize();
        proFormatOptions.setTabSize(n);
        proFormatOptions.setWidthSize(n2);
        proFormatOptions.setTabType(this.getTabType().name().toLowerCase());
        proFormatOptions.setKeepNewLines(this.isKeepNewLines());
        proFormatOptions.setListNewLines(this.getListItems());
        proFormatOptions.setWrapOn(this.isWrapOn());
        proFormatOptions.setTargetSQLChoiceOpt(this.getTargetSQLChoiceOpt());
        proFormatOptions.setNumSpaceschoiceOpt(this.getNumSpaces());
        proFormatOptions.setUCChoiceOpt(this.getUCChoiceOpt());
        proFormatOptions.setGraphLevelcheckboxOpt(this.isGraphLevel());
        proFormatOptions.setSuppressSpacescheckboxOpt(this.isSuppressSpacescheckboxOpt());
        proFormatOptions.setQuoteCharactertextFieldOpt(this.getQuoteCharacter());
        proFormatOptions.setDoubleIndentionCheckboxOpt(this.isDoubleIndent());
        proFormatOptions.setAndOrIndentionCheckboxOpt(this.isIndentAndOr());
        proFormatOptions.setUseTabCheckboxOpt(this.isUseTabCheckboxOpt());
        proFormatOptions.setEmptyLinecheckboxOpt(this.isEmptyLine());
        proFormatOptions.setLinebreakBeforeCommaCheckboxOpt(this.isBreakBeforeComma());
        proFormatOptions.setLinebreakAfterCommaCheckboxOpt(this.isBreakAfterComma());
        proFormatOptions.setLinebreakBeforeANDCheckboxOpt(this.isBreakBeforeAnd());
        proFormatOptions.setLinebreakAfterANDCheckboxOpt(this.isBreakAfterAnd());
        proFormatOptions.setLinebreakSelectBracketCheckboxOpt(this.isLinebreakSelectBracketCheckboxOpt());
        proFormatOptions.setLinebreakConditionBracketCheckboxOpt(this.isBreakConditionBracket());
        proFormatOptions.setLinebreakSchemaChoiceOpt(this.getBreakSchema().toString());
        proFormatOptions.setSourceSQLEnclosedCheckboxOpt(this.isSourceSQLCopied());
        proFormatOptions.setSourceSQLEnclosedTextFieldOpt(this.getSourceSQLEnclosed());
        proFormatOptions.setLineWidthTextFieldOpt(this.getLineWidthTextFieldOpt());
        proFormatOptions.setColorCheckboxOpt(this.isColored());
        proFormatOptions.setLineNumberCheckboxOpt(this.isLineNumberCheckboxOpt());
        proFormatOptions.setLineNumberCheckboxOpt(this.isLineNumberCheckboxOpt());
        proFormatOptions.setLinebreakKeywordCheckboxOpt(this.isBreakKeyword());
        proFormatOptions.setLinebreakCaseCheckboxOpt(this.isBreakCase());
        proFormatOptions.setSmallSQLTextFieldOpt(this.getSmallSQLTextFieldOpt());
        proFormatOptions.setAlignmentEqualCheckboxOpt(this.isAlignEqual());
        proFormatOptions.setAlignmentOperatorCheckboxOpt(this.isAlignOperator());
        proFormatOptions.setSourceSQLChoiceOpt(this.getSourceSQLChoiceOpt());
        proFormatOptions.setAlignmentKeywordCheckboxOpt(this.isAlignKeyword());
        proFormatOptions.setSuppressCommentCheckboxOpt(this.isSuppressComment());
        proFormatOptions.setNoSpacesAroundBracketjRadioButtonOpt(false);
        proFormatOptions.setUnchangedSpaceInsideBracketjRadioButtonOpt(false);
        proFormatOptions.setOneSpaceAroundBracketjRadioButtonOpt(false);
        proFormatOptions.setOneSpaceInsideBracketjRadioButtonOpt(false);
        proFormatOptions.setOneSpaceOutsideBracketjRadioButtonOpt(false);
        SpacingType spacingType = this.getBracketSpacing();
        if (SpacingType.NONE == spacingType) {
            proFormatOptions.setNoSpacesAroundBracketjRadioButtonOpt(true);
        } else if (SpacingType.UNCHANGED == spacingType) {
            proFormatOptions.setUnchangedSpaceInsideBracketjRadioButtonOpt(true);
        } else if (SpacingType.AROUND == spacingType) {
            proFormatOptions.setOneSpaceAroundBracketjRadioButtonOpt(true);
        } else if (SpacingType.AFTER == spacingType) {
            proFormatOptions.setOneSpaceInsideBracketjRadioButtonOpt(true);
        } else if (SpacingType.BEFORE == spacingType) {
            proFormatOptions.setOneSpaceOutsideBracketjRadioButtonOpt(true);
        }
        proFormatOptions.setUnchangedSpaceCommajRadioButtonOpt(false);
        proFormatOptions.setNoSpacesAroundCommajRadioButtonOpt(false);
        proFormatOptions.setOneSpaceAfterCommajRadioButtonOpt(false);
        proFormatOptions.setOneSpaceBeforeCommajRadioButtonOpt(false);
        proFormatOptions.setOneSpaceAroundCommajRadioButtonOpt(false);
        SpacingType spacingType2 = this.getCommaSpacing();
        if (SpacingType.NONE == spacingType2) {
            proFormatOptions.setNoSpacesAroundCommajRadioButtonOpt(true);
        } else if (SpacingType.UNCHANGED == spacingType2) {
            proFormatOptions.setUnchangedSpaceCommajRadioButtonOpt(true);
        } else if (SpacingType.BEFORE == spacingType2) {
            proFormatOptions.setOneSpaceBeforeCommajRadioButtonOpt(true);
        } else if (SpacingType.AFTER == spacingType2) {
            proFormatOptions.setOneSpaceAfterCommajRadioButtonOpt(true);
        } else if (SpacingType.AROUND == spacingType2) {
            proFormatOptions.setOneSpaceAroundCommajRadioButtonOpt(true);
        }
        proFormatOptions.setUnchangedSpaceEqualjRadioButtonOpt(false);
        proFormatOptions.setNoSpacesAroundEqualjRadioButtonOpt(false);
        proFormatOptions.setOneSpaceAroundEqualjRadioButtonOpt(false);
        SpacingType spacingType3 = this.getOperatorSpacing();
        if (SpacingType.NONE == spacingType3) {
            proFormatOptions.setNoSpacesAroundEqualjRadioButtonOpt(true);
        } else if (SpacingType.UNCHANGED == spacingType3) {
            proFormatOptions.setUnchangedSpaceEqualjRadioButtonOpt(true);
        } else if (SpacingType.SINGLE == spacingType3) {
            proFormatOptions.setOneSpaceAroundEqualjRadioButtonOpt(true);
        }
        proFormatOptions.setLinebreakBeforeLineCommentOpt(this.isBreakBeforeLineComment());
        proFormatOptions.setAlignmentAsCheckboxOpt(this.isAlignOnAs());
        proFormatOptions.setAlignmentCommentCheckboxOpt(this.isAlignComment());
        proFormatOptions.setAlignmentDeclarationCheckboxOpt(this.isAlignDecl());
        proFormatOptions.setLinebreakCaseThenCheckboxOpt(this.isBreakCaseThen());
        proFormatOptions.setLinebreakCaseElseCheckboxOpt(this.isBreakCaseElse());
        proFormatOptions.setVariableNameTextFieldOpt(this.getVariableNameTextFieldOpt());
        proFormatOptions.setLinebreakCaseWhenCheckboxOpt(this.isBreakCaseWhen());
        proFormatOptions.setLinebreakCaseAndOrCheckboxOpt(this.isBreakCaseAndOr());
        proFormatOptions.setReplaceCommentCheckboxOpt(this.isReplaceComment());
        proFormatOptions.setLinebreakBeforeConcatCheckboxOpt(this.isBreakBeforeConcat());
        proFormatOptions.setLinebreakAfterConcatCheckboxOpt(this.isBreakAfterConcat());
        proFormatOptions.setAlignmentConcatCheckboxOpt(this.isAlignConcat());
        proFormatOptions.setSuppressLinebreakCheckboxOpt(this.isSuppressLinebreakCheckboxOpt());
        proFormatOptions.setLinebreakJoinCheckboxOpt(this.isBreakJoin());
        proFormatOptions.setLinebreakJoinJoinCheckboxOpt(this.isBreakJoinJoin());
        proFormatOptions.setLinebreakJoinOnCheckboxOpt(this.isBreakJoinOn());
        proFormatOptions.setNumCommaschoiceOpt(this.getNumCommas());
        proFormatOptions.setAlignmentCommaCheckboxOpt(this.isAlignComma());
        return proFormatOptions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakSchemaType {
        LARGE("large SQL"),
        SMALL("small SQL"),
        CUSTOM("customized SQL"),
        ONELINE("1-line SQL");

        private String m_label;

        private BreakSchemaType(String string2) {
            this.m_label = string2;
        }

        public String toString() {
            return this.m_label;
        }
    }
}

