/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.proformatter.ConfigPanelData;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public final class OtherPanel
extends DefaultTraversablePanel {
    public static final long serialVersionUID = 1693L;
    public static final String TITLE = "Other";
    private JPanel otherOptionPanel;
    private JCheckBox colorCheckbox;
    private JCheckBox suppressCommentCheckbox;
    private JComboBox UCChoice;
    private JLabel jLabel2;
    private JCheckBox replaceCommentCheckbox;
    private JCheckBox suppressLinebreakCheckbox;
    private JLabel jLabel7;

    public OtherPanel() {
        this.setHelpID("f1_idedidesetproformat_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public Color getColor() {
        new ConfigPanelData();
        return ConfigPanelData.getColor();
    }

    private void load(ConfigProFormat configProFormat) {
        this.colorCheckbox.setSelected(configProFormat.isColored());
        this.suppressCommentCheckbox.setSelected(configProFormat.isSuppressComment());
        this.UCChoice.setSelectedItem(configProFormat.getUCChoiceOpt());
        this.replaceCommentCheckbox.setSelected(configProFormat.isReplaceComment());
        this.suppressLinebreakCheckbox.setSelected(configProFormat.isSuppressLinebreakCheckboxOpt());
    }

    private void commit(ConfigProFormat configProFormat) {
        configProFormat.setColored(this.colorCheckbox.isSelected());
        configProFormat.setSuppressComment(this.suppressCommentCheckbox.isSelected());
        configProFormat.setUCChoiceOpt((String)this.UCChoice.getSelectedItem());
        configProFormat.setReplaceComment(this.replaceCommentCheckbox.isSelected());
        configProFormat.setSuppressLinebreakCheckboxOpt(this.suppressLinebreakCheckbox.isSelected());
    }

    private void jbInit() throws Exception {
        this.otherOptionPanel = new JPanel();
        this.otherOptionPanel.setLayout(null);
        this.colorCheckbox = new JCheckBox();
        this.suppressCommentCheckbox = new JCheckBox();
        this.UCChoice = new JComboBox();
        this.replaceCommentCheckbox = new JCheckBox();
        this.suppressLinebreakCheckbox = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jLabel2 = new JLabel();
        this.otherOptionPanel.setAlignmentY(0.0f);
        this.otherOptionPanel.setMaximumSize(new Dimension(150, 500));
        this.otherOptionPanel.setMinimumSize(new Dimension(150, 500));
        this.otherOptionPanel.setPreferredSize(new Dimension(150, 500));
        this.colorCheckbox.setForeground(this.getColor());
        this.colorCheckbox.setSelected(true);
        this.colorCheckbox.setText("Colored SQL");
        this.colorCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.otherOptionPanel.add(this.colorCheckbox);
        this.colorCheckbox.setBounds(20, 40, 140, 21);
        this.suppressCommentCheckbox.setForeground(this.getColor());
        this.suppressCommentCheckbox.setText("Delete Comment");
        this.suppressCommentCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.otherOptionPanel.add(this.suppressCommentCheckbox);
        this.suppressCommentCheckbox.setBounds(20, 60, 170, 21);
        this.UCChoice.addItem("No Change");
        this.UCChoice.addItem("Keywords Uppercase");
        this.UCChoice.addItem("Whole SQL Uppercase");
        this.UCChoice.addItem("Whole SQL Lowercase");
        this.UCChoice.setSelectedIndex(1);
        this.UCChoice.setForeground(this.getColor());
        this.otherOptionPanel.add(this.UCChoice);
        this.UCChoice.setBounds(20, 200, 162, 24);
        this.jLabel2.setForeground(this.getColor());
        this.jLabel2.setText("Case");
        this.otherOptionPanel.add(this.jLabel2);
        this.jLabel2.setBounds(20, 180, 50, 16);
        this.replaceCommentCheckbox.setForeground(this.getColor());
        this.replaceCommentCheckbox.setText("Put -- comment between /* .... */ ");
        this.replaceCommentCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.otherOptionPanel.add(this.replaceCommentCheckbox);
        this.replaceCommentCheckbox.setBounds(20, 80, 260, 21);
        this.suppressLinebreakCheckbox.setForeground(this.getColor());
        this.suppressLinebreakCheckbox.setText("Input SQL has linebreaks inside tokens");
        this.suppressLinebreakCheckbox.setToolTipText("This option is useful if your editor has added linebreaks inside SQL keywords or column names");
        this.suppressLinebreakCheckbox.setIconTextGap(2);
        this.suppressLinebreakCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.otherOptionPanel.add(this.suppressLinebreakCheckbox);
        this.suppressLinebreakCheckbox.setBounds(20, 100, 290, 21);
        this.jLabel7.setForeground(this.getColor());
        this.jLabel7.setText("Special formatting");
        this.otherOptionPanel.add(this.jLabel7);
        this.jLabel7.setBounds(18, 18, 114, 16);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.otherOptionPanel);
    }

    public void onEntry(TraversableContext traversableContext) {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance(traversableContext.getPropertyStorage());
        this.load(configProFormat);
    }

    public void onExit(TraversableContext traversableContext) {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance(traversableContext.getPropertyStorage());
        this.commit(configProFormat);
    }
}

