/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleConnection;

public class InitializeConnectionListener
implements ConnectionListener {
    private Connections _conns;
    private static final String INIT = "begin dbms_application_info.set_module(?,?); end;";
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getConnectionName();
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            if (!(editor instanceof IDBEditor) || ((IDBEditor)editor).getConnectionName() == null || !((IDBEditor)editor).getConnectionName().equals(string)) continue;
            editor.getController().handleEvent(this.getConnClosedAction(), editor.getContext());
        }
    }

    public IdeAction getConnClosedAction() {
        IdeAction ideAction = IdeAction.get((int)IDBEditor.CONN_CLOSED_CMD_ID);
        return ideAction;
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
        final ConnectionEvent connectionEvent2 = connectionEvent;
        Thread thread = new Thread(){

            public void run() {
                InitializeConnectionListener.this.initConnection(connectionEvent2);
            }
        };
        thread.setName("InitConnection");
        thread.start();
    }

    public void initConnection(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getConnectionName();
        Connections connections = Connections.getInstance();
        Connection connection = null;
        try {
            connection = connections.getConnection(string);
            ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(string, connection);
            if (connectionTypeDetails.isSupportsAutocommit()) {
                boolean bl = DBConfig.getInstance().getBoolean("AUTOCOMMIT");
                connection.setAutoCommit(bl);
            }
            Properties properties = connections.getConnectionInfo(string);
            Connections.safePropertySetter(properties, "PreferfedFetchSize", connectionTypeDetails.getPreferredFetchSize());
            if (Connections.getInstance().isOracle(string)) {
                Statement statement;
                String string2;
                Object object;
                int n = connection.getMetaData().getDatabaseMajorVersion();
                if (n < 9) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Database Versions 9.x and above are supported.", (String)"Unsupported Database Version", (String)"f1_nonsupporteddb_html");
                }
                if (n >= 11) {
                    object = DBConfig.getInstance();
                    string2 = object.getString("PLSQLSCOPE");
                    if (string2 != null && "All".equals(string2.trim())) {
                        statement = connection.createStatement();
                        statement.execute("alter session set PLSCOPE_SETTINGS='identifiers:all'");
                        statement.close();
                    }
                    Connections.getInstance().putProperty(connection, "SESSIONID", DBUtil.getInstance().executeReturnOneCol(connection, "select sys_context('USERENV','SESSIONID') from dual", new ArrayList()));
                    Connections.getInstance().putProperty(connection, "SID", DBUtil.getInstance().executeReturnOneCol(connection, "select sys_context('USERENV','SID') from dual", new ArrayList()));
                }
                object = new ArrayList();
                ((ArrayList)object).add("APEX_RELEASE");
                string2 = DBUtil.getInstance().executeReturnOneCol(connection, "select count(1) from all_objects where object_name = ?", (List)object);
                if (!string2.equals("0")) {
                    Connections.getInstance().putProperty(connection, "APEX_VERSION", new Version(DBUtil.getInstance().executeReturnOneCol(connection, "select  version_no from apex_release", new ArrayList())));
                }
                this.runLoginSql(string);
                statement = NLSProvider.getProvider((String)string);
                if (statement != null) {
                    statement.updateDefaults(DBConfig.getInstance().getNLSMap());
                    statement.initConnection();
                }
                if (connection instanceof OracleConnection) {
                    ((OracleConnection)connection).setDefaultRowPrefetch(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
    }

    private void runLoginSql(String string) {
        File file;
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("GLOGIN").booleanValue() && (file = new File(dBConfig.getString(""))).exists()) {
            try {
                ScriptUtils.runAsScript(new FileInputStream(file), string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.fine("No " + dBConfig.getString("") + " found");
            }
        }
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }
}

